/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.providers.jsp.JSPProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class Request
implements HttpServletRequest {
    private Cookie[] cookies = null;
    private Map attrs = null;
    private String requestURI;
    private HttpSession httpSession;
    private HttpServletRequest origRequest;
    private Hashtable parameters;
    private JSPProvider jspProvider;
    private String pathInfo;
    private String servletPath;
    private String contextPath;

    public Request(HttpServletRequest req, HttpSession jspsess, Hashtable params, Cookie[] ca, Map attributes, String uri) {
        this.origRequest = req;
        this.httpSession = jspsess;
        this.parameters = params;
        this.cookies = ca;
        this.attrs = attributes;
        this.requestURI = uri;
        this.pathInfo = req.getPathInfo();
        this.servletPath = req.getServletPath();
        this.contextPath = req.getContextPath();
    }

    public Map getAttributes() {
        return this.attrs;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public Object getAttribute(String name) {
        Object o = this.getAttributes().get(name);
        if (o != null) {
            return o;
        }
        if (name.equals("javax.servlet.include.servlet_path")) {
            return null;
        }
        return this.origRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.getAttributes().remove(name);
    }

    public Enumeration getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration en = this.origRequest.getAttributeNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            names.add(key);
        }
        Set thisNames = this.getAttributes().keySet();
        names.addAll(thisNames);
        return names.elements();
    }

    public String getAuthType() {
        this.checkRequest();
        return this.origRequest.getAuthType();
    }

    public String getCharacterEncoding() {
        this.checkRequest();
        return this.origRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        this.checkRequest();
        return this.origRequest.getContentLength();
    }

    public String getContentType() {
        this.checkRequest();
        return this.origRequest.getContentType();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        this.checkRequest();
        return this.origRequest.getDateHeader(name);
    }

    public String getHeader(String name) {
        this.checkRequest();
        return this.origRequest.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        this.checkRequest();
        return this.origRequest.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        this.checkRequest();
        return this.origRequest.getHeaderNames();
    }

    public int getIntHeader(String name) {
        this.checkRequest();
        return this.origRequest.getIntHeader(name);
    }

    public String getMethod() {
        this.checkRequest();
        return this.origRequest.getMethod();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String getPathInfo() {
        this.checkRequest();
        return this.pathInfo;
    }

    public String getPathTranslated() {
        this.checkRequest();
        return this.origRequest.getPathTranslated();
    }

    public String getProtocol() {
        this.checkRequest();
        return this.origRequest.getProtocol();
    }

    public String getQueryString() {
        this.checkRequest();
        return this.origRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.origRequest.getRemoteUser();
    }

    public String getScheme() {
        this.checkRequest();
        return this.origRequest.getScheme();
    }

    public String getServerName() {
        this.checkRequest();
        return this.origRequest.getServerName();
    }

    public int getServerPort() {
        this.checkRequest();
        return this.origRequest.getServerPort();
    }

    public String getRemoteAddr() {
        this.checkRequest();
        return this.origRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        this.checkRequest();
        return this.origRequest.getRemoteHost();
    }

    public ServletInputStream getInputStream() throws IOException {
        this.checkRequest();
        return this.origRequest.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Reader in JSPProvider is not available.  Use getParameter method to get parameters.");
    }

    public String getRequestedSessionId() {
        return this.origRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("RequestDispatcher is not available to providers");
    }

    public boolean isSecure() {
        this.checkRequest();
        return this.origRequest.isSecure();
    }

    public Locale getLocale() {
        this.checkRequest();
        return this.origRequest.getLocale();
    }

    public Enumeration getLocales() {
        this.checkRequest();
        return this.origRequest.getLocales();
    }

    public String getContextPath() {
        this.checkRequest();
        return this.contextPath;
    }

    public boolean isUserInRole(String role) {
        return this.origRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.origRequest.getUserPrincipal();
    }

    public String getServletPath() {
        this.checkRequest();
        return this.servletPath;
    }

    public String getRealPath(String name) {
        return name;
    }

    public boolean isRequestedSessionIdValid() {
        return this.origRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    private void checkRequest() throws UnsupportedOperationException {
        if (this.origRequest == null) {
            throw new UnsupportedOperationException("Request information unavailable in this mode.");
        }
    }
}

