/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PropertiesDebug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    private static Map debugMap = new HashMap();
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.US);
    private final String debugName;
    private PrintWriter debugFile = null;
    private int debug = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesDebug(String debugName) {
        this.debugName = debugName;
        Map map = debugMap;
        synchronized (map) {
            debugMap.put(debugName, this);
        }
    }

    public static synchronized PropertiesDebug getInstance(String debugName) {
        PropertiesDebug debugObj = (PropertiesDebug)debugMap.get(debugName);
        if (debugObj == null) {
            debugObj = new PropertiesDebug(debugName);
        }
        return debugObj;
    }

    public boolean debugEnabled() {
        return this.debug > 2;
    }

    public boolean messageEnabled() {
        return this.debug > 2;
    }

    public boolean warningEnabled() {
        return this.debug > 1;
    }

    public int getState() {
        return this.debug;
    }

    public void message(String msg) {
        if (this.debug > 2) {
            this.message(msg, null);
        }
    }

    public void message(String msg, Throwable t) {
        if (this.debug > 2) {
            this.formatAndWrite(null, msg, t);
        }
    }

    public void warning(String msg) {
        if (this.debug > 1) {
            this.formatAndWrite("WARNING: ", msg, null);
        }
    }

    public void warning(String msg, Throwable t) {
        if (this.debug > 1) {
            this.formatAndWrite("WARNING: ", msg, t);
        }
    }

    public void error(String msg) {
        if (this.debug > 0) {
            this.formatAndWrite("ERROR: ", msg, null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.debug > 0) {
            this.formatAndWrite("ERROR: ", msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatAndWrite(String prefix, String msg, Throwable t) {
        if (this.debug == 4) {
            if (msg != null) {
                if (prefix == null) {
                    System.out.println(msg);
                } else {
                    System.out.println(prefix + msg);
                }
            }
            if (t != null) {
                System.out.println(t.getMessage());
                t.printStackTrace(System.out);
            }
            return;
        }
        StringWriter swriter = new StringWriter(160);
        PrintWriter buf = new PrintWriter((Writer)swriter, true);
        DateFormat dateFormat = PropertiesDebug.dateFormat;
        synchronized (dateFormat) {
            buf.write(PropertiesDebug.dateFormat.format(new Date()));
        }
        buf.write(": ");
        buf.write(Thread.currentThread().toString());
        buf.write("\n");
        if (prefix != null) {
            buf.write(prefix);
        }
        if (msg != null) {
            buf.write(msg);
        }
        if (t != null) {
            buf.write("\n");
            t.printStackTrace(buf);
        }
        buf.flush();
        this.write(swriter.toString());
    }

    private synchronized void write(String msg) {
        try {
            if (this.debugFile == null) {
                FileOutputStream fos = new FileOutputStream(this.getDebugBaseDir() + "/" + this.debugName, true);
                this.debugFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8")), true);
                this.debugFile.println("******************************************************");
            }
            this.debugFile.println(msg);
        }
        catch (IOException e) {
            System.err.println(msg);
            this.debug = 0;
        }
    }

    public void setDebug(int debugType) {
        switch (debugType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.debug = debugType;
                break;
            }
        }
    }

    public void setDebug(String debugType) {
        if (debugType == null) {
            return;
        }
        if (debugType.equalsIgnoreCase("error")) {
            this.debug = 1;
        } else if (debugType.equalsIgnoreCase("warning")) {
            this.debug = 2;
        } else if (debugType.equalsIgnoreCase("message")) {
            this.debug = 3;
        } else if (debugType.equalsIgnoreCase("on")) {
            this.debug = 4;
        } else if (debugType.equalsIgnoreCase("off")) {
            this.debug = 0;
        } else if (debugType.equals("*")) {
            this.debug = 4;
        } else {
            if (debugType.endsWith("*")) {
                debugType = debugType.substring(0, debugType.length() - 1);
            }
            if (this.debugName.startsWith(debugType)) {
                this.debug = 4;
            }
        }
    }

    public void destroy() {
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Object object = debugMap;
        synchronized (object) {
            debugMap.remove(this.debugName);
        }
        object = this;
        synchronized (object) {
            if (this.debugFile == null) {
                return;
            }
            this.debug = 0;
            this.debugFile.flush();
            this.debugFile.close();
            this.debugFile = null;
        }
    }

    private String getDebugBaseDir() {
        try {
            return "/var/tmp";
        }
        catch (Exception ex) {
            System.out.println("Error setting basedir: ");
            ex.printStackTrace();
            return null;
        }
    }
}

