/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.template;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.ParsedTagElement;
import com.sun.portal.desktop.util.NSStringBuffer;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class TagSwapper {
    private static String propertiesfile = "message.properties";
    private static DesktopAppContext dac = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer doSwap(StringBuffer inBuffer, Hashtable aTagTable, String sContent, String channel, ContainerProviderContext pc) {
        if (inBuffer == null) {
            return inBuffer;
        }
        Properties p = new Properties();
        FileInputStream propFile = null;
        try {
            try {
                File message = pc.getTemplatePath(channel, propertiesfile);
                String messageFile = message.getPath();
                propFile = new FileInputStream(messageFile);
                p.load(propFile);
            }
            catch (ProviderContextException pce) {
                StringBuffer stringBuffer = null;
                Object var10_14 = null;
                try {
                    if (propFile == null) return stringBuffer;
                    propFile.close();
                    return stringBuffer;
                }
                catch (IOException ex2) {
                    return null;
                }
            }
            catch (Exception ex) {
                StringBuffer stringBuffer = null;
                Object var10_15 = null;
                try {}
                catch (IOException ex2) {
                    return null;
                }
                if (propFile == null) return stringBuffer;
                propFile.close();
                return stringBuffer;
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            try {}
            catch (IOException ex2) {
                return null;
            }
            if (propFile == null) throw throwable;
            propFile.close();
            throw throwable;
        }
        try {}
        catch (IOException ex2) {
            return null;
        }
        if (propFile != null) {
            propFile.close();
        }
        ParsedTagArray pta = new ParsedTagArray(inBuffer);
        return TagSwapper.doSwapFromParsedTagArray(pta, pc, channel, sContent, aTagTable, p);
    }

    private static String getPropertyValue(String channel, ContainerProviderContext pc, String key) {
        if (!pc.existsChannel(channel)) {
            return null;
        }
        try {
            if (!pc.existsStringProperty(channel, key)) {
                return null;
            }
            String value = pc.getStringProperty(channel, key);
            return value;
        }
        catch (ProviderContextException pce) {
            return null;
        }
    }

    private static String getAttributeValue(ContainerProviderContext pc, String key) {
        String value = pc.getStringAttribute(key);
        return value;
    }

    public static StringBuffer doSwapFromParsedTagArray(ParsedTagArray pta, ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable, Properties p) {
        if (pta == null) {
            return null;
        }
        if (aTagTable == null) {
            return pta.getTemplateSB();
        }
        StringBuffer outBuffer = new StringBuffer(pta.getStaticLength() + pta.getNumberTags() * 100);
        int numpte = pta.size();
        if (numpte == 0) {
            return outBuffer;
        }
        String dtURL = null;
        for (int i = 0; i < numpte; ++i) {
            ParsedTagElement pte = pta.get(i);
            String key = pte.getKey();
            TagSwapper.doTags(pc, channel, sContent, aTagTable, pte, key, outBuffer, dtURL, p);
        }
        return outBuffer;
    }

    private static void doTags(ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable, ParsedTagElement pte, String key, StringBuffer outBuffer, String dtURL, Properties p) {
        switch (pte.getType()) {
            case 0: {
                outBuffer.append(key);
                break;
            }
            case 1: {
                Object value = aTagTable.get(key);
                if (value == null && pte.getDefault() != null) {
                    ParsedTagElement dElement = pte.getDefault();
                    TagSwapper.doTags(pc, channel, sContent, aTagTable, dElement, dElement.getKey(), outBuffer, dtURL, p);
                }
                if (value == null && pc != null) {
                    value = TagSwapper.getPropertyValue(channel, pc, key);
                }
                if (value == null && pc != null) {
                    value = TagSwapper.getAttributeValue(pc, key);
                }
                if (value == null) break;
                String valueStr = value.toString();
                if (value instanceof NSStringBuffer) {
                    outBuffer.append(valueStr);
                    break;
                }
                StringBuffer tagValue = new StringBuffer(valueStr);
                outBuffer.append(TagSwapper.doSwapFromParsedTagArray(new ParsedTagArray(tagValue), pc, channel, sContent, aTagTable, p));
                break;
            }
            case 2: {
                String encodedURL = null;
                encodedURL = pc != null ? pc.encodeURL(key) : key;
                outBuffer.append(encodedURL);
                break;
            }
            case 3: {
                outBuffer.append(sContent);
                outBuffer.append(key);
                break;
            }
            case 4: {
                if (dtURL == null) {
                    HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
                    dtURL = pc != null ? pc.getDesktopURL(req) : dac.getDesktopURL(req);
                }
                outBuffer.append(dtURL);
                break;
            }
            case 6: {
                String[] pat = key.split(":");
                if (p == null) {
                    outBuffer.append(key);
                    break;
                }
                if (pat.length == 1) {
                    String val = p.getProperty(pat[0]);
                    if (val == null) {
                        outBuffer.append(pat[0]);
                        break;
                    }
                    outBuffer.append(val);
                    break;
                }
                if (pat.length <= 1) break;
                String rbKey = pat[0];
                String[] formatVal = new String[pat.length - 1];
                String msgFormat = p.getProperty(rbKey);
                if (msgFormat == null) {
                    outBuffer.append(rbKey);
                    break;
                }
                for (int i = 1; i < pat.length; ++i) {
                    formatVal[i - 1] = TagSwapper.getTagAttribute(pc, channel, sContent, aTagTable, pte, pat[i], p);
                }
                MessageFormat mf = new MessageFormat(msgFormat);
                outBuffer.append(mf.format(formatVal));
                break;
            }
            default: {
                throw new DesktopError("TagSwapper.doSwapFromParsedTagArray(): invalid ParsedTagElement type");
            }
        }
    }

    private static String getTagAttribute(ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable, ParsedTagElement pte, String key, Properties p) {
        Object value = aTagTable.get(key);
        if (value == null && pc != null) {
            value = TagSwapper.getPropertyValue(channel, pc, key);
        }
        if (value == null && pc != null) {
            value = TagSwapper.getAttributeValue(pc, key);
        }
        if (value != null) {
            String valueStr = value.toString();
            if (value instanceof NSStringBuffer) {
                return valueStr;
            }
            StringBuffer tagValue = new StringBuffer(valueStr);
            return TagSwapper.doSwapFromParsedTagArray(new ParsedTagArray(tagValue), pc, channel, sContent, aTagTable, p).toString();
        }
        return null;
    }

    static {
        dac = DesktopAppContextThreadLocalizer.get();
    }
}

