/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.monitoring;

import com.sun.common.pool.Pool;
import com.sun.portal.desktop.monitoring.PoolStatistic;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.OpenStatisticMBeanRegistration;
import com.sun.portal.monitoring.statistics.RangeStatisticImpl;
import com.sun.portal.monitoring.statistics.RangeStatisticWrapper;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

public class PoolStatisticImpl
implements PoolStatistic {
    private static final Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$monitoring$PoolStatisticImpl == null ? (class$com$sun$portal$desktop$monitoring$PoolStatisticImpl = PoolStatisticImpl.class$("com.sun.portal.desktop.monitoring.PoolStatisticImpl")) : class$com$sun$portal$desktop$monitoring$PoolStatisticImpl));
    private Subsystem subsystem;
    private String compositeTypeName;
    private int min;
    private Map registry = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$sun$portal$desktop$monitoring$PoolStatisticImpl;

    private static LogRecord getLogRecord(Level level, String message, Object[] parameters, Throwable t) {
        LogRecord result = new LogRecord(level, message);
        result.setLoggerName(logger.getName());
        result.setParameters(parameters);
        result.setThrown(t);
        return result;
    }

    public PoolStatisticImpl(Subsystem subsystem, String compositeTypeName, int min, Pool pool) {
        this.subsystem = subsystem;
        this.compositeTypeName = compositeTypeName;
        this.min = min;
        this.registry = subsystem.getRegistry();
        pool.setPoolStatistic(this);
    }

    private OpenStatisticMBeanRegistration getOpenStatisticMBeanRegistration() {
        RangeStatisticImpl rangeStatistic;
        RangeStatisticWrapper rangeStatisticWrapper;
        block2: {
            rangeStatisticWrapper = new RangeStatisticWrapper();
            rangeStatisticWrapper.setCompositeTypeName(this.compositeTypeName);
            rangeStatisticWrapper.setResourceBundleBaseName("desktopMonitoring");
            rangeStatistic = (RangeStatisticImpl)rangeStatisticWrapper.getStatisticImpl();
            try {
                CompositeType compositeType = rangeStatisticWrapper.getCompositeType();
                rangeStatistic.setDescription(compositeType.getDescription("Description"));
                rangeStatistic.setName(compositeType.getDescription("Name"));
                rangeStatistic.setUnit(compositeType.getDescription("Unit"));
            }
            catch (OpenDataException e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(PoolStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
            }
        }
        rangeStatistic.setLowWaterMark((long)this.min);
        rangeStatistic.setHighWaterMark((long)this.min);
        return new OpenStatisticMBeanRegistration(this.registry, (StatisticWrapper)rangeStatisticWrapper);
    }

    private ObjectName getObjectName(String namingDomain) throws MalformedObjectNameException {
        return new ObjectName(namingDomain + ":type=" + this.compositeTypeName);
    }

    public void setCurrent(long current) {
        block7: {
            if (!this.subsystem.isDisabled().booleanValue()) {
                try {
                    OpenStatistic openStatistic;
                    block6: {
                        ObjectName objectName = this.getObjectName(this.subsystem.getNamingDomain());
                        openStatistic = (OpenStatistic)this.registry.get(objectName);
                        if (openStatistic == null) {
                            openStatistic = this.getOpenStatisticMBeanRegistration();
                            try {
                                this.subsystem.registerMBean((Object)openStatistic, objectName.toString());
                            }
                            catch (MonitoringException e) {
                                if (!logger.isLoggable(Level.SEVERE)) break block6;
                                logger.log(PoolStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                            }
                        }
                    }
                    RangeStatisticWrapper rangeStatisticWrapper = (RangeStatisticWrapper)openStatistic.getStatisticWrapper();
                    RangeStatisticImpl rangeStatistic = (RangeStatisticImpl)rangeStatisticWrapper.getStatisticImpl();
                    rangeStatistic.setCurrent(current);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.log(PoolStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

