/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.monitoring;

import com.sun.common.pool.Pool;
import com.sun.portal.desktop.monitoring.ChannelActionStatistic;
import com.sun.portal.desktop.monitoring.ChannelActionStatisticImpl;
import com.sun.portal.desktop.monitoring.ChannelCacheHitsStatistic;
import com.sun.portal.desktop.monitoring.ChannelCacheHitsStatisticImpl;
import com.sun.portal.desktop.monitoring.DesktopRequestStatistic;
import com.sun.portal.desktop.monitoring.DesktopRequestStatisticImpl;
import com.sun.portal.desktop.monitoring.MonitoringSubsystem;
import com.sun.portal.desktop.monitoring.PoolStatisticImpl;
import com.sun.portal.monitoring.Client;
import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.SubsystemImpl;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MonitoringSubsystemImpl
implements MonitoringSubsystem {
    private Subsystem subsystem;
    private DesktopRequestStatistic desktopRequestStatistic;
    private ChannelActionStatistic contentChannelActionStatistic;
    private ChannelActionStatistic editChannelActionStatistic;
    private ChannelActionStatistic processChannelActionStatistic;
    private ChannelCacheHitsStatistic channelCacheHitsStatistic;

    public MonitoringSubsystemImpl(Properties properties) throws MonitoringException {
        this.subsystem = new SubsystemImpl(properties);
        this.setResourceBundleBaseName("desktopMonitoring");
        this.start();
        this.desktopRequestStatistic = new DesktopRequestStatisticImpl(this.subsystem);
        this.contentChannelActionStatistic = new ChannelActionStatisticImpl(this.subsystem, "Content");
        this.editChannelActionStatistic = new ChannelActionStatisticImpl(this.subsystem, "Edit");
        this.processChannelActionStatistic = new ChannelActionStatisticImpl(this.subsystem, "Process");
        this.channelCacheHitsStatistic = new ChannelCacheHitsStatisticImpl(this.subsystem);
    }

    public DesktopRequestStatistic getDesktopRequestStatistic() {
        return this.desktopRequestStatistic;
    }

    public ChannelActionStatistic getContentChannelActionStatistic() {
        return this.contentChannelActionStatistic;
    }

    public ChannelActionStatistic getEditChannelActionStatistic() {
        return this.editChannelActionStatistic;
    }

    public ChannelActionStatistic getProcessChannelActionStatistic() {
        return this.processChannelActionStatistic;
    }

    public ChannelCacheHitsStatistic getChannelCacheHitsStatistic() {
        return this.channelCacheHitsStatistic;
    }

    public void createPoolStatistic(String poolId, int minSize, Pool pool) {
        new PoolStatisticImpl(this.subsystem, poolId, minSize, pool);
    }

    public Boolean isDisabled() {
        return this.subsystem.isDisabled();
    }

    public String getNamingDomain() {
        return this.subsystem.getNamingDomain();
    }

    public Map getRegistry() {
        return this.subsystem.getRegistry();
    }

    public void registerMBean(Object mBeanObject, String objectName) throws MonitoringException {
        this.subsystem.registerMBean(mBeanObject, objectName);
    }

    public Boolean isRegistered(String objectName) throws MonitoringException {
        return this.subsystem.isRegistered(objectName);
    }

    public void unregisterMBean(String objectName) throws MonitoringException {
        this.subsystem.unregisterMBean(objectName);
    }

    public Client getClient() throws MonitoringException {
        return this.subsystem.getClient();
    }

    public void start() throws MonitoringException {
        this.subsystem.start();
    }

    public void stop(Boolean unregisterMBeans) throws MonitoringException {
        this.subsystem.stop(unregisterMBeans);
    }

    public void destroy() throws MonitoringException {
        this.subsystem.destroy();
    }

    public List getImmortalMBeanObjectNames() {
        return this.subsystem.getImmortalMBeanObjectNames();
    }

    public void setImmortalMBeanObjectNames(List immortalMBeanObjectNames) {
        this.subsystem.setImmortalMBeanObjectNames(immortalMBeanObjectNames);
    }

    public String getResourceBundleBaseName() {
        return this.subsystem.getResourceBundleBaseName();
    }

    public void setResourceBundleBaseName(String rbBaseName) {
        this.subsystem.setResourceBundleBaseName(rbBaseName);
    }
}

