/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.monitoring;

import com.sun.portal.desktop.monitoring.DesktopRequestStatistic;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.OpenStatisticMBeanRegistration;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticImpl;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticWrapper;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.monitoring.utilities.ActivityTime;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

public class DesktopRequestStatisticImpl
implements DesktopRequestStatistic {
    private static final Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$monitoring$DesktopRequestStatisticImpl == null ? (class$com$sun$portal$desktop$monitoring$DesktopRequestStatisticImpl = DesktopRequestStatisticImpl.class$("com.sun.portal.desktop.monitoring.DesktopRequestStatisticImpl")) : class$com$sun$portal$desktop$monitoring$DesktopRequestStatisticImpl));
    private Subsystem subsystem;
    private Map registry;
    private ActivityTime activityTime = new ActivityTime();
    static /* synthetic */ Class class$com$sun$portal$desktop$monitoring$DesktopRequestStatisticImpl;

    private static LogRecord getLogRecord(Level level, String message, Object[] parameters, Throwable t) {
        LogRecord result = new LogRecord(level, message);
        result.setLoggerName(logger.getName());
        result.setParameters(parameters);
        result.setThrown(t);
        return result;
    }

    public DesktopRequestStatisticImpl(Subsystem subsystem) {
        this.subsystem = subsystem;
        this.registry = subsystem.getRegistry();
    }

    private OpenStatisticMBeanRegistration getOpenStatisticMBeanRegistration(String requestType) {
        RollingAvgTimeStatisticImpl rollingAvgTimeStatistic;
        RollingAvgTimeStatisticWrapper rollingAvgTimeStatisticWrapper;
        block2: {
            rollingAvgTimeStatisticWrapper = new RollingAvgTimeStatisticWrapper();
            rollingAvgTimeStatisticWrapper.setCompositeTypeName(this.getClass().getName() + "." + requestType);
            rollingAvgTimeStatisticWrapper.setResourceBundleBaseName("desktopMonitoring");
            rollingAvgTimeStatistic = (RollingAvgTimeStatisticImpl)rollingAvgTimeStatisticWrapper.getStatisticImpl();
            try {
                CompositeType compositeType = rollingAvgTimeStatisticWrapper.getCompositeType();
                rollingAvgTimeStatistic.setDescription(compositeType.getDescription("Description"));
                rollingAvgTimeStatistic.setName(compositeType.getDescription("Name"));
                rollingAvgTimeStatistic.setUnit(compositeType.getDescription("Unit"));
            }
            catch (OpenDataException e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(DesktopRequestStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
            }
        }
        rollingAvgTimeStatistic.setLowerBound(100L);
        rollingAvgTimeStatistic.setUpperBound(1000L);
        return new OpenStatisticMBeanRegistration(this.registry, (StatisticWrapper)rollingAvgTimeStatisticWrapper);
    }

    private ObjectName getObjectName(String namingDomain, String requestType) throws MalformedObjectNameException {
        return new ObjectName(namingDomain + ":type=DesktopRequestStatistic,name=" + requestType);
    }

    public void mark() {
        if (!this.subsystem.isDisabled().booleanValue()) {
            this.activityTime.mark();
        }
    }

    public void measure(String requestType) {
        block7: {
            if (!this.subsystem.isDisabled().booleanValue()) {
                try {
                    OpenStatistic openStatistic;
                    block6: {
                        ObjectName objectName = this.getObjectName(this.subsystem.getNamingDomain(), requestType);
                        openStatistic = (OpenStatistic)this.registry.get(objectName);
                        if (openStatistic == null) {
                            openStatistic = this.getOpenStatisticMBeanRegistration(requestType);
                            try {
                                this.subsystem.registerMBean((Object)openStatistic, objectName.toString());
                            }
                            catch (MonitoringException e) {
                                if (!logger.isLoggable(Level.SEVERE)) break block6;
                                logger.log(DesktopRequestStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                            }
                        }
                    }
                    RollingAvgTimeStatisticWrapper rollingAvgTimeStatisticWrapper = (RollingAvgTimeStatisticWrapper)openStatistic.getStatisticWrapper();
                    RollingAvgTimeStatisticImpl rollingAvgTimeStatistic = (RollingAvgTimeStatisticImpl)rollingAvgTimeStatisticWrapper.getStatisticImpl();
                    rollingAvgTimeStatistic.setTime(this.activityTime.measure());
                }
                catch (MalformedObjectNameException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.log(DesktopRequestStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

