/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.monitoring;

import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.monitoring.ChannelCacheHitsStatistic;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.OpenStatisticMBeanRegistration;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticImpl;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticWrapper;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.monitoring.utilities.ActivityTime;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

public class ChannelCacheHitsStatisticImpl
implements ChannelCacheHitsStatistic {
    private static final Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$monitoring$ChannelCacheHitsStatisticImpl == null ? (class$com$sun$portal$desktop$monitoring$ChannelCacheHitsStatisticImpl = ChannelCacheHitsStatisticImpl.class$("com.sun.portal.desktop.monitoring.ChannelCacheHitsStatisticImpl")) : class$com$sun$portal$desktop$monitoring$ChannelCacheHitsStatisticImpl));
    private Subsystem subsystem;
    private Map registry;
    static /* synthetic */ Class class$com$sun$portal$desktop$monitoring$ChannelCacheHitsStatisticImpl;

    private static LogRecord getLogRecord(Level level, String message, Object[] parameters, Throwable t) {
        LogRecord result = new LogRecord(level, message);
        result.setLoggerName(logger.getName());
        result.setParameters(parameters);
        result.setThrown(t);
        return result;
    }

    public ChannelCacheHitsStatisticImpl(Subsystem subsystem) {
        this.subsystem = subsystem;
        this.registry = subsystem.getRegistry();
    }

    private OpenStatisticMBeanRegistration getOpenStatisticMBeanRegistration() {
        RollingAvgTimeStatisticImpl rollingAvgTimeStatistic;
        RollingAvgTimeStatisticWrapper rollingAvgTimeStatisticWrapper;
        block2: {
            rollingAvgTimeStatisticWrapper = new RollingAvgTimeStatisticWrapper();
            rollingAvgTimeStatisticWrapper.setCompositeTypeName(this.getClass().getName());
            rollingAvgTimeStatisticWrapper.setResourceBundleBaseName("desktopMonitoring");
            rollingAvgTimeStatistic = (RollingAvgTimeStatisticImpl)rollingAvgTimeStatisticWrapper.getStatisticImpl();
            try {
                CompositeType compositeType = rollingAvgTimeStatisticWrapper.getCompositeType();
                rollingAvgTimeStatistic.setDescription(compositeType.getDescription("Description"));
                rollingAvgTimeStatistic.setName(compositeType.getDescription("Name"));
                rollingAvgTimeStatistic.setUnit(compositeType.getDescription("Unit"));
            }
            catch (OpenDataException e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(ChannelCacheHitsStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
            }
        }
        rollingAvgTimeStatistic.setLowerBound(100L);
        rollingAvgTimeStatistic.setUpperBound(1000L);
        return new OpenStatisticMBeanRegistration(this.registry, (StatisticWrapper)rollingAvgTimeStatisticWrapper);
    }

    private String evaluateChannelId(String channelId, DPChannel dpChannel, DPProperties dpProperties) {
        StringBuffer result = new StringBuffer();
        if (channelId == null) {
            result.append("name=");
            result.append(dpChannel.getName());
            result.append(",");
            result.append("class=");
            result.append(dpChannel.getProvider().getClassName());
        } else {
            StringTokenizer tokenizer = new StringTokenizer(channelId, "${}");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("name")) {
                    result.append(dpChannel.getName());
                    continue;
                }
                if (token.equals("class")) {
                    result.append(dpChannel.getProvider().getClassName());
                    continue;
                }
                if (dpProperties != null) {
                    DPProperty dpProperty = dpProperties.get(token);
                    if (dpProperty != null) {
                        result.append(dpProperty.getValue());
                        continue;
                    }
                    result.append(token);
                    continue;
                }
                result.append(token);
            }
        }
        return result.toString();
    }

    private String getChannelId(String channelName, DPNode dpNode) {
        DPChannel dpChannel = dpNode.getChannel(channelName);
        DPProperties dpProperties = dpChannel.getProperties();
        DPString dpString = dpProperties == null ? null : dpProperties.getString("id");
        String id = dpString == null ? null : dpString.getStringValue();
        String result = this.evaluateChannelId(id, dpChannel, dpProperties);
        return result;
    }

    private String getChannelId(String channelName) {
        DPRoot dpRoot = DesktopContextThreadLocalizer.get().getDPRoot();
        DPChannel dpChannel = dpRoot.getChannel(channelName);
        DPProperties dpProperties = dpChannel.getProperties();
        DPString dpString = dpProperties == null ? null : dpProperties.getString("id");
        String id = dpString == null ? null : dpString.getStringValue();
        String result = this.evaluateChannelId(id, dpChannel, dpProperties);
        return result;
    }

    private ObjectName getObjectName(String namingDomain, String channelId) throws MalformedObjectNameException {
        return new ObjectName(namingDomain + ":type=ChannelCacheHitsStatistic," + channelId);
    }

    public void mark(ActivityTime activityTime) {
        if (!this.subsystem.isDisabled().booleanValue()) {
            activityTime.mark();
        }
    }

    public void measure(ActivityTime activityTime, String channelName, DPNode dpNode) {
        block7: {
            if (!this.subsystem.isDisabled().booleanValue()) {
                try {
                    OpenStatistic openStatistic;
                    block6: {
                        ObjectName objectName = this.getObjectName(this.subsystem.getNamingDomain(), this.getChannelId(channelName, dpNode));
                        openStatistic = (OpenStatistic)this.registry.get(objectName);
                        if (openStatistic == null) {
                            openStatistic = this.getOpenStatisticMBeanRegistration();
                            try {
                                this.subsystem.registerMBean((Object)openStatistic, objectName.toString());
                            }
                            catch (MonitoringException e) {
                                if (!logger.isLoggable(Level.SEVERE)) break block6;
                                logger.log(ChannelCacheHitsStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                            }
                        }
                    }
                    RollingAvgTimeStatisticWrapper rollingAvgTimeStatisticWrapper = (RollingAvgTimeStatisticWrapper)openStatistic.getStatisticWrapper();
                    RollingAvgTimeStatisticImpl rollingAvgTimeStatistic = (RollingAvgTimeStatisticImpl)rollingAvgTimeStatisticWrapper.getStatisticImpl();
                    rollingAvgTimeStatistic.setTime(activityTime.measure());
                }
                catch (MalformedObjectNameException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.log(ChannelCacheHitsStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                }
            }
        }
    }

    public void measure(ActivityTime activityTime, String channelName) {
        block7: {
            if (!this.subsystem.isDisabled().booleanValue()) {
                try {
                    OpenStatistic openStatistic;
                    block6: {
                        ObjectName objectName = this.getObjectName(this.subsystem.getNamingDomain(), this.getChannelId(channelName));
                        openStatistic = (OpenStatistic)this.registry.get(objectName);
                        if (openStatistic == null) {
                            openStatistic = this.getOpenStatisticMBeanRegistration();
                            try {
                                this.subsystem.registerMBean((Object)openStatistic, objectName.toString());
                            }
                            catch (MonitoringException e) {
                                if (!logger.isLoggable(Level.SEVERE)) break block6;
                                logger.log(ChannelCacheHitsStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                            }
                        }
                    }
                    RollingAvgTimeStatisticWrapper rollingAvgTimeStatisticWrapper = (RollingAvgTimeStatisticWrapper)openStatistic.getStatisticWrapper();
                    RollingAvgTimeStatisticImpl rollingAvgTimeStatistic = (RollingAvgTimeStatisticImpl)rollingAvgTimeStatisticWrapper.getStatisticImpl();
                    rollingAvgTimeStatistic.setTime(activityTime.measure());
                }
                catch (MalformedObjectNameException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.log(ChannelCacheHitsStatisticImpl.getLogRecord(Level.SEVERE, "PSDT_CSPDM0001", new Object[]{e.getLocalizedMessage()}, e));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

