/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPObject;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAttrs;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPProvider;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDPRoot
extends XMLDPNode
implements DPRoot,
DPTypes,
XMLDPTags,
XMLDPAttrs {
    static long ccount = 0L;
    private Map objects = null;
    protected Map providersTable = null;
    private Element providersElement = null;
    private Integer priority = null;

    public XMLDPRoot(DPContext dpc, String doc) {
        this(dpc, XMLDPRoot.createElement(dpc, doc));
    }

    public XMLDPRoot(DPContext dpc, InputStream xmlByteStream) {
        this(dpc, XMLDPRoot.createElement(dpc, xmlByteStream));
    }

    public XMLDPRoot(DPContext dpc) {
        this(dpc, XMLDPRoot.createElement(dpc));
    }

    XMLDPRoot(DPContext dpc, Element e) {
        super(dpc, null, e);
        this.putObject(this);
        this.providersTable = XMLDPRoot.createElementTable(this.getProvidersElement(this.getElement()));
    }

    public Map getObjects() {
        if (this.objects == null) {
            this.objects = new HashMap();
        }
        return this.objects;
    }

    public DPObject getObject(Element e) {
        DPObject dpo = (DPObject)this.getObjects().get(e);
        return dpo;
    }

    public void putObject(DPObject dpo) {
        XMLDPObject xmldpo = (XMLDPObject)dpo;
        Element e = xmldpo.getElement();
        this.getObjects().put(e, dpo);
    }

    public void removeObject(DPObject dpo) {
        XMLDPObject xmldpo = (XMLDPObject)dpo;
        Element e = xmldpo.getElement();
        this.removeObject(e);
    }

    public void removeObject(Element e) {
        this.getObjects().remove(e);
    }

    public DPRoot getRoot() {
        return this;
    }

    public boolean isDirty() {
        return this.getElement().hasAttribute("dirty") && this.getElement().getAttribute("dirty").equals("true");
    }

    public void setDirty(boolean state) {
        if (!state) {
            this.getElement().removeAttribute("dirty");
        } else {
            this.getElement().setAttribute("dirty", "true");
        }
    }

    Element getRootElement() {
        return this.getElement();
    }

    public int getPriority() {
        if (this.priority == null) {
            String p = this.getElement().getAttribute("priority");
            if (p.equals("user")) {
                this.priority = new Integer(Integer.MAX_VALUE);
            } else {
                try {
                    this.priority = new Integer(p);
                }
                catch (NumberFormatException nfe) {
                    throw new DPError("XMLDPRoot.getPriority(): invalid value priority=" + p);
                }
            }
        }
        return this.priority;
    }

    public void setPriority(int priority) {
        this.getElement().setAttribute("priority", Integer.toString(priority));
    }

    public String getVersion() {
        return this.getElement().getAttribute("version");
    }

    public void setVersion(String version) {
        this.getElement().setAttribute("version", version);
    }

    public String getTag() {
        return "DisplayProfile";
    }

    public short getType() {
        return 13;
    }

    Element getProvidersElement(Element e) {
        if (this.providersElement == null) {
            this.providersElement = XMLDPRoot.getChildElement(e, "Providers", null);
            if (this.providersElement == null) {
                throw new DPError("XMLDPNode.getProviderElement(): could not find child Providers element");
            }
        }
        return this.providersElement;
    }

    Element getProviderElement(String name) {
        Element providerElement = (Element)this.providersTable.get(name);
        return providerElement;
    }

    public DPProvider getProviderFromThis(String name) {
        Element e = this.getProviderElement(name);
        DPProvider dpp = null;
        if (e != null && (dpp = (DPProvider)this.getObject(e)) == null) {
            dpp = XMLDPFactory.getInstance().getProvider(this.getContext(), this.getRoot(), e);
            this.putObject(dpp);
        }
        return dpp;
    }

    public DPProvider getProvider(String name) {
        boolean replace = false;
        DPProvider dpProvider = this.getProviderFromThis(name);
        if (dpProvider == null || !dpProvider.isMerged()) {
            for (int i = 0; i < this.getMergers().size(); ++i) {
                DPRoot dpr = (DPRoot)this.getMergers().get(i);
                DPProvider dpp = ((XMLDPRoot)dpr).getProviderFromThis(name);
                if (dpp == null) continue;
                if (dpProvider == null) {
                    DPProvider ddpp = ((XMLDPProvider)dpp).createDummy(this.getRoot());
                    dpProvider = this.addProvider(ddpp, false, false, true);
                    if (!dpp.isLocked() && dpProvider.isDummy() && this.isReplace()) {
                        replace = true;
                    }
                }
                if (!dpProvider.isMergeLocked() && dpp.isLocked() && dpp.isRemove()) {
                    dpProvider = null;
                    break;
                }
                dpProvider.addMerger(dpp);
            }
        }
        if (dpProvider != null && !dpProvider.isMergeLocked() && dpProvider.isRemove()) {
            dpProvider = null;
        }
        if (replace) {
            dpProvider = null;
        }
        return dpProvider;
    }

    public DPProvider addProvider(DPProvider dpp) {
        return this.addProvider(dpp, true, true, false);
    }

    DPProvider addProvider(DPProvider dpp, boolean copy, boolean deep, boolean dummy) {
        this.removeObject(dpp);
        XMLDPProvider xmldpp = null;
        xmldpp = copy ? (XMLDPProvider)dpp.copy(this.getRoot(), deep) : (XMLDPProvider)dpp;
        Element e = xmldpp.getElement();
        this.providersTable.put(xmldpp.getName(), e);
        this.addProviderElement(this.getElement(), e);
        this.putObject(xmldpp);
        xmldpp.setDummy(dummy);
        return xmldpp;
    }

    void addProviderElement(Element parentNodeElement, Element providerElement) {
        Element providersElement = this.getProvidersElement(parentNodeElement);
        providersElement.appendChild(providerElement);
    }

    DPProvider getProviderFromMergers(String key) {
        DPProvider dpProvider = null;
        for (int i = 0; i < this.getMergers().size(); ++i) {
            DPRoot dpr = (DPRoot)this.getMergers().get(i);
            DPProvider dpp = ((XMLDPRoot)dpr).getProviderFromThis(key);
            if (dpp == null) continue;
            dpProvider = dpp;
            break;
        }
        return dpProvider;
    }

    public DPProvider removeProvider(String key) {
        DPProvider dppFromMerger;
        DPProvider removedDPP = null;
        DPProvider dppFromThis = this.getProviderFromThis(key);
        if (dppFromThis != null) {
            this.removeProviderElement(dppFromThis);
            this.providersTable.remove(key);
            this.removeObject(dppFromThis);
            removedDPP = dppFromThis;
            this.setDummy(false);
        }
        if ((dppFromMerger = this.getProviderFromMergers(key)) != null) {
            DPProvider dpp = this.addProvider(dppFromMerger, true, false, false);
            dpp.setMergeType((short)2);
            if (removedDPP == null) {
                removedDPP = dpp;
            }
        }
        return removedDPP;
    }

    void removeProviderElement(DPProvider dpp) {
        XMLDPProvider xmldpp = (XMLDPProvider)dpp;
        Element childElement = xmldpp.getElement();
        Element parentElement = (Element)childElement.getParentNode();
        parentElement.removeChild(childElement);
    }

    Set getProviderNamesFromMergers() {
        Set names = new HashSet();
        HashSet locked = new HashSet();
        for (int i = 0; i < this.getMergers().size(); ++i) {
            DPRoot dpr = (DPRoot)this.getMergers().get(i);
            if (dpr.isRemove()) {
                names = this.clearProviderNames(names, locked);
            } else if (dpr.getMergeType() == 1) {
                names = this.clearProviderNames(names, locked);
                names = ((XMLDPRoot)dpr).mergeProviderNamesFromThis(names, locked);
            } else {
                names = ((XMLDPRoot)dpr).mergeProviderNamesFromThis(names, locked);
            }
            if (!dpr.isLocked()) continue;
            return names;
        }
        return names;
    }

    public Set getProviderNames() {
        Set names = new HashSet();
        HashSet locked = new HashSet();
        for (int i = 0; i < this.getMergers().size(); ++i) {
            DPRoot dpr = (DPRoot)this.getMergers().get(i);
            if (dpr.isRemove()) {
                names = this.clearProviderNames(names, locked);
            } else if (dpr.getMergeType() == 1) {
                names = this.clearProviderNames(names, locked);
                names = ((XMLDPRoot)dpr).mergeProviderNamesFromThis(names, locked);
            } else {
                names = ((XMLDPRoot)dpr).mergeProviderNamesFromThis(names, locked);
            }
            if (!dpr.isLocked()) continue;
            return names;
        }
        if (!this.isDummy()) {
            if (this.isReplace()) {
                names = this.clearProviderNames(names, locked);
            }
            names = this.mergeProviderNamesFromThis(names, locked);
        }
        return names;
    }

    public Set getProviderNamesFromThis() {
        return this.providersTable.keySet();
    }

    Set mergeProviderNamesFromThis(Set names, Set locked) {
        Set namesFromThis = this.getProviderNamesFromThis();
        Iterator i = namesFromThis.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPProvider dpp = this.getProviderFromThis(name);
            if (dpp == null) {
                throw new DPError("XMLDPRoot.mergeProviderNamesFromThis(): mismatch, could not get object from this for name from this, name=" + name + ", namesFromThis=" + namesFromThis);
            }
            if (dpp.isDummy() || locked.contains(name)) continue;
            if (dpp.isLocked()) {
                locked.add(name);
            }
            if (dpp.getMergeType() == 2) {
                names.remove(name);
                continue;
            }
            names.add(name);
        }
        return names;
    }

    DPChannel addChannelHierarchy(DPNode n) {
        DPChannel dpc = this.addChannelHierarchy(n.getRoot(), n.getName(), n);
        return dpc;
    }

    public DPChannel addChannelHierarchy(DPChannel dpc) {
        return this.addChannelHierarchy((DPNode)dpc);
    }

    public static StringBuffer getXMLHeader() {
        StringBuffer b = new StringBuffer(128);
        b.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n");
        b.append("<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">\n\n");
        return b;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(256);
        b.append(XMLDPRoot.getXMLHeader());
        XMLDPRoot.toStringBuffer(this.getElement(), b, true, 0);
        return b.toString();
    }

    public String toString(boolean prune) {
        StringBuffer b = new StringBuffer(256);
        b.append(XMLDPRoot.getXMLHeader());
        XMLDPRoot.toStringBuffer(this.getElement(), b, prune, 0);
        return b.toString();
    }

    public String toMergedXML() {
        StringBuffer b = new StringBuffer(256);
        b.append(XMLDPRoot.getXMLHeader());
        XMLDPRoot.toStringBuffer(this.getMergedElement(), b, true, 0);
        return b.toString();
    }

    static Element createElement(DPContext dpc) {
        return XMLDPRoot.createElement(dpc, (InputStream)null);
    }

    public DPRoot copy(boolean deep) {
        DocumentBuilder db = XMLDPRoot.getDocBuilder(this.getContext());
        Document ownerDocument = db.newDocument();
        Element copyElement = (Element)ownerDocument.importNode(this.getElement(), deep);
        if (!deep) {
            copyElement.appendChild(ownerDocument.importNode(XMLDPRoot.getChildElement(this.getElement(), "Properties", null), false));
            copyElement.appendChild(ownerDocument.importNode(XMLDPRoot.getChildElement(this.getElement(), "Channels", null), false));
            copyElement.appendChild(ownerDocument.importNode(this.getProvidersElement(this.getElement()), false));
        }
        return XMLDPFactory.getInstance().getRoot(this.getContext(), copyElement);
    }

    protected Element getMergedElement() {
        Element e = XMLDPRoot.createElement(this.getContext(), this.getDocument());
        e.removeAttribute("dummy");
        Element pse = XMLDPRoot.getChildElement(e, "Properties");
        XMLDPProperties xp = (XMLDPProperties)this.getProperties();
        e.replaceChild(xp.getMergedElement(), pse);
        Element cse = XMLDPRoot.getChildElement(e, "Channels");
        Set names = this.getChannelNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            XMLDPChannel xc = (XMLDPChannel)this.getChannel(name);
            Element ce = xc.getMergedElement();
            cse.appendChild(ce);
        }
        Element pvse = XMLDPRoot.getChildElement(e, "Providers");
        names = this.getProviderNames();
        Iterator i2 = names.iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            XMLDPProvider xpv = (XMLDPProvider)this.getProvider(name);
            Element pe = xpv.getMergedElement();
            pvse.appendChild(pe);
        }
        int priority = this.getPriority();
        e.setAttribute("priority", Integer.toString(priority));
        return e;
    }

    static Element createElement(DPContext dpc, String dpXML) {
        Element elem = null;
        if (dpXML != null) {
            try {
                ByteArrayInputStream byteIS = null;
                byte[] bytes = dpXML.getBytes("UTF-8");
                byteIS = new ByteArrayInputStream(bytes);
                elem = XMLDPRoot.createElement(dpc, byteIS);
                byteIS.close();
            }
            catch (IOException ioe) {
                throw new DPError("XMLDPRoot.createElement(): ", ioe);
            }
        }
        return elem;
    }

    static Element createElement(DPContext dpc, InputStream xmlByteStream) {
        if (dpc == null) {
            throw new DPError("XMLDPRoot.createElement(): DP context was null");
        }
        DocumentBuilder db = XMLDPRoot.getDocBuilder(dpc);
        Document d = null;
        if (xmlByteStream == null) {
            d = db.newDocument();
            Element documentElement = XMLDPRoot.createElement(dpc, d);
            d.appendChild(documentElement);
        } else {
            try {
                xmlByteStream.reset();
                InputSource is = new InputSource(xmlByteStream);
                d = db.parse(is);
            }
            catch (SAXParseException spe) {
                throw new DPError("XMLDPRoot.createElement(): line=" + spe.getLineNumber() + ".  ", spe);
            }
            catch (SAXException se) {
                throw new DPError("XMLDPRoot.createElement(): ", se);
            }
            catch (IOException ioe) {
                throw new DPError("XMLDPRoot.createElement(): ", ioe);
            }
        }
        return d.getDocumentElement();
    }

    static Element createElement(DPContext dpc, Document d) {
        Element documentElement = d.createElement("DisplayProfile");
        Element propertiesElement = XMLDPProperties.createElement(dpc, d);
        documentElement.appendChild(propertiesElement);
        Element channelsElement = d.createElement("Channels");
        documentElement.appendChild(channelsElement);
        Element providersElement = d.createElement("Providers");
        documentElement.appendChild(providersElement);
        XMLDPRoot.setDefaultsElement(documentElement);
        documentElement.setAttribute("version", "1.0");
        documentElement.setAttribute("priority", "user");
        documentElement.setAttribute("dummy", "true");
        return documentElement;
    }

    public boolean providerExists(String name) {
        return this.getProvider(name) != null;
    }

    protected Set clearProviderNames(Set names, Set locked) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (locked.contains(name)) continue;
            i.remove();
        }
        return names;
    }

    public void toXML(StringBuffer b, int indent) {
        if (b == null) {
            b = new StringBuffer(256);
        }
        b.append(XMLDPRoot.getXMLHeader());
        this.appendStartTag(b);
        b.append(" version=\"").append(this.getElement().getAttribute("version")).append("\" priority=\"").append(this.getElement().getAttribute("priority")).append("\"");
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        b.append(">\n");
        this.indentBuffer(b, indent);
        this.getPropertiesFromThis().toXML(b, indent + 1);
        this.indentBuffer(b, indent + 1);
        this.appendChannels(b, indent);
        this.indentBuffer(b, indent + 1);
        b.append("<").append("Providers").append(">\n");
        Iterator i = this.getProviderNamesFromThis().iterator();
        while (i.hasNext()) {
            String providerName = (String)i.next();
            DPProvider provider = this.getProviderFromThis(providerName);
            provider.toXML(b, indent + 2);
        }
        this.indentBuffer(b, indent + 1);
        b.append("</").append("Providers").append(">\n");
        this.appendEndTag(b);
    }
}

