/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPObject;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAttrs;
import com.sun.portal.desktop.dp.xml.XMLDPEntityResolver;
import com.sun.portal.desktop.dp.xml.XMLDPErrorHandler;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.util.OrderedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLDPObject
implements DPObject,
DPTypes,
XMLDPTags,
XMLDPAttrs,
Comparable {
    static final int INDENT_SPACES = 4;
    static Map mergeTypeTable = null;
    static String[] MERGETYPE_VALUES = null;
    private DPContext dpContext = null;
    private DPRoot dpRoot = null;
    private Element element = null;
    private DocumentBuilder docBuilder = null;
    private List mergers = null;
    private List unmodifiableMergers = Collections.EMPTY_LIST;
    private boolean mergeLocked = false;
    private boolean mergeRemoved = false;
    private boolean mergeAdvanced = false;
    static long ccount;
    private static Map localeNames;
    private static XMLDPEntityResolver entityResolver;
    private static XMLDPErrorHandler errorHandler;
    private Boolean locked = null;
    private Boolean removed = null;
    private Boolean replaced = null;
    private Boolean dummy = null;
    private Short mergeType = null;
    private Boolean advanced = null;
    private String name = null;

    private XMLDPObject() {
    }

    static Map createElementTable(Element e) {
        OrderedMap elementTable = new OrderedMap();
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String name = XMLDPObject.getNameElement(childElement);
            elementTable.put(name, childElement);
        }
        return elementTable;
    }

    XMLDPObject(DPContext dpc, DPRoot r, Element e) {
        this.dpContext = dpc;
        this.dpRoot = r;
        this.element = e;
        this.checkType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocBuilder() {
        if (this.docBuilder == null) {
            XMLDPObject xMLDPObject = this;
            synchronized (xMLDPObject) {
                if (this.docBuilder == null) {
                    this.docBuilder = XMLDPObject.getDocBuilder(this.getContext());
                }
            }
        }
        return this.docBuilder;
    }

    public DPObject getObject(Element e) {
        return ((XMLDPRoot)this.getRoot()).getObject(e);
    }

    public void putObject(DPObject dpo) {
        ((XMLDPRoot)this.getRoot()).putObject(dpo);
    }

    public void removeObject(DPObject dpo) {
        ((XMLDPRoot)this.getRoot()).removeObject(dpo);
    }

    public void removeObject(Element e) {
        ((XMLDPRoot)this.getRoot()).removeObject(e);
    }

    public DPRoot getRoot() {
        return this.dpRoot;
    }

    Element getRootElement() {
        return XMLDPObject.getRootElement(this.getElement());
    }

    static Element getRootElement(Element e) {
        Element rootElement = e.getOwnerDocument().getDocumentElement();
        return rootElement;
    }

    public boolean isRemove() {
        if (this.removed == null) {
            this.removed = this.isDummy() ? (this.isMergeRemove() ? Boolean.TRUE : Boolean.FALSE) : (this.isThisRemove(this.getElement()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.removed;
    }

    public boolean isThisRemove(Element e) {
        if (!XMLDPObject.isDummyElement(e) && XMLDPObject.isRemoveElement(e)) {
            return true;
        }
        Node parentNode = e.getParentNode();
        if (parentNode == null || parentNode.getNodeType() == 9) {
            return false;
        }
        if (parentNode.getNodeType() != 1) {
            throw new DPError("XMLDPProperty.isThisRemove(): parent node was not an element");
        }
        Element parentElement = (Element)parentNode;
        return this.isThisRemove(parentElement);
    }

    public static boolean isRemoveElement(Element e) {
        return e.hasAttribute("merge") && e.getAttribute("merge").equals("remove");
    }

    public boolean isReplace() {
        if (this.replaced == null) {
            this.replaced = this.isThisReplace(this.getElement()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.replaced;
    }

    public boolean isThisReplace(Element e) {
        if (!XMLDPObject.isDummyElement(e) && XMLDPObject.isReplaceElement(e)) {
            return true;
        }
        Node parentNode = e.getParentNode();
        if (parentNode == null || parentNode.getNodeType() == 9) {
            return false;
        }
        if (parentNode.getNodeType() != 1) {
            throw new DPError("XMLDPProperty.isThisReplace(): parent node was not an element");
        }
        Element parentElement = (Element)parentNode;
        return this.isThisReplace(parentElement);
    }

    public static boolean isReplaceElement(Element e) {
        return e.hasAttribute("merge") && e.getAttribute("merge").equals("replace");
    }

    public boolean isMergeReplace() {
        DPObject dpo = this.getLastMerger();
        if (dpo == null) {
            return false;
        }
        return dpo.getMergeType() == 1;
    }

    public boolean isMergeRemove() {
        return this.mergeRemoved;
    }

    public boolean isMergeLocked() {
        return this.mergeLocked;
    }

    public boolean isMergeAdvanced() {
        return this.mergeAdvanced;
    }

    public DPObject getLastMerger() {
        if (this.mergers == null) {
            return null;
        }
        int size = this.mergers.size();
        if (size == 0) {
            return null;
        }
        return (DPObject)this.mergers.get(size - 1);
    }

    public List getMergers() {
        return this.unmodifiableMergers;
    }

    private List getModifiableMergers() {
        if (this.mergers == null) {
            this.mergers = new ArrayList();
            this.unmodifiableMergers = Collections.unmodifiableList(this.mergers);
        }
        return this.mergers;
    }

    public void addMergers(List m) {
        Collections.sort(m);
        for (int i = 0; i < m.size(); ++i) {
            this.addMerger((DPObject)m.get(i));
        }
    }

    public void addMerger(DPObject dpo) {
        if (this.getType() != dpo.getType()) {
            throw new DPError("XMLDPObject.addMerger(): merger type mismatch");
        }
        List m = this.getModifiableMergers();
        if (m.contains(dpo)) {
            throw new DPError("XMLDPObject.addMerger(): merger already added");
        }
        m.add(dpo);
        this.mergeRemoved = dpo.isRemove();
        if (dpo.isLocked()) {
            this.mergeLocked = true;
        }
        if (dpo.isAdvanced()) {
            this.mergeAdvanced = true;
        }
    }

    public static boolean isLockedElement(Element e) {
        String l = e.getAttribute("lock");
        if (l == null || l.length() == 0) {
            return XMLDPObject.staticGetDefaultLockValue();
        }
        boolean lock = XMLDPObject.toBoolean(l);
        return lock;
    }

    public boolean isThisLocked(Element e) {
        if (!XMLDPObject.isDummyElement(e) && XMLDPObject.isLockedElement(e)) {
            return true;
        }
        Node parentNode = e.getParentNode();
        if (parentNode == null || parentNode.getNodeType() == 9) {
            return false;
        }
        if (parentNode.getNodeType() != 1) {
            throw new DPError("XMLDPProperty.isThisLocked(): parent node was not an element");
        }
        Element parentElement = (Element)parentNode;
        return this.isThisLocked(parentElement);
    }

    public boolean isLocked() {
        if (this.locked == null) {
            this.locked = this.isDummy() ? (this.isMergeLocked() ? Boolean.TRUE : Boolean.FALSE) : (this.isThisLocked(this.getElement()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.locked;
    }

    public void setLock(boolean lock) {
        if (lock) {
            this.getElement().setAttribute("lock", "true");
            this.locked = Boolean.TRUE;
        } else {
            this.getElement().setAttribute("lock", "false");
            this.locked = Boolean.FALSE;
        }
    }

    public int getPriority() {
        return this.getRoot().getPriority();
    }

    public void setPriority(int priority) {
        this.getRoot().setPriority(priority);
    }

    public String getVersion() {
        return this.getRoot().getVersion();
    }

    public void setVersion(String version) {
        this.getRoot().setVersion(version);
    }

    public void setMergeType(short type) {
        this.removed = null;
        this.replaced = null;
        this.advanced = null;
        this.mergeType = new Short(type);
        XMLDPObject.setMergeTypeElement(this.getElement(), type);
        this.setDummy(false);
    }

    static void setMergeTypeElement(Element e, int type) {
        switch (type) {
            case 0: {
                e.setAttribute("merge", "fuse");
                break;
            }
            case 1: {
                e.setAttribute("merge", "replace");
                break;
            }
            case 2: {
                e.setAttribute("merge", "remove");
                break;
            }
            default: {
                throw new DPError("XMLDPObject.setMergeType(): unknown type=" + type);
            }
        }
    }

    public short getMergeType() {
        if (this.mergeType == null) {
            this.mergeType = new Short(XMLDPObject.getMergeTypeElement(this.getElement(), this.getDefaultMergeType()));
        }
        return this.mergeType;
    }

    public short getThisMergeType() {
        return XMLDPObject.getMergeTypeElement(this.getElement(), this.getDefaultMergeType());
    }

    private static short getMergeTypeElement(Element e, int defaultType) {
        String t = e.getAttribute("merge");
        if (t == null || t.length() == 0) {
            return (short)defaultType;
        }
        Short type = (Short)mergeTypeTable.get(t);
        if (type == null) {
            throw new DPError("XMLDPObject.getMergeType(): unknown merge type=" + t + " for element=" + e.toString());
        }
        return type;
    }

    public boolean isAdvanced() {
        if (this.advanced == null) {
            this.advanced = this.isDummy() ? (this.isMergeAdvanced() ? Boolean.TRUE : Boolean.FALSE) : (this.isThisAdvanced(this.getElement()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.advanced;
    }

    public void setAdvanced(boolean adv) {
        if (adv) {
            this.getElement().setAttribute("advanced", "true");
            this.advanced = Boolean.TRUE;
        } else {
            this.getElement().setAttribute("advanced", "false");
            this.advanced = Boolean.FALSE;
        }
    }

    public static boolean isAdvancedElement(Element e) {
        String a = e.getAttribute("advanced");
        if (a == null || a.length() == 0) {
            return XMLDPObject.staticGetDefaultAdvancedValue();
        }
        return XMLDPObject.toBoolean(a);
    }

    public boolean isThisAdvanced(Element e) {
        return XMLDPObject.isAdvancedElement(e);
    }

    public DPContext getContext() {
        return this.dpContext;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getParentElement() {
        Node pn = this.getElement().getParentNode();
        Element pe = (Element)pn;
        return pe;
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    public void setElement(Element e) {
        Node parentNode = this.element.getParentNode();
        parentNode.removeChild(this.element);
        parentNode.appendChild(e);
        this.element = e;
        this.checkType();
    }

    public abstract short getType();

    public abstract String getTag();

    public void setDummy(boolean state) {
        if (!state) {
            this.getRoot().setDirty(true);
            this.setDummyElement(this.getElement(), false);
            this.locked = null;
            this.dummy = Boolean.FALSE;
        } else if (state) {
            this.setDummyElement(this.getElement(), true);
            this.dummy = Boolean.TRUE;
        }
    }

    private void setDummyElement(Element e, boolean state) {
        if (state) {
            e.setAttribute("dummy", "true");
        } else {
            Node n;
            if (e.hasAttribute("dummy")) {
                e.removeAttribute("dummy");
            }
            if ((n = e.getParentNode()) == null) {
                return;
            }
            if (n.getNodeType() != 1) {
                return;
            }
            Element parentElement = (Element)n;
            DPObject dpo = this.getObject(parentElement);
            if (dpo != null) {
                dpo.setDummy(false);
            } else {
                this.setDummyElement(parentElement, false);
            }
        }
    }

    public void setDirty(boolean state) {
        this.getRoot().setDirty(state);
    }

    public boolean isDirty() {
        return this.getRoot().isDirty();
    }

    public boolean isMerged() {
        return this.mergers != null && this.mergers.size() > 0;
    }

    private static boolean isDummyElement(Element e) {
        String dummy = e.getAttribute("dummy");
        return dummy != null && dummy.length() != 0 && dummy.equals("true");
    }

    public boolean isDummy() {
        if (this.dummy == null) {
            this.dummy = XMLDPObject.isDummyElement(this.getElement()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.dummy;
    }

    static boolean isAtomicElement(Element e) {
        return e.getTagName().equals("String") || e.getTagName().equals("Boolean") || e.getTagName().equals("Integer") || e.getTagName().equals("Reference");
    }

    static void setName(Element e, String name) {
        e.setAttribute("name", name);
    }

    static String getCachedLocaleName(String l, String c, String v) {
        if (localeNames == null) {
            return null;
        }
        Map countries = (Map)localeNames.get(l);
        if (countries == null) {
            return null;
        }
        Map variants = (Map)countries.get(c);
        if (variants == null) {
            return null;
        }
        String name = (String)variants.get(v);
        return name;
    }

    static void putCachedLocaleName(String l, String c, String v, String name) {
        HashMap<String, String> variants;
        HashMap<String, HashMap<String, String>> countries;
        if (localeNames == null) {
            localeNames = new HashMap();
        }
        if ((countries = (HashMap<String, HashMap<String, String>>)localeNames.get(l)) == null) {
            countries = new HashMap<String, HashMap<String, String>>();
            localeNames.put(l, countries);
        }
        if ((variants = (HashMap<String, String>)countries.get(c)) == null) {
            variants = new HashMap<String, String>();
            countries.put(c, variants);
        }
        variants.put(v, name);
    }

    static String getLocaleName(String l, String c, String v) {
        String name = XMLDPObject.getCachedLocaleName(l, c, v);
        if (name == null) {
            StringBuffer b = new StringBuffer();
            b.append("_locale");
            if (l != null && l.length() > 0) {
                b.append("_");
                b.append(l);
            }
            if (c != null && c.length() > 0) {
                b.append("_");
                b.append(c);
            }
            if (v != null && v.length() > 0) {
                b.append("_");
                b.append(v);
            }
            name = b.toString();
            XMLDPObject.putCachedLocaleName(l, c, v, name);
        }
        return name;
    }

    static boolean isLocaleName(String name) {
        return name.startsWith("_locale");
    }

    static List parseLocaleName(String name) {
        ArrayList<String> attrs = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(name, "_");
        String lang = null;
        String country = null;
        String variant = null;
        tk.nextToken();
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        attrs.add(lang);
        attrs.add(country);
        attrs.add(variant);
        return attrs;
    }

    static String getConditionalPropertiesName(String type, String value) {
        StringBuffer b = new StringBuffer();
        b.append("_conditional").append("_").append(type).append("_").append(value);
        return b.toString();
    }

    static boolean isConditionalPropertiesName(String name) {
        return name.startsWith("_conditional");
    }

    static List parseConditionalPropertiesName(String name) {
        ArrayList<String> attrs = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(name, "_");
        String type = "";
        String value = "";
        tk.nextToken();
        if (tk.hasMoreTokens()) {
            type = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            value = tk.nextToken();
        }
        attrs.add(type);
        attrs.add(value);
        return attrs;
    }

    private static String getNameElement(Element e) {
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            if (e.getTagName().equals("ConditionalProperties")) {
                String condition = e.getAttribute("condition");
                String conditionValue = e.getAttribute("value");
                name = XMLDPObject.getConditionalPropertiesName(condition, conditionValue);
            } else if (e.getTagName().equals("Locale")) {
                String l = e.getAttribute("language");
                String c = e.getAttribute("country");
                String v = e.getAttribute("variant");
                name = XMLDPObject.getLocaleName(l, c, v);
            } else if (XMLDPObject.isAtomicElement(e)) {
                Text textNode = null;
                textNode = XMLDPObject.getTextNode(e);
                if (textNode == null) {
                    String value = e.getAttribute("value");
                    if (value != null && value.length() != 0) {
                        name = value;
                    }
                } else {
                    String text = textNode.getData();
                    if (text != null && text.length() != 0) {
                        name = text;
                    }
                }
            }
        }
        return name;
    }

    protected static Text getTextNode(Element e) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 3) continue;
            return (Text)childNode;
        }
        return null;
    }

    public String getName() {
        if (this.name == null) {
            this.name = XMLDPObject.getNameElement(this.getElement());
        }
        return this.name;
    }

    public void checkType() {
        this.checkType(this.getElement().getTagName());
    }

    void checkType(String actual) {
        if (actual.equals(this.getTag())) {
            return;
        }
        throw new DPError("XMLDPObject.checkType(): wrong type tagName=" + this.getElement().getTagName());
    }

    public String toDebugString() {
        StringBuffer b = new StringBuffer(256);
        b.append("\n\n\n\nthis=\n");
        b.append(this.toString(false));
        for (int i = 0; i < this.getMergers().size(); ++i) {
            DPObject dpo = (DPObject)this.getMergers().get(i);
            b.append("\n\n\n\nmerger(");
            b.append(i);
            b.append(")=");
            b.append(dpo.toString(false));
            b.append("\n\n\n\n");
        }
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer(256);
        XMLDPObject.toStringBuffer(this.getElement(), b, false, 0);
        return b.toString();
    }

    public String toString(boolean prune) {
        StringBuffer b = new StringBuffer(256);
        XMLDPObject.toStringBuffer(this.getElement(), b, prune, 0);
        return b.toString();
    }

    public String toMergedXML() {
        StringBuffer b = new StringBuffer(256);
        XMLDPObject.toStringBuffer(this.getMergedElement(), b, true, 0);
        return b.toString();
    }

    protected abstract Element getMergedElement();

    private static XMLDPEntityResolver getEntityResolver() {
        if (entityResolver == null) {
            entityResolver = new XMLDPEntityResolver();
        }
        return entityResolver;
    }

    private static XMLDPErrorHandler getErrorHandler(DPContext dpc) {
        if (errorHandler == null) {
            errorHandler = new XMLDPErrorHandler(dpc);
        }
        return errorHandler;
    }

    static DocumentBuilder getDocBuilder(DPContext dpc) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        dbf.setValidating(dpc.isValidating());
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new DPError("XMLDPObject.getDocBuilder(): ", pce);
        }
        db.setErrorHandler(XMLDPObject.getErrorHandler(dpc));
        db.setEntityResolver(XMLDPObject.getEntityResolver());
        return db;
    }

    Element createElement(String xml) {
        Document d = null;
        try {
            byte[] bytes = xml.getBytes("UTF-8");
            ByteArrayInputStream byteIS = new ByteArrayInputStream(bytes);
            InputSource is = new InputSource(byteIS);
            d = this.getDocBuilder().parse(is);
        }
        catch (SAXParseException spe) {
            throw new DPError("XMLDPRoot.createElement(): line=" + spe.getLineNumber() + ".  ", spe);
        }
        catch (SAXException se) {
            throw new DPError("XMLDPRoot.createElement(): ", se);
        }
        catch (IOException ioe) {
            throw new DPError("XMLDPRoot.createElement(): ", ioe);
        }
        Element docElement = d.getDocumentElement();
        Element importedElement = (Element)this.getDocument().importNode(docElement, true);
        return importedElement;
    }

    static short getType(Element e) {
        if (e.getTagName().equals("String")) {
            return 1;
        }
        if (e.getTagName().equals("Reference")) {
            return 8;
        }
        if (e.getTagName().equals("Collection")) {
            return 14;
        }
        if (e.getTagName().equals("Integer")) {
            return 3;
        }
        if (e.getTagName().equals("Boolean")) {
            return 4;
        }
        if (e.getTagName().equals("Channel")) {
            return 6;
        }
        if (e.getTagName().equals("Container")) {
            return 5;
        }
        if (e.getTagName().equals("Properties")) {
            return 5;
        }
        if (e.getTagName().equals("Provider")) {
            return 12;
        }
        return -1;
    }

    static List getChildElements(Element e, String tagName) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        ArrayList<Element> childElements = new ArrayList<Element>();
        for (int i = 0; i < numChildren; ++i) {
            String childTagName;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName)) continue;
            childElements.add(childElement);
        }
        return childElements;
    }

    static Element getChildElement(Element e, String tagName) {
        return XMLDPObject.getChildElement(e, tagName, null);
    }

    static Element getChildElement(Element e, String tagName, String name) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        for (int i = 0; i < numChildren; ++i) {
            String childName;
            String childTagName;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            if (tagName != null && !(childTagName = childElement.getTagName()).equals(tagName) || name != null && !(childName = XMLDPObject.getNameElement(childElement)).equals(name)) continue;
            return childElement;
        }
        return null;
    }

    static void appendBuffer(String a, StringBuffer b, int indent) {
        if (b.length() != 0 && b.charAt(b.length() - 1) == '\n') {
            for (int i = 0; i < indent * 4; ++i) {
                b.append(" ");
            }
        }
        b.append(a);
    }

    static void toStringBuffer(Node n, StringBuffer b, boolean prune, int indent) {
        switch (n.getNodeType()) {
            case 1: {
                Node s;
                Element e = (Element)n;
                if (prune && e.hasAttribute("dummy")) {
                    return;
                }
                XMLDPObject.appendBuffer("<", b, indent);
                XMLDPObject.appendBuffer(e.getTagName(), b, indent);
                NamedNodeMap attrs = e.getAttributes();
                if (attrs != null) {
                    int numAttrs = attrs.getLength();
                    for (int i = 0; i < numAttrs; ++i) {
                        Node na = attrs.item(i);
                        if (na.getNodeType() != 2) continue;
                        Attr a = (Attr)na;
                        XMLDPObject.appendBuffer(" ", b, indent);
                        XMLDPObject.appendBuffer(Encoder.XML_ENCODER.encode(a.getName()), b, indent);
                        XMLDPObject.appendBuffer("=\"", b, indent);
                        XMLDPObject.appendBuffer(Encoder.XML_ENCODER.encode(a.getValue()), b, indent);
                        XMLDPObject.appendBuffer("\"", b, indent);
                    }
                }
                boolean appendNewline = (s = e.getNextSibling()) == null || s.getNodeType() != 3;
                NodeList nodes = e.getChildNodes();
                if (nodes.getLength() == 0) {
                    if (appendNewline) {
                        XMLDPObject.appendBuffer("/>\n", b, indent);
                        break;
                    }
                    XMLDPObject.appendBuffer("/>", b, indent);
                    break;
                }
                if (nodes.item(0).getNodeType() == 3) {
                    XMLDPObject.appendBuffer(">", b, indent);
                } else {
                    XMLDPObject.appendBuffer(">\n", b, indent);
                }
                for (int j = 0; j < nodes.getLength(); ++j) {
                    XMLDPObject.toStringBuffer(nodes.item(j), b, prune, indent + 1);
                }
                XMLDPObject.appendBuffer("</", b, indent);
                XMLDPObject.appendBuffer(e.getTagName(), b, indent);
                if (appendNewline) {
                    XMLDPObject.appendBuffer(">\n", b, indent);
                    break;
                }
                XMLDPObject.appendBuffer(">", b, indent);
                break;
            }
            case 8: {
                Comment c = (Comment)n;
                XMLDPObject.appendBuffer("<!--", b, indent);
                XMLDPObject.appendBuffer(c.getData(), b, indent);
                XMLDPObject.appendBuffer("-->\n", b, indent);
                break;
            }
            case 3: {
                Text t = (Text)n;
                String text = t.getData();
                if (text.length() <= 0) break;
                XMLDPObject.appendBuffer(Encoder.XML_ENCODER.encode(text), b, 0);
                break;
            }
            default: {
                throw new DPError("XMLDPObject.toStringBuffer(): unknown node type encountered");
            }
        }
    }

    static Element createElement(DPContext dpc, Document d, String tagName) {
        Element e = d.createElement(tagName);
        return e;
    }

    static Element createElement(DPContext dpc, Document d, String tagName, String name) {
        Element e = XMLDPObject.createElement(dpc, d, tagName);
        if (name != null) {
            XMLDPObject.setName(e, name);
        }
        return e;
    }

    public int compareTo(Object o) {
        DPObject dpo = (DPObject)o;
        if (this.getPriority() < dpo.getPriority()) {
            return -1;
        }
        if (this.getPriority() > dpo.getPriority()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XMLDPObject)) {
            return false;
        }
        XMLDPObject xmldpo = (XMLDPObject)o;
        Element e = this.getElement();
        Element f = xmldpo.getElement();
        boolean eq = e.equals(f);
        return eq;
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public static boolean staticGetDefaultLockValue() {
        return false;
    }

    public boolean getDefaultLockValue() {
        return XMLDPObject.staticGetDefaultLockValue();
    }

    public static boolean staticGetDefaultAdvancedValue() {
        return false;
    }

    public boolean getDefaultAdvancedValue() {
        return XMLDPObject.staticGetDefaultAdvancedValue();
    }

    public static boolean staticGetDefaultPropagateValue() {
        return true;
    }

    public boolean getDefaultPropagateValue() {
        return XMLDPObject.staticGetDefaultPropagateValue();
    }

    public void appendMergeAttr(StringBuffer b) {
        if (this.getMergeType() != this.getDefaultMergeType()) {
            b.append(" merge=\"").append(MERGETYPE_VALUES[this.getMergeType()]).append("\"");
        }
    }

    public void appendLockAttr(StringBuffer b) {
        if (XMLDPObject.isLockedElement(this.getElement()) != this.getDefaultLockValue()) {
            b.append(" lock=\"").append(this.isLocked()).append("\"");
        }
    }

    public void appendAdvancedAttr(StringBuffer b) {
        if (XMLDPObject.isAdvancedElement(this.getElement()) != this.getDefaultAdvancedValue()) {
            b.append(" advanced=\"").append(this.isAdvanced()).append("\"");
        }
    }

    public void appendStartTag(StringBuffer b) {
        b.append("<").append(this.getTag());
    }

    public void appendEndTag(StringBuffer b) {
        b.append("</").append(this.getTag()).append(">\n");
    }

    public void indentBuffer(StringBuffer b, int indent) {
        if (b.length() != 0 && b.charAt(b.length() - 1) == '\n') {
            for (int i = 0; i < indent * 4; ++i) {
                b.append(" ");
            }
        }
    }

    public static int max(int a, int b, int c) {
        return Math.max(a, Math.max(b, c));
    }

    static {
        mergeTypeTable = new HashMap();
        mergeTypeTable.put("fuse", new Short(0));
        mergeTypeTable.put("replace", new Short(1));
        mergeTypeTable.put("remove", new Short(2));
        MERGETYPE_VALUES = new String[XMLDPObject.max(0, 1, 2) + 1];
        XMLDPObject.MERGETYPE_VALUES[0] = "fuse";
        XMLDPObject.MERGETYPE_VALUES[1] = "replace";
        XMLDPObject.MERGETYPE_VALUES[2] = "remove";
        ccount = 0L;
        localeNames = null;
        entityResolver = null;
        errorHandler = null;
    }
}

