/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.dp.DPAvailable;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPConditionalProperties;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPFactory;
import com.sun.portal.desktop.dp.DPLocale;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReference;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPSelected;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAvailable;
import com.sun.portal.desktop.dp.xml.XMLDPBoolean;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPConditionalProperties;
import com.sun.portal.desktop.dp.xml.XMLDPContainerChannel;
import com.sun.portal.desktop.dp.xml.XMLDPInteger;
import com.sun.portal.desktop.dp.xml.XMLDPLocale;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPProvider;
import com.sun.portal.desktop.dp.xml.XMLDPReference;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPSelected;
import com.sun.portal.desktop.dp.xml.XMLDPString;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPFactory
implements DPFactory,
DPTypes,
XMLDPTags {
    protected static XMLDPFactory factory = new XMLDPFactory();
    protected static final char CHANNEL_NAME_SEPARATOR = '/';

    public static XMLDPFactory getInstance() {
        return factory;
    }

    private XMLDPFactory() {
    }

    public DPRoot getRoot(DPContext dpc, Element e) {
        if (e.getTagName().equals("DisplayProfile")) {
            return new XMLDPRoot(dpc, e);
        }
        throw new DPError("XMLDPFactory.getRoot(): not root node tagName=" + e.getTagName());
    }

    public DPNode getNode(DPContext dpc, DPRoot r, Element e) {
        String name = e.getAttribute("name");
        if (name.indexOf(47) != -1) {
            throw new DPError("XMLDPFactory.getNode(): invalid character \"/\" found in the name=" + name);
        }
        if (e.getTagName().equals("DisplayProfile")) {
            return new XMLDPRoot(dpc, e);
        }
        if (e.getTagName().equals("Channel")) {
            return new XMLDPChannel(dpc, r, e);
        }
        if (e.getTagName().equals("Container")) {
            return new XMLDPContainerChannel(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getNode(): unknown node type tagName=" + e.getTagName());
    }

    public DPPropertyHolder getPropertyHolder(DPContext dpc, DPRoot r, Element e) {
        DPPropertyHolder dpph = null;
        dpph = e.getTagName().equals("Provider") ? this.getProvider(dpc, r, e) : this.getNode(dpc, r, e);
        return dpph;
    }

    public DPProperty getProperty(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("String")) {
            return new XMLDPString(dpc, r, e);
        }
        if (e.getTagName().equals("Reference")) {
            return new XMLDPReference(dpc, r, e);
        }
        if (e.getTagName().equals("Integer")) {
            return new XMLDPInteger(dpc, r, e);
        }
        if (e.getTagName().equals("Boolean")) {
            return new XMLDPBoolean(dpc, r, e);
        }
        if (e.getTagName().equals("Collection")) {
            return new XMLDPCollection(dpc, r, e);
        }
        if (e.getTagName().equals("Locale")) {
            return new XMLDPLocale(dpc, r, e);
        }
        if (e.getTagName().equals("Properties")) {
            return new XMLDPProperties(dpc, r, e);
        }
        if (e.getTagName().equals("ConditionalProperties")) {
            return new XMLDPConditionalProperties(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getProperty(): unknown property type tagName=" + e.getTagName());
    }

    public DPCollection getCollectionProperty(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Collection") || e.getTagName().equals("Locale") || e.getTagName().equals("Selected") || e.getTagName().equals("Available") || e.getTagName().equals("Properties") || e.getTagName().equals("ConditionalProperties")) {
            return new XMLDPCollection(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getCollectionProperty(): unknown property type tagName=" + e.getTagName());
    }

    public DPReference getReference(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Reference")) {
            return new XMLDPReference(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getReference(): not a reference element tagName=" + e.getTagName());
    }

    public DPProperties getProperties(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Properties")) {
            return new XMLDPProperties(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getProperties(): not a properties element tagName=" + e.getTagName());
    }

    public DPConditionalProperties getConditionalProperties(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("ConditionalProperties")) {
            return new XMLDPConditionalProperties(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getProperties(): not a conditionalproperties element tagName=" + e.getTagName());
    }

    public DPSelected getSelected(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Selected")) {
            return new XMLDPSelected(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getSelected(): not a selected element tagName=" + e.getTagName());
    }

    public DPAvailable getAvailable(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Available")) {
            return new XMLDPAvailable(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getAvailable(): not an available element tagName=" + e.getTagName());
    }

    public DPChannel getChannel(DPContext dpc, DPRoot r, Element e) {
        String name = e.getAttribute("name");
        if (name.indexOf(47) != -1) {
            throw new DPError("XMLDPFactory.getchannel(): invalid character \"/\" found in the name=" + name);
        }
        if (e.getTagName().equals("Channel")) {
            return new XMLDPChannel(dpc, r, e);
        }
        if (e.getTagName().equals("Container")) {
            return new XMLDPContainerChannel(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getChannel(): unknown channel type tagName=" + e.getTagName());
    }

    public DPProvider getProvider(DPContext dpc, DPRoot r, Element e) {
        if (e.getTagName().equals("Provider")) {
            return new XMLDPProvider(dpc, r, e);
        }
        throw new DPError("XMLDPFactory.getProvider(): unknown provider type tagName=" + e.getTagName());
    }

    public DPProperty createProperty(DPContext dpc, DPRoot r, Document d, String name, Object o) {
        if (o instanceof String) {
            return new XMLDPString(dpc, r, d, name, (String)o);
        }
        if (o instanceof Boolean) {
            return new XMLDPBoolean(dpc, r, d, name, (Boolean)o);
        }
        if (o instanceof Integer) {
            return new XMLDPInteger(dpc, r, d, name, (Integer)o);
        }
        if (o instanceof List) {
            return new XMLDPCollection(dpc, r, d, name, (List)o);
        }
        if (o instanceof Map) {
            return new XMLDPCollection(dpc, r, d, name, (Map)o);
        }
        return new XMLDPString(dpc, r, d, name, o.toString());
    }

    public DPProperty createProperty(DPContext dpc, DPRoot r, Document d, Object o) {
        if (o instanceof String) {
            return new XMLDPString(dpc, r, d, (String)o);
        }
        if (o instanceof Boolean) {
            return new XMLDPBoolean(dpc, r, d, (Boolean)o);
        }
        if (o instanceof Integer) {
            return new XMLDPInteger(dpc, r, d, (Integer)o);
        }
        return new XMLDPString(dpc, r, d, o.toString());
    }

    public DPReference createReference(DPContext dpc, DPRoot r, Document d, String ref) {
        return new XMLDPReference(dpc, r, d, ref);
    }

    public DPString createString(DPContext dpc, DPRoot r, Document d, String name, String value) {
        return new XMLDPString(dpc, r, d, name, value);
    }

    public DPProperties createProperties(DPContext dpc, DPRoot r, Document d) {
        return new XMLDPProperties(dpc, r, d);
    }

    public DPConditionalProperties createConditionalProperties(DPContext dpc, DPRoot r, Document d, String type, String value) {
        return new XMLDPConditionalProperties(dpc, r, d, type, value);
    }

    public DPConditionalProperties createConditionalProperties(DPContext dpc, DPRoot r, Document d, String type, String value, Map m) {
        return new XMLDPConditionalProperties(dpc, r, d, type, value, m);
    }

    public DPAvailable createAvailable(DPContext dpc, DPRoot r, Document d) {
        return new XMLDPAvailable(dpc, r, d);
    }

    public DPSelected createSelected(DPContext dpc, DPRoot r, Document d) {
        return new XMLDPSelected(dpc, r, d);
    }

    public DPChannel createChannel(DPContext dpc, DPRoot r, Document d, String name, String providerName) {
        if (name.indexOf(47) != -1) {
            throw new DPError("XMLDPFactory.getNode(): invalid character,\"/\" found in the name=" + name);
        }
        return new XMLDPChannel(dpc, r, d, name, providerName);
    }

    public DPContainerChannel createContainerChannel(DPContext dpc, DPRoot r, Document d, String name, String providerName) {
        if (name.indexOf(47) != -1) {
            throw new DPError("XMLDPFactory.getNode(): invalid character,\"/\" found in the name=" + name);
        }
        return new XMLDPContainerChannel(dpc, r, d, name, providerName);
    }

    public DPProvider createProvider(DPContext dpc, DPRoot r, Document d, String name, String className, int providerVersion) {
        return new XMLDPProvider(dpc, r, d, name, className, providerVersion);
    }

    public DPLocale createLocale(DPContext dpc, DPRoot r, Document d, String lang, String country, String variant) {
        return new XMLDPLocale(dpc, r, d, lang, country, variant);
    }

    public DPLocale createLocale(DPContext dpc, DPRoot r, Document d, String lang, String country, String variant, Map m) {
        return new XMLDPLocale(dpc, r, d, lang, country, variant, m);
    }

    public DPRoot createRoot(DPContext dpc, DPUserContext dpuc, Map dpRoots, boolean merge) {
        byte[] userDoc = dpuc.getDPUserDocument();
        XMLDPRoot dpr = null;
        if (userDoc == null || userDoc.length == 0) {
            dpr = new XMLDPRoot(dpc);
        } else {
            ByteArrayInputStream s = new ByteArrayInputStream(userDoc);
            dpr = new XMLDPRoot(dpc, s);
        }
        if (!merge) {
            return dpr;
        }
        Set names = null;
        names = dpuc.getDPDocumentNames();
        return this.addMergers(dpc, dpr, names, dpRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DPRoot addMergers(DPContext dpc, DPRoot dpr, Set names, Map dpRoots) {
        ArrayList<DPRoot> mergers = new ArrayList<DPRoot>();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPRoot dprMerger = null;
            if (dpRoots != null) {
                dprMerger = (DPRoot)dpRoots.get(name);
            }
            if (dprMerger == null) {
                XMLDPFactory xMLDPFactory = this;
                synchronized (xMLDPFactory) {
                    if (dpRoots != null) {
                        dprMerger = (DPRoot)dpRoots.get(name);
                    }
                    if (dprMerger == null) {
                        String val = dpc.getDPDocument(name);
                        if (val == null || val.length() == 0) {
                            continue;
                        }
                        dprMerger = new XMLDPRoot(dpc, val);
                        if (dpRoots != null) {
                            dpRoots.put(name, dprMerger);
                        }
                    }
                }
            }
            mergers.add(dprMerger);
        }
        dpr.addMergers(mergers);
        return dpr;
    }

    public DPRoot createRoot(DPContext dpc) {
        XMLDPRoot dpr = new XMLDPRoot(dpc);
        return dpr;
    }

    public DPRoot createRoot(DPContext dpc, String doc) {
        XMLDPRoot dpr = null;
        if (doc == null) {
            throw new DPError("XMLDPFactory.createRoot(): document was null");
        }
        dpr = new XMLDPRoot(dpc, doc);
        return dpr;
    }

    public DPRoot createRoot(DPContext dpc, InputStream xmlByteStream) {
        XMLDPRoot dpr = null;
        if (xmlByteStream == null) {
            throw new DPError("XMLDPFactory.createRoot(): document was null");
        }
        dpr = new XMLDPRoot(dpc, xmlByteStream);
        return dpr;
    }

    public DPRoot createRoot(DPContext dpc, String baseName, Map dpRoots) {
        DPRoot dpRoot = (DPRoot)dpRoots.get(baseName);
        if (dpRoot == null) {
            String dpText = dpc.getDPDocument(baseName);
            dpRoot = dpText != null && dpText.length() > 0 ? this.createRoot(dpc, dpText) : this.createRoot(dpc);
            Set mergers = dpc.getDPDocumentNames(baseName);
            dpRoot = this.addMergers(dpc, dpRoot, mergers, dpRoots);
            dpRoots.put(baseName, dpRoot);
        }
        if (dpRoot.getMergers() == null || dpRoot.getMergers().isEmpty()) {
            Set mergers = dpc.getDPDocumentNames(baseName);
            dpRoot = this.addMergers(dpc, dpRoot, mergers, dpRoots);
            dpRoots.put(baseName, dpRoot);
        }
        return dpRoot;
    }
}

