/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPAvailable;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReferenceList;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPSelected;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPContainerChannel;
import com.sun.portal.desktop.dp.xml.XMLDPEntityResolver;
import com.sun.portal.desktop.dp.xml.XMLDPErrorHandler;
import com.sun.portal.desktop.dp.xml.XMLDPProvider;
import com.sun.portal.desktop.dp.xml.XMLDPReferenceList;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class DPAUtil {
    public static final String RESOURCE_BASE = "desktopDPA";
    public static ResourceBundle rb = PropertyResourceBundle.getBundle("desktopDPA", Locale.getDefault());
    public static final int CONTEXT_LINE_NUM = 5;

    DPAUtil() {
    }

    public static void setLocale(Locale locale) {
        rb = PropertyResourceBundle.getBundle(RESOURCE_BASE, locale);
    }

    public static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public static String getLocalizedString(String key) {
        return rb.getString(key);
    }

    public static String getLocalizedString(String key, Object[] objs) {
        if (objs != null && objs.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(rb.getLocale());
            mf.applyPattern(rb.getString(key));
            return mf.format(objs);
        }
        return rb.getString(key);
    }

    public static Element getElement(DPContext adc, InputStream xmlByteStream) throws DPAException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            dbf.setValidating(false);
            db = dbf.newDocumentBuilder();
            db.setErrorHandler(new XMLDPErrorHandler(adc));
            db.setEntityResolver(new XMLDPEntityResolver());
        }
        catch (Exception ex) {
            throw new DPAException("errorDocumentBuilder", ex);
        }
        Document d = null;
        try {
            xmlByteStream.reset();
            InputSource is = new InputSource(xmlByteStream);
            d = db.parse(is);
        }
        catch (SAXParseException spe) {
            Object[] tokens = new Object[]{Integer.toString(spe.getLineNumber())};
            throw new DPAException("errorXMLParseLine", spe, tokens);
        }
        catch (Exception e) {
            throw new DPAException("errorXMLParse", e);
        }
        if (d.getDoctype() == null) {
            throw new DPAException("errorMissingDocType");
        }
        return d.getDocumentElement();
    }

    public static void combineProperties(DPCollection oldDpp, DPCollection newDpp) throws DPAException {
        DPAUtil.combineCollections(oldDpp, newDpp);
        XMLDPCollection xmlNewDpp = (XMLDPCollection)newDpp;
        Element e = xmlNewDpp.getElement();
        oldDpp.setMergeType(newDpp.getMergeType());
        oldDpp.setLock(XMLDPCollection.isLockedElement(e));
        oldDpp.setPropagate(XMLDPCollection.isPropagateElement(e));
        oldDpp.setAdvanced(XMLDPCollection.isAdvancedElement(e));
    }

    public static void combineLists(DPReferenceList oldDpl, DPReferenceList newDpl) throws DPAException {
        DPAUtil.combineCollections(oldDpl, newDpl);
        XMLDPReferenceList xmlNewDpl = (XMLDPReferenceList)newDpl;
        Element e = xmlNewDpl.getElement();
        oldDpl.setMergeType(newDpl.getMergeType());
        oldDpl.setLock(XMLDPReferenceList.isLockedElement(e));
        oldDpl.setAdvanced(XMLDPReferenceList.isAdvancedElement(e));
    }

    private static void combineCollections(DPCollection oldDpc, DPCollection newDpc) throws DPAException {
        XMLDPCollection xnewDpc = (XMLDPCollection)newDpc;
        Set names = xnewDpc.getNamesFromThis();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DPProperty dpProperty = xnewDpc.getFromThis(name);
            XMLDPCollection xoldDpc = (XMLDPCollection)oldDpc;
            DPProperty oldDpProperty = xoldDpc.getFromThis(name);
            if (oldDpProperty == null) {
                oldDpc.add(dpProperty);
                continue;
            }
            if (dpProperty.getType() == oldDpProperty.getType()) {
                if (dpProperty instanceof DPCollection) {
                    DPCollection collection = (DPCollection)dpProperty;
                    DPCollection oldCollection = (DPCollection)oldDpProperty;
                    DPAUtil.combineCollections(oldCollection, collection);
                    continue;
                }
                oldDpc.remove(name);
                oldDpc.add(dpProperty);
                continue;
            }
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorCombineConflict", tokens);
        }
    }

    public static void combineChannels(DPChannel oldDpc, DPChannel newDpc) throws DPAException {
        if (oldDpc.getType() != newDpc.getType()) {
            Object[] tokens = new Object[]{oldDpc.getName()};
            throw new DPAException("errorCombineConflict", tokens);
        }
        XMLDPChannel xoldDpc = (XMLDPChannel)oldDpc;
        XMLDPChannel xnewDpc = (XMLDPChannel)newDpc;
        DPProperties oprops = xoldDpc.getPropertiesFromThis();
        DPProperties nprops = xnewDpc.getPropertiesFromThis();
        DPAUtil.combineProperties(oprops, nprops);
        if (oldDpc instanceof DPContainerChannel) {
            XMLDPContainerChannel xoldDpcc = (XMLDPContainerChannel)oldDpc;
            XMLDPContainerChannel xnewDpcc = (XMLDPContainerChannel)newDpc;
            DPAvailable odpa = xoldDpcc.getAvailableFromThis();
            DPSelected odps = xoldDpcc.getSelectedFromThis();
            DPAvailable ndpa = xnewDpcc.getAvailableFromThis();
            DPSelected ndps = xnewDpcc.getSelectedFromThis();
            DPAUtil.combineLists(odpa, ndpa);
            DPAUtil.combineLists(odps, ndps);
            Set names = xnewDpc.getChannelNamesFromThis();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                DPChannel nch = xnewDpc.getChannelFromThis(name);
                DPChannel och = null;
                och = xoldDpc.getChannelFromThis(name);
                if (och != null) {
                    DPAUtil.combineChannels(och, nch);
                    continue;
                }
                oldDpc.addChannel(nch);
            }
        }
        XMLDPChannel xmlNewDpc = (XMLDPChannel)newDpc;
        Element e = xmlNewDpc.getElement();
        oldDpc.setProviderName(newDpc.getProviderName());
        oldDpc.setMergeType(newDpc.getMergeType());
        oldDpc.setLock(XMLDPChannel.isLockedElement(e));
        oldDpc.setAdvanced(XMLDPChannel.isAdvancedElement(e));
    }

    public static void combineProviders(DPProvider oldDpp, DPProvider newDpp) throws DPAException {
        XMLDPProvider xoldDpp = (XMLDPProvider)oldDpp;
        XMLDPProvider xnewDpp = (XMLDPProvider)newDpp;
        DPProperties oprops = xoldDpp.getPropertiesFromThis();
        DPProperties nprops = xnewDpp.getPropertiesFromThis();
        DPAUtil.combineProperties(oprops, nprops);
        XMLDPProvider xmlNewDpp = (XMLDPProvider)newDpp;
        Element e = xmlNewDpp.getElement();
        oldDpp.setClassName(newDpp.getClassName());
        oldDpp.setProviderVersion(newDpp.getProviderVersion());
        oldDpp.setMergeType(newDpp.getMergeType());
        oldDpp.setLock(XMLDPProvider.isLockedElement(e));
        oldDpp.setAdvanced(XMLDPProvider.isAdvancedElement(e));
    }

    public static void combineRoots(DPRoot oldDpr, DPRoot newDpr) throws DPAException {
        XMLDPRoot xoldDpr = (XMLDPRoot)oldDpr;
        XMLDPRoot xnewDpr = (XMLDPRoot)newDpr;
        DPProperties oprops = xoldDpr.getPropertiesFromThis();
        DPProperties nprops = xnewDpr.getPropertiesFromThis();
        DPAUtil.combineProperties(oprops, nprops);
        Set channels = xnewDpr.getChannelNamesFromThis();
        Iterator i = channels.iterator();
        while (i.hasNext()) {
            String ch = (String)i.next();
            DPChannel odpc = xoldDpr.getChannelFromThis(ch);
            DPChannel ndpc = xnewDpr.getChannelFromThis(ch);
            if (odpc != null) {
                DPAUtil.combineChannels(odpc, ndpc);
                continue;
            }
            oldDpr.addChannel(ndpc);
        }
        Set providers = xnewDpr.getProviderNamesFromThis();
        Iterator i2 = providers.iterator();
        while (i2.hasNext()) {
            String ch = (String)i2.next();
            DPProvider odpc = xoldDpr.getProviderFromThis(ch);
            DPProvider ndpc = xnewDpr.getProviderFromThis(ch);
            if (odpc != null) {
                DPAUtil.combineProviders(odpc, ndpc);
                continue;
            }
            oldDpr.addProvider(ndpc);
        }
        XMLDPRoot xmlNewDpr = (XMLDPRoot)newDpr;
        Element e = xmlNewDpr.getElement();
        oldDpr.setVersion(newDpr.getVersion());
        oldDpr.setMergeType(newDpr.getMergeType());
        oldDpr.setLock(XMLDPRoot.isLockedElement(e));
        oldDpr.setPriority(newDpr.getPriority());
        oldDpr.setAdvanced(XMLDPRoot.isAdvancedElement(e));
    }

    public static String getLines(Reader reader, int linenum) {
        StringBuffer buf = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(reader);
        try {
            int i = 1;
            int beg = linenum - 5;
            int end = linenum + 5;
            buf.append("\n");
            while ((line = br.readLine()) != null) {
                if (i == linenum) {
                    buf.append("(*)").append(line).append("\n");
                } else if (i >= beg && i <= end) {
                    buf.append("   ").append(line).append("\n");
                }
                ++i;
            }
            buf.append("\n");
        }
        catch (IOException ioe) {
            return "";
        }
        return buf.toString();
    }
}

