/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPReferenceList;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPContainerChannel;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPReferenceList;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.log.common.PortalLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

class DPARemove {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$dp$cli$DPARemove == null ? (class$com$sun$portal$desktop$dp$cli$DPARemove = DPARemove.class$("com.sun.portal.desktop.dp.cli.DPARemove")) : class$com$sun$portal$desktop$dp$cli$DPARemove));
    XMLDPFactory dpf = XMLDPFactory.getInstance();
    boolean verbose = false;
    private static final String TYPE_ROOT = "root";
    private static final String TYPE_CHANNEL = "channel";
    private static final String TYPE_PROVIDER = "provider";
    private static final String TYPE_PROPERTY = "property";
    private static final String TYPE_AVAILABLE = "available";
    private static final String TYPE_SELECTED = "selected";
    static /* synthetic */ Class class$com$sun$portal$desktop$dp$cli$DPARemove;

    DPARemove() {
    }

    public void process(AdminDPContext adc, String dn, boolean global, String parent, String name, String type, boolean verbose, boolean dryrun, Logger logger) throws DPAException {
        this.verbose = verbose;
        if (type.toLowerCase().equals(TYPE_ROOT)) {
            try {
                if (!global) {
                    adc.removeDPDocument(dn);
                } else {
                    adc.removeGlobalDPDocument();
                }
                return;
            }
            catch (Throwable ex) {
                Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
                throw new DPAException("errorRemoveDP", ex, tokens);
            }
        }
        DPRoot dpr = null;
        String doc = null;
        try {
            doc = !global ? adc.getDPDocument(dn) : adc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        try {
            dpr = this.dpf.createRoot((DPContext)adc, doc);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens);
        }
        if (type.toLowerCase().equals(TYPE_CHANNEL)) {
            if (name == null) {
                throw new DPAException("errorChannelNameUnspecified");
            }
            dpr = this.doRemoveChannel(dpr, parent, name);
        } else if (type.toLowerCase().equals(TYPE_PROVIDER)) {
            if (name == null) {
                throw new DPAException("errorProviderNameUnspecified");
            }
            if (parent != null) {
                Object[] tokens = new Object[]{parent};
                throw new DPAException("errorProviderCannotHaveParent", tokens);
            }
            dpr = this.doRemoveProvider(dpr, name);
        } else if (type.toLowerCase().equals(TYPE_PROPERTY)) {
            if (name == null) {
                throw new DPAException("errorPropertyNameUnspecified");
            }
            dpr = this.doRemoveProperty(dpr, parent, name);
        } else if (type.toLowerCase().equals(TYPE_AVAILABLE) || type.toLowerCase().equals(TYPE_SELECTED)) {
            if (name == null) {
                throw new DPAException("errorReferenceValueUnspecified");
            }
            if (parent == null) {
                throw new DPAException("errorParentUnspecified");
            }
            dpr = this.doRemoveReference(dpr, parent, name, type);
        } else {
            Object[] tokens = new Object[]{type};
            throw new DPAException("errorInvalidType", tokens);
        }
        if (!dryrun) {
            if (verbose) {
                logger.log(Level.FINEST, "PSDT_CSPDDC0047");
            }
            try {
                if (dpr.isDirty()) {
                    dpr.setDirty(false);
                }
                StringBuffer sb = new StringBuffer(256);
                dpr.toXML(sb, 0);
                if (!global) {
                    adc.storeDPDocument(dn, sb.toString());
                } else {
                    adc.storeGlobalDPDocument(sb.toString());
                }
            }
            catch (Throwable ex) {
                throw new DPAException("errorStoreDP", ex);
            }
        }
    }

    private DPRoot doRemoveChannel(DPRoot dpr, String parent, String name) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{name, parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0048", tokens2);
        }
        DPNode node = null;
        try {
            if (parent == null) {
                node = dpr;
            } else {
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0049", tokens);
                }
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                node = xdpr.getChannelFromThis(parent);
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (this.verbose) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0050", tokens);
        }
        DPChannel ch = null;
        try {
            XMLDPNode xnode = (XMLDPNode)node;
            ch = xnode.getChannelFromThis(name);
        }
        catch (Throwable ex) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorLookupChannel", ex, tokens4);
        }
        if (ch == null) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorFindChannel", tokens5);
        }
        try {
            String leafName = null;
            int i = name.lastIndexOf(47);
            leafName = i != -1 ? name.substring(i + 1) : name;
            ((XMLDPChannel)ch).getParentNodeFromThis().removeChannel(leafName);
        }
        catch (Throwable ex) {
            Object[] tokens6 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorRemoveChannel", ex, tokens6);
        }
        return dpr;
    }

    private DPRoot doRemoveProvider(DPRoot dpr, String name) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{name};
            logger.log(Level.FINEST, "PSDT_CSPDDC0051", tokens);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0052");
        }
        boolean exists = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            exists = xdpr.getProviderFromThis(name) != null;
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorLookupProvider", ex, tokens);
        }
        if (!exists) {
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorFindProvider", tokens);
        }
        try {
            dpr.removeProvider(name);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorRemoveProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot doRemoveProperty(DPRoot dpr, String parent, String name) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{name, parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0053", tokens2);
        }
        DPPropertyHolder ph = null;
        try {
            if (parent == null) {
                ph = dpr;
            } else {
                XMLDPRoot xdpr;
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0054", tokens);
                }
                if ((ph = (xdpr = (XMLDPRoot)dpr).getChannelFromThis(parent)) == null) {
                    ph = xdpr.getProviderFromThis(parent);
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (ph == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0055", tokens);
        }
        DPProperties props = null;
        boolean exists = false;
        try {
            XMLDPPropertyHolder xph = (XMLDPPropertyHolder)ph;
            props = xph.getPropertiesFromThis();
            XMLDPProperties xprops = (XMLDPProperties)props;
            exists = xprops.getFromThis(name) != null;
        }
        catch (Throwable ex) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorLookupProperty", ex, tokens4);
        }
        if (!exists) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorFindProperty", tokens5);
        }
        try {
            props.remove(name);
        }
        catch (Throwable ex) {
            Object[] tokens6 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, name};
            throw new DPAException("errorRemoveProperty", ex, tokens6);
        }
        return dpr;
    }

    private DPRoot doRemoveReference(DPRoot dpr, String parent, String value, String type) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{type, value, parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0056", tokens2);
        }
        DPChannel node = null;
        try {
            if (this.verbose) {
                tokens = new Object[]{parent};
                logger.log(Level.FINEST, "PSDT_CSPDDC0057", tokens);
            }
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            node = xdpr.getChannelFromThis(parent);
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (node == null) {
            tokens = new Object[]{parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (!(node instanceof DPContainerChannel)) {
            tokens = new Object[]{parent};
            throw new DPAException("errorParentNotCotainer", tokens);
        }
        if (this.verbose) {
            tokens = new Object[]{type, parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0058", tokens);
        }
        DPContainerChannel cc = (DPContainerChannel)node;
        DPReferenceList rl = null;
        boolean exists = false;
        try {
            XMLDPContainerChannel xcc = (XMLDPContainerChannel)cc;
            if (type.toLowerCase().equals(TYPE_AVAILABLE)) {
                rl = xcc.getAvailableFromThis();
            } else if (type.toLowerCase().equals(TYPE_SELECTED)) {
                rl = xcc.getSelectedFromThis();
            }
            XMLDPReferenceList xrl = (XMLDPReferenceList)rl;
            exists = xrl.getFromThis(value) != null;
        }
        catch (Throwable ex) {
            Object[] tokens4 = new Object[]{type, parent};
            throw new DPAException("errorlookupDPList", ex, tokens4);
        }
        if (!exists) {
            Object[] tokens5 = new Object[]{type, parent, value};
            throw new DPAException("errorFindReference", tokens5);
        }
        try {
            rl.remove(value);
        }
        catch (Throwable ex) {
            Object[] tokens6 = new Object[]{type, parent, value};
            throw new DPAException("errorRemoveReference", ex, tokens6);
        }
        return dpr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

