/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReferenceList;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPContainerChannel;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPReferenceList;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.log.common.PortalLogger;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

class DPAModify {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$dp$cli$DPAModify == null ? (class$com$sun$portal$desktop$dp$cli$DPAModify = DPAModify.class$("com.sun.portal.desktop.dp.cli.DPAModify")) : class$com$sun$portal$desktop$dp$cli$DPAModify));
    XMLDPFactory dpf = XMLDPFactory.getInstance();
    boolean verbose = false;
    static /* synthetic */ Class class$com$sun$portal$desktop$dp$cli$DPAModify;

    DPAModify() {
    }

    public void process(AdminDPContext adc, String dn, boolean global, String parent, boolean combine, InputStream[] xmlByteStreams, boolean verbose, boolean dryrun, Logger logger) throws DPAException {
        this.verbose = verbose;
        if (verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0023");
        }
        String doc = null;
        try {
            doc = !global ? adc.getDPDocument(dn) : adc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        DPRoot dpr = null;
        try {
            if (doc != null && doc.length() > 0) {
                dpr = this.dpf.createRoot((DPContext)adc, doc);
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens);
        }
        for (int i = 0; i < xmlByteStreams.length; ++i) {
            dpr = this.doModify(adc, dn, global, parent, combine, xmlByteStreams[i], verbose, dpr);
        }
        if (verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0024");
        }
        String dpDoc = null;
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
            dpDoc = dpr.toString();
            this.dpf.createRoot((DPContext)adc, dpDoc);
        }
        catch (DPError de) {
            Throwable wrapped = de.getCause();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens = new Object[]{DPAUtil.getLines(new StringReader(dpDoc), linenum)};
                throw new DPAException("errorInvalidXMLText", de, tokens);
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        if (!dryrun) {
            if (verbose) {
                logger.log(Level.FINEST, "PSDT_CSPDDC0025");
            }
            try {
                StringBuffer sb = new StringBuffer(256);
                dpr.toXML(sb, 0);
                if (!global) {
                    adc.storeDPDocument(dn, sb.toString());
                } else {
                    adc.storeGlobalDPDocument(sb.toString());
                }
            }
            catch (Throwable ex) {
                throw new DPAException("errorStoreDP", ex);
            }
        }
    }

    private DPRoot doModify(AdminDPContext adc, String dn, boolean global, String parent, boolean combine, InputStream xmlByteStream, boolean verbose, DPRoot dpr) throws DPAException {
        Object[] tokens;
        Element element = DPAUtil.getElement(adc, xmlByteStream);
        String tag = element.getTagName();
        if (verbose) {
            tokens = new Object[]{tag};
            logger.log(Level.FINEST, "PSDT_CSPDDC0026", tokens);
        }
        if (!(tag.equals("DisplayProfile") || tag.equals("Channel") || tag.equals("Container") || tag.equals("Properties") || tag.equals("Collection") || tag.equals("ConditionalProperties") || tag.equals("Locale") || tag.equals("Available") || tag.equals("Selected") || !combine)) {
            tokens = new Object[]{tag};
            throw new DPAException("errorCombineNotSupported", tokens);
        }
        if (tag.equals("DisplayProfile")) {
            if (parent != null) {
                tokens = new Object[]{parent};
                throw new DPAException("errorCannotHaveParent", tokens);
            }
            dpr = this.doModifyDP(adc, dn, global, combine, element, dpr);
        } else if (tag.equals("Channel") || tag.equals("Container")) {
            dpr = this.doModifyChannel(adc, dpr, parent, combine, element);
        } else if (tag.equals("Provider")) {
            if (parent != null) {
                tokens = new Object[]{parent};
                throw new DPAException("errorProviderCannotHaveParent", tokens);
            }
            dpr = this.doModifyProvider(adc, dpr, element);
        } else if (tag.equals("String") || tag.equals("Boolean") || tag.equals("Integer") || tag.equals("Collection") || tag.equals("ConditionalProperties") || tag.equals("Locale")) {
            dpr = this.doModifyProperty(adc, dpr, parent, combine, element);
        } else if (tag.equals("Properties")) {
            dpr = this.doModifyProperties(adc, dpr, parent, combine, element);
        } else if (tag.equals("Available") || tag.equals("Selected")) {
            if (parent == null) {
                throw new DPAException("errorParentUnspecified");
            }
            dpr = this.doModifyList(adc, dpr, parent, combine, element, tag);
        } else {
            tokens = new Object[]{tag};
            throw new DPAException("errorUnsupportedTag", tokens);
        }
        return dpr;
    }

    private DPRoot doModifyDP(AdminDPContext adc, String dn, boolean global, boolean combine, Element element, DPRoot dpr) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            logger.log(Level.FINEST, "PSDT_CSPDDC0027", tokens);
        }
        Object doc = null;
        DPRoot newDpr = null;
        try {
            newDpr = this.dpf.getRoot(adc, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        if (combine) {
            if (this.verbose) {
                logger.log(Level.FINEST, "PSDT_CSPDDC0028");
            }
            String dpDoc = null;
            try {
                dpDoc = newDpr.toString();
                this.dpf.createRoot((DPContext)adc, dpDoc);
            }
            catch (DPError de) {
                Throwable wrapped = de.getCause();
                if (wrapped != null && wrapped instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)wrapped;
                    int linenum = spe.getLineNumber();
                    Object[] tokens = new Object[]{DPAUtil.getLines(new StringReader(dpDoc), linenum)};
                    throw new DPAException("errorInvalidXMLText", de, tokens);
                }
            }
            catch (Throwable ex) {
                throw new DPAException("errorInvalidXML", ex);
            }
            if (dpr != null) {
                DPAUtil.combineRoots(dpr, newDpr);
                newDpr = dpr;
            }
        }
        return newDpr;
    }

    private DPRoot doModifyChannel(DPContext adc, DPRoot dpr, String parent, boolean combine, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0029", tokens2);
        }
        DPNode node = null;
        try {
            if (parent == null) {
                node = dpr;
            } else {
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0030", tokens);
                }
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                node = xdpr.getChannelFromThis(parent);
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (node == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0031");
        }
        DPChannel ch = null;
        try {
            ch = this.dpf.getChannel(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPChannel", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0032", tokens4);
        }
        DPChannel och = null;
        try {
            XMLDPNode xnode = (XMLDPNode)node;
            och = xnode.getChannelFromThis(ch.getName());
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, ch.getName()};
            throw new DPAException("errorLookupChannel", ex, tokens5);
        }
        if (och == null) {
            Object[] tokens6 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, ch.getName()};
            throw new DPAException("errorFindChannel", tokens6);
        }
        try {
            if (combine) {
                DPAUtil.combineChannels(och, ch);
            } else {
                node.removeChannel(ch.getName());
                node.addChannel(ch);
            }
        }
        catch (Throwable ex) {
            Object[] tokens7 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, ch.getName()};
            throw new DPAException("errorModifyChannel", ex, tokens7);
        }
        return dpr;
    }

    private DPRoot doModifyProvider(DPContext adc, DPRoot dpr, Element element) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{element.getAttribute("name")};
            logger.log(Level.FINEST, "PSDT_CSPDDC0033", tokens);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0034");
        }
        DPProvider p = null;
        try {
            p = this.dpf.getProvider(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProvider", ex);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0035");
        }
        boolean exists = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            exists = xdpr.getProviderFromThis(p.getName()) != null;
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{p.getName()};
            throw new DPAException("errorLookupProvider", ex, tokens);
        }
        if (!exists) {
            Object[] tokens = new Object[]{p.getName()};
            throw new DPAException("errorFindProvider", tokens);
        }
        try {
            dpr.removeProvider(p.getName());
            dpr.addProvider(p);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{p.getName()};
            throw new DPAException("errorModifyProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot doModifyProperties(DPContext adc, DPRoot dpr, String parent, boolean combine, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0036", tokens2);
        }
        DPPropertyHolder ph = null;
        try {
            if (parent == null) {
                ph = dpr;
            } else {
                XMLDPRoot xdpr;
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0037", tokens);
                }
                if ((ph = (xdpr = (XMLDPRoot)dpr).getChannelFromThis(parent)) == null) {
                    ph = xdpr.getProviderFromThis(parent);
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (ph == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0038");
        }
        DPCollection c = null;
        DPProperties op = null;
        try {
            XMLDPPropertyHolder xph = (XMLDPPropertyHolder)ph;
            op = xph.getPropertiesFromThis();
            c = this.dpf.getCollectionProperty(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProperties", ex);
        }
        try {
            if (combine) {
                DPAUtil.combineProperties(op, c);
            } else {
                op.removeAll();
                XMLDPCollection xc = (XMLDPCollection)c;
                Set names = xc.getNamesFromThis();
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    op.add(xc.getFromThis((String)i.next()));
                }
                XMLDPCollection xmlC = (XMLDPCollection)c;
                Element e = xmlC.getElement();
                op.setMergeType(c.getMergeType());
                op.setLock(XMLDPCollection.isLockedElement(e));
                op.setPropagate(XMLDPCollection.isPropagateElement(e));
                op.setAdvanced(XMLDPCollection.isAdvancedElement(e));
            }
        }
        catch (Throwable ex) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorModifyProperties", ex, tokens4);
        }
        return dpr;
    }

    private DPRoot doModifyProperty(DPContext adc, DPRoot dpr, String parent, boolean combine, Element element) throws DPAException {
        XMLDPProperties xprops;
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0039", tokens2);
        }
        DPPropertyHolder ph = null;
        try {
            if (parent == null) {
                ph = dpr;
            } else {
                XMLDPRoot xdpr;
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0040", tokens);
                }
                if ((ph = (xdpr = (XMLDPRoot)dpr).getChannelFromThis(parent)) == null) {
                    ph = xdpr.getProviderFromThis(parent);
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (ph == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            logger.log(Level.FINEST, "PSDT_CSPDDC0041");
        }
        DPProperty p = null;
        try {
            p = this.dpf.getProperty(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProperty", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0042", tokens4);
        }
        DPProperties props = null;
        boolean exists = false;
        try {
            XMLDPPropertyHolder xph = (XMLDPPropertyHolder)ph;
            props = xph.getPropertiesFromThis();
            xprops = (XMLDPProperties)props;
            exists = xprops.getFromThis(p.getName()) != null;
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, p.getName()};
            throw new DPAException("PSDT_CSPDDC0043", ex, tokens5);
        }
        if (!exists) {
            Object[] tokens6 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, p.getName()};
            throw new DPAException("errorFindProperty", tokens6);
        }
        try {
            if (combine) {
                DPCollection c = (DPCollection)p;
                xprops = (XMLDPProperties)props;
                DPCollection oc = (DPCollection)xprops.getFromThis(c.getName());
                DPAUtil.combineProperties(oc, c);
            } else {
                props.remove(p.getName());
                props.add(p);
            }
        }
        catch (Throwable ex) {
            Object[] tokens7 = new Object[]{p};
            throw new DPAException("errorModifyProperty", ex, tokens7);
        }
        return dpr;
    }

    private DPRoot doModifyList(DPContext adc, DPRoot dpr, String parent, boolean combine, Element element, String tag) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{tag, parent};
            logger.log(Level.FINEST, "PSDT_CSPDDC0044", tokens2);
        }
        DPNode node = null;
        try {
            if (parent == null) {
                node = dpr;
            } else {
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    logger.log(Level.FINEST, "PSDT_CSPDDC0045", tokens);
                }
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                node = xdpr.getChannelFromThis(parent);
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (node == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (!(node instanceof DPContainerChannel)) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorParentNotCotainer", tokens);
        }
        DPContainerChannel cc = (DPContainerChannel)node;
        DPReferenceList orl = null;
        try {
            XMLDPContainerChannel xcc = (XMLDPContainerChannel)cc;
            if (tag.equals("Available")) {
                orl = xcc.getAvailableFromThis();
            } else if (tag.equals("Selected")) {
                orl = xcc.getSelectedFromThis();
            }
        }
        catch (Throwable ex) {
            Object[] tokens4 = new Object[]{tag, parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorLookupDPList", ex, tokens4);
        }
        if (this.verbose) {
            Object[] tokens5 = new Object[]{tag};
            logger.log(Level.FINEST, "PSDT_CSPDDC0046", tokens5);
        }
        DPReferenceList rl = null;
        try {
            if (tag.equals("Available")) {
                rl = this.dpf.getAvailable(adc, dpr, element);
            } else if (tag.equals("Selected")) {
                rl = this.dpf.getSelected(adc, dpr, element);
            }
        }
        catch (Throwable ex) {
            Object[] tokens6 = new Object[]{tag};
            throw new DPAException("errorCreateDPList", ex, tokens6);
        }
        try {
            if (combine) {
                DPAUtil.combineLists(orl, rl);
            } else {
                orl.removeAll();
                XMLDPReferenceList xrl = (XMLDPReferenceList)rl;
                Set names = xrl.getNamesFromThis();
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    orl.add(xrl.getFromThis((String)i.next()));
                }
                XMLDPReferenceList xmlRl = (XMLDPReferenceList)rl;
                Element e = xmlRl.getElement();
                orl.setMergeType(rl.getMergeType());
                orl.setLock(XMLDPReferenceList.isLockedElement(e));
                orl.setAdvanced(XMLDPReferenceList.isAdvancedElement(e));
            }
        }
        catch (Throwable ex) {
            Object[] tokens7 = new Object[]{tag, parent};
            throw new DPAException("errorModifyDPList", ex, tokens7);
        }
        return dpr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

