/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.dp.cli.CLIPParser;
import com.sun.portal.desktop.dp.cli.DPACommand;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class DPAMain {
    public static final String COMMANDNAME = "dpadmin";
    public static final String COMMANDVERSION = "1.2";
    public static final String DSAME_CACHEON = "com.iplanet.am.sdk.caching.enabled";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$dp$cli$DPAMain == null ? (class$com$sun$portal$desktop$dp$cli$DPAMain = DPAMain.class$("com.sun.portal.desktop.dp.cli.DPAMain")) : class$com$sun$portal$desktop$dp$cli$DPAMain));
    static /* synthetic */ Class class$com$sun$portal$desktop$dp$cli$DPAMain;

    DPAMain(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-l") && !args[i].equals("--locale") || i >= args.length - 1) continue;
            Locale locale = DPAUtil.getLocale(args[i + 1]);
            DPAException.setLocale(locale);
            DPAUtil.setLocale(locale);
        }
    }

    private static Map getBatchInput(String batchFile) throws DPAException {
        File f = new File(batchFile);
        TreeMap<Long, String> batch = new TreeMap<Long, String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(batchFile));
            String line = null;
            long lineNum = 1L;
            while ((line = br.readLine()) != null) {
                if (line.length() > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(line + "\n");
                    batch.put(new Long(lineNum), buf.toString());
                }
                ++lineNum;
            }
            br.close();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{batchFile};
            throw new DPAException("errorFileRead", ioe, tokens);
        }
        if (batch.size() == 0) {
            throw new DPAException("errorEmptyBatch");
        }
        return batch;
    }

    public static void main(String[] args) {
        DPAMain dpa = new DPAMain(args);
        CLIPParser clipp = null;
        try {
            clipp = DPACommand.getCLIPParser(false);
            DPACommand cmd = new DPACommand(clipp, args, false);
            if (!cmd.isBatch()) {
                cmd.runCommand();
            } else {
                if (System.getProperty(DSAME_CACHEON) == null) {
                    System.setProperty(DSAME_CACHEON, "false");
                }
                AdminDPContext adc = null;
                boolean isPreAuthorized = false;
                if (cmd.isAuthProvided()) {
                    adc = cmd.doAuth();
                    isPreAuthorized = true;
                }
                Map batch = DPAMain.getBatchInput(cmd.batchFile);
                CLIPParser cp = DPACommand.getCLIPParser(true);
                Set keySet = batch.keySet();
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    Long key = (Long)i.next();
                    String cmdline = (String)batch.get(key);
                    if (cmd.verbose) {
                        Object[] tokens = new Object[]{key, cmdline};
                        logger.log(Level.FINEST, "PSDT_CSPDDC0019", tokens);
                    }
                    try {
                        DPACommand c = new DPACommand(cp, cmdline, true, isPreAuthorized);
                        if (isPreAuthorized) {
                            c.runCommand(adc);
                            continue;
                        }
                        c.runCommand();
                    }
                    catch (DPAException dpaex) {
                        Object[] tokens;
                        String wrappedMsg = dpaex.getWrappedMessage();
                        if (wrappedMsg != null && wrappedMsg.length() > 0) {
                            tokens = new Object[]{dpaex.getLocalizedMessage(), key, wrappedMsg};
                            System.err.println(DPAUtil.getLocalizedString("msgWrappedErrorLine", tokens));
                        } else {
                            tokens = new Object[]{dpaex.getLocalizedMessage(), key};
                            System.err.println(DPAUtil.getLocalizedString("msgErrorLine", tokens));
                        }
                        logger.log(Level.INFO, "PSDT_CSPDDC0059", dpaex);
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                    catch (Exception ex) {
                        Object[] tokens = new Object[]{ex.getLocalizedMessage(), key};
                        System.err.println(DPAUtil.getLocalizedString("msgErrorLine", tokens));
                        logger.log(Level.INFO, "PSDT_CSPDDC0059", ex);
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                }
            }
            System.exit(0);
        }
        catch (DPAException dpaex) {
            String wrappedMsg = dpaex.getWrappedMessage();
            if (wrappedMsg != null && wrappedMsg.length() > 0) {
                Object[] tokens = new Object[]{dpaex.getLocalizedMessage(), wrappedMsg};
                System.err.println(DPAUtil.getLocalizedString("msgWrappedError", tokens));
            } else {
                Object[] tokens = new Object[]{dpaex.getLocalizedMessage()};
                System.err.println(DPAUtil.getLocalizedString("msgError", tokens));
            }
            logger.log(Level.SEVERE, "PSDT_CSPDDC0059", dpaex);
            System.exit(1);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.getLocalizedMessage()};
            System.err.println(DPAUtil.getLocalizedString("msgError", tokens));
            logger.log(Level.SEVERE, "PSDT_CSPDDC0059", ex);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

