/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParXferPPF;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ParManifest
extends Manifest {
    public static final int CLASSFILE = 1;
    public static final int DPFILE = 2;
    public static final int PBFILE = 3;
    public static final int STATFILE = 4;
    public static final int WARFILE = 5;
    public static final int CONFFILE = 6;
    public static final String DEF_PBFILES_STR = "pbfiles";
    public static final String DEF_DP_STR = "dp";
    public static final String DEF_STATIC_STR = "static";
    public static final String DEF_WAR_STR = "war";
    public static final String DEF_CONFIG_STR = "config";
    private String m_CRoot;
    private String m_PBFRoot;
    private String m_DPRoot;
    private String m_SRoot;
    private String m_WRoot;
    private String m_ConfRoot;
    private String m_BackupVersion;
    private static final int VERSION = 2;
    private static final String INCLUDE_DELIM = ",";
    private static final String INCLUDE_OPEN = "(";
    private static final String INCLUDE_CLOSE = ")";
    private static final String KEY_PFX = "PS-";
    private static final String MAKEY_VERSION = "PS-Version";
    private static final String MAKEY_PBFILEROOT = "PS-PBFileRoot";
    private static final String MAKEY_DPROOT = "PS-DPRoot";
    private static final String MAKEY_CLASSROOT = "PS-ClassRoot";
    private static final String MAKEY_STATROOT = "PS-StaticRoot";
    private static final String MAKEY_DEFAULTENTRY = "PS-DefaultEntry";
    private static final String MAKEY_WARROOT = "PS-WARRoot";
    private static final String MAKEY_CONFROOT = "PS-ConfigRoot";
    private static final String MAKEY_BACKUP_VERSION = "PS-Backup-Version";
    private static final String MAKEY_BACKUP_TIMESTAMP = "PS-Backup-Timestamp";
    private static final String EAKEY_NAME = "PS-EntryName";
    private static final String EAKEY_INCLUDE = "PS-Include";
    private static final String EAKEY_AUTOEXTRACT = "PS-AutoExtract";
    private static final String EAKEY_DP_DOCS = "PS-DP-Docs";
    private static final String EAKEY_ATTR_PROPS = "PS-Attributes-Properties";
    private static final char FSC = File.separatorChar;

    public ParManifest(String classroot, String dproot, String pbfileroot, String sroot, String wroot, String croot, String backupVersion) {
        this.m_CRoot = classroot;
        this.m_DPRoot = dproot;
        this.m_PBFRoot = pbfileroot;
        this.m_SRoot = sroot;
        this.m_WRoot = wroot;
        this.m_ConfRoot = croot;
        Attributes ma = this.getMainAttributes();
        ma.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ma.putValue(MAKEY_VERSION, Integer.toString(2));
        if (backupVersion != null) {
            ma.putValue(MAKEY_BACKUP_VERSION, backupVersion);
            long msec = System.currentTimeMillis();
            Date d = new Date(msec);
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy K:mm a z");
            StringBuffer buf = new StringBuffer();
            formatter.format(d, buf, new FieldPosition(1));
            buf.append(" | ").append(Long.toString(msec));
            ma.putValue(MAKEY_BACKUP_TIMESTAMP, buf.toString());
        }
        if (classroot != null) {
            ma.putValue(MAKEY_CLASSROOT, classroot);
        }
        if (dproot != null) {
            ma.putValue(MAKEY_DPROOT, dproot);
        }
        if (pbfileroot != null) {
            ma.putValue(MAKEY_PBFILEROOT, pbfileroot);
        }
        if (sroot != null) {
            ma.putValue(MAKEY_STATROOT, sroot);
        }
        if (wroot != null) {
            ma.putValue(MAKEY_WARROOT, wroot);
        }
        if (croot != null) {
            ma.putValue(MAKEY_CONFROOT, croot);
        }
    }

    public ParManifest() {
        this(null, DEF_DP_STR, DEF_PBFILES_STR, DEF_STATIC_STR, DEF_WAR_STR, DEF_CONFIG_STR, null);
    }

    public ParManifest(String backupVersion) {
        this(null, DEF_DP_STR, DEF_PBFILES_STR, DEF_STATIC_STR, DEF_WAR_STR, DEF_CONFIG_STR, backupVersion);
    }

    private ParManifest(Manifest man) {
        super(man);
        Attributes ma = this.getMainAttributes();
        this.m_CRoot = ma.getValue(MAKEY_CLASSROOT);
        this.m_DPRoot = ma.getValue(MAKEY_DPROOT);
        this.m_PBFRoot = ma.getValue(MAKEY_PBFILEROOT);
        this.m_SRoot = ma.getValue(MAKEY_STATROOT);
        if (ma.getValue(MAKEY_WARROOT) != null) {
            this.m_WRoot = ma.getValue(MAKEY_WARROOT);
        }
        if (ma.getValue(MAKEY_CONFROOT) != null) {
            this.m_ConfRoot = ma.getValue(MAKEY_CONFROOT);
        }
        if (ma.getValue(MAKEY_BACKUP_VERSION) != null) {
            this.m_BackupVersion = ma.getValue(MAKEY_BACKUP_VERSION);
        }
    }

    public static ParManifest makeManifest(Manifest man) throws ParFileException {
        Attributes ma = man.getMainAttributes();
        String ver = ma.getValue(MAKEY_VERSION);
        if (ver == null) {
            throw new ParFileException("errorManifestNoVersion");
        }
        try {
            if (Integer.parseInt(ver) > 2) {
                throw new ParFileException("errorManifestBadVersion");
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorManifestBadVersion");
        }
        return new ParManifest(man);
    }

    public ZipEntry getClassZip(String pkg, String classname) {
        return new ZipEntry(this.getClassPath(pkg, classname));
    }

    public ZipEntry getClassZip(String fullclassname) {
        return new ZipEntry(this.getClassPath(fullclassname));
    }

    public ZipEntry getDPZip(String name) throws ParFileException {
        return new ZipEntry(this.getDPPath(name, false));
    }

    public ZipEntry getDPDocZip(String name) throws ParFileException {
        return new ZipEntry(this.getDPDocPath(name));
    }

    public ZipEntry getPBFileZip(String prop, String path) {
        return new ZipEntry(this.getPBFPath(prop, path));
    }

    public ZipEntry getStatZip(String path) {
        return new ZipEntry(this.getStaticPath(path));
    }

    public ZipEntry getPropertiesZip(String name) throws ParFileException {
        return new ZipEntry(this.getPropertiesPath(name));
    }

    public ZipEntry getWarZip(String name) throws ParFileException {
        return new ZipEntry(this.getWarPath(name));
    }

    public ZipEntry getConfZip(String name) throws ParFileException {
        return new ZipEntry(this.getConfPath(name));
    }

    public void addDPEntry(String name) throws ParFileException {
        this.getDPPath(name, true);
    }

    public void addDPEntryIncludeClass(String name, String pkg, String classname, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getClassPath(pkg, classname), types);
    }

    public void addDPEntryIncludeClass(String name, String fullclassname, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getClassPath(fullclassname), types);
    }

    public void addDPEntryIncludePBFile(String name, String prop, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getPBFPath(prop, path), types);
    }

    public void addDPEntryIncludeStat(String name, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getStaticPath(path), types);
    }

    public void addDPEntryIncludeWar(String name, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getWarPath(path), types);
    }

    public void addDPEntryIncludeConf(String name, String path, int types) throws ParFileException {
        this.addDPEntryInclude(name, this.getConfPath(path), types);
    }

    public void addDPEntryAutoExtract(String name, ExtractOp op) throws ParFileException {
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        op = new ExtractOp(op);
        op.setEntryName(name);
        a.putValue(EAKEY_AUTOEXTRACT, op.toArg());
    }

    public void addDPEntryDPDocs(String name, Set keys) throws ParFileException {
        StringBuffer sb = new StringBuffer();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key).append(".xml").append(INCLUDE_DELIM);
        }
        sb.deleteCharAt(sb.length() - 1);
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        a.putValue(EAKEY_DP_DOCS, sb.toString());
    }

    public void addDPEntryAttrProps(String name, Set keys) throws ParFileException {
        StringBuffer sb = new StringBuffer();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key).append(".properties").append(INCLUDE_DELIM);
        }
        sb.deleteCharAt(sb.length() - 1);
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        a.putValue(EAKEY_ATTR_PROPS, sb.toString());
    }

    public Vector getDPEntryList() throws ParFileException {
        Vector<String> v = new Vector<String>();
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            v.add(this.getNameFromDPPath(it.next()));
        }
        return v;
    }

    public Vector getDPEntryIncludeList(String name, int types) throws ParFileException {
        Vector v = new Vector();
        this.getDPEntryIncludeList(name, types, v, null);
        return v;
    }

    public void getDPEntryIncludeList(String name, int types, Vector v, Vector vt) throws ParFileException {
        String list;
        v.clear();
        if (vt != null) {
            vt.clear();
        }
        if ((list = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_INCLUDE)) == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, INCLUDE_DELIM);
        while (tok.hasMoreTokens()) {
            StringTokenizer subtok = new StringTokenizer(tok.nextToken(), ")(");
            if (!subtok.hasMoreTokens()) continue;
            String fn = subtok.nextToken();
            if (!subtok.hasMoreTokens()) {
                v.add(fn);
                if (vt == null) continue;
                vt.add(new Integer(3));
                continue;
            }
            try {
                int ftyp = Integer.parseInt(subtok.nextToken());
                if ((ftyp & types) == 0) continue;
                v.add(fn);
                if (vt == null) continue;
                vt.add(new Integer(ftyp));
            }
            catch (Exception ex) {
                throw new ParFileException("errorManifestInclusion");
            }
        }
    }

    public Vector getDPEntryDPDocList(String name) throws ParFileException {
        Vector<String> v = new Vector<String>();
        String list = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_DP_DOCS);
        if (list == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(list, INCLUDE_DELIM);
        while (tok.hasMoreTokens()) {
            v.add(tok.nextToken());
        }
        return v;
    }

    public Vector getDPEntryAttrPropList(String name) throws ParFileException {
        Vector<String> v = new Vector<String>();
        String list = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_ATTR_PROPS);
        if (list == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(list, INCLUDE_DELIM);
        while (tok.hasMoreTokens()) {
            v.add(tok.nextToken());
        }
        return v;
    }

    public ExtractOp getDPEntryAutoExtract(String name) throws ParFileException {
        String opstr = this.getAttributes(this.getDPPath(name, false)).getValue(EAKEY_AUTOEXTRACT);
        if (opstr == null) {
            return null;
        }
        return ExtractOp.makeOpFromArgument(opstr);
    }

    public int getPathRootType(String path) throws ParFileException {
        return this.getPathRootType(path, null);
    }

    public String getPropertyFromPBFPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 3) {
            throw new ParFileException("errorManifestPathType");
        }
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        return tok.nextToken().replace('/', FSC);
    }

    public String getPathFromPBFPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 3) {
            throw new ParFileException("errorManifestPathType");
        }
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        tok.nextToken();
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        while (tok.hasMoreTokens()) {
            buf.append(pfx);
            buf.append(tok.nextToken());
            pfx = "/";
        }
        return buf.toString().replace('/', FSC);
    }

    public String getFullFromClassPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 1) {
            throw new ParFileException("errorManifestPathType");
        }
        StringBuffer cb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(rest.toString(), "/");
        String pfx = "";
        while (tok.hasMoreTokens()) {
            cb.append(pfx);
            String part = tok.nextToken();
            int dotidx = part.indexOf(".");
            if (dotidx > 0) {
                part = part.substring(0, dotidx);
            }
            cb.append(part);
            pfx = ".";
        }
        return cb.toString().replace('/', FSC);
    }

    public String getPathFromStaticPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 4) {
            throw new ParFileException("errorManifestPathType");
        }
        return rest.toString();
    }

    public String getPathFromWarPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 5) {
            throw new ParFileException("errorManifestPathType");
        }
        return rest.toString().replace('/', FSC);
    }

    public String getPathFromConfPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 6) {
            throw new ParFileException("errorManifestPathType");
        }
        return rest.toString().replace('/', FSC);
    }

    public void transferFileEntries(ParFileBuilder pfb, ParFile oldpf) throws ParFileException {
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            Vector vif = new Vector();
            Vector vift = new Vector();
            this.getDPEntryIncludeList(ename, 3, vif, vift);
            Vector<ParXferPPF> vppf = new Vector<ParXferPPF>();
            for (int i = 0; i < vif.size(); ++i) {
                String fn = (String)vif.elementAt(i);
                Integer fntyp = (Integer)vift.elementAt(i);
                vppf.add(new ParXferPPF(oldpf, fn, fntyp));
            }
            pfb.addDPEntry(this.getDPDoc(ekey, oldpf), vppf, op);
        }
    }

    public void describe(PrintStream out, ParFile pf) throws ParFileException {
        out.println(Par.getLocalizedString("parDescClassRoot") + ": " + (this.m_CRoot == null ? "/" : "/" + this.m_CRoot));
        out.println(Par.getLocalizedString("parDescPBRoot") + ": " + (this.m_PBFRoot == null ? "/" : "/" + this.m_PBFRoot));
        out.println(Par.getLocalizedString("parDescDPRoot") + ": " + (this.m_DPRoot == null ? "/" : "/" + this.m_DPRoot));
        out.println(Par.getLocalizedString("parDescStaticRoot") + ": " + (this.m_SRoot == null ? "/" : "/" + this.m_SRoot));
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            out.println("");
            out.println(Par.getLocalizedString("parDescEntry") + ": " + ename);
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            if (op != null) {
                out.println(Par.getLocalizedString("parDescAutoExtract") + ": " + op.toArg());
            }
            Par.describeDPDoc(this.getDPDoc(ekey, pf), out);
            Vector v = new Vector();
            Vector vt = new Vector();
            this.getDPEntryIncludeList(ename, 3, v, vt);
            for (int i = 0; i < v.size(); ++i) {
                String fn = (String)v.elementAt(i);
                int ty = (Integer)vt.elementAt(i);
                StringBuffer bf = new StringBuffer();
                bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                this.describeFile(bf, fn);
                bf.append(" (");
                ExtractOp.describeTypes(bf, ty);
                bf.append(INCLUDE_CLOSE);
                out.println(bf.toString());
            }
        }
    }

    public String describeAll(ParFile pf) throws ParFileException {
        StringBuffer sb = new StringBuffer();
        sb.append(Par.getLocalizedString("parDescClassRoot") + ": " + (this.m_CRoot == null ? "/" : "/" + this.m_CRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescPBRoot") + ": " + (this.m_PBFRoot == null ? "/" : "/" + this.m_PBFRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescDPRoot") + ": " + (this.m_DPRoot == null ? "/" : "/" + this.m_DPRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescStaticRoot") + ": " + (this.m_SRoot == null ? "/" : "/" + this.m_SRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescWarRoot") + ": " + (this.m_WRoot == null ? "/" : "/" + this.m_WRoot));
        sb.append("\n");
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            Vector dpVec;
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            sb.append("");
            sb.append(Par.getLocalizedString("parDescEntry") + ": " + ename);
            sb.append("\n");
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            if (op != null) {
                sb.append(Par.getLocalizedString("parDescAutoExtract") + ": " + op.toArg());
                sb.append("\n");
            }
            if ((dpVec = this.getDPEntryDPDocList(ename)) != null) {
                for (int i = 0; i < dpVec.size(); ++i) {
                    String fn = (String)dpVec.elementAt(i);
                    StringBuffer bf = new StringBuffer();
                    bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                    this.describeFile(bf, fn);
                    sb.append(bf.toString());
                    sb.append("\n");
                }
            }
            Vector v = new Vector();
            Vector vt = new Vector();
            this.getDPEntryIncludeList(ename, 3, v, vt);
            for (int i = 0; i < v.size(); ++i) {
                String fn = (String)v.elementAt(i);
                int ty = (Integer)vt.elementAt(i);
                StringBuffer bf = new StringBuffer();
                bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                this.describeFile(bf, fn);
                bf.append(" (");
                ExtractOp.describeTypes(bf, ty);
                bf.append(INCLUDE_CLOSE);
                sb.append(bf.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String describeAll(ParFile pf, Map types) throws ParFileException {
        StringBuffer sb = new StringBuffer();
        sb.append(Par.getLocalizedString("parDescClassRoot") + ": " + (this.m_CRoot == null ? "/" : "/" + this.m_CRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescPBRoot") + ": " + (this.m_PBFRoot == null ? "/" : "/" + this.m_PBFRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescDPRoot") + ": " + (this.m_DPRoot == null ? "/" : "/" + this.m_DPRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescStaticRoot") + ": " + (this.m_SRoot == null ? "/" : "/" + this.m_SRoot));
        sb.append("\n");
        sb.append(Par.getLocalizedString("parDescWarRoot") + ": " + (this.m_WRoot == null ? "/" : "/" + this.m_WRoot));
        sb.append("\n");
        Iterator<String> it = this.getEntries().keySet().iterator();
        while (it.hasNext()) {
            Vector dpVec;
            String ekey = it.next();
            String ename = this.getNameFromDPPath(ekey);
            sb.append("");
            sb.append(Par.getLocalizedString("parDescEntry") + ": " + ename);
            sb.append("\n");
            ExtractOp op = this.getDPEntryAutoExtract(ename);
            if (op != null) {
                sb.append(Par.getLocalizedString("parDescAutoExtract") + ": " + op.toArg());
                sb.append("\n");
            }
            if ((dpVec = this.getDPEntryDPDocList(ename)) != null) {
                for (int i = 0; i < dpVec.size(); ++i) {
                    String fn = (String)dpVec.elementAt(i);
                    StringBuffer bf = new StringBuffer();
                    bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                    this.describeFile(bf, fn);
                    sb.append(bf.toString());
                    sb.append("\n");
                }
            }
            Vector v = new Vector();
            Vector vt = new Vector();
            this.getDPEntryIncludeList(ename, 3, v, vt);
            for (int i = 0; i < v.size(); ++i) {
                String fn = (String)v.elementAt(i);
                int type = this.getPathRootType(fn);
                Boolean toDisplay = (Boolean)types.get(new Integer(type));
                if (toDisplay == null || !toDisplay.booleanValue()) continue;
                int ty = (Integer)vt.elementAt(i);
                StringBuffer bf = new StringBuffer();
                bf.append(Par.getLocalizedString("parDescIncludes") + ": ");
                this.describeFile(bf, fn);
                bf.append(" (");
                ExtractOp.describeTypes(bf, ty);
                bf.append(INCLUDE_CLOSE);
                sb.append(bf.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String getBackupVersion() {
        return this.m_BackupVersion;
    }

    private Document getDPDoc(String path, ParFile pf) throws ParFileException {
        try {
            InputStream is = pf.getInputStream(pf.getEntry(path));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(is);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDescribingDPDocument", ex);
        }
    }

    private void describeFile(StringBuffer bf, String fn) throws ParFileException {
        switch (this.getPathRootType(fn)) {
            case 1: {
                Object[] tokc = new Object[]{fn};
                bf.append(Par.getLocalizedString("parDescClassFile", tokc));
                break;
            }
            case 3: {
                Object[] tokpb = new Object[]{this.getPropertyFromPBFPath(fn), this.getPathFromPBFPath(fn)};
                bf.append(Par.getLocalizedString("parDescPBFile", tokpb));
                break;
            }
            case 4: {
                Object[] toks = new Object[]{fn};
                bf.append(Par.getLocalizedString("parDescStaticFile", toks));
                break;
            }
            case 5: {
                Object[] tokw = new Object[]{fn};
                bf.append(Par.getLocalizedString("parDescWarFile", tokw));
                break;
            }
            default: {
                throw new ParFileException("errorManifestPathType");
            }
        }
    }

    private String getNameFromDPPath(String path) throws ParFileException {
        StringBuffer rest = new StringBuffer();
        if (this.getPathRootType(path, rest) != 2) {
            throw new ParFileException("errorManifestPathType");
        }
        String rstr = rest.toString();
        int idx = rstr.lastIndexOf(46);
        if (idx <= 0) {
            throw new ParFileException("Empty DP path");
        }
        return rstr.substring(0, idx);
    }

    private String getDPPath(String name, boolean create) throws ParFileException {
        if (name == null) {
            if (create) {
                throw new ParFileException("errorNullDPEntry");
            }
            Attributes ma = this.getMainAttributes();
            name = ma.getValue(MAKEY_DEFAULTENTRY);
            if (name == null) {
                throw new ParFileException("errorNullDPEntry");
            }
        }
        StringBuffer buf = new StringBuffer();
        if (this.m_DPRoot != null) {
            buf.append(this.m_DPRoot);
            buf.append("/");
        }
        buf.append(name);
        buf.append(".xml");
        String key = buf.toString();
        if (this.getAttributes(key) == null) {
            if (!create) {
                throw new ParFileException("errorBadDPEntry");
            }
            Attributes ea = new Attributes();
            ea.putValue(EAKEY_NAME, name);
            this.getEntries().put(key, ea);
            Attributes ma = this.getMainAttributes();
            if (ma.getValue(MAKEY_DEFAULTENTRY) == null) {
                ma.putValue(MAKEY_DEFAULTENTRY, name);
            }
            return key;
        }
        if (create) {
            throw new ParFileException("errorBadDPEntry");
        }
        return key;
    }

    private String getDPDocPath(String name) throws ParFileException {
        StringBuffer buf = new StringBuffer();
        if (this.m_DPRoot != null) {
            buf.append(this.m_DPRoot);
            buf.append("/");
        }
        buf.append(name);
        buf.append(".xml");
        return buf.toString();
    }

    private String getClassPath(String fullclassname) {
        String cfile = Par.classToFile(fullclassname);
        if (this.m_CRoot == null) {
            return cfile;
        }
        return this.m_CRoot + "/" + cfile;
    }

    private String getClassPath(String pkg, String classname) {
        String cfile = Par.classToFile(pkg, classname);
        if (this.m_CRoot == null) {
            return cfile;
        }
        return this.m_CRoot + "/" + cfile;
    }

    private String getPBFPath(String prop, String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_PBFRoot != null) {
            buf.append(this.m_PBFRoot);
            buf.append("/");
        }
        path = path.replace(FSC, '/');
        buf.append(prop);
        buf.append("/");
        buf.append(path);
        return buf.toString();
    }

    private String getStaticPath(String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_SRoot != null) {
            buf.append(this.m_SRoot);
            buf.append("/");
        }
        path = path.replace(FSC, '/');
        buf.append(path);
        return buf.toString();
    }

    private String getWarPath(String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_WRoot != null) {
            buf.append(this.m_WRoot);
            buf.append("/");
        }
        path = path.replace(FSC, '/');
        buf.append(path);
        return buf.toString();
    }

    private String getConfPath(String path) {
        StringBuffer buf = new StringBuffer();
        if (this.m_ConfRoot != null) {
            buf.append(this.m_ConfRoot);
            buf.append("/");
        }
        path = path.replace(FSC, '/');
        buf.append(path);
        return buf.toString();
    }

    private String getPropertiesPath(String name) {
        StringBuffer buf = new StringBuffer();
        if (this.m_PBFRoot != null) {
            buf.append(this.m_DPRoot);
            buf.append("/");
        }
        buf.append(name);
        buf.append(".properties");
        return buf.toString();
    }

    private void addDPEntryInclude(String name, String path, int types) throws ParFileException {
        Attributes a = this.getAttributes(this.getDPPath(name, false));
        String list = a.getValue(EAKEY_INCLUDE);
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        if (list != null) {
            StringTokenizer toks = new StringTokenizer(list, INCLUDE_DELIM);
            while (toks.hasMoreTokens()) {
                String p = toks.nextToken();
                if (p.startsWith(path)) continue;
                buf.append(pfx);
                pfx = INCLUDE_DELIM;
                buf.append(p);
            }
        }
        buf.append(pfx);
        buf.append(path);
        buf.append(INCLUDE_OPEN);
        buf.append(types);
        buf.append(INCLUDE_CLOSE);
        a.putValue(EAKEY_INCLUDE, buf.toString());
    }

    private int getPathRootType(String path, StringBuffer rem) throws ParFileException {
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (!tok.hasMoreTokens()) {
            throw new ParFileException("errorManifestPathSyntax");
        }
        String root = tok.nextToken();
        if (rem != null) {
            rem.setLength(0);
            String pfx = "";
            while (tok.hasMoreTokens()) {
                rem.append(pfx);
                rem.append(tok.nextToken());
                pfx = "/";
            }
        }
        if (this.m_CRoot != null && this.m_CRoot.equals(root)) {
            return 1;
        }
        if (this.m_DPRoot != null && this.m_DPRoot.equals(root)) {
            return 2;
        }
        if (this.m_PBFRoot != null && this.m_PBFRoot.equals(root)) {
            return 3;
        }
        if (this.m_SRoot != null && this.m_SRoot.equals(root)) {
            return 4;
        }
        if (this.m_WRoot != null && this.m_WRoot.equals(root)) {
            return 5;
        }
        if (this.m_ConfRoot != null && this.m_ConfRoot.equals(root)) {
            return 6;
        }
        if (rem != null) {
            rem.setLength(0);
            rem.append(path);
        }
        if (this.m_CRoot == null) {
            return 1;
        }
        if (this.m_DPRoot == null) {
            return 2;
        }
        if (this.m_PBFRoot == null) {
            return 3;
        }
        if (this.m_SRoot == null) {
            return 4;
        }
        if (this.m_WRoot == null) {
            return 5;
        }
        if (this.m_ConfRoot == null) {
            return 6;
        }
        throw new ParFileException("errorManifestPathSyntax");
    }
}

