/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.DPDocDomPPF;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParEntryDomPPF;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.desktop.deployment.ParOutputStream;
import com.sun.portal.desktop.deployment.PropertiesPPF;
import com.sun.portal.desktop.deployment.ProviderPackageFile;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;

public class ParFileBuilder {
    private HashMap m_FileLists = new HashMap();
    private ParManifest m_Man = null;
    private boolean m_DefaultManifest;
    private String m_CRoot;
    private String m_DPRoot;
    private String m_PBFRoot;
    private String m_SRoot;
    private String m_WRoot;
    private String m_ConfRoot;
    private boolean m_Verbose;
    private PrintStream m_Out;
    private Logger m_Logger;
    private String m_BackupVersion;

    public ParFileBuilder(boolean verbose, Logger logger, String backupVersion) {
        this.m_Verbose = verbose;
        this.m_Logger = logger;
        this.m_BackupVersion = backupVersion;
        Par.setLogger(logger);
    }

    public ParFileBuilder(boolean verbose, PrintStream out) {
        this.m_DefaultManifest = true;
        this.m_Verbose = verbose;
        this.m_Out = out;
    }

    public ParFileBuilder(boolean verbose, PrintStream out, String classroot, String dproot, String pbfileroot, String statroot, String warroot, String confroot) {
        this(verbose, out);
        this.m_DefaultManifest = false;
        this.m_CRoot = classroot;
        this.m_DPRoot = dproot;
        this.m_PBFRoot = pbfileroot;
        this.m_SRoot = statroot;
        this.m_WRoot = warroot;
        this.m_ConfRoot = confroot;
    }

    public void clear() {
        this.m_FileLists.clear();
        this.m_Man = null;
    }

    public void addDPEntry(String name, Map docs, Vector files, Map properties, ExtractOp op) throws ParFileException {
        String key;
        Iterator i;
        this.assureManifest();
        Vector fc = (Vector)files.clone();
        if (this.m_Verbose && this.m_Logger != null && this.m_Logger.isLoggable(Level.INFO)) {
            this.m_Logger.log(Level.INFO, "ParFileBuilder.addDPEntry(): Add ManifestEntry for:" + name);
        }
        this.m_Man.addDPEntry(name);
        for (int i2 = 0; i2 < fc.size(); ++i2) {
            ProviderPackageFile ppf = (ProviderPackageFile)fc.elementAt(i2);
            ppf.addManifestInclusion(this.m_Man, name);
        }
        if (op != null) {
            this.m_Man.addDPEntryAutoExtract(name, op);
            if (this.m_Verbose && this.m_Logger != null && this.m_Logger.isLoggable(Level.INFO)) {
                this.m_Logger.log(Level.INFO, "ParFileBuilder.addDPEntry(): Autoextract:" + op.toArg());
            }
        }
        if (docs != null && !docs.isEmpty()) {
            Set keys = docs.keySet();
            i = keys.iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                Document doc = (Document)docs.get(key);
                fc.add(new DPDocDomPPF(doc, key));
            }
            this.m_Man.addDPEntryDPDocs(name, keys);
        }
        if (properties != null && !properties.isEmpty()) {
            Set keys = properties.keySet();
            i = keys.iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                fc.add(new PropertiesPPF((Properties)properties.get(key), 0, key));
            }
            this.m_Man.addDPEntryAttrProps(name, keys);
        }
        this.m_FileLists.put(name, fc);
    }

    public void addDPEntry(Document doc, Vector files, ExtractOp op) throws ParFileException {
        this.assureManifest();
        Vector fc = (Vector)files.clone();
        String name = Par.findDPEntryName(doc);
        Vector vold = (Vector)this.m_FileLists.get(name);
        if (vold != null) {
            int len = vold.size() - 1;
            for (int i = 0; i < len; ++i) {
                fc.add(vold.elementAt(i));
            }
        }
        if (this.m_Verbose) {
            Object[] tok = new Object[]{name};
            if (this.m_Out != null) {
                this.m_Out.println(Par.getLocalizedString("msgAddManifestEntry", tok));
            }
        }
        if (vold == null) {
            this.m_Man.addDPEntry(name);
        }
        for (int i = 0; i < fc.size(); ++i) {
            ProviderPackageFile ppf = (ProviderPackageFile)fc.elementAt(i);
            ppf.addManifestInclusion(this.m_Man, name);
        }
        if (op != null) {
            this.m_Man.addDPEntryAutoExtract(name, op);
            if (this.m_Verbose && this.m_Out != null) {
                this.m_Out.println("\tAutoextract - " + op.toArg());
            }
        }
        fc.add(new ParEntryDomPPF(doc, name));
        this.m_FileLists.put(name, fc);
    }

    public void addDPEntry(Document doc, Vector files) throws ParFileException {
        this.addDPEntry(doc, files, null);
    }

    public void makeParFile(String path) throws ParFileException {
        if (this.m_Man == null) {
            throw new ParFileException("errorEmptyPar");
        }
        if (this.m_Verbose) {
            Object[] tok = new Object[]{path};
            if (this.m_Out != null) {
                this.m_Out.println(Par.getLocalizedString("msgStreamTo", tok));
            }
            if (this.m_Logger != null && this.m_Logger.isLoggable(Level.INFO)) {
                this.m_Logger.log(Level.INFO, "ParFileBuider.makeParFile(), message streamed to: " + path);
            }
        }
        try {
            ParOutputStream pos = new ParOutputStream(path, this.m_Man);
            Vector ev = this.m_Man.getDPEntryList();
            for (int i = 0; i < ev.size(); ++i) {
                String name = (String)ev.elementAt(i);
                this.streamEntry(pos, name, true);
            }
            pos.close();
        }
        catch (Exception ex) {
            throw new ParFileException("errorParStream", ex);
        }
        this.clear();
    }

    public void makePar(String path, ByteArrayOutputStream out) throws ParFileException {
        if (this.m_Man == null) {
            throw new ParFileException("errorEmptyPar");
        }
        if (this.m_Verbose && this.m_Logger != null && this.m_Logger.isLoggable(Level.INFO)) {
            this.m_Logger.log(Level.INFO, "ParFileBuilder.makePar(), Making par for: " + path);
        }
        try {
            ParOutputStream pos = new ParOutputStream((OutputStream)out, this.m_Man);
            Vector ev = this.m_Man.getDPEntryList();
            for (int i = 0; i < ev.size(); ++i) {
                String nameEnt = (String)ev.elementAt(i);
                this.streamEntry(pos, nameEnt, false);
            }
            pos.close();
        }
        catch (Exception ex) {
            throw new ParFileException("errorParStream", ex);
        }
        this.clear();
    }

    private void streamEntry(ParOutputStream pos, String name, boolean checkName) throws ParFileException {
        Vector files = (Vector)this.m_FileLists.get(name);
        byte[] buf = new byte[4000];
        HashMap<String, String> namecheck = new HashMap<String, String>();
        try {
            for (int i = 0; i < files.size(); ++i) {
                int len;
                ProviderPackageFile ppf = (ProviderPackageFile)files.elementAt(i);
                ZipEntry ze = ppf.getZipEntry(this.m_Man);
                String nm = ze.getName();
                if (checkName) {
                    if (namecheck.get(nm) != null) continue;
                    namecheck.put(nm, nm);
                }
                if (this.m_Verbose) {
                    Object[] tok = new Object[]{nm};
                    if (this.m_Out != null) {
                        this.m_Out.println(Par.getLocalizedString("msgArchiving", tok));
                    }
                    if (this.m_Logger != null && this.m_Logger.isLoggable(Level.INFO)) {
                        this.m_Logger.log(Level.INFO, "ParFileBuilder.streamEntry(), Archiving: " + nm);
                    }
                }
                pos.putNextEntry(ze);
                InputStream is = ppf.getStream();
                while ((len = is.read(buf)) > 0) {
                    pos.write(buf, 0, len);
                }
                is.close();
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorParStream", ex);
        }
    }

    private void assureManifest() {
        if (this.m_Man != null) {
            return;
        }
        if (this.m_BackupVersion != null) {
            this.m_Man = new ParManifest(this.m_BackupVersion);
            return;
        }
        if (this.m_DefaultManifest) {
            this.m_Man = new ParManifest();
            return;
        }
        this.m_Man = new ParManifest(this.m_CRoot, this.m_DPRoot, this.m_PBFRoot, this.m_SRoot, this.m_WRoot, this.m_ConfRoot, null);
    }
}

