/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.ParExtractionContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ParFile
extends JarFile {
    private ParManifest m_PMan = ParManifest.makeManifest(this.getManifest());
    private static final int CLASSFILE = 1;
    private static final int PBFILE = 3;
    private static final int STATFILE = 4;
    private static final int WARFILE = 5;
    private static final int CONFFILE = 6;

    private ParFile(String path) throws Exception {
        super(path);
    }

    public static ParFile makeParFile(String path) throws ParFileException {
        try {
            return new ParFile(path);
        }
        catch (Exception ex) {
            throw new ParFileException("errorParFileCreation", ex);
        }
    }

    public ParManifest getParManifest() {
        return this.m_PMan;
    }

    public void describe(PrintStream out) throws ParFileException {
        this.m_PMan.describe(out, this);
    }

    public void performAutoExtraction(ParExtractionContext pex, String dpnode) throws ParFileException {
        Vector nl = this.m_PMan.getDPEntryList();
        int opcount = 0;
        for (int i = 0; i < nl.size(); ++i) {
            String name = (String)nl.elementAt(i);
            ExtractOp op = this.m_PMan.getDPEntryAutoExtract(name);
            if (op == null) continue;
            ++opcount;
            if (dpnode != null) {
                op.setDPNode(dpnode);
            }
            op.setEntryName(name);
            this.performExtraction(pex, op);
        }
        if (opcount == 0) {
            throw new ParFileException("errorNoOperations");
        }
    }

    public void performAutoExtraction(ParExtractionContext pex, String dpnode, boolean extractDP) throws ParFileException {
        Vector nl = this.m_PMan.getDPEntryList();
        int opcount = 0;
        for (int i = 0; i < nl.size(); ++i) {
            String name = (String)nl.elementAt(i);
            ExtractOp op = this.m_PMan.getDPEntryAutoExtract(name);
            if (op == null) continue;
            ++opcount;
            if (dpnode != null) {
                op.setDPNode(dpnode);
            }
            op.setEntryName(name);
            this.performExtraction(pex, op, extractDP);
        }
        if (opcount == 0) {
            throw new ParFileException("errorNoOperations");
        }
    }

    public void performExtraction(ParExtractionContext pex, ExtractOp op) throws ParFileException {
        pex.initializeForOperation(op);
        try {
            this.extractionOperation(pex, op);
        }
        catch (ParFileException ex) {
            pex.terminateOperation(false);
            throw ex;
        }
        pex.terminateOperation(true);
    }

    public void performExtraction(ParExtractionContext pex, ExtractOp op, boolean extractDP) throws ParFileException {
        pex.initializeForOperation(op);
        try {
            this.extractionOperation(pex, op, extractDP);
        }
        catch (ParFileException ex) {
            pex.terminateOperation(false);
            throw ex;
        }
        pex.terminateOperation(true);
    }

    public void performFileExtraction(ParExtractionContext pex, String entryName, int types) throws ParFileException {
        this.fileExtractionOperation(pex, entryName, types);
    }

    private void extractionOperation(ParExtractionContext pex, ExtractOp op) throws ParFileException {
        ZipEntry ze = this.m_PMan.getDPZip(op.getEntryName());
        InputStream is = this.getCheckedIS(ze);
        pex.putParEntryXMLFile(is, op.getTypes());
        this.fileExtractionOperation(pex, op.getEntryName(), op.getTypes());
    }

    private void extractionOperation(ParExtractionContext pex, ExtractOp op, boolean extractDP) throws ParFileException {
        ZipEntry ze = this.m_PMan.getDPZip(op.getEntryName());
        InputStream is = this.getCheckedIS(ze);
        if (extractDP) {
            pex.putParEntryXMLFile(is, op.getTypes());
        } else {
            pex.setChannelPath(is, op.getTypes());
        }
        this.fileExtractionOperation(pex, op.getEntryName(), op.getTypes());
    }

    private void fileExtractionOperation(ParExtractionContext pex, String entryName, int types) throws ParFileException {
        Vector files = this.m_PMan.getDPEntryIncludeList(entryName, types);
        block7: for (int i = 0; i < files.size(); ++i) {
            String path = (String)files.elementAt(i);
            JarEntry ze = this.getJarEntry(path);
            InputStream is = this.getCheckedIS(ze);
            switch (this.m_PMan.getPathRootType(path)) {
                case 1: {
                    String fn = this.m_PMan.getFullFromClassPath(path);
                    pex.putClassFile(fn, is);
                    continue block7;
                }
                case 3: {
                    String prop = this.m_PMan.getPropertyFromPBFPath(path);
                    String relp = this.m_PMan.getPathFromPBFPath(path);
                    pex.putPropLocFile(prop, relp, is);
                    continue block7;
                }
                case 4: {
                    String sp = this.m_PMan.getPathFromStaticPath(path);
                    pex.putStaticFile(sp, is);
                    continue block7;
                }
                case 5: {
                    String wp = this.m_PMan.getPathFromWarPath(path);
                    pex.putWarFile(wp, is);
                    continue block7;
                }
                case 6: {
                    String cp = this.m_PMan.getPathFromConfPath(path);
                    pex.putConfigFile(cp, is);
                    continue block7;
                }
                default: {
                    throw new ParFileException("errorExportOp");
                }
            }
        }
    }

    private InputStream getCheckedIS(ZipEntry ze) throws ParFileException {
        try {
            InputStream is = this.getInputStream(ze);
            if (is == null) {
                throw new ParFileException("errorZipOpen");
            }
            return is;
        }
        catch (Exception ex) {
            throw new ParFileException("errorZipOpen", ex);
        }
    }
}

