/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Par
implements XMLDPTags {
    public static final String RESOURCE_BASE = "desktopPAR";
    public static ResourceBundle m_RB = PropertyResourceBundle.getBundle("desktopPAR", Locale.getDefault());
    public static Logger m_Logger = null;

    public static void setLogger(Logger logger) {
        m_Logger = logger;
    }

    public static String classToFile(String pkg, String classname) {
        if (pkg != null && pkg.length() > 0) {
            return Par.classToFile(pkg + "." + classname);
        }
        return classname + ".class";
    }

    public static String classToFile(String fullclassname) {
        StringTokenizer tok = new StringTokenizer(fullclassname, ".");
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        while (tok.hasMoreTokens()) {
            buf.append(pfx);
            buf.append(tok.nextToken());
            pfx = File.separator;
        }
        buf.append(".class");
        return buf.toString();
    }

    public static String findDPEntryName(Document doc) throws ParFileException {
        Element e = Par.getDPDocElement(doc);
        Attr a = e.getAttributeNode("name");
        if (a == null) {
            Object[] tok = new Object[]{"document"};
            throw new ParFileException("errorXMLNoName", tok);
        }
        return a.getValue();
    }

    public static int applicableDocTypes(Document doc) throws ParFileException {
        return Par.describeDPDoc(doc, null);
    }

    public static int describeDPDoc(Document doc, PrintStream dout) throws ParFileException {
        Element e = Par.getDPDocElement(doc);
        if (dout != null) {
            dout.println("DP Document:");
        }
        int types = 0;
        NodeList kids = e.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Object[] tok;
            Attr a;
            Node child = kids.item(i);
            if (!(child instanceof Element)) continue;
            String nm = child.getNodeName();
            Element chelt = (Element)child;
            if (nm.equals("Channel")) {
                types |= 2;
                if (dout == null) continue;
                a = chelt.getAttributeNode("name");
                if (a == null) {
                    tok = new Object[]{"channel"};
                    throw new ParFileException("errorXMLNoName", tok);
                }
                dout.println("\tChannel: " + a.getValue());
                continue;
            }
            if (nm.equals("Provider")) {
                types |= 1;
                if (dout == null) continue;
                a = chelt.getAttributeNode("name");
                if (a == null) {
                    tok = new Object[]{"provider"};
                    throw new ParFileException("errorXMLNoName", tok);
                }
                dout.println("\tProvider: " + a.getValue());
                continue;
            }
            if (!nm.equals("Description") || dout == null) continue;
            NodeList dkids = child.getChildNodes();
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < dkids.getLength(); ++j) {
                Node dchild = dkids.item(j);
                if (!(dchild instanceof Text)) continue;
                buf.append(dchild.getNodeValue());
            }
            StringTokenizer tok2 = new StringTokenizer(buf.toString(), "\n\r");
            while (tok2.hasMoreTokens()) {
                dout.println("\t" + tok2.nextToken());
            }
        }
        return types;
    }

    public static InputStream domToStream(Document doc) throws ParFileException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            DOMSource ds = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            t.transform(ds, sr);
            return new ByteArrayInputStream(Par.indentTags(sw.getBuffer().toString()).getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new ParFileException("errorXMLWrite", ex);
        }
    }

    private static String indentTags(String str) {
        int idx;
        StringBuffer out = new StringBuffer();
        int indent = 0;
        while ((idx = str.indexOf("<")) >= 0) {
            if (idx > 0) {
                out.append(str.substring(0, idx));
                if (str.charAt(idx - 1) != '\n') {
                    out.append("\n");
                }
                str = str.substring(idx);
            }
            if ((idx = str.indexOf(">")) <= 0) break;
            if (str.charAt(1) == '/' && indent > 0) {
                --indent;
            }
            for (int ic = 0; ic < indent; ++ic) {
                out.append("  ");
            }
            if (idx + 1 == str.length()) {
                out.append(str);
                str = "";
                break;
            }
            out.append(str.substring(0, idx + 1));
            if (str.charAt(idx + 1) != '\n') {
                out.append("\n");
            }
            if (str.charAt(1) != '/' && str.charAt(idx - 1) != '/') {
                ++indent;
            }
            str = str.substring(idx + 1);
        }
        out.append(str);
        out.append("\n");
        return out.toString();
    }

    public static Document streamToDom(InputStream str) throws ParFileException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(str);
        }
        catch (Exception ex) {
            throw new ParFileException("errorXMLRead", ex);
        }
    }

    public static Document makeParEntry(String name, String desc, Element dp) throws ParFileException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            throw new ParFileException("errorXMLConstruct", ex);
        }
        Element root = doc.createElement("ParEntry");
        root.setAttribute("name", name);
        doc.appendChild(root);
        if (desc != null) {
            Element delt = doc.createElement("Description");
            delt.appendChild(doc.createTextNode(desc));
            root.appendChild(delt);
        }
        if (dp != null) {
            root.appendChild(Par.cloneElement(doc, dp));
        }
        return doc;
    }

    public static Document makeParEntry(String name, String desc, Element provider, Element channel) throws ParFileException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            throw new ParFileException("errorXMLConstruct", ex);
        }
        Element root = doc.createElement("ParEntry");
        root.setAttribute("name", name);
        doc.appendChild(root);
        if (desc != null) {
            Element delt = doc.createElement("Description");
            delt.appendChild(doc.createTextNode(desc));
            root.appendChild(delt);
        }
        if (provider != null) {
            root.appendChild(Par.cloneElement(doc, provider));
        }
        if (channel != null) {
            root.appendChild(Par.cloneElement(doc, channel));
        }
        return doc;
    }

    public static String getProviderNameFromChannel(Document doc) throws ParFileException {
        Element chan = Par.findElement(doc, "Channel", false);
        if (chan == null) {
            return null;
        }
        Attr a = chan.getAttributeNode("provider");
        if (a == null) {
            Object[] tok = new Object[]{"channel", "provider"};
            throw new ParFileException("errorXMLAttr", tok);
        }
        return a.getValue();
    }

    public static String getProviderName(Document doc) throws ParFileException {
        Element p = Par.findElement(doc, "Provider", true);
        Attr a = p.getAttributeNode("name");
        if (a == null) {
            Object[] tok = new Object[]{"provider", "name"};
            throw new ParFileException("errorXMLAttr", tok);
        }
        return a.getValue();
    }

    public static String getChannelName(Document doc) throws ParFileException {
        Element chan = Par.findElement(doc, "Channel", true);
        Attr a = chan.getAttributeNode("name");
        if (a == null) {
            Object[] tok = new Object[]{"channel", "name"};
            throw new ParFileException("errorXMLAttr", tok);
        }
        return a.getValue();
    }

    public static String getProviderClass(Document doc) throws ParFileException {
        Element p = Par.findElement(doc, "Provider", true);
        Attr a = p.getAttributeNode("class");
        if (a == null) {
            Object[] tok = new Object[]{"provider", "class"};
            throw new ParFileException("errorXMLAttr", tok);
        }
        return a.getValue();
    }

    public static int getProviderVersion(Document doc) throws ParFileException {
        Element p = Par.findElement(doc, "Provider", true);
        Attr a = p.getAttributeNode("version");
        if (a == null) {
            Object[] tok = new Object[]{"provider", "version"};
            throw new ParFileException("errorXMLAttr", tok);
        }
        int version = -1;
        String versionStr = a.getValue();
        try {
            version = Integer.parseInt(versionStr);
        }
        catch (NumberFormatException nfe) {
            throw new ParFileException("errorXMLProviderVersion", nfe);
        }
        return version;
    }

    public static Element getProviderProperties(Document doc) throws ParFileException {
        return Par.findProperties(Par.findElement(doc, "Provider", true));
    }

    public static Element getChannelProperties(Document doc) throws ParFileException {
        return Par.findProperties(Par.findElement(doc, "Channel", true));
    }

    public static void replaceProps(Element elt, Element props) throws ParFileException {
        NodeList kids = elt.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node child = kids.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals("Properties")) continue;
            elt.removeChild(child);
            break;
        }
        elt.appendChild(Par.cloneElement(elt.getOwnerDocument(), props));
    }

    public static void setLocale(Locale locale) {
        m_RB = PropertyResourceBundle.getBundle(RESOURCE_BASE, locale);
    }

    public static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public static String getLocalizedString(String key) {
        try {
            return m_RB.getString(key);
        }
        catch (MissingResourceException mrex) {
            return "Missing PAR resource string: " + key;
        }
    }

    public static String getLocalizedString(String key, Object[] objs) {
        try {
            if (objs != null && objs.length > 0) {
                MessageFormat mf = new MessageFormat("");
                mf.setLocale(m_RB.getLocale());
                mf.applyPattern(m_RB.getString(key));
                return mf.format(objs);
            }
            return m_RB.getString(key);
        }
        catch (MissingResourceException mrex) {
            return "Missing PAR resource string: " + key;
        }
    }

    private static Element findElement(Document doc, String tag, boolean required) throws ParFileException {
        Element elt = Par.getDPDocElement(doc);
        NodeList kids = elt.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node child = kids.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals(tag)) continue;
            return (Element)child;
        }
        if (required) {
            Object[] tok = new Object[]{tag};
            throw new ParFileException("errorXMLMissing", tok);
        }
        return null;
    }

    private static Element cloneElement(Document doc, Element elt) throws ParFileException {
        Element copy = doc.createElement(elt.getNodeName());
        NamedNodeMap attrs = elt.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node n = attrs.item(i);
                if (!(n instanceof Attr)) continue;
                copy.setAttribute(n.getNodeName(), n.getNodeValue());
            }
        }
        NodeList kids = elt.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node n = kids.item(j);
            if (!(n instanceof Element)) continue;
            copy.appendChild(Par.cloneElement(doc, (Element)n));
        }
        return copy;
    }

    private static Element findProperties(Element elt) throws ParFileException {
        NodeList kids = elt.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node child = kids.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals("Properties")) continue;
            return (Element)child;
        }
        throw new ParFileException("errorXMLMissingProperties");
    }

    private static Element getDPDocElement(Document doc) throws ParFileException {
        Element e = doc.getDocumentElement();
        if (e == null) {
            throw new ParFileException("errorXMLNoRoot");
        }
        if (!e.getNodeName().equals("ParEntry")) {
            throw new ParFileException("errorXMLNoRoot");
        }
        return e;
    }
}

