/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.iplanet.sso.SSOToken;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReference;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.util.ResourceLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.w3c.dom.Document;

public class DPRootSpecifier {
    private String DTPROPFILE = "desktop.propertiesFile";
    private boolean m_IsGlobal;
    private String m_DN = null;
    private DPRoot m_DRoot = null;
    private Object m_ADPCtxObj;
    private XMLDPFactory m_Factory;
    private static String GLOBAL = "global";

    private DPRootSpecifier(String user, String pwd) throws ParFileException {
        String sysprop = System.getProperty(this.DTPROPFILE);
        if (sysprop == null) {
            Object[] tok = new Object[]{this.DTPROPFILE};
            throw new ParFileException("errorSystemProp", tok);
        }
        try {
            this.m_ADPCtxObj = new DSAMEAdminDPContext();
            ((AdminDPContext)this.m_ADPCtxObj).init(user, pwd, null, ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId());
            this.m_Factory = XMLDPFactory.getInstance();
        }
        catch (Exception ex) {
            throw new ParFileException("errorAuthenticate", ex);
        }
    }

    private DPRootSpecifier(SSOToken ssoToken, String portalId) throws ParFileException {
        String sysprop = System.getProperty(this.DTPROPFILE);
        if (sysprop == null) {
            Object[] tok = new Object[]{this.DTPROPFILE};
            throw new ParFileException("errorSystemProp", tok);
        }
        try {
            this.m_ADPCtxObj = new DSAMEAdminDPContext();
            ((AdminDPContext)this.m_ADPCtxObj).init(ssoToken, null, portalId);
            this.m_Factory = XMLDPFactory.getInstance();
        }
        catch (Exception ex) {
            throw new ParFileException("errorAuthenticate", ex);
        }
    }

    public static DPRootSpecifier makeSpecifier(String user, String pwd) throws ParFileException {
        return new DPRootSpecifier(user, pwd);
    }

    public static DPRootSpecifier makeSpecifier(SSOToken ssoToken, String portalId) throws ParFileException {
        return new DPRootSpecifier(ssoToken, portalId);
    }

    public void setDN(String dn) {
        if (dn != null && this.m_DN != null && dn.equals(this.m_DN)) {
            return;
        }
        this.m_DN = dn;
        this.m_IsGlobal = dn.equalsIgnoreCase(GLOBAL);
        this.m_DRoot = null;
    }

    public DPRoot getRoot() throws ParFileException {
        if (this.m_DRoot != null) {
            return this.m_DRoot;
        }
        if (this.m_DN == null) {
            throw new ParFileException("errorNoDirName");
        }
        try {
            String buf = this.m_IsGlobal ? ((AdminDPContext)this.m_ADPCtxObj).getGlobalDPDocument() : ((AdminDPContext)this.m_ADPCtxObj).getDPDocument(this.m_DN);
            this.m_DRoot = this.m_Factory.createRoot((DPContext)this.m_ADPCtxObj, buf);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPFetch", ex);
        }
        return this.m_DRoot;
    }

    public String getDN() {
        return this.m_DN;
    }

    public DPProvider createProvider(String name, String classname, int providerVersion) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createProvider((DPContext)this.m_ADPCtxObj, this.m_DRoot, doc, name, classname, providerVersion);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPCreate", ex);
        }
    }

    public DPChannel createChannel(String name, String provider) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createChannel((DPContext)this.m_ADPCtxObj, this.m_DRoot, doc, name, provider);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPCreate", ex);
        }
    }

    public DPReference createReference(String name) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createReference((DPContext)this.m_ADPCtxObj, this.m_DRoot, doc, name);
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPCreate", ex);
        }
    }

    public void flush() throws ParFileException {
        try {
            this.m_DRoot.setDirty(false);
            StringBuffer buf = new StringBuffer(256);
            this.m_DRoot.toXML(buf, 0);
            if (this.m_IsGlobal) {
                ((AdminDPContext)this.m_ADPCtxObj).storeGlobalDPDocument(buf.toString());
            } else {
                ((AdminDPContext)this.m_ADPCtxObj).storeDPDocument(this.m_DN, buf.toString());
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPFlush", ex);
        }
    }

    private Object getAdminDPContextObject(String propsFileName) throws ParFileException {
        Properties desktopProps = new Properties();
        try {
            desktopProps.load(new FileInputStream(propsFileName));
        }
        catch (FileNotFoundException fnfe) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext() ", fnfe);
        }
        catch (IOException ioe) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext() ", ioe);
        }
        String adminDPContextClassName = desktopProps.getProperty("adminDPContextClassName");
        Object adcObj = null;
        try {
            adcObj = Class.forName(adminDPContextClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", iae);
        }
        catch (ClassCastException cce) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", cce);
        }
        catch (InstantiationException ie) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", ie);
        }
        catch (SecurityException se) {
            throw new ParFileException("DPRootSpecifier.getAdminDPContext()", se);
        }
        return adcObj;
    }
}

