/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.BasicFileHelper;
import com.sun.portal.desktop.deployment.ClassFilePPF;
import com.sun.portal.desktop.deployment.ClassJarPPF;
import com.sun.portal.desktop.deployment.ClassLoaderPPF;
import com.sun.portal.desktop.deployment.ClassPPF;
import com.sun.portal.desktop.deployment.ConfPPF;
import com.sun.portal.desktop.deployment.DPBasedContext;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.PropLocPPF;
import com.sun.portal.desktop.deployment.ProviderPackageContext;
import com.sun.portal.desktop.deployment.ProviderPackageFile;
import com.sun.portal.desktop.deployment.StaticPPF;
import com.sun.portal.desktop.deployment.WarPPF;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPChannel;
import com.sun.portal.desktop.dp.xml.XMLDPProvider;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DPBasedPPCtx
extends DPBasedContext
implements ProviderPackageContext {
    private DPRoot m_DPRoot;

    public DPBasedPPCtx(DPRootSpecifier dpr, String ss) throws ParFileException {
        if (dpr != null) {
            this.m_DPRoot = dpr.getRoot();
        }
        if (ss != null) {
            this.setStaticSub(ss);
        }
    }

    public void setObject(String objname, int types) throws ParFileException {
        this.setPropertyHolder(this.m_DPRoot, objname, types);
    }

    public String getContainerName(String channel) throws ParFileException {
        DPChannel ch = this.getChannel();
        if (ch == null) {
            return null;
        }
        try {
            DPNode pn = ch.getParentNode();
            if (pn instanceof DPContainerChannel) {
                return pn.getName();
            }
        }
        catch (Exception ex) {
            throw new ParFileException("errorContainerName", ex);
        }
        return null;
    }

    public Document getParEntry(String entryname, String desc) throws ParFileException {
        DPChannel ch = this.getChannel();
        DPProvider pr = this.getProvider();
        Element chelt = ch == null ? null : ((XMLDPChannel)ch).getElement();
        Element pelt = pr == null ? null : ((XMLDPProvider)pr).getElement();
        return Par.makeParEntry(entryname, desc, pelt, chelt);
    }

    public ProviderPackageFile getStaticFile(String path, int types) throws ParFileException {
        return new StaticPPF(this.getStaticDirectory(), path, types);
    }

    public ProviderPackageFile getWarFile(String path, int types) throws ParFileException {
        return new WarPPF(this.getPortalWarDirectory(), path, types);
    }

    public ProviderPackageFile getConfigFile(String path, int types) throws ParFileException {
        return new ConfPPF(this.getPSDataDirectory(), path, types);
    }

    public ProviderPackageFile getPropLocFile(String rootproperty, String path, int types) throws ParFileException {
        String rdir = this.getPBFProperty(rootproperty, false);
        return new PropLocPPF(rootproperty, rdir, path, types);
    }

    public ProviderPackageFile getClassFile(String classname, int types) throws ParFileException {
        Vector v = this.getClassPath();
        for (int i = 0; i < v.size(); ++i) {
            String croot = (String)v.elementAt(i);
            ClassPPF cpp = null;
            cpp = this.isJar(croot) ? new ClassJarPPF(classname, croot, types) : new ClassFilePPF(classname, croot, types);
            if (!cpp.classExists()) continue;
            return cpp;
        }
        ClassLoaderPPF cpp = new ClassLoaderPPF(classname, types);
        if (((ClassPPF)cpp).classExists()) {
            return cpp;
        }
        Object[] tok = new Object[]{classname};
        throw new ParFileException("errorNoClass", tok);
    }

    public void addBasicFiles(Vector v) throws ParFileException {
        String hlp = this.getPBFProperty("DeploymentFileHelper", true);
        if (hlp == null) {
            return;
        }
        BasicFileHelper bh = null;
        try {
            bh = (BasicFileHelper)Class.forName(hlp).newInstance();
        }
        catch (Exception ex) {
            throw new ParFileException("errorClassCreate", ex);
        }
        bh.addBasicFiles(this, this.getTypes(), v);
    }

    public String getPropertyString(String prop) throws ParFileException {
        return this.getPBFProperty(prop, true);
    }

    public void addDirectory(String prop, String subdir, boolean recurse, boolean addFiles, String dfilter, int types, String excludedDir, Vector v) throws ParFileException {
        String rdir = null;
        rdir = prop != null ? (prop.equals("ps.warDir") ? this.getPortalWarDirectory() : (prop.equals("ps.dataDir") ? this.getPSDataDirectory() : this.getPBFProperty(prop, false))) : this.getStaticDirectory();
        if (rdir.endsWith(FS)) {
            int len = rdir.length();
            rdir = rdir.substring(0, len - 1);
        }
        Vector<String> dlist = new Vector<String>();
        if (recurse) {
            if (dfilter != null && subdir != null) {
                dlist.add(subdir);
            }
            this.addSubDirs(dlist, rdir, subdir, dfilter, excludedDir);
        } else if (subdir != null) {
            dlist.add(subdir);
        }
        if (addFiles) {
            if (subdir != null) {
                dlist.add(subdir);
            } else {
                dlist.add("");
            }
        }
        for (int i = 0; i < dlist.size(); ++i) {
            File f;
            File[] children;
            String dir = (String)dlist.elementAt(i);
            if (dir.equals(excludedDir) || (children = (f = new File(rdir + FS + dir)).listFiles()) == null) continue;
            for (int j = 0; j < children.length; ++j) {
                String rp;
                File child = children[j];
                if (child.isDirectory()) continue;
                String string = rp = dir.equals("") ? child.getName() : dir + FS + child.getName();
                if (prop != null) {
                    if (prop.equals("ps.warDir")) {
                        String psWarFile = System.getProperty("ps.warFile");
                        if (child.getName().lastIndexOf(psWarFile) != -1) continue;
                        v.add(this.getWarFile(rp, types));
                        continue;
                    }
                    if (prop.equals("ps.dataDir")) {
                        v.add(this.getConfigFile(rp, types));
                        continue;
                    }
                    v.add(this.getPropLocFile(prop, rp, types));
                    continue;
                }
                v.add(this.getStaticFile(rp, types));
            }
        }
    }

    public void setDTProps(Properties prop) {
        this.m_DTProps = prop;
    }

    private void addSubDirs(Vector dlist, String rdir, String subdir, String dfilter, String excludedDir) {
        File d = new File(subdir == null ? rdir : rdir + FS + subdir);
        File[] children = d.listFiles();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            String nmplus;
            File child = children[i];
            String nm = child.getName();
            if (!child.isDirectory() || nm.equals(excludedDir)) continue;
            String string = nmplus = subdir == null ? nm : subdir + FS + nm;
            if (dfilter == null || dfilter.equals(nm)) {
                dlist.add(nmplus);
                this.addSubDirs(dlist, rdir, nmplus, null, null);
                continue;
            }
            this.addSubDirs(dlist, rdir, nmplus, dfilter, null);
        }
    }
}

