/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.DPBasedContext;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParExtractionContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReference;
import com.sun.portal.desktop.dp.DPReferenceList;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DPBasedExCtx
extends DPBasedContext
implements ParExtractionContext {
    private boolean m_Overwrite = false;
    private boolean m_Verbose = false;
    private Logger m_Logger = null;
    private PrintStream m_Out = null;
    private ExtractOp m_Op = null;
    private DPRootSpecifier m_DPRSpec;
    private String m_PathXFrom = null;
    private String m_PathXTo = null;
    private String m_PropFileXFrom = null;
    private String m_PropFileXTo = null;
    private static final String FS = File.separator;

    public DPBasedExCtx(boolean verbose, Logger logger, boolean overwrite) {
        this.m_Verbose = verbose;
        this.m_Logger = logger;
        this.m_Overwrite = overwrite;
    }

    public DPBasedExCtx(DPRootSpecifier droot, boolean overwrite, boolean verbose, PrintStream out, String ss) {
        this.m_DPRSpec = droot;
        this.m_Overwrite = overwrite;
        this.m_Verbose = verbose;
        this.m_Out = out;
        this.setStaticSub(ss);
    }

    public DPBasedExCtx(DPRootSpecifier droot, boolean verbose, Logger logger, boolean overwrite) {
        this.m_DPRSpec = droot;
        this.m_Overwrite = overwrite;
        this.m_Verbose = verbose;
        this.m_Logger = logger;
    }

    public void putParEntryXMLFile(InputStream in, int types) throws ParFileException {
        Object[] tok;
        String pvname;
        if (!this.deployDynamic()) {
            return;
        }
        Document doc = Par.streamToDom(in);
        DPRoot dr = this.m_DPRSpec.getRoot();
        String objname = pvname = Par.getProviderNameFromChannel(doc);
        this.m_PathXFrom = null;
        this.m_PathXTo = null;
        this.m_PropFileXFrom = null;
        this.m_PropFileXTo = null;
        if ((types & 1) != 0) {
            pvname = this.m_Op.getProviderName();
            if (pvname == null) {
                pvname = Par.getProviderName(doc);
            } else {
                this.m_PropFileXFrom = Par.getProviderName(doc);
                this.m_PropFileXTo = pvname;
            }
            objname = pvname;
            String cls = Par.getProviderClass(doc);
            int providerVersion = Par.getProviderVersion(doc);
            try {
                if (dr.getProvider(pvname) != null) {
                    if (!this.m_Overwrite) {
                        Object[] tok2 = new Object[]{pvname};
                        throw new ParFileException("errorProviderExists", tok2);
                    }
                    dr.removeProvider(pvname);
                }
                tok = new Object[]{"provider", pvname + ", " + cls};
                if (this.m_Logger != null) {
                    if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                        this.m_Logger.log(Level.INFO, "PSDT_CSPDD0001", tok);
                    }
                } else {
                    this.message(Par.getLocalizedString("msgImportAdd", tok));
                }
                DPProvider pr = this.m_DPRSpec.createProvider(pvname, cls, providerVersion);
                pr = dr.addProvider(pr);
                this.setProperties(pr, Par.getProviderProperties(doc));
            }
            catch (Exception ex) {
                throw new ParFileException("errorImporting", ex);
            }
        }
        if ((types & 2) != 0) {
            try {
                Object[] tok3;
                DPNode container = dr;
                String containerName = this.m_Op.getChannelContainer();
                if (containerName != null && (container = dr.getChannel(containerName)) == null) {
                    tok = new Object[]{containerName};
                    throw new ParFileException("errorNoContainer", tok);
                }
                String channelName = this.m_Op.getChannelName();
                if (channelName == null) {
                    channelName = Par.getChannelName(doc);
                } else {
                    this.m_PathXFrom = Par.getChannelName(doc);
                    this.m_PathXTo = channelName;
                }
                String string = objname = containerName != null ? containerName + '/' + channelName : channelName;
                if (dr.getChannel(objname) != null) {
                    if (!this.m_Overwrite) {
                        tok3 = new Object[]{objname};
                        throw new ParFileException("errorChannelExists", tok3);
                    }
                    dr.removeChannel(objname);
                }
                tok3 = new Object[]{"channel", objname + ", " + pvname};
                if (this.m_Logger != null) {
                    if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                        this.m_Logger.log(Level.INFO, "PSDT_CSPDD0001", tok3);
                    }
                } else {
                    this.message(Par.getLocalizedString("msgImportAdd", tok3));
                }
                DPChannel chan = this.m_DPRSpec.createChannel(channelName, pvname);
                chan = container.addChannel(chan);
                this.setProperties(chan, Par.getChannelProperties(doc));
                String aname = this.m_Op.getAvailContainer();
                if (aname != null) {
                    DPChannel avchan = dr.getChannel(aname);
                    this.addReference(((DPContainerChannel)avchan).getAvailable(), objname);
                    if (this.m_Op.getMakeSelected()) {
                        this.addReference(((DPContainerChannel)avchan).getSelected(), objname);
                    }
                }
            }
            catch (Exception ex) {
                throw new ParFileException("errorImporting", ex);
            }
        }
        this.m_DPRSpec.flush();
        this.setPropertyHolder(dr, objname, types);
    }

    public void putClassFile(String fullname, InputStream in) throws ParFileException {
        if (!this.deployDynamic()) {
            return;
        }
        String cdir = (String)this.getClassPath().elementAt(0);
        this.streamOut(cdir + FS + Par.classToFile(fullname), in);
    }

    public void initializeForOperation(ExtractOp op) throws ParFileException {
        Object[] tok = new Object[]{op.toArg()};
        if (this.m_Logger != null) {
            if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                this.m_Logger.log(Level.INFO, "PSDT_CSPDD0002", tok);
            }
        } else {
            this.message(Par.getLocalizedString("msgImportInitOp", tok));
        }
        this.m_DPRSpec.setDN(op.getDPNode());
        this.m_Op = op;
    }

    public void putPropLocFile(String rootproperty, String path, InputStream in) throws ParFileException {
        String realPath = this.getPBFProperty(rootproperty, false) + FS + this.translatePath(path);
        if (this.deployDynamic()) {
            this.streamOut(this.getPBFProperty(rootproperty, false) + FS + this.translatePath(path), in);
        }
    }

    public void putWarFile(String path, InputStream in) throws ParFileException {
        if (this.deployStatic()) {
            this.streamOut(this.getPortalWarDirectory() + FS + path, in);
        }
    }

    public void putConfigFile(String path, InputStream in) throws ParFileException {
        if (this.deployStatic()) {
            this.streamOut(this.getPSDataDirectory() + FS + path, in);
        }
    }

    public void putStaticFile(String path, InputStream in) throws ParFileException {
        if (this.deployStatic()) {
            for (int idx = 0; idx < this.getStaticDirectoryCount(); ++idx) {
                String outpath = this.getStaticDirectory() + FS + this.translatePath(path);
                this.streamOut(outpath, in);
                try {
                    in = new FileInputStream(outpath);
                    continue;
                }
                catch (Exception ex) {
                    throw new ParFileException("errorImporting", ex);
                }
            }
        }
    }

    public void terminateOperation(boolean success) throws ParFileException {
        if (success) {
            if (this.deployStatic()) {
                // empty if block
            }
            if (this.m_Logger != null) {
                if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                    this.m_Logger.log(Level.INFO, "PSDT_CSPDD0003");
                }
            } else {
                this.message(Par.getLocalizedString("msgImportOpComplete"));
            }
        } else if (this.m_Logger != null) {
            if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                this.m_Logger.log(Level.INFO, "PSDT_CSPDD0004");
            }
        } else {
            this.message(Par.getLocalizedString("msgImportOpFailed"));
        }
        this.m_Op = null;
    }

    private String translatePath(String path) {
        if (this.m_PathXFrom == null && this.m_PropFileXFrom == null) {
            return path;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer toks = new StringTokenizer(path, "/");
        String pfx = "";
        while (toks.hasMoreTokens()) {
            String comp = toks.nextToken();
            if (this.m_PathXFrom != null && comp.equals(this.m_PathXFrom)) {
                comp = this.m_PathXTo;
            }
            if (this.m_PropFileXFrom != null && comp.endsWith(".properties") && comp.startsWith(this.m_PropFileXFrom)) {
                comp = this.m_PropFileXTo + comp.substring(this.m_PropFileXFrom.length());
            }
            buf.append(pfx);
            buf.append(comp);
            pfx = "/";
        }
        return buf.toString();
    }

    private void setProperties(DPPropertyHolder nd, Element props) throws ParFileException {
        XMLDPObject xnd = (XMLDPObject)((Object)nd);
        Element elt = xnd.getElement();
        Par.replaceProps(elt, props);
    }

    private void addReference(DPReferenceList rl, String nm) throws ParFileException {
        try {
            DPReference ref = this.m_DPRSpec.createReference(nm);
            rl.add(ref);
        }
        catch (Exception ex) {
            throw new ParFileException("errorImporting", ex);
        }
    }

    private void message(String mess) {
        if (this.m_Verbose && this.m_Out != null) {
            this.m_Out.println(mess);
        }
    }

    private void streamOut(String filename, InputStream in) throws ParFileException {
        try {
            int len;
            byte[] buf = new byte[4000];
            File f = new File(filename);
            if (!this.m_Overwrite && f.exists() && !f.isDirectory()) {
                return;
            }
            f.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(f);
            while ((len = in.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            os.close();
        }
        catch (Exception ex) {
            throw new ParFileException("errorImporting", ex);
        }
    }

    public void putJarFile(String path, InputStream in) throws ParFileException {
    }

    public void delDirectory(String prop, String subdir, String dfilter, boolean delTopChildren) throws ParFileException {
        String rdir;
        String string = rdir = prop != null ? this.getPBFProperty(prop, false) : this.getStaticDirectory();
        if (rdir.endsWith(FS)) {
            int len = rdir.length();
            rdir = rdir.substring(0, len - 1);
        }
        if (this.m_Verbose) {
            Object[] token = new String[]{rdir};
            if (this.m_Logger.isLoggable(Level.INFO)) {
                this.m_Logger.log(Level.INFO, "PSDT_CSPDD0005", token);
            }
        }
        this.delSubDir(rdir, subdir, dfilter, delTopChildren);
    }

    private void delSubDir(String rdir, String subdir, String dfilter, boolean delTopChildren) {
        File f = new File(subdir == null ? rdir : rdir + FS + subdir);
        File[] children = f.listFiles();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                String nmplus;
                String nm = child.getName();
                String string = nmplus = subdir == null ? nm : subdir + FS + nm;
                if (dfilter == null || dfilter.equals(nm)) {
                    this.delSubDir(rdir, nmplus, null, true);
                } else {
                    this.delSubDir(rdir, nmplus, dfilter, true);
                }
                child.delete();
                continue;
            }
            if (!child.exists() || !delTopChildren) continue;
            if (this.m_Verbose && this.m_Logger.isLoggable(Level.INFO)) {
                Object[] token = new String[]{child.getName()};
                this.m_Logger.log(Level.INFO, "PSDT_CSPDD0006", token);
            }
            child.delete();
        }
    }

    public void setChannelPath(InputStream in, int types) throws ParFileException {
        if ((types & 2) != 0) {
            Document doc = Par.streamToDom(in);
            String channelName = this.m_Op.getChannelName();
            if (channelName == null) {
                channelName = Par.getChannelName(doc);
            } else {
                this.m_PathXFrom = Par.getChannelName(doc);
                this.m_PathXTo = channelName;
            }
        }
    }
}

