/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPString;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class DPBasedContext {
    public static final String FS = File.separator;
    public static final String TEMPLATE_BASE_DIR = "templateBaseDir";
    public static final String COMMUNITY_TEMPLATE_BASE_DIR = "communityTemplateBaseDir";
    public static final String PROVIDER_BASE_DIR = "providerClassBaseDir";
    public Logger m_Logger;
    private DPPropertyHolder m_Prop = null;
    private DPChannel m_Chan = null;
    private Vector m_Classes = null;
    private int m_Types;
    private String[] m_StatSub = null;
    protected Properties m_DTProps = null;

    DPBasedContext() {
    }

    public void setLogger(Logger logger) {
        this.m_Logger = logger;
    }

    protected void setStaticSub(String ss) {
        if (ss == null) {
            this.m_StatSub = null;
            return;
        }
        StringTokenizer toks = new StringTokenizer(ss, ", ");
        Vector<String> v = new Vector<String>();
        while (toks.hasMoreTokens()) {
            v.add(toks.nextToken());
        }
        this.m_StatSub = v.toArray(new String[v.size()]);
    }

    protected void setPropertyHolder(DPNode root, String objname, int types) throws ParFileException {
        try {
            if ((types & 2) != 0) {
                this.m_Chan = root.getChannel(objname);
                this.m_Prop = this.m_Chan;
            } else {
                this.m_Prop = root.getProvider(objname);
                this.m_Chan = null;
            }
            this.m_Types = types;
        }
        catch (Exception ex) {
            throw new ParFileException("errorDPRoot", ex);
        }
        if (this.m_Prop == null) {
            Object[] tok = new Object[]{objname};
            throw new ParFileException("errorNoObject", tok);
        }
    }

    protected String getPBFProperty(String prop, boolean nullok) throws ParFileException {
        String val = this.getDesktopProperty(prop, true);
        if (val != null) {
            return val;
        }
        if (this.m_Prop == null) {
            throw new ParFileException("errorNoPropHolder");
        }
        try {
            DPString dps = this.m_Prop.getProperties().getString(prop);
            if (dps != null) {
                val = dps.getStringValue();
            }
        }
        catch (Exception ex) {
            val = null;
        }
        if (val != null || nullok) {
            return val;
        }
        Object[] tok = new Object[]{prop};
        throw new ParFileException("errorUndefinedProperty", tok);
    }

    protected Vector getClassPath() throws ParFileException {
        if (this.m_Classes != null) {
            return this.m_Classes;
        }
        this.m_Classes = new Vector();
        String bdir = this.getDesktopProperty(PROVIDER_BASE_DIR, false);
        this.m_Classes.add(bdir);
        File f = new File(bdir);
        String[] names = f.list();
        if (names == null) {
            return this.m_Classes;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].endsWith(".jar")) continue;
            this.m_Classes.add(bdir + FS + names[i]);
        }
        return this.m_Classes;
    }

    protected boolean isJar(String fn) {
        File f = new File(fn);
        return f.isFile();
    }

    protected DPChannel getChannel() {
        return this.m_Chan;
    }

    protected DPProvider getProvider() throws ParFileException {
        if (this.m_Chan != null) {
            try {
                return this.m_Chan.getProvider();
            }
            catch (Exception ex) {
                throw new ParFileException("errorProviderForChannel", ex);
            }
        }
        return (DPProvider)this.m_Prop;
    }

    protected int getTypes() {
        return this.m_Types;
    }

    private String getStaticDirectoryRoot() throws ParFileException {
        String dir = System.getProperty("ps.staticDir");
        if (dir == null) {
            Object[] tok = new Object[]{"ps.staticDir"};
            throw new ParFileException("errorSystemProp", tok);
        }
        return dir;
    }

    protected String getStaticDirectory(int idx) throws ParFileException {
        String sroot = this.getStaticDirectoryRoot();
        if (idx == 0 && (this.m_StatSub == null || this.m_StatSub.length == 0)) {
            return sroot;
        }
        return sroot + FS + this.m_StatSub[idx];
    }

    protected String getStaticDirectory() throws ParFileException {
        return this.getStaticDirectory(0);
    }

    protected int getStaticDirectoryCount() {
        if (this.m_StatSub == null || this.m_StatSub.length == 0) {
            return 1;
        }
        return this.m_StatSub.length;
    }

    protected String getPortalWarDirectory() throws ParFileException {
        String dir = System.getProperty("ps.warDir");
        if (dir == null) {
            Object[] tok = new Object[]{"ps.warDir"};
            throw new ParFileException("errorSystemProp", tok);
        }
        return dir;
    }

    protected String getPSDataDirectory() throws ParFileException {
        String dir = System.getProperty("ps.dataDir");
        if (dir == null) {
            Object[] tok = new Object[]{"ps.dataDir"};
            throw new ParFileException("errorSystemProp", tok);
        }
        return dir;
    }

    protected boolean deployDynamic() throws ParFileException {
        return true;
    }

    protected boolean deployStatic() throws ParFileException {
        return true;
    }

    private String getDesktopProperty(String key, boolean nullok) throws ParFileException {
        String val = null;
        if (this.m_DTProps == null) {
            String sysprop = System.getProperty("desktop.propertiesFile");
            if (sysprop == null) {
                Object[] tok = new Object[]{"desktop.propertiesFile"};
                throw new ParFileException("errorSystemProp", tok);
            }
            try {
                this.m_DTProps = new Properties();
                this.m_DTProps.load(new FileInputStream(sysprop));
            }
            catch (Exception ex) {
                if (this.m_Logger != null) {
                    this.m_Logger.log(Level.INFO, "DPBaseContext, key:" + key);
                }
                if ((val = this.getDTPropVal(key)) != null || nullok) {
                    this.m_DTProps = null;
                    return val;
                }
                throw new ParFileException("errorDesktopLoad", ex);
            }
        }
        if ((val = this.m_DTProps.getProperty(key)) != null || nullok) {
            return val;
        }
        Object[] tok = new Object[]{key, "desktop.propertiesFile"};
        throw new ParFileException("Desktop property " + key + " not defined in " + "desktop.propertiesFile");
    }

    private String getDTPropVal(String key) throws ParFileException {
        String val = null;
        if (key != null) {
            if (key.equals(TEMPLATE_BASE_DIR)) {
                val = this.getPSDataDirectory() + FS + "desktop";
            } else if (key.equals(COMMUNITY_TEMPLATE_BASE_DIR)) {
                val = this.getPSDataDirectory() + FS + "communitytemplates";
            } else if (key.equals(PROVIDER_BASE_DIR)) {
                val = this.getPSDataDirectory() + FS + "desktop" + FS + "classes";
            }
            if (this.m_Logger != null) {
                this.m_Logger.log(Level.INFO, "DPBaseContext, val:" + val);
            }
        }
        return val;
    }
}

