/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.common.pool.PartitionObject;
import com.sun.common.util.LockWithMemory;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderGetterPool;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReusableProviderGetter
extends Thread
implements PartitionObject {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private HttpServletRequest origRequest = null;
    private HttpServletResponse origResponse = null;
    private ContainerProviderContext providerContext = null;
    private Provider provider = null;
    private String providerName = null;
    private String parent = null;
    private Monitor monitor = null;
    private boolean initialized = false;
    private boolean running = true;
    private LockWithMemory begin = new LockWithMemory();
    private LockWithMemory end = new LockWithMemory();
    private ProviderGetterPool pool = null;
    private DesktopAppContext desktopAppContext = null;
    private DesktopContext desktopContext = null;
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;
    private int partition = 0;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$ReusableProviderGetter == null ? (class$com$sun$portal$desktop$context$ReusableProviderGetter = ReusableProviderGetter.class$("com.sun.portal.desktop.context.ReusableProviderGetter")) : class$com$sun$portal$desktop$context$ReusableProviderGetter));
    static /* synthetic */ Class class$com$sun$portal$desktop$context$ReusableProviderGetter;

    public ReusableProviderGetter() {
        this.setDaemon(true);
        this.setName(this.getClass().getName());
        this.desktopAppContext = DesktopAppContextThreadLocalizer.get();
    }

    void init(DesktopAppContext dac, DesktopContext dc, ContainerProviderContext cpc, String parent, String providerName, Monitor m, HttpServletRequest req, HttpServletResponse res, HttpServletRequest origReq, HttpServletResponse origRes, ServletContext sc, ProviderGetterPool getterPool) {
        this.providerContext = cpc;
        this.monitor = m;
        this.request = req;
        this.response = res;
        this.origRequest = origReq;
        this.origResponse = origRes;
        this.parent = parent;
        this.providerName = providerName;
        this.desktopAppContext = dac;
        this.desktopContext = dc;
        this.servletConfig = this.servletConfig;
        this.servletContext = this.servletContext;
        this.pool = getterPool;
        this.initialized = true;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public int getPartition() {
        return this.partition;
    }

    void clear() {
        this.initialized = false;
        this.providerContext = null;
        this.monitor = null;
        this.parent = null;
        this.providerName = null;
        this.request = null;
        this.response = null;
        this.origRequest = null;
        this.origResponse = null;
        this.desktopAppContext = null;
        this.desktopContext = null;
        this.servletConfig = null;
        this.servletContext = null;
    }

    public void execute() {
        this.begin.signal();
    }

    void finish() {
        this.running = false;
        this.begin.signal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            while (this.running) {
                try {
                    try {
                        this.begin.waitFor();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    if (!this.running) {
                        return;
                    }
                    DesktopThreadLocalManager.init(this.desktopAppContext, this.request, this.response, this.origRequest, this.origResponse, this.servletConfig, this.servletContext);
                    DesktopThreadLocalManager.init(this.desktopContext, this.providerContext);
                    try {
                        if (!this.initialized) {
                            throw new ContextError("ProviderGetter.run(): attmpted un-initialized loop!");
                        }
                        ProviderContextThreadLocalizer.set(this.providerContext);
                        this.provider = this.providerContext.getProvider(this.request, this.parent, this.providerName);
                        this.monitor.put(this.providerName, this.provider);
                        debugLogger.log(Level.FINE, "PSDT_CSPDC0026", this.providerName);
                    }
                    catch (Throwable e) {
                        if (debugLogger.isLoggable(Level.INFO)) {
                            LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0027");
                            logRecord.setLoggerName(debugLogger.getName());
                            logRecord.setParameters(new String[]{this.providerName});
                            logRecord.setThrown(e);
                            debugLogger.log(logRecord);
                        }
                        this.monitor.put(this.providerName, null);
                    }
                    this.end.signal();
                    DesktopThreadLocalManager.release();
                    this.pool.releaseGetter(this);
                }
                catch (Throwable t1) {
                    throw new ContextError("ProviderGetter.run()", t1);
                    return;
                }
            }
        }
        catch (Throwable t2) {
            throw new ContextError("ProviderGetter.run()", t2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

