/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.common.pool.PartitionObject;
import com.sun.common.util.LockWithMemory;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.context.CommunityUserMembershipThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.ProviderCallerPool;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.monitoring.MonitoringSubsystemWrapper;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.utilities.ActivityTime;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReusableProviderCaller
extends Thread
implements PartitionObject {
    private ContainerProviderContext providerContext = null;
    private Provider provider = null;
    private StringBuffer content = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private HttpServletRequest origRequest = null;
    private HttpServletResponse origResponse = null;
    private String parent = null;
    private Monitor monitor = null;
    private boolean initialized = false;
    private boolean running = true;
    private LockWithMemory begin = new LockWithMemory();
    private LockWithMemory end = new LockWithMemory();
    private ProviderCallerPool pool = null;
    private DesktopAppContext desktopAppContext = null;
    private DesktopContext desktopContext = null;
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;
    private Set cuMembership = null;
    private int partition = 0;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$ReusableProviderCaller == null ? (class$com$sun$portal$desktop$context$ReusableProviderCaller = ReusableProviderCaller.class$("com.sun.portal.desktop.context.ReusableProviderCaller")) : class$com$sun$portal$desktop$context$ReusableProviderCaller));
    static /* synthetic */ Class class$com$sun$portal$desktop$context$ReusableProviderCaller;

    public ReusableProviderCaller() {
        this.setDaemon(true);
        this.setName(this.getClass().getName());
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public int getPartition() {
        return this.partition;
    }

    void init(DesktopAppContext dac, DesktopContext dc, ContainerProviderContext cpc, Provider p, String parent, Monitor m, HttpServletRequest req, HttpServletResponse res, HttpServletRequest origReq, HttpServletResponse origRes, ServletConfig servletConfig, ServletContext servletContext, Set cuMembership, ProviderCallerPool callerPool) {
        this.providerContext = cpc;
        this.provider = p;
        this.parent = parent;
        this.monitor = m;
        this.request = req;
        this.response = res;
        this.origRequest = origReq;
        this.origResponse = origRes;
        this.desktopAppContext = dac;
        this.desktopContext = dc;
        this.servletConfig = servletConfig;
        this.servletContext = servletContext;
        this.pool = callerPool;
        this.cuMembership = cuMembership;
        this.initialized = true;
    }

    void clear() {
        this.initialized = false;
        this.content = null;
        this.providerContext = null;
        this.provider = null;
        this.parent = null;
        this.monitor = null;
        this.request = null;
        this.response = null;
        this.origRequest = null;
        this.origResponse = null;
        this.desktopAppContext = null;
        this.desktopContext = null;
        this.servletContext = null;
        this.servletConfig = null;
    }

    public void execute() {
        this.begin.signal();
    }

    void finish() {
        this.running = false;
        this.begin.signal();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public void run() {
        try {
            while (this.running) {
                try {
                    this.begin.waitFor();
                }
                catch (InterruptedException ie) {
                    DesktopThreadLocalManager.release();
                    CommunityUserMembershipThreadLocalizer.reset();
                    continue;
                }
                try {
                    if (!this.running) {
                        return;
                    }
                    String name = null;
                    DesktopThreadLocalManager.init(this.desktopAppContext, this.request, this.response, this.origRequest, this.origResponse, this.servletConfig, this.servletContext);
                    DesktopThreadLocalManager.init(this.desktopContext, this.providerContext);
                    DesktopThreadLocalManager.init(this.parent);
                    CommunityUserMembershipThreadLocalizer.set(this.desktopContext.getUserID(), this.cuMembership);
                    try {
                        if (!this.initialized) {
                            throw new ContextError("ProviderCaller.run(): attmpted un-initialized loop!");
                        }
                        ProviderContextThreadLocalizer.set(this.providerContext);
                        name = this.provider.getName();
                        ActivityTime activityTime = new ActivityTime();
                        MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().mark(activityTime);
                        this.content = this.provider.getContent(this.request, this.response);
                        MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().measure(activityTime, name);
                        if (this.provider.getRefreshTime() > 0L) {
                            this.providerContext.putCachedContent(name, this.content);
                        }
                        if (this.content == null) {
                            throw new ContextError("couldn't fetch content");
                        }
                        this.monitor.put(name, this.content);
                    }
                    catch (Throwable e) {
                        if (debugLogger.isLoggable(Level.INFO)) {
                            LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0025");
                            logRecord.setLoggerName(debugLogger.getName());
                            logRecord.setParameters(new String[]{name});
                            logRecord.setThrown(e);
                            debugLogger.log(logRecord);
                        }
                        this.monitor.put(name, this.content);
                    }
                    this.end.signal();
                    this.pool.releaseCaller(this);
                }
                catch (Throwable t1) {
                    throw new ContextError("ProviderCaller.run()", t1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DesktopThreadLocalManager.release();
                    CommunityUserMembershipThreadLocalizer.reset();
                }
            }
        }
        catch (Throwable t2) {
            throw new ContextError("ProviderCaller.run()", t2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

