/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.ServiceAppContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesServiceAppContext
implements ServiceAppContext {
    protected Properties properties = new Properties();
    protected String filename = null;
    protected static final String NOSESSIONURL_KEY = "noSessionURL";
    protected static final String SESSIONRETURNURLPARAMNAME_KEY = "sessionReturnURLParamName";
    protected static final String DEBUGCONTEXTCLASSNAME_KEY = "debugContextClassName";
    protected static final String SESSIONAPPCONTEXTCLASSNAME_KEY = "sessionAppContextClassName";
    protected static final String AUTHLESSSESSIONAPPCONTEXTCLASSNAME_KEY = "sessionAppContextClassName";
    protected static final String DESKTOPCONTEXTCLASSNAME_KEY = "desktopContextClassName";
    protected static final String SERVICECONTEXTCLASSNAME_KEY = "serviceContextClassName";
    protected static final String SESSIONCONTEXTCLASSNAME_KEY = "sessionContextClassName";
    protected static final String CLIENTCONTEXTCLASSNAME_KEY = "clientContextClassName";
    protected static final String TEMPLATECONTEXTCLASSNAME_KEY = "templateContextClassName";
    protected static final String INACTIVE_MAX_KEY = "inactiveMax";
    protected static final String REAP_INTERVAL_KEY = "reapInterval";
    protected static final String CLIENT_SESSION_INACTIVE_MAX_KEY = "clientSessionInactiveMax";
    protected static final String CLIENT_SESSION_REAP_INTERVAL_KEY = "clientSessionReapInterval";
    protected static final String CLIENT_SESSIONS_MAX_KEY = "clientSessionsMax";
    protected static final String ENABLE_AUTHLESS_DESKTOP_KEY = "enableAuthlessDesktop";
    protected static final String ENABLE_FEDERATION_KEY = "enableFederation";
    protected static final String PRELOGIN_URL_KEY = "preLoginURL";
    protected static final String ACCESS_URL_KEY = "accessURL";
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWportal/service-context.properties";

    public PropertiesServiceAppContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesServiceAppContext(String filename) {
        this.filename = filename;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesServiceAppContext.PropertiesServiceAppContext(): ", ioe);
        }
    }

    public void init(String portalId) {
    }

    public String getDebugContextClassName() {
        return this.properties.getProperty(DEBUGCONTEXTCLASSNAME_KEY);
    }

    public String getSessionAppContextClassName() {
        return this.properties.getProperty("sessionAppContextClassName");
    }

    public String getAuthlessSessionAppContextClassName() {
        return this.properties.getProperty("sessionAppContextClassName");
    }

    public String getWSRPSessionAppContextClassName() {
        return this.properties.getProperty("sessionAppContextClassName");
    }

    public String getDesktopContextClassName() {
        return this.properties.getProperty(DESKTOPCONTEXTCLASSNAME_KEY);
    }

    public String getSessionContextClassName() {
        return this.properties.getProperty(SESSIONCONTEXTCLASSNAME_KEY);
    }

    public String getServiceContextClassName() {
        return this.properties.getProperty(SERVICECONTEXTCLASSNAME_KEY);
    }

    public String getClientContextClassName() {
        return this.properties.getProperty(CLIENTCONTEXTCLASSNAME_KEY);
    }

    public String getTemplateContextClassName() {
        return this.properties.getProperty(TEMPLATECONTEXTCLASSNAME_KEY);
    }

    public String getNoSessionURL() {
        return this.properties.getProperty(NOSESSIONURL_KEY);
    }

    public String getAccessURL() {
        return this.properties.getProperty(ACCESS_URL_KEY);
    }

    public String getSessionReturnURLParamName() {
        return this.properties.getProperty(SESSIONRETURNURLPARAMNAME_KEY);
    }

    public Map getAuthorizedAuthlessUIDs() {
        HashMap somemap = new HashMap();
        return somemap;
    }

    public String getDefaultAuthlessUID() {
        return "userid";
    }

    public long getReapInterval() {
        long interval = Long.parseLong(this.properties.getProperty(REAP_INTERVAL_KEY));
        return interval;
    }

    public long getInactiveMax() {
        long maxInactive = Long.parseLong(this.properties.getProperty(INACTIVE_MAX_KEY));
        return maxInactive;
    }

    public long getClientSessionReapInterval() {
        long interval = Long.parseLong(this.properties.getProperty(CLIENT_SESSION_REAP_INTERVAL_KEY));
        return interval;
    }

    public long getClientSessionInactiveMax() {
        long maxInactive = Long.parseLong(this.properties.getProperty(CLIENT_SESSION_INACTIVE_MAX_KEY));
        return maxInactive;
    }

    public long getClientSessionsMax() {
        long maxSessions = Long.parseLong(this.properties.getProperty(CLIENT_SESSIONS_MAX_KEY));
        return maxSessions;
    }

    public boolean isAuthlessEnabled() {
        Boolean authlessEnabled = Boolean.valueOf(this.properties.getProperty(ENABLE_AUTHLESS_DESKTOP_KEY));
        return authlessEnabled;
    }

    public boolean isFederationEnabled() {
        Boolean federationEnabled = Boolean.valueOf(this.properties.getProperty(ENABLE_FEDERATION_KEY));
        return federationEnabled;
    }

    public String getPreLoginURL(String returnURL, String libertySSOFailedParamName) {
        return this.properties.getProperty(PRELOGIN_URL_KEY);
    }

    public String getStringAttribute(String name) {
        return this.properties.getProperty(name);
    }

    public void setStringAttribute(String name, String val) {
        this.properties.setProperty(name, val);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.filename));
            this.properties.store(fos, "Last updated at: ");
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesContext.storeAttribute()", ioe);
        }
    }
}

