/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PropertiesDPContext
implements DPContext {
    protected static final String ISVALIDATING_KEY = "isValidating";
    protected static final String NAMESPACEURI_KEY = "nameSpaceURI";
    protected static final String DOCUMENTPATH_KEY = "documentPath";
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWportal/dp-context.properties";
    protected static final String DEFAULT_DOCUMENT_FILENAME = "/etc/opt/SUNWportal/sampleportal/dp.xml";
    protected DesktopContext desktopContext = null;
    protected Properties properties = new Properties();
    protected static FilenameFilter dpFilenameFilter = new DPDocumentFilenameFilter();
    protected static DPFileComparator dpFileComparator = new DPFileComparator();

    public PropertiesDPContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesDPContext(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.PropertiesDPContext()", ioe);
        }
    }

    public void init(HttpServletRequest req) {
        this.desktopContext = DesktopContextThreadLocalizer.get();
        if (this.desktopContext == null) {
            throw new ContextError("PropertiesDPContext.init(): desktop context was null");
        }
    }

    protected DesktopContext getDesktopContext() {
        return this.desktopContext;
    }

    public boolean isValidating() {
        return new Boolean(this.properties.getProperty(ISVALIDATING_KEY));
    }

    public String getNameSpaceURI() {
        return this.properties.getProperty(NAMESPACEURI_KEY);
    }

    protected String getDPDocumentPath() {
        String filename = this.properties.getProperty(DOCUMENTPATH_KEY);
        return filename;
    }

    public synchronized Locale getLocale() {
        return this.getDesktopContext().getLocale();
    }

    public Set getDPDocumentNames(String name) {
        return this.getDPDocumentNames();
    }

    public Set getDPDocumentNames() {
        File docPath = new File(this.getDPDocumentPath());
        File[] dpDocuments = docPath.listFiles(dpFilenameFilter);
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < dpDocuments.length; ++i) {
            File f = dpDocuments[i];
            names.add(f.toString());
        }
        return names;
    }

    public String getDPDocument(String name) {
        File f = new File(name);
        return this.readFile(f).toString();
    }

    public StringBuffer getDPUserDocument() {
        String path = this.getDPDocumentPath();
        if (path == null) {
            throw new ContextError("DPContext.getDPUserDocument(): path was null");
        }
        File f = new File(path, "dp-user.xml");
        if (!f.exists()) {
            return null;
        }
        if (!f.canRead()) {
            return null;
        }
        StringBuffer buf = this.readFile(f);
        return buf;
    }

    public void storeDPUserDocument(String dp) {
        String path = this.getDPDocumentPath();
        if (path == null) {
            throw new ContextError("DPContext.getDPUserDocument(): path was null");
        }
        File f = new File(path, "dp-user.xml");
        this.writeFile(f, dp);
    }

    protected StringBuffer readFile(File f) {
        if (!f.canRead()) {
            throw new ContextError("PropertiesDPContext.readFile(): cannot read file: " + f);
        }
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                buf.append(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.readFile(): ", ioe);
        }
        return buf;
    }

    protected void writeFile(File f, String s) {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ioe) {
                throw new ContextError("PropertiesDPContext.writeFile(): failed to create file: " + f, ioe);
            }
        }
        if (!f.canWrite()) {
            throw new ContextError("PropertiesDPContext.writeFile(): cannot write to file: " + f);
        }
        try {
            BufferedReader br = new BufferedReader(new StringReader(s));
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            bw.close();
            br.close();
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.writeFile(): ", ioe);
        }
    }

    public long getDPUserDocumentLastModified() {
        return -1L;
    }

    public long getDPDocumentLastModified(String name) {
        return -1L;
    }

    public long getDPUserDocumentLastRead() {
        return -1L;
    }

    public long getDPDocumentLastRead(String name) {
        return -1L;
    }

    private static class DPDocumentFilenameFilter
    implements FilenameFilter {
        private DPDocumentFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.equals("dp-user.xml")) {
                return false;
            }
            if (!name.startsWith("dp-")) {
                return false;
            }
            return name.endsWith(".xml");
        }
    }

    private static class DPFileComparator
    implements Comparator {
        private DPFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            return f1.toString().compareTo(f2.toString());
        }
    }
}

