/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.util.ResourceLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

public class PropertiesConfigContext
implements ConfigContext {
    public static final String PROPERTIESFILE = "desktop.propertiesFile";
    public static final String DESKTOP_CONFIG_FILE = "desktopconfig.properties";
    public static final String SERVICEAPPCONTEXTCLASSNAME_KEY = "serviceAppContextClassName";
    public static final String TEMPLATEBASEDIR_KEY = "templateBaseDir";
    public static final String PROVIDERCLASSBASEDIR_KEY = "providerClassBaseDir";
    public static final String JSPCOMPILERWARCLASSPATH_KEY = "jspCompilerWARClassPath";
    public static final String DEFAULT_DESKTOPTYPE_KEY = "defaultDesktopType";
    public static final String TEMPLATE_SCAN_INTERVAL = "templateScanInterval";
    public static final String DP_SCAN_INTERVAL = "dpScanInterval";
    public static final String CLASSLOADER_REVALIDATE_INTERVAL = "classLoaderRevalidateInterval";
    public static final String BROWSER_CACHE_INTERVAL = "browserCacheInterval";
    public static final String GETTER_POOL_MIN_SIZE_KEY = "getterPoolMinSize";
    public static final String GETTER_POOL_MAX_SIZE_KEY = "getterPoolMaxSize";
    public static final String GETTER_POOL_PARTITION_SIZE_KEY = "getterPoolPartitionSize";
    public static final String CALLER_POOL_MIN_SIZE_KEY = "callerPoolMinSize";
    public static final String CALLER_POOL_MAX_SIZE_KEY = "callerPoolMaxSize";
    public static final String CALLER_POOL_PARTITION_SIZE_KEY = "callerPoolPartitionSize";
    public static final String COOKIEPREFIX_KEY = "cookiePrefix";
    public static final String LB_COOKIE_NAME = "lb.cookie.name";
    public static final String JSPSCRATCHDIR_KEY = "jspScratchDir";
    public static final String MAX_EVENT_GENERATIONS = "maxEventGenerations";
    public static final String PORTLET_RENDER_MODE_PARALLEL = "portletRenderModeParallel";
    public static final String CURRENT_COMMUNITY_CONTRIBUTOR_TYPES = "current.community.contributor.types";
    protected static final String CURRENT_COMMUNITY_CONTRIBUTOR_TYPES_DELIMITERS = " ,|";
    protected static final String CURRENT_COMMUNITY_CONTRIBUTOR_TYPES_DEFAULT = "jdo";
    protected static List currentCommunityContributorTypes = null;
    protected static Properties properties = null;

    public void init(ServletContext sc) {
        ResourceLoader resourceLoader = ResourceLoader.getInstance((Properties)System.getProperties());
        try {
            properties = resourceLoader.getProperties(DESKTOP_CONFIG_FILE);
        }
        catch (FileNotFoundException fnfe) {
            throw new ContextError("PropertiesConfigContext.init(): ", fnfe);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesConfigContext.init(): ", ioe);
        }
    }

    public void init(String filename) {
        properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            throw new ContextError("PropertiesConfigContext.init(): ", fnfe);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesConfigContext.init(): ", ioe);
        }
    }

    public String getServiceAppContextClassName() {
        return properties.getProperty(SERVICEAPPCONTEXTCLASSNAME_KEY);
    }

    public String getConfigProperty(String key) {
        return properties.getProperty(key);
    }

    public String getTemplateBaseDir() {
        return properties.getProperty(TEMPLATEBASEDIR_KEY);
    }

    public String getCookiePrefix() {
        return properties.getProperty(COOKIEPREFIX_KEY);
    }

    public String getLBCookieName() {
        return properties.getProperty(LB_COOKIE_NAME);
    }

    public String getProviderClassBaseDir() {
        return properties.getProperty(PROVIDERCLASSBASEDIR_KEY);
    }

    public String getJSPCompilerWARClassPath() {
        return properties.getProperty(JSPCOMPILERWARCLASSPATH_KEY);
    }

    public String getJSPScratchDir() {
        return properties.getProperty(JSPSCRATCHDIR_KEY);
    }

    public String getDefaultDesktopType() {
        return properties.getProperty(DEFAULT_DESKTOPTYPE_KEY);
    }

    public String getPortalId() {
        return ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
    }

    public String getInstanceId() {
        return ResourceLoader.getInstance((Properties)System.getProperties()).getInstanceId();
    }

    public String getPortletRenderModeParallel() {
        String portletRenderModeParallel = properties.getProperty(PORTLET_RENDER_MODE_PARALLEL);
        if (portletRenderModeParallel == null) {
            portletRenderModeParallel = new String("true");
        }
        return portletRenderModeParallel;
    }

    public int getGetterPoolMinSize() {
        return this.getIntegerProperty(GETTER_POOL_MIN_SIZE_KEY);
    }

    public int getGetterPoolMaxSize() {
        return this.getIntegerProperty(GETTER_POOL_MAX_SIZE_KEY);
    }

    public int getGetterPoolPartitionSize() {
        return this.getIntegerProperty(GETTER_POOL_PARTITION_SIZE_KEY);
    }

    public int getCallerPoolMinSize() {
        return this.getIntegerProperty(CALLER_POOL_MIN_SIZE_KEY);
    }

    public int getCallerPoolMaxSize() {
        return this.getIntegerProperty(CALLER_POOL_MAX_SIZE_KEY);
    }

    public int getCallerPoolPartitionSize() {
        return this.getIntegerProperty(CALLER_POOL_PARTITION_SIZE_KEY);
    }

    public int getTemplateScanInterval() {
        return this.getIntegerProperty(TEMPLATE_SCAN_INTERVAL);
    }

    public int getDPScanInterval() {
        return this.getIntegerProperty(DP_SCAN_INTERVAL);
    }

    public int getClassLoaderRevalidateInterval() {
        return this.getIntegerProperty(CLASSLOADER_REVALIDATE_INTERVAL);
    }

    public int getBrowserCacheInterval() {
        return this.getIntegerProperty(BROWSER_CACHE_INTERVAL);
    }

    public int getMaxEventGenerations() {
        return this.getIntegerProperty(MAX_EVENT_GENERATIONS);
    }

    public List getCurrentCommunityContributorTypes() {
        if (currentCommunityContributorTypes == null) {
            currentCommunityContributorTypes = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(properties.getProperty(CURRENT_COMMUNITY_CONTRIBUTOR_TYPES, CURRENT_COMMUNITY_CONTRIBUTOR_TYPES_DEFAULT), CURRENT_COMMUNITY_CONTRIBUTOR_TYPES_DELIMITERS);
            while (tokenizer.hasMoreTokens()) {
                currentCommunityContributorTypes.add(tokenizer.nextToken());
            }
        }
        return currentCommunityContributorTypes;
    }

    private int getIntegerProperty(String key) {
        String strInt = properties.getProperty(key);
        int result = 0;
        if (strInt != null && strInt.length() > 0) {
            try {
                result = Integer.parseInt(strInt);
            }
            catch (NumberFormatException e) {
                throw new ContextError("PropertiesConfigContext.getIntegerProperty(): invalid number format for key " + key, e);
            }
        }
        return result;
    }
}

