/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.sso.SSOToken;
import com.sun.portal.community.mc.CMCException;
import com.sun.portal.community.mc.CMCFactory;
import com.sun.portal.community.mc.CMCUser;
import com.sun.portal.community.mc.ConfigTable;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.CommunityUserMembershipThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPCacheManager;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.desktop.context.ProviderClassLoaderListener;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.context.ServiceContext;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserEvent;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.LDAPDN;

public class PSDesktopContext
implements DesktopContext,
UserListener,
ProviderClassLoaderListener {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$PSDesktopContext == null ? (class$com$sun$portal$desktop$context$PSDesktopContext = PSDesktopContext.class$("com.sun.portal.desktop.context.PSDesktopContext")) : class$com$sun$portal$desktop$context$PSDesktopContext));
    protected static DesktopAppContext desktopAppContext = null;
    protected SessionContext session = null;
    protected ServiceContext service = null;
    protected static DPContext dpContext = null;
    protected DPUserContext dpUserContext = null;
    protected ContainerProviderContext containerProviderContext = null;
    protected Locale locale = null;
    protected String charset = null;
    private long lastAccess = 0L;
    private boolean isStale = false;
    protected Map clientProperties = Collections.synchronizedMap(new HashMap());
    private String clientType = null;
    private DPRoot dpRoot = null;
    private long lastUserDPScanTime;
    private static ThreadLocal tlCMCUser = new ThreadLocal();
    private static final String WSRP_REMOTE_TOKEN = "desktop.wsrp.ssotoken";
    static /* synthetic */ Class class$com$sun$portal$desktop$context$PSDesktopContext;

    public void init(HttpServletRequest req) {
        DesktopContextThreadLocalizer.set(this);
        if (desktopAppContext == null) {
            desktopAppContext = DesktopAppContextThreadLocalizer.get();
        }
        if (desktopAppContext == null) {
            throw new ContextError("PSDesktopContext.init(): could not get desktop app context");
        }
        this.initServiceContext(req);
        this.initSessionContext(req, desktopAppContext.getPortalId());
        this.addUserListener(this);
        this.initDPContext();
        this.initDPUserContext(req);
        this.initLocale();
        if (this.isAuthless(req)) {
            ProviderClassLoader pcl = ProviderClassLoader.getInstance(this.getProviderClassBaseDir());
            pcl.addListener(this);
        }
    }

    protected SessionContext getSessionContext() {
        if (this.session == null) {
            throw new ContextError("PSDesktopContext.getSessionContext(): not initialized");
        }
        return this.session;
    }

    private SessionContext initSessionContext(HttpServletRequest req, String portalId) {
        if (this.session == null) {
            String sessionContextClassName = this.isWSRP(req) ? this.getWSRPSessionContextClassName() : (this.isAuthless(req) ? this.getAuthlessSessionContextClassName() : this.getSessionContextClassName());
            try {
                this.session = (SessionContext)Class.forName(sessionContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getSessionContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getSessionContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getSessionContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getSessionContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getSessionContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getSessionContext()", se);
            }
            this.session.init(req, portalId);
        }
        return this.session;
    }

    private DPContext getDPContext() {
        if (dpContext == null) {
            throw new ContextError("PSDesktopContext.getDPContext(): not initialized");
        }
        return dpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DPContext initDPContext() {
        Class clazz = class$com$sun$portal$desktop$context$PSDesktopContext == null ? (class$com$sun$portal$desktop$context$PSDesktopContext = PSDesktopContext.class$("com.sun.portal.desktop.context.PSDesktopContext")) : class$com$sun$portal$desktop$context$PSDesktopContext;
        synchronized (clazz) {
            if (dpContext == null) {
                String dpContextClassName = this.getDPContextClassName();
                if (dpContextClassName == null) {
                    throw new ContextError("DesktopContext.getDPContext(): class name was null");
                }
                try {
                    dpContext = (DPContext)Class.forName(dpContextClassName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ContextError("DesktopContext.getDPContext()", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ContextError("DesktopContext.getDPContext()", ncdfe);
                }
                catch (IllegalAccessException iae) {
                    throw new ContextError("DesktopContext.getDPContext()", iae);
                }
                catch (ClassCastException cce) {
                    throw new ContextError("DesktopContext.getDPContext()", cce);
                }
                catch (InstantiationException ie) {
                    throw new ContextError("DesktopContext.getDPContext()", ie);
                }
                catch (SecurityException se) {
                    throw new ContextError("DesktopContext.getDPContext()", se);
                }
                dpContext.init(RequestThreadLocalizer.getRequest());
            }
        }
        return dpContext;
    }

    protected DPUserContext getDPUserContext() {
        if (this.dpUserContext == null) {
            throw new ContextError("PSDesktopContext.getDPUserContext(): not initialized");
        }
        return this.dpUserContext;
    }

    protected DPUserContext initDPUserContext(HttpServletRequest req) {
        if (this.dpUserContext == null) {
            String dpUserContextClassName = this.getDPUserContextClassName();
            if (dpUserContextClassName == null) {
                throw new ContextError("DesktopContext.getDPUserContext(): class name was null");
            }
            try {
                this.dpUserContext = (DPUserContext)Class.forName(dpUserContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getDPUserContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getDPUserContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getDPUserContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getDPUserContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getDPUserContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getDPUserContext()", se);
            }
            if (this.isWSRP(req)) {
                SSOToken ssoToken = this.getRemoteSSOToken(req);
                if (ssoToken != null) {
                    this.dpUserContext.init(ssoToken);
                } else {
                    String uid = desktopAppContext.getSessionID(req);
                    this.dpUserContext.init(req, uid, uid);
                }
            } else if (this.isAuthless(req)) {
                String uid = desktopAppContext.getSessionID(req);
                Map authorized = desktopAppContext.getAuthorizedAuthlessUIDs();
                if (!authorized.containsKey(uid = uid.toLowerCase())) {
                    throw new ContextError("DesktopContext.initDPUserContext(): no password for authless uid=" + uid);
                }
                String pw = (String)authorized.get(uid);
                this.dpUserContext.init(req, uid, pw);
            } else {
                this.dpUserContext.init(req);
            }
        }
        return this.dpUserContext;
    }

    protected ServiceContext getServiceContext() {
        if (this.service == null) {
            throw new ContextError("PSDesktopContext.getServiceContext(): not initialized");
        }
        return this.service;
    }

    private ServiceContext initServiceContext(HttpServletRequest req) {
        if (this.service == null) {
            String serviceContextClassName = this.getServiceContextClassName();
            if (serviceContextClassName == null) {
                throw new ContextError("DesktopContext.getServiceContext(): class name was null");
            }
            try {
                this.service = (ServiceContext)Class.forName(serviceContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getServiceContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getServiceContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getServiceContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getServiceContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getServiceContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getServiceContext()", se);
            }
            if (this.isWSRP(req)) {
                SSOToken ssoToken = this.getRemoteSSOToken(req);
                if (ssoToken != null) {
                    this.service.init(ssoToken);
                } else {
                    String uid = desktopAppContext.getSessionID(req);
                    this.service.init(req, uid, uid);
                }
            } else if (this.isAuthless(req)) {
                String uid = desktopAppContext.getSessionID(req);
                Map authorized = desktopAppContext.getAuthorizedAuthlessUIDs();
                if (!authorized.containsKey(uid = uid.toLowerCase())) {
                    throw new ContextError("DesktopContext.initServiceContext(): no password for authless uid=" + uid);
                }
                String pw = (String)authorized.get(uid);
                this.service.init(req, uid, pw);
            } else {
                this.service.init(req);
            }
        }
        return this.service;
    }

    public ContainerProviderContext getContainerProviderContext() {
        if (this.containerProviderContext == null) {
            throw new ContextError("PSDesktopContext.getContainerProviderContext(): not initialized");
        }
        return this.containerProviderContext;
    }

    public synchronized ContainerProviderContext initContainerProviderContext() {
        if (this.containerProviderContext == null) {
            String providerContextClassName = this.getContainerProviderContextClassName();
            if (providerContextClassName == null) {
                throw new ContextError("DesktopContext.getContainerProviderContext(): provider context class name was null");
            }
            try {
                this.containerProviderContext = (ContainerProviderContext)Class.forName(providerContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getProviderContext(): ", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getProviderContext(): ", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getProviderContext(): ", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getProviderContext(): ", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getProviderContext(): ", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getProviderContext(): ", se);
            }
            this.containerProviderContext.init(RequestThreadLocalizer.getRequest());
        }
        return this.containerProviderContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        DPRoot dpr = this.getDPRoot();
        if (dpr.isDirty()) {
            DPRoot dPRoot = dpr;
            synchronized (dPRoot) {
                if (dpr.isDirty()) {
                    if (!this.isDPRootCustomized()) {
                        throw new ContextError("PSDesktopContext.store(): attempt to store non-customized dpRoot=" + dpr.toString());
                    }
                    dpr.setDirty(false);
                    DPUserContext dpuc = this.getDPUserContext();
                    StringBuffer sb = new StringBuffer(256);
                    dpr.toXML(sb, 0);
                    dpuc.storeDPUserDocument(sb.toString());
                    DPCacheManager.setUserDocumentLastRead(this.getUserID());
                }
            }
        }
    }

    protected boolean isDPUserRootModified() {
        boolean modified = false;
        long userLastModified = this.getDPUserContext().getDPUserDocumentLastModified();
        long userLastRead = DPCacheManager.getUserDocumentLastRead(this.getUserID());
        if (userLastRead == -1L && this.isDPRootSet() || userLastModified > userLastRead) {
            modified = true;
        }
        return modified;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long ms) {
        this.lastAccess = ms;
    }

    public boolean getIsStale() {
        return this.isStale;
    }

    public void setIsStale(boolean stale) {
        this.isStale = stale;
    }

    public void providerClassLoaderOutdated() {
        this.setIsStale(true);
    }

    private void updateLastUserDPScanTime() {
        if (desktopAppContext.getDPScanInterval() == -1 || desktopAppContext.getDPScanInterval() == 0) {
            return;
        }
        this.lastUserDPScanTime = System.currentTimeMillis();
    }

    private boolean doScanUserDP() {
        if (desktopAppContext.getDPScanInterval() == -1) {
            return false;
        }
        if (desktopAppContext.getDPScanInterval() == 0) {
            return true;
        }
        return System.currentTimeMillis() - this.lastUserDPScanTime > (long)(desktopAppContext.getDPScanInterval() * 1000);
    }

    public void refresh() {
        boolean membershipChanged = this.updateMembership();
        boolean modified = false;
        boolean doScanUserDP = this.doScanUserDP();
        if (doScanUserDP && this.personalize()) {
            modified = this.isDPUserRootModified();
            this.updateLastUserDPScanTime();
        }
        if ((modified |= DPCacheManager.sharedDPRootsModified(PSDesktopContext.getCMCUser(), PSDesktopContext.getEffectiveMembership(this.getSessionContext()), this.getDPContext(), desktopAppContext.getDPScanInterval())) || membershipChanged) {
            this.dpRoot = null;
            DPCacheManager.removeUserDPRoot(this.getUserID());
        }
        this.gearUpDPRoot();
        this.initContainerProviderContext();
        if (modified || membershipChanged) {
            this.getContainerProviderContext().refresh();
        }
        ProviderContextThreadLocalizer.set(this.getContainerProviderContext());
    }

    public void setDPRootCustomized(boolean state) {
        DPCacheManager.setCustomized(this.getUserID(), state);
    }

    public boolean isDPRootCustomized() {
        return DPCacheManager.hasCustomized(this.getUserID());
    }

    protected boolean isDPRootSet() {
        DPUserContext dpuc = this.getDPUserContext();
        byte[] doc = dpuc.getDPUserDocument();
        return doc != null && doc.length > 0;
    }

    private static CMCUser getCMCUser() {
        return (CMCUser)tlCMCUser.get();
    }

    private static void setCMCUser(CMCUser cu) {
        tlCMCUser.set(cu);
    }

    private void gearUpCMCUser() {
        if (PSDesktopContext.getCMCUser() == null) {
            try {
                CMCFactory cf = CMCFactory.getInstance();
                PSDesktopContext.setCMCUser(cf.getCMCUser(LDAPDN.normalize((String)this.getUserID().toLowerCase())));
            }
            catch (CMCException e) {
                throw new ContextError("PSDesktopContext.gearUpCMCUser()", e);
            }
        }
    }

    private static void setMembership(String userId, Set membership) {
        CommunityUserMembershipThreadLocalizer.set(userId, membership);
    }

    private static Set getTemporaryMembership(SessionContext sessionContext) {
        TreeSet result = new TreeSet();
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        String temporaryMembership = null;
        if (req != null) {
            temporaryMembership = req.getParameter("com.sun.portal.desktop.temporary.membership");
        }
        if (temporaryMembership != null) {
            sessionContext.setStringProperty("com.sun.portal.desktop.temporary.membership", temporaryMembership);
        }
        if ((temporaryMembership = sessionContext.getStringProperty("com.sun.portal.desktop.temporary.membership")) != null && !temporaryMembership.equals("NONE")) {
            result.addAll(ConfigTable.ConfigKey.asCollection((String)temporaryMembership));
        }
        return result.size() == 0 ? null : result;
    }

    private static Set getCurrentMembership(SessionContext sessionContext) {
        TreeSet result = new TreeSet();
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        String currentMembership = null;
        if (req != null) {
            currentMembership = req.getParameter("com.sun.portal.desktop.current.membership");
        }
        if (currentMembership != null) {
            sessionContext.setStringProperty("com.sun.portal.desktop.current.membership", currentMembership);
        }
        if ((currentMembership = sessionContext.getStringProperty("com.sun.portal.desktop.current.membership")) != null && !currentMembership.equals("NONE")) {
            result.addAll(ConfigTable.ConfigKey.asCollection((String)currentMembership));
        }
        return result.size() == 0 ? null : result;
    }

    private static Set filterMembership(Set realMembership, Set currentMembership, Set temporaryMembership) {
        ConfigTable.ConfigKey configKey;
        TreeSet<ConfigTable.ConfigKey> result = new TreeSet<ConfigTable.ConfigKey>(realMembership);
        List currentCommunityContributorTypes = desktopAppContext.getCurrentCommunityContributorTypes();
        Iterator iterator = realMembership.iterator();
        while (iterator.hasNext()) {
            configKey = (ConfigTable.ConfigKey)iterator.next();
            if (!currentCommunityContributorTypes.contains(configKey.getCommunityPrincipal().getType())) continue;
            result.remove(configKey);
        }
        if (currentMembership != null) {
            iterator = currentMembership.iterator();
            while (iterator.hasNext()) {
                configKey = (ConfigTable.ConfigKey)iterator.next();
                if (!realMembership.contains(configKey)) {
                    throw new ContextError("Current membership <" + currentMembership + "> should be subset of real membership <" + realMembership + ">");
                }
                if (!currentCommunityContributorTypes.contains(configKey.getCommunityPrincipal().getType())) {
                    throw new ContextError("Current membership contributor type <" + configKey.getCommunityPrincipal().getType() + "> should be mentioned in Desktop configuration." + " Desktop configuration allows following current membership contributor types <" + currentCommunityContributorTypes.toString() + ">");
                }
                result.add(configKey);
            }
        }
        if (temporaryMembership != null) {
            result.addAll(temporaryMembership);
        }
        return result.size() == 0 ? null : result;
    }

    private static Set getEffectiveMembership(SessionContext sessionContext) {
        String effectiveMembership = sessionContext.getStringProperty("com.sun.portal.desktop.effective.membership");
        if (effectiveMembership == null) {
            return null;
        }
        return new TreeSet(ConfigTable.ConfigKey.asCollection((String)effectiveMembership));
    }

    private static void setEffectiveMembership(SessionContext sessionContext, Set effectiveMembership) {
        if (effectiveMembership != null) {
            sessionContext.setStringProperty("com.sun.portal.desktop.effective.membership", ConfigTable.ConfigKey.asString((Collection)effectiveMembership));
        }
    }

    private static boolean gearUpMembership(String userId, SessionContext sessionContext) {
        boolean membershipChanged = false;
        Set oldEffectiveMembership = PSDesktopContext.getEffectiveMembership(sessionContext);
        try {
            TreeSet realMembership = new TreeSet(PSDesktopContext.getCMCUser().getMembership());
            Set currentMembership = PSDesktopContext.getCurrentMembership(sessionContext);
            Set temporaryMembership = PSDesktopContext.getTemporaryMembership(sessionContext);
            Set newEffectiveMembership = PSDesktopContext.filterMembership(realMembership, currentMembership, temporaryMembership);
            PSDesktopContext.setEffectiveMembership(sessionContext, newEffectiveMembership);
            if (oldEffectiveMembership == null) {
                membershipChanged = true;
            } else if (!((Object)oldEffectiveMembership).equals(newEffectiveMembership)) {
                membershipChanged = true;
            }
            PSDesktopContext.setMembership(userId, realMembership);
        }
        catch (CMCException e) {
            throw new ContextError("PSDesktopContext.gearUpMembership()", e);
        }
        return membershipChanged;
    }

    private boolean updateMembership() {
        PSDesktopContext.setCMCUser(null);
        this.gearUpCMCUser();
        return PSDesktopContext.gearUpMembership(this.getUserID(), this.getSessionContext());
    }

    private boolean personalize() {
        return this.isDPRootCustomized() || this.isDPRootSet();
    }

    private void gearUpDPRoot() {
        if (this.dpRoot == null) {
            if (this.personalize()) {
                this.dpRoot = DPCacheManager.getUserDPRoot(this.getUserID());
                if (this.dpRoot == null) {
                    this.dpRoot = DPCacheManager.getDPRoot(PSDesktopContext.getEffectiveMembership(this.getSessionContext()), this.getDPContext(), this.getDPUserContext(), true);
                    DPCacheManager.putUserDPRoot(this.getUserID(), this.dpRoot);
                    this.setDPRootCustomized(true);
                }
            } else {
                this.dpRoot = DPCacheManager.getDPRoot(PSDesktopContext.getEffectiveMembership(this.getSessionContext()), this.getDPContext(), this.getDPUserContext(), false);
                this.setDPRootCustomized(false);
            }
        }
    }

    public DPRoot getDPRoot() {
        if (this.isDPRootCustomized() && !this.isDPRootSet()) {
            this.dpRoot = null;
            this.gearUpDPRoot();
        }
        return this.dpRoot;
    }

    public Set getAncestors(HttpServletRequest req, String name) {
        String topName = this.getDefaultChannelName();
        return this.getAncestors(req, name, topName);
    }

    private Set getAncestors(HttpServletRequest req, String child, String current) {
        if (child.equals(current)) {
            return new LinkedHashSet();
        }
        try {
            Provider currentProvider = this.getProvider(req, current);
            if (currentProvider == null) {
                throw new ProviderException("error getting anccestors for child: " + child + ", could not get provider object for ancestor: " + current);
            }
            if (!(currentProvider instanceof ContainerProvider)) {
                return null;
            }
            ContainerProvider currentContainerProvider = (ContainerProvider)((Object)currentProvider);
            List selected = currentContainerProvider.getSelectedChannels();
            Set children = null;
            Iterator i = selected.iterator();
            while (i.hasNext()) {
                String selectedName = (String)i.next();
                Set selectedChildren = this.getAncestors(req, child, selectedName);
                if (selectedChildren == null) continue;
                if (children == null) {
                    children = selectedChildren;
                    continue;
                }
                children.addAll(selectedChildren);
            }
            if (children != null) {
                children.add(current);
            }
            return children;
        }
        catch (ProviderException pe) {
            if (logger.isLoggable(Level.WARNING)) {
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPDC0035");
                rec.setLoggerName(logger.getName());
                rec.setParameters(new String[]{child, current});
                rec.setThrown(pe);
                logger.log(rec);
            }
            return null;
        }
    }

    public String getPropertiesContextClassName() {
        return this.getServiceContext().getPropertiesContextClassName();
    }

    public String getContainerProviderContextClassName() {
        return this.getServiceContext().getContainerProviderContextClassName();
    }

    protected String getSessionContextClassName() {
        return this.getServiceContext().getSessionContextClassName();
    }

    protected String getAuthlessSessionContextClassName() {
        return this.getServiceContext().getAuthlessSessionContextClassName();
    }

    protected String getWSRPSessionContextClassName() {
        return this.getServiceContext().getWSRPSessionContextClassName();
    }

    protected String getDPContextClassName() {
        return this.getServiceContext().getDPContextClassName();
    }

    protected String getDPUserContextClassName() {
        return this.getServiceContext().getDPUserContextClassName();
    }

    protected String getServiceContextClassName() {
        return desktopAppContext.getServiceContextClassName();
    }

    public Set getRoles() {
        return this.getServiceContext().getRoles();
    }

    public String getLocaleString() {
        return this.getServiceContext().getLocaleString();
    }

    private boolean isLocaleChanged() {
        String newLocale = this.getLocaleString();
        return newLocale != null && !newLocale.equals(this.locale.toString());
    }

    public Locale getLocale() {
        if (this.locale == null) {
            throw new ContextError("PSDesktopContext.getLocale(): not initialized");
        }
        if (this.isLocaleChanged()) {
            this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        }
        return this.locale;
    }

    protected Locale initLocale() {
        this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    protected static Locale initLocale(String stringformat) {
        if (stringformat == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tokenizer.hasMoreTokens()) {
            lang = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public String getDesktopType() {
        return this.getServiceContext().getDesktopType();
    }

    public String getDesktopURL(HttpServletRequest req) {
        return this.encodeURL(desktopAppContext.getDesktopURL(req));
    }

    public String getDesktopURL(HttpServletRequest req, Map query, Map pathInfo) {
        return this.encodeURL(desktopAppContext.getDesktopURL(req, query, pathInfo));
    }

    public String getDesktopURL(HttpServletRequest req, String query) {
        return this.encodeURL(desktopAppContext.getDesktopURL(req, query));
    }

    public String getLogoutURL() {
        return this.encodeURL(this.getServiceContext().getLogoutURL());
    }

    public String getLoginURL() {
        return this.getServiceContext().getLoginURL();
    }

    public String getDefaultChannelName() {
        String name = this.getClientProperty("lastChannelName");
        if (name == null || name.length() == 0 || this.getProvider(DesktopRequestThreadLocalizer.getRequest(), name) == null) {
            name = this.getServiceContext().getDefaultChannelName();
        }
        return name;
    }

    public void setDefaultChannelName(String channel) {
        this.setClientProperty("lastChannelName", channel);
    }

    public String getEditProviderContainerName() {
        return this.getServiceContext().getEditProviderContainerName();
    }

    public String getTemplateBaseDir() {
        return desktopAppContext.getTemplateBaseDir();
    }

    public String getStringAttribute(String name) {
        return this.getServiceContext().getStringAttribute(name);
    }

    public String getStringAttribute(String name, Locale locale) {
        return this.getServiceContext().getStringAttribute(name, locale);
    }

    public void setStringAttribute(String name, String val) {
        this.getServiceContext().setStringAttribute(name, val);
    }

    public String getTopChannelName(HttpServletRequest req) {
        String name = (String)req.getAttribute("topChannelName");
        if (name == null || name.length() == 0) {
            name = this.getDefaultChannelName();
        }
        return name;
    }

    public void setTopChannelName(HttpServletRequest req, String channel) {
        req.setAttribute("topChannelName", (Object)channel);
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        return desktopAppContext.getRequestServer(req);
    }

    public String getClientType() {
        String ct;
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        if (this.clientType != null) {
            ct = this.clientType;
        } else if (!desktopAppContext.isAuthless(req)) {
            this.clientType = ct = this.getClientProperty("clientType");
            if (ct == null) {
                this.clientType = ct = desktopAppContext.getClientType(req);
            }
        } else {
            ct = desktopAppContext.getClientType(req);
        }
        return ct;
    }

    public String getContentType() {
        return desktopAppContext.getContentType(this.getClientType());
    }

    public String getCharset() {
        if (this.isLocaleChanged()) {
            this.locale = PSDesktopContext.initLocale(this.getLocaleString());
        }
        return desktopAppContext.getCharset(this.getClientType(), this.locale);
    }

    public String getDefaultClientType() {
        return desktopAppContext.getDefaultClientType();
    }

    public String getClientPath() {
        return desktopAppContext.getClientPath(this.getClientType());
    }

    public String getClientTypeProperty(String key) {
        return this.getClientTypeProperty(this.getClientType(), key);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return desktopAppContext.getClientTypeProperty(clientType, key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        return desktopAppContext.getClientTypeProperties(clientType, key);
    }

    public String getEncoderClassName() {
        return desktopAppContext.getEncoderClassName(this.getClientType());
    }

    public Object getSessionProperty(String name) {
        return this.clientProperties.get(name);
    }

    public void setSessionProperty(String name, Object val) {
        this.clientProperties.put(name, val);
    }

    public String getSessionID() {
        String sid = this.getSessionContext().getSessionID();
        if (sid == null) {
            sid = desktopAppContext.getDefaultAuthlessUID();
        }
        return sid;
    }

    public boolean isAuthless(HttpServletRequest req) {
        return desktopAppContext.isAuthless(req);
    }

    public boolean isWSRP(HttpServletRequest req) {
        return desktopAppContext.isWSRP(req);
    }

    public void addSessionListener(SessionListener sl) {
        this.getSessionContext().addSessionListener(sl);
    }

    public String encodeURL(String url) {
        return this.getSessionContext().encodeURL(url);
    }

    public String getUserID() {
        String uid = this.getSessionContext().getUserID();
        if (uid == null) {
            uid = desktopAppContext.getDefaultAuthlessUID();
        }
        return uid;
    }

    public void addUserListener(UserListener ul) {
        this.getSessionContext().addUserListener(ul);
    }

    public String getAuthenticationType() {
        return this.getSessionContext().getAuthenticationType();
    }

    public String getClientProperty(String name) {
        return this.getSessionContext().getStringProperty(name);
    }

    public void setClientProperty(String name, String value) {
        this.getSessionContext().setStringProperty(name, value);
    }

    public Provider getProvider(HttpServletRequest req, String name) {
        return this.getContainerProviderContext().getProvider(req, null, name);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res, String name) throws ProviderException {
        return this.getContainerProviderContext().getContent(req, res, null, name);
    }

    public Map getContent(HttpServletRequest req, HttpServletResponse res, List providers, int timeout) throws ProviderException {
        return this.getContainerProviderContext().getContent(req, res, null, providers, timeout);
    }

    public ParsedTagArray getTemplate(String app, String provider, String file) {
        return desktopAppContext.getTemplate(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file, this.getTemplateBaseDir());
    }

    public ParsedTagArray getTemplate(String desktopType, String locale, String app, String provider, String clientPath, String file, String baseDir) {
        return desktopAppContext.getTemplate(desktopType, locale, app, provider, clientPath, file, baseDir);
    }

    public StringBuffer getTemplate(String app, String provider, String file, Hashtable table) {
        ContainerProviderContext pc = null;
        try {
            pc = this.getContainerProviderContext();
        }
        catch (ContextError e) {
            // empty catch block
        }
        return desktopAppContext.getTemplate(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file, table, this.getTemplateBaseDir(), pc);
    }

    public StringBuffer getTemplate(String desktopType, String locale, String app, String provider, String clientPath, String file, Hashtable table, String baseDir) {
        ContainerProviderContext pc = null;
        try {
            pc = this.getContainerProviderContext();
        }
        catch (ContextError e) {
            // empty catch block
        }
        return desktopAppContext.getTemplate(desktopType, locale, app, provider, clientPath, file, table, baseDir, pc);
    }

    public File getTemplatePath(String app, String provider, String file) {
        return desktopAppContext.getTemplatePath(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file, this.getTemplateBaseDir());
    }

    public File getTemplatePath(String desktopType, String locale, String app, String provider, String clientPath, String file, String baseDir) {
        return desktopAppContext.getTemplatePath(desktopType, locale, app, provider, clientPath, file, baseDir);
    }

    public File getTemplateMostSpecificPath(String app, String provider, String file) {
        return desktopAppContext.getTemplateMostSpecificPath(this.getServiceContext().getDesktopType(), this.getLocaleString(), app, provider, this.getClientPath(), file, this.getTemplateBaseDir());
    }

    public File getTemplateMostSpecificPath(String desktopType, String locale, String app, String provider, String clientPath, String file, String baseDir) {
        return desktopAppContext.getTemplateMostSpecificPath(desktopType, locale, app, provider, clientPath, file, baseDir);
    }

    public void userLogout(UserEvent ue) {
        DPCacheManager.removeUserDPRoot(ue.getUserID());
    }

    public String getProviderClassBaseDir() {
        return desktopAppContext.getProviderClassBaseDir();
    }

    public String getJSPScratchDir() {
        return desktopAppContext.getJSPScratchDir();
    }

    public String getJSPCompilerWARClassPath() {
        return desktopAppContext.getJSPCompilerWARClassPath();
    }

    public String getStaticContentPath() {
        return desktopAppContext.getStaticContentPath();
    }

    public String getConfigProperty(String key) {
        return desktopAppContext.getConfigProperty(key);
    }

    private SSOToken getRemoteSSOToken(HttpServletRequest req) {
        Object ssoToken = req.getAttribute(WSRP_REMOTE_TOKEN);
        if (ssoToken == null) {
            return null;
        }
        return (SSOToken)ssoToken;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

