/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.PSContextConstants;
import com.sun.portal.desktop.context.ServiceAppContext;
import com.sun.portal.desktop.context.SessionAppContext;
import com.sun.portal.desktop.context.TemplateContext;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.TagSwapper;
import com.sun.portal.desktop.util.PIParser;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PSDesktopAppContext
implements DesktopAppContext,
PSContextConstants {
    private static final String ROC_SID = "sid";
    private static final String ROC_SUID = "suid";
    private static final String ROC_ISAUTHLESS = "isAuthless";
    private static final String propertiesfile = "message.properties";
    private static final Pattern HOST_HEADER_PATTERN = Pattern.compile("(?:(.+):(.+))|(.+)");
    protected SessionAppContext session = null;
    protected SessionAppContext authlessSession = null;
    protected SessionAppContext wsrpSession = null;
    protected ServiceAppContext service = null;
    protected ConfigContext config = null;
    protected TemplateContext template = null;
    protected ServletContext servletContext = null;
    protected ClientContext client = null;
    protected String configContextClassName = null;
    private static String scratchDir = null;
    private static Map desktopURLs = Collections.synchronizedMap(new HashMap());
    private String suidCookieName = null;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$PSDesktopAppContext == null ? (class$com$sun$portal$desktop$context$PSDesktopAppContext = PSDesktopAppContext.class$("com.sun.portal.desktop.context.PSDesktopAppContext")) : class$com$sun$portal$desktop$context$PSDesktopAppContext));
    static /* synthetic */ Class class$com$sun$portal$desktop$context$PSDesktopAppContext;

    public synchronized void init(ServletContext sc) {
        DesktopAppContextThreadLocalizer.set(this);
        this.servletContext = sc;
        this.configContextClassName = sc.getInitParameter("desktop.configContextClassName");
        if (this.configContextClassName == null) {
            throw new ContextError("PSDesktopAppContext.init(): could not get config context class name");
        }
        this.initConfigContext();
        this.initServiceAppContext();
        this.initTemplateContext();
        this.initClientContext();
        this.initSessionAppContext();
        this.initWSRPSessionAppContext();
        this.initAuthlessSessionAppContext();
    }

    private static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    protected SessionAppContext getSessionAppContext() {
        if (this.session == null) {
            throw new ContextError("PSDesktopAppContext.getSessionAppContext(): not initialized");
        }
        return this.session;
    }

    protected SessionAppContext initSessionAppContext() {
        if (this.session == null) {
            String sessionAppContextClassName = this.getSessionAppContextClassName();
            if (sessionAppContextClassName == null) {
                throw new ContextError("DesktopAppContext.getSessionAppContext(): class name was null");
            }
            try {
                this.session = (SessionAppContext)Class.forName(sessionAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getSessionAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getSessionAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getSessionAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getSessionAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getSessionAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getSessionAppContext()", se);
            }
        }
        return this.session;
    }

    protected ServiceAppContext getServiceAppContext() {
        if (this.service == null) {
            throw new ContextError("PSDesktopAppContext.getServiceAppContext(): not initialized");
        }
        return this.service;
    }

    protected ServiceAppContext initServiceAppContext() {
        if (this.service == null) {
            String serviceAppContextClassName = this.getServiceAppContextClassName();
            if (serviceAppContextClassName == null) {
                throw new ContextError("DesktopContext.getServiceAppContext(): class name was null");
            }
            try {
                this.service = (ServiceAppContext)Class.forName(serviceAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContext.getServiceAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContext.getServiceAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContext.getServiceAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContext.getServiceAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContext.getServiceAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContext.getServiceAppContext()", se);
            }
            this.service.init(this.getPortalId());
        }
        return this.service;
    }

    protected SessionAppContext getWSRPSessionAppContext() {
        if (this.wsrpSession == null) {
            throw new ContextError("PSDesktopAppContext.getWSRPSessionAppContext(): not initialized");
        }
        return this.wsrpSession;
    }

    protected SessionAppContext initWSRPSessionAppContext() {
        if (this.wsrpSession == null) {
            String wsrpSessionAppContextClassName = this.getWSRPSessionAppContextClassName();
            if (wsrpSessionAppContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext(): class name was null");
            }
            try {
                this.wsrpSession = (SessionAppContext)Class.forName(wsrpSessionAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.initWSRPSessionAppContext()", se);
            }
        }
        return this.wsrpSession;
    }

    protected SessionAppContext getAuthlessSessionAppContext() {
        if (this.authlessSession == null) {
            throw new ContextError("PSDesktopAppContext.getAuthlessSessionAppContext(): not initialized");
        }
        return this.authlessSession;
    }

    protected SessionAppContext initAuthlessSessionAppContext() {
        if (this.authlessSession == null) {
            String authlessSessionAppContextClassName = this.getAuthlessSessionAppContextClassName();
            if (authlessSessionAppContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext(): class name was null");
            }
            try {
                this.authlessSession = (SessionAppContext)Class.forName(authlessSessionAppContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.initAuthlessSessionAppContext()", se);
            }
        }
        return this.authlessSession;
    }

    protected ConfigContext getConfigContext() {
        if (this.config == null) {
            throw new ContextError("PSDesktopAppContext.getConfigContext(): not initialized");
        }
        return this.config;
    }

    protected ConfigContext initConfigContext() {
        if (this.config == null) {
            String configContextClassName = this.getConfigContextClassName();
            if (configContextClassName == null) {
                throw new ContextError("DesktopContext.getConfigContext(): class name was null");
            }
            try {
                this.config = (ConfigContext)Class.forName(configContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.getConfigContext()", se);
            }
        }
        this.config.init(this.servletContext);
        return this.config;
    }

    protected ClientContext getClientContext() {
        if (this.client == null) {
            throw new ContextError("PSDesktopAppContext.getClientContext(): not initialized");
        }
        return this.client;
    }

    protected ClientContext initClientContext() {
        if (this.client == null) {
            String clientContextClassName = this.getClientContextClassName();
            if (clientContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.getClientContext(): class name was null");
            }
            try {
                this.client = (ClientContext)Class.forName(clientContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.initClientContext()", se);
            }
        }
        this.client.init();
        return this.client;
    }

    private TemplateContext getTemplateContext() {
        if (this.template == null) {
            throw new ContextError("PSDesktopAppContext.getTemplateContext(): not initialized");
        }
        return this.template;
    }

    private TemplateContext initTemplateContext() {
        if (this.template == null) {
            String templateContextClassName = this.getTemplateContextClassName();
            if (templateContextClassName == null) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext(): class name was null");
            }
            try {
                this.template = (TemplateContext)Class.forName(templateContextClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopAppContext.getTemplateContext()", se);
            }
            if (this.config != null) {
                this.template.init(this.config.getTemplateScanInterval());
            } else {
                this.template.init(30);
            }
        }
        return this.template;
    }

    protected String getDebugContextClassName() {
        return this.getServiceAppContext().getDebugContextClassName();
    }

    protected String getConfigContextClassName() {
        return this.configContextClassName;
    }

    protected String getSessionAppContextClassName() {
        return this.getServiceAppContext().getSessionAppContextClassName();
    }

    protected String getAuthlessSessionAppContextClassName() {
        return this.getServiceAppContext().getAuthlessSessionAppContextClassName();
    }

    protected String getWSRPSessionAppContextClassName() {
        return this.getServiceAppContext().getWSRPSessionAppContextClassName();
    }

    protected String getClientContextClassName() {
        return this.getServiceAppContext().getClientContextClassName();
    }

    protected String getServiceAppContextClassName() {
        return this.getConfigContext().getServiceAppContextClassName();
    }

    public String getDesktopContextClassName() {
        return this.getServiceAppContext().getDesktopContextClassName();
    }

    protected String getTemplateContextClassName() {
        return this.getServiceAppContext().getTemplateContextClassName();
    }

    public String getServiceContextClassName() {
        return this.getServiceAppContext().getServiceContextClassName();
    }

    protected String getSessionContextClassName() {
        return this.getServiceAppContext().getSessionContextClassName();
    }

    public String getNoSessionURL() {
        return this.getServiceAppContext().getNoSessionURL();
    }

    public String getSessionReturnURLParamName() {
        return this.getServiceAppContext().getSessionReturnURLParamName();
    }

    public Map getAuthorizedAuthlessUIDs() {
        return this.getServiceAppContext().getAuthorizedAuthlessUIDs();
    }

    public String getDefaultAuthlessUID() {
        return this.getServiceAppContext().getDefaultAuthlessUID();
    }

    public long getClientSessionReapInterval() {
        return this.getServiceAppContext().getClientSessionReapInterval();
    }

    public long getClientSessionInactiveMax() {
        return this.getServiceAppContext().getClientSessionInactiveMax();
    }

    public long getClientSessionsMax() {
        return this.getServiceAppContext().getClientSessionsMax();
    }

    public boolean isAuthlessEnabled() {
        return this.getServiceAppContext().isAuthlessEnabled();
    }

    public boolean isFederationEnabled() {
        return this.getServiceAppContext().isFederationEnabled();
    }

    public String getPreLoginURL(String returnURL, String libertySSOFailedParamName) {
        return this.getServiceAppContext().getPreLoginURL(returnURL, libertySSOFailedParamName);
    }

    public String getStringAttribute(String name) {
        return this.getServiceAppContext().getStringAttribute(name);
    }

    public void setStringAttribute(String name, String val) {
        this.getServiceAppContext().setStringAttribute(name, val);
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        String hostHeader;
        String host = null;
        String port = null;
        String scheme = null;
        String ignoreHostHeaders = this.getClientTypeProperty(this.getClientType(req), "ignoreHostHeader");
        if (!PSDesktopAppContext.toBoolean(ignoreHostHeaders) && (hostHeader = req.getHeader("host")) != null && hostHeader.length() > 0) {
            Matcher m = HOST_HEADER_PATTERN.matcher(hostHeader);
            if (!m.matches()) {
                throw new ContextError("unable to parse host header: " + hostHeader);
            }
            if (m.group(3) != null) {
                host = m.group(3);
            } else {
                host = m.group(1);
                port = m.group(2);
            }
            String au = this.getServiceAppContext().getAccessURL();
            if (au != null && au.length() > 0) {
                try {
                    URL accessURL = new URL(au);
                    if (host.equals(accessURL.getHost())) {
                        scheme = accessURL.getProtocol();
                        if (port == null) {
                            port = String.valueOf(accessURL.getPort());
                        }
                    }
                }
                catch (MalformedURLException mfue) {
                    throw new ContextError("could not construct access URL: " + au, mfue);
                }
            }
        }
        if (scheme == null) {
            scheme = req.getScheme();
        }
        if (host == null) {
            host = req.getServerName();
        }
        if (port == null) {
            port = String.valueOf(req.getServerPort());
        }
        StringBuffer url = new StringBuffer(32);
        url.append(scheme).append("://");
        url.append(host);
        if (scheme.equals("http") && !port.equals("80") || scheme.equals("https") && !port.equals("443")) {
            url.append(':').append(port);
        }
        return url;
    }

    public String getDesktopURL(HttpServletRequest req) {
        String requestServer = this.getRequestServer(req).toString();
        String dtURL = (String)desktopURLs.get(requestServer);
        if (dtURL == null) {
            dtURL = requestServer + req.getContextPath() + req.getServletPath();
            desktopURLs.put(requestServer, dtURL);
        }
        return dtURL;
    }

    public String getDesktopURL(HttpServletRequest req, Map query, Map pathInfo) {
        StringBuffer urlBuffer = new StringBuffer(this.getDesktopURL(req));
        if (pathInfo != null && !pathInfo.isEmpty()) {
            HashMap<String, Map> piMap = new HashMap<String, Map>();
            piMap.put("desktop.args", pathInfo);
            String pathInfoString = PIParser.getPathInfoString(piMap);
            urlBuffer.append("/").append(pathInfoString);
        }
        if (query != null && !query.isEmpty()) {
            StringBuffer queryBuffer = new StringBuffer();
            Iterator i = query.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)query.get(key);
                queryBuffer.append(key).append("=").append(value);
                if (!i.hasNext()) continue;
                queryBuffer.append("&");
            }
            urlBuffer.append("?").append(queryBuffer.toString());
        }
        return urlBuffer.toString();
    }

    public String getDesktopURL(HttpServletRequest req, String query) {
        StringBuffer urlBuffer = new StringBuffer(this.getDesktopURL(req));
        if (query != null && query.length() != 0) {
            urlBuffer.append("?").append(query);
        }
        return urlBuffer.toString();
    }

    public boolean validateSession(HttpServletRequest req) {
        boolean valid = false;
        if (this.getSessionAppContext().validateSession(req)) {
            valid = true;
        }
        return valid;
    }

    public boolean validateAuthlessSession(HttpServletRequest req) {
        boolean valid = false;
        if (this.getAuthlessSessionAppContext().validateSession(req)) {
            valid = true;
        }
        return valid;
    }

    public boolean isAuthless(HttpServletRequest req) {
        boolean authless = false;
        Boolean al = (Boolean)ROC.getObject(ROC_ISAUTHLESS);
        if (al != null) {
            authless = al;
        } else {
            boolean isValidAuthless;
            boolean isValidAuth = this.getSessionAppContext().validateSession(req);
            boolean isValidWSRP = this.isWSRP(req);
            if (!isValidAuth && !isValidWSRP && (isValidAuthless = this.getAuthlessSessionAppContext().validateSession(req))) {
                authless = true;
            }
            if (authless) {
                ROC.setObject(ROC_ISAUTHLESS, Boolean.TRUE);
            } else {
                ROC.setObject(ROC_ISAUTHLESS, Boolean.FALSE);
            }
        }
        return authless;
    }

    public boolean isWSRP(HttpServletRequest req) {
        boolean isValidWSRP = this.getWSRPSessionAppContext().validateSession(req);
        return isValidWSRP;
    }

    public boolean isAuthorizedAuthlessUID(String uid) {
        Map authorized = this.getAuthorizedAuthlessUIDs();
        return authorized.containsKey(uid.toLowerCase());
    }

    public String getSessionID(HttpServletRequest req) {
        String sid = (String)ROC.getObject(ROC_SID);
        if (sid == null) {
            sid = this.isWSRP(req) ? this.getWSRPSessionAppContext().getSessionID(req) : (this.isAuthless(req) ? this.getAuthlessSessionAppContext().getSessionID(req) : this.getSessionAppContext().getSessionID(req));
            ROC.setObject(ROC_SID, sid);
        }
        return sid;
    }

    public String getContentType(String clientType) {
        return this.getClientContext().getContentType(clientType);
    }

    public String getClientType(HttpServletRequest req) {
        String clientType = this.getClientContext().getClientType(req);
        return clientType;
    }

    public String getDefaultClientType() {
        return this.getClientContext().getDefaultClientType();
    }

    public String getClientPath(String clientType) {
        return this.getClientContext().getClientPath(clientType);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.getClientContext().getClientTypeProperty(clientType, key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        return this.getClientContext().getClientTypeProperties(clientType, key);
    }

    public String getCharset(String clientType, Locale locale) {
        return this.getClientContext().getCharset(clientType, locale);
    }

    public short getCookieSupport(String clientType) {
        return this.getClientContext().getCookieSupport(clientType);
    }

    public short getAuthlessState(String clientType) {
        return this.getClientContext().getAuthlessState(clientType);
    }

    public String getEncoderClassName(String clientType) {
        return this.getClientContext().getEncoderClassName(clientType);
    }

    public String getPortalId() {
        return this.getConfigContext().getPortalId();
    }

    public String getInstanceId() {
        return this.getConfigContext().getInstanceId();
    }

    public String getTemplateBaseDir() {
        return this.getConfigContext().getTemplateBaseDir();
    }

    public String getProviderClassBaseDir() {
        return this.getConfigContext().getProviderClassBaseDir();
    }

    public String getJSPScratchDir() {
        return this.getConfigContext().getJSPScratchDir();
    }

    public String getJSPCompilerWARClassPath() {
        return this.getConfigContext().getJSPCompilerWARClassPath();
    }

    public String getDefaultDesktopType() {
        return this.getConfigContext().getDefaultDesktopType();
    }

    public int getGetterPoolMinSize() {
        return this.getConfigContext().getGetterPoolMinSize();
    }

    public int getGetterPoolMaxSize() {
        return this.getConfigContext().getGetterPoolMaxSize();
    }

    public int getGetterPoolPartitionSize() {
        return this.getConfigContext().getGetterPoolPartitionSize();
    }

    public int getCallerPoolMinSize() {
        return this.getConfigContext().getCallerPoolMinSize();
    }

    public int getCallerPoolMaxSize() {
        return this.getConfigContext().getCallerPoolMaxSize();
    }

    public int getCallerPoolPartitionSize() {
        return this.getConfigContext().getCallerPoolPartitionSize();
    }

    public int getTemplateScanInterval() {
        return this.getConfigContext().getTemplateScanInterval();
    }

    public int getClassLoaderRevalidateInterval() {
        return this.getConfigContext().getClassLoaderRevalidateInterval();
    }

    public int getBrowserCacheInterval() {
        return this.getConfigContext().getBrowserCacheInterval();
    }

    public int getDPScanInterval() {
        return this.getConfigContext().getDPScanInterval();
    }

    public List getCurrentCommunityContributorTypes() {
        return this.getConfigContext().getCurrentCommunityContributorTypes();
    }

    public String getStaticContentPath() {
        return DesktopRequestThreadLocalizer.getRequest().getContextPath();
    }

    public String getCookiePrefix() {
        return this.getConfigContext().getCookiePrefix();
    }

    public String getLBCookieName() {
        return this.getConfigContext().getLBCookieName();
    }

    public String getConfigProperty(String key) {
        return this.getConfigContext().getConfigProperty(key);
    }

    public int getMaxEventGenerations() {
        return this.config.getMaxEventGenerations();
    }

    public String getPortletRenderModeParallel() {
        return this.config.getPortletRenderModeParallel();
    }

    public ParsedTagArray getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplate(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    public StringBuffer getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, Hashtable table, String baseDir, ContainerProviderContext pc) {
        ParsedTagArray pta = this.getTemplate(type, locale, app, provider, clientFilePath, file, baseDir);
        Properties p = this.getTemplateContext().getTemplateProperties(baseDir, type, locale, app, provider, clientFilePath, propertiesfile);
        return TagSwapper.doSwapFromParsedTagArray(pta, pc, app, this.getStaticContentPath(), table, p);
    }

    public StringBuffer getTemplate(String type, String locale, String app, String provider, String clientFilePath, String file, Hashtable table, String baseDir) {
        return this.getTemplate(type, locale, app, provider, clientFilePath, file, table, baseDir, null);
    }

    public File getTemplatePath(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplatePath(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    public File getTemplateMostSpecificPath(String type, String locale, String app, String provider, String clientFilePath, String file, String baseDir) {
        return this.getTemplateContext().getTemplateMostSpecificPath(baseDir, type, locale, app, provider, clientFilePath, file);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

