/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.ServletContextThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.Monitor;
import com.sun.portal.desktop.context.PSProviderContext;
import com.sun.portal.desktop.context.ParentContainerThreadLocalizer;
import com.sun.portal.desktop.context.ProviderCallerPool;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.desktop.context.ProviderGetterPool;
import com.sun.portal.desktop.context.ReusableProviderCaller;
import com.sun.portal.desktop.context.ReusableProviderGetter;
import com.sun.portal.desktop.monitoring.MonitoringSubsystemWrapper;
import com.sun.portal.desktop.ubt.ProviderLogRecord;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.utilities.ActivityTime;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.containers.jsp.tab.JSPTabContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.portletwindow.PortletWindowProvider;
import com.sun.portal.ubt.UBTEvent;
import com.sun.portal.ubt.UBTLogField;
import com.sun.portal.ubt.UBTLogManager;
import com.sun.portal.ubt.UBTLogRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PSContainerProviderContext
extends PSProviderContext
implements ContainerProviderContext {
    protected Map providerCache = new HashMap();
    private static int DEFAULT_MIN_SIZE = 0;
    private static int DEFAULT_MAX_SIZE = 10000;
    private static int DEFAULT_PARTITION_SIZE = 13;
    protected static ProviderCallerPool callerPool = null;
    protected static ProviderGetterPool getterPool = null;
    protected Map cachedContent = new HashMap();
    protected Map cachedTime = new HashMap();
    private long lastClassLoaderCheckTimer = 0L;
    private static String CHECK_PROVIDER_CLASS_LOADER = "checkProviderClassLoader";
    private boolean parallelPortletAllowed = true;
    private static String PARALLEL_PORTLET_NOT_ALLOWED_CONTAINER = "IBM";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$PSContainerProviderContext == null ? (class$com$sun$portal$desktop$context$PSContainerProviderContext = PSContainerProviderContext.class$("com.sun.portal.desktop.context.PSContainerProviderContext")) : class$com$sun$portal$desktop$context$PSContainerProviderContext));
    static /* synthetic */ Class class$com$sun$portal$desktop$context$PSContainerProviderContext;

    public synchronized void init(HttpServletRequest req) {
        ServletContext sc;
        super.init(req);
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        if (callerPool == null) {
            this.initCallerPool(dac);
        }
        if (getterPool == null) {
            this.initGetterPool(dac);
        }
        this.parallelPortletAllowed = (sc = ServletContextThreadLocalizer.get()).getServerInfo().indexOf(PARALLEL_PORTLET_NOT_ALLOWED_CONTAINER) == -1;
    }

    public void refresh() {
        super.refresh();
        this.cachedContent = new HashMap();
        this.cachedTime = new HashMap();
        this.providerCache.clear();
    }

    public void contentChanged(String channel) {
        this.removeCachedContent(channel);
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        Set ancestors = this.getDesktopContext().getAncestors(req, channel);
        if (ancestors != null) {
            Iterator i = ancestors.iterator();
            while (i.hasNext()) {
                String ancestor = (String)i.next();
                this.removeCachedContent(ancestor);
            }
        }
    }

    public void allContentChanged() {
        this.removeAllCachedContent();
    }

    public boolean existsChannel(String channel) {
        return this.getPropertiesContext().existsChannel(channel);
    }

    public void createChannel(String channelName, String providerName) throws ProviderContextException {
        try {
            this.getPropertiesContext().createChannel(channelName, providerName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.createChannel ", ce);
        }
    }

    public void createContainer(String channelName, String providerName) throws ProviderContextException {
        try {
            this.getPropertiesContext().createContainer(channelName, providerName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.createContainer", ce);
        }
    }

    public void removeChannel(String channelName) throws ProviderContextException {
        try {
            this.getPropertiesContext().removeChannel(channelName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.removeChannel ", ce);
        }
    }

    public void copyChannel(String srcName, String dstName) throws ProviderContextException {
        try {
            this.getPropertiesContext().copyChannel(srcName, dstName);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.copyChannel()", ce);
        }
    }

    public List getSelectedChannels(String container) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getSelectedChannels(container);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.getSelectedChannels ", ce);
        }
    }

    public List getAvailableChannels(String container) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getAvailableChannels(container);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.getAvailableChannels ", ce);
        }
    }

    public void setSelectedChannels(String container, List sel) throws ProviderContextException {
        try {
            this.getPropertiesContext().setSelectedChannels(container, sel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.setSelectedChannels ", ce);
        }
    }

    public void setAvailableChannels(String container, List avail) throws ProviderContextException {
        try {
            this.getPropertiesContext().setAvailableChannels(container, avail);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSContainerProviderContext.setAvailableChannels ", ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider getProvider(HttpServletRequest req, String parent, String channel) {
        Provider p;
        block13: {
            p = (Provider)this.providerCache.get(channel);
            DesktopContext dc = this.getDesktopContext();
            DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
            if (p == null) {
                block12: {
                    try {
                        p = this.initProvider(req, parent, channel);
                    }
                    catch (ProviderContextException pce) {
                        if (!debugLogger.isLoggable(Level.WARNING)) break block12;
                        LogRecord logRecord = new LogRecord(Level.WARNING, "PSDT_CSPDC0004");
                        logRecord.setLoggerName(debugLogger.getName());
                        logRecord.setParameters(new String[]{channel});
                        logRecord.setThrown(pce);
                        debugLogger.log(logRecord);
                    }
                }
                if (p != null) {
                    Map pce = this.providerCache;
                    synchronized (pce) {
                        if (this.providerCache.get(channel) == null) {
                            this.providerCache.put(channel, p);
                        }
                    }
                }
            } else {
                long currentTime = System.currentTimeMillis();
                String providerClassName = null;
                if (this.isAuthless(req) && (req.getAttribute(CHECK_PROVIDER_CLASS_LOADER) != null || currentTime - this.lastClassLoaderCheckTimer > (long)(1000 * dac.getClassLoaderRevalidateInterval()))) {
                    this.lastClassLoaderCheckTimer = System.currentTimeMillis();
                    req.setAttribute(CHECK_PROVIDER_CLASS_LOADER, (Object)Boolean.TRUE);
                    try {
                        providerClassName = this.getClassName(channel);
                        ProviderClassLoader pcl = ProviderClassLoader.getInstance(providerClassName, dc.getProviderClassBaseDir());
                    }
                    catch (ProviderContextException pce) {
                        if (!debugLogger.isLoggable(Level.WARNING)) break block13;
                        LogRecord logRecord = new LogRecord(Level.WARNING, "PSDT_CSPDC0005");
                        logRecord.setLoggerName(debugLogger.getName());
                        logRecord.setParameters(new String[]{channel});
                        logRecord.setThrown(pce);
                        debugLogger.log(logRecord);
                    }
                }
            }
        }
        return p;
    }

    private Provider initProvider(HttpServletRequest req, String parent, String channel) throws ProviderContextException {
        String providerClassName = null;
        providerClassName = this.getClassName(channel);
        if (providerClassName == null) {
            return null;
        }
        Provider p = null;
        DesktopContext dc = this.getDesktopContext();
        try {
            ProviderClassLoader pcl = ProviderClassLoader.getInstance(providerClassName, dc.getProviderClassBaseDir());
            Class<?> pclClass = pcl.loadClass(providerClassName);
            if (pclClass == null) {
                debugLogger.log(Level.INFO, "PSDT_CSPDC0006", new String[]{providerClassName, channel, parent});
                return null;
            }
            p = (Provider)pclClass.newInstance();
            p.init(channel, req);
        }
        catch (NoClassDefFoundError ncdfe) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", ncdfe);
        }
        catch (IllegalAccessException iae) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", iae);
        }
        catch (ClassCastException cce) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", cce);
        }
        catch (InstantiationException ie) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", ie);
        }
        catch (SecurityException se) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", se);
        }
        catch (ProviderException pe) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", pe);
        }
        catch (ClassNotFoundException cnfe) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0003", cnfe);
        }
        this.lastClassLoaderCheckTimer = System.currentTimeMillis();
        return p;
    }

    public void initProviders(HttpServletRequest req, String parent, List providers, int timeout) {
        ReusableProviderGetter getter;
        Monitor monitor = new Monitor();
        HashMap<String, ReusableProviderGetter> getters = new HashMap<String, ReusableProviderGetter>();
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        DesktopContext dc = DesktopContextThreadLocalizer.get();
        ServletContext sc = ServletContextThreadLocalizer.get();
        HttpServletRequest origReq = RequestThreadLocalizer.getRequest();
        HttpServletResponse origRes = RequestThreadLocalizer.getResponse();
        HttpServletResponse res = DesktopRequestThreadLocalizer.getResponse();
        for (int i = 0; i < providers.size(); ++i) {
            String channel = (String)providers.get(i);
            monitor.addTask();
            getter = getterPool.obtainGetter(dac, dc, this, parent, channel, monitor, req, res, origReq, origRes, sc);
            if (getter == null) {
                debugLogger.info("PSDT_CSPDC0007");
                continue;
            }
            getter.execute();
            getters.put(channel, getter);
        }
        monitor.start();
        if (!monitor.isDoneWaiting(timeout)) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0008", monitor.getCompleted());
        }
        Iterator i = getters.keySet().iterator();
        while (i.hasNext()) {
            String providerName = (String)i.next();
            if (monitor.contains(providerName)) continue;
            getter = (ReusableProviderGetter)getters.get(providerName);
            getter.interrupt();
        }
    }

    protected synchronized void removeCachedContent(String name) {
        this.cachedContent.remove(name);
        this.cachedTime.remove(name);
    }

    protected synchronized void removeAllCachedContent() {
        this.cachedContent.clear();
        this.cachedTime.clear();
    }

    public synchronized void putCachedContent(String name, StringBuffer content) {
        this.cachedContent.put(name, content);
        this.cachedTime.put(name, new Long(System.currentTimeMillis() / 1000L));
    }

    public StringBuffer getCachedContent(String name) {
        return (StringBuffer)this.cachedContent.get(name);
    }

    public long getCachedTime(String name) {
        Long t = (Long)this.cachedTime.get(name);
        if (t == null) {
            return 0L;
        }
        return t;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res, String parent, String name) throws ProviderException {
        long refreshTime;
        Provider p;
        ActivityTime activityTime;
        block19: {
            activityTime = new ActivityTime();
            MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().mark(activityTime);
            p = this.getProvider(req, parent, name);
            if (p == null) {
                MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().measure(activityTime, name);
                return null;
            }
            if (!p.isPresentable(req)) {
                MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().measure(activityTime, name);
                return null;
            }
            refreshTime = 0L;
            try {
                refreshTime = p.getRefreshTime();
            }
            catch (ProviderException pe) {
                if (!debugLogger.isLoggable(Level.INFO)) break block19;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0009");
                logRecord.setLoggerName(debugLogger.getName());
                logRecord.setParameters(new String[]{name});
                logRecord.setThrown(pe);
                debugLogger.log(logRecord);
            }
        }
        long timeCached = this.getCachedTime(name);
        long now = System.currentTimeMillis() / 1000L;
        StringBuffer content = this.getCachedContent(name);
        if (content == null || timeCached != -1L && now >= timeCached + refreshTime) {
            String oldParent;
            block20: {
                if (debugLogger.isLoggable(Level.FINEST)) {
                    debugLogger.log(Level.FINEST, "PSDT_CSPDC0028", p.getName());
                }
                oldParent = ParentContainerThreadLocalizer.get();
                ParentContainerThreadLocalizer.set(parent);
                TreeSet portlets = new TreeSet();
                try {
                    this.createVisiblePortletsList(req, p, portlets);
                    if (portlets.size() > 0) {
                        Set portletSet = (Set)this.getSessionProperty("portlets_on_tab");
                        if (portletSet != null) {
                            portlets.addAll(portletSet);
                        }
                        this.setSessionProperty("portlets_on_tab", portlets);
                    }
                }
                catch (ProviderContextException pce) {
                    if (!debugLogger.isLoggable(Level.WARNING)) break block20;
                    LogRecord logRecord = new LogRecord(Level.WARNING, "PSDT_CSPDC0033");
                    logRecord.setLoggerName(debugLogger.getName());
                    logRecord.setParameters(new String[]{parent});
                    logRecord.setThrown(pce);
                    debugLogger.log(logRecord);
                }
            }
            content = p.getContent(req, res);
            ParentContainerThreadLocalizer.set(oldParent);
            if (refreshTime > 0L) {
                this.putCachedContent(p.getName(), content);
            }
            try {
                UBTLogManager manager = UBTLogManager.getInstance();
                if (manager.isUBTEnabled()) {
                    UBTEvent prov_ren = UBTEvent.getInstance((String)"PROVIDER_RENDER_FRESH");
                    prov_ren.put(UBTLogField.CHANNEL_NAME, (Object)name);
                    prov_ren.put(UBTLogField.PROVIDER, (Object)p.getClass().getName());
                    prov_ren.put(UBTLogField.CONTAINER_NAME, (Object)this.getParentContainerName(name));
                    prov_ren.put(UBTLogField.ACTION, (Object)"Content");
                    manager.logEvent((UBTLogRecord)new ProviderLogRecord(prov_ren, req, res, this.getUserID()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().measure(activityTime, name);
        } else {
            if (debugLogger.isLoggable(Level.FINEST)) {
                debugLogger.log(Level.FINEST, "PSDT_CSPDC0029", p.getName());
            }
            try {
                UBTLogManager manager = UBTLogManager.getInstance();
                if (manager.isUBTEnabled()) {
                    UBTEvent prov_ren = UBTEvent.getInstance((String)"PROVIDER_RENDER_CACHE");
                    prov_ren.put(UBTLogField.CHANNEL_NAME, (Object)p.getName());
                    prov_ren.put(UBTLogField.PROVIDER, (Object)p.getClass().getName());
                    prov_ren.put(UBTLogField.CONTAINER_NAME, (Object)this.getParentContainerName(p.getName()));
                    prov_ren.put(UBTLogField.ACTION, (Object)"Content");
                    manager.logEvent((UBTLogRecord)new ProviderLogRecord(prov_ren, req, res, this.getUserID()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getChannelCacheHitsStatistic().measure(activityTime, name);
        }
        return content;
    }

    private void createVisiblePortletsList(HttpServletRequest req, Provider p, Set portlets) throws ProviderContextException, ProviderException {
        if (p instanceof JSPTabContainerProvider) {
            String selected = req.getParameter(p.getName() + ".setSelected");
            if (selected != null && selected.length() > 0) {
                return;
            }
            String name = ((JSPTabContainerProvider)p).getSelectedTab().getName();
            Provider provider = this.getProvider(req, p.getName(), name);
            this.createVisiblePortletsList(req, provider, portlets);
        } else if (p instanceof ContainerProvider) {
            ContainerProvider cp = (ContainerProvider)((Object)p);
            List channelList = cp.getSelectedChannels();
            for (int i = 0; i < channelList.size(); ++i) {
                String name = (String)channelList.get(i);
                Provider provider = this.getProvider(req, p.getName(), name);
                this.createVisiblePortletsList(req, provider, portlets);
            }
        } else if (p instanceof PortletWindowProvider) {
            String entity = this.getStringProperty(p.getName(), "entityIDPrefix") + "|" + p.getName();
            portlets.add(entity);
        }
    }

    public Map getContent(HttpServletRequest req, HttpServletResponse res, String parent, List providers, int timeout) throws ProviderException {
        Map minimizedChannels;
        boolean existMaximizedChannel;
        String maximizedChannel;
        Map detachedChannels;
        HttpServletResponse origRes;
        HttpServletRequest origReq;
        ServletConfig scfg;
        ServletContext sc;
        DesktopContext dc;
        DesktopAppContext dac;
        ArrayList<String> parallelProviders;
        HashMap<String, ReusableProviderCaller> callers;
        HashMap<String, StringBuffer> content;
        Monitor monitor;
        ActivityTime activityTime;
        block24: {
            activityTime = new ActivityTime();
            MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().mark(activityTime);
            monitor = new Monitor();
            content = new HashMap<String, StringBuffer>();
            callers = new HashMap<String, ReusableProviderCaller>();
            parallelProviders = null;
            if (!this.parallelPortletAllowed) {
                parallelProviders = new ArrayList<String>(providers.size());
                for (int i = 0; i < providers.size(); ++i) {
                    String channel = (String)providers.get(i);
                    if (this.isPortlet(channel)) {
                        StringBuffer channelContent;
                        block23: {
                            channelContent = null;
                            try {
                                channelContent = this.getContent(req, res, parent, channel);
                            }
                            catch (Throwable t) {
                                if (!debugLogger.isLoggable(Level.INFO)) break block23;
                                LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0010");
                                logRecord.setLoggerName(debugLogger.getName());
                                logRecord.setParameters(new String[]{channel});
                                logRecord.setThrown(t);
                                debugLogger.log(logRecord);
                            }
                        }
                        content.put(channel, channelContent);
                        continue;
                    }
                    parallelProviders.add(channel);
                }
            } else {
                parallelProviders = providers;
            }
            dac = DesktopAppContextThreadLocalizer.get();
            dc = DesktopContextThreadLocalizer.get();
            sc = ServletContextThreadLocalizer.get();
            scfg = ServletConfigThreadLocalizer.get();
            origReq = RequestThreadLocalizer.getRequest();
            origRes = RequestThreadLocalizer.getResponse();
            detachedChannels = null;
            maximizedChannel = null;
            existMaximizedChannel = false;
            minimizedChannels = null;
            try {
                existMaximizedChannel = this.existsStringProperty(parent, "maximizedChannel");
                if (existMaximizedChannel) {
                    maximizedChannel = this.getStringProperty(parent, "maximizedChannel");
                }
                minimizedChannels = this.getCollectionPropertyIE(parent, "channelsIsMinimized");
                detachedChannels = this.getCollectionPropertyIE(parent, "channelsIsDetached");
            }
            catch (ProviderContextException pce) {
                if (!debugLogger.isLoggable(Level.INFO)) break block24;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0011");
                logRecord.setLoggerName(debugLogger.getName());
                logRecord.setParameters(new String[]{parent});
                logRecord.setThrown(pce);
                debugLogger.log(logRecord);
            }
        }
        for (int i = 0; i < parallelProviders.size(); ++i) {
            long refreshTime;
            Provider p;
            String channel;
            ActivityTime activityTime2;
            block25: {
                activityTime2 = new ActivityTime();
                MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getChannelCacheHitsStatistic().mark(activityTime2);
                channel = (String)parallelProviders.get(i);
                p = this.getProvider(req, parent, channel);
                if (p == null || !p.isPresentable(req) || existMaximizedChannel && maximizedChannel != null && maximizedChannel.trim().length() > 0 && !channel.equalsIgnoreCase(maximizedChannel) || this.checkChannel(detachedChannels, channel) || this.checkChannel(minimizedChannels, channel)) continue;
                refreshTime = 0L;
                try {
                    refreshTime = p.getRefreshTime();
                }
                catch (ProviderException pe) {
                    if (!debugLogger.isLoggable(Level.INFO)) break block25;
                    LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDC0009");
                    logRecord.setLoggerName(debugLogger.getName());
                    logRecord.setParameters(new String[]{channel});
                    logRecord.setThrown(pe);
                    debugLogger.log(logRecord);
                }
            }
            long timeCached = this.getCachedTime(channel);
            long now = System.currentTimeMillis() / 1000L;
            StringBuffer channelContent = this.getCachedContent(channel);
            if (channelContent == null || timeCached != -1L && now >= timeCached + refreshTime) {
                if (debugLogger.isLoggable(Level.FINEST)) {
                    debugLogger.log(Level.FINEST, "PSDT_CSPDC0028", p.getName());
                }
                monitor.addTask();
                ReusableProviderCaller caller = callerPool.obtainCaller(dac, dc, this, p, parent, monitor, req, res, origReq, origRes, scfg, sc);
                if (caller == null) {
                    debugLogger.info("PSDT_CSPDC0012");
                    continue;
                }
                caller.execute();
                callers.put(p.getName(), caller);
                try {
                    UBTLogManager manager = UBTLogManager.getInstance();
                    if (!manager.isUBTEnabled()) continue;
                    UBTEvent prov_ren = UBTEvent.getInstance((String)"PROVIDER_RENDER_FRESH");
                    prov_ren.put(UBTLogField.CHANNEL_NAME, (Object)p.getName());
                    prov_ren.put(UBTLogField.PROVIDER, (Object)p.getClass().getName());
                    prov_ren.put(UBTLogField.CONTAINER_NAME, (Object)this.getParentContainerName(p.getName()));
                    prov_ren.put(UBTLogField.ACTION, (Object)"Content");
                    manager.logEvent((UBTLogRecord)new ProviderLogRecord(prov_ren, req, res, this.getUserID()));
                }
                catch (Exception e) {}
                continue;
            }
            if (debugLogger.isLoggable(Level.FINEST)) {
                debugLogger.log(Level.FINEST, "PSDT_CSPDC0029", p.getName());
            }
            content.put(channel, channelContent);
            try {
                UBTLogManager manager = UBTLogManager.getInstance();
                if (manager.isUBTEnabled()) {
                    UBTEvent prov_ren = UBTEvent.getInstance((String)"PROVIDER_RENDER_CACHE");
                    prov_ren.put(UBTLogField.CHANNEL_NAME, (Object)p.getName());
                    prov_ren.put(UBTLogField.PROVIDER, (Object)p.getClass().getName());
                    prov_ren.put(UBTLogField.CONTAINER_NAME, (Object)this.getParentContainerName(p.getName()));
                    prov_ren.put(UBTLogField.ACTION, (Object)"Content");
                    manager.logEvent((UBTLogRecord)new ProviderLogRecord(prov_ren, req, res, this.getUserID()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getChannelCacheHitsStatistic().measure(activityTime2, channel);
        }
        monitor.start();
        if (!monitor.isDoneWaiting(timeout)) {
            debugLogger.log(Level.INFO, "PSDT_CSPDC0013", new String[]{monitor.getCompleted().keySet().toString()});
        }
        content.putAll(monitor.getCompleted());
        Iterator i = callers.keySet().iterator();
        while (i.hasNext()) {
            String providerName = (String)i.next();
            if (monitor.contains(providerName)) continue;
            ReusableProviderCaller caller = (ReusableProviderCaller)callers.get(providerName);
            caller.interrupt();
        }
        MonitoringSubsystemWrapper.getDesktopMonitoringSubsystem().getContentChannelActionStatistic().measure(activityTime, parent);
        return content;
    }

    private Map getCollectionPropertyIE(String parent, String propertyName) throws ProviderContextException {
        Map map = null;
        boolean existsProp = this.existsCollectionProperty(parent, propertyName);
        if (existsProp) {
            map = this.getCollectionProperty(parent, propertyName);
        }
        return map;
    }

    private boolean checkChannel(Map map, String channel) {
        if (map != null) {
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String cname = (String)iter.next();
                if (!cname.equalsIgnoreCase(channel)) continue;
                Boolean boolVal = (Boolean)map.get(cname);
                return boolVal;
            }
        }
        return false;
    }

    private void initCallerPool(DesktopAppContext dac) {
        int partitionSize;
        int maxSize;
        int minSize = dac.getCallerPoolMinSize();
        if (minSize < 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0014", new String[]{Integer.toString(minSize), Integer.toString(DEFAULT_MIN_SIZE)});
            minSize = DEFAULT_MIN_SIZE;
        }
        if ((maxSize = dac.getCallerPoolMaxSize()) < 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0015", new String[]{Integer.toString(maxSize), Integer.toString(DEFAULT_MAX_SIZE)});
            maxSize = DEFAULT_MAX_SIZE;
        }
        if ((partitionSize = dac.getCallerPoolPartitionSize()) <= 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0016", new String[]{Integer.toString(partitionSize), Integer.toString(DEFAULT_PARTITION_SIZE)});
            partitionSize = DEFAULT_PARTITION_SIZE;
        }
        callerPool = new ProviderCallerPool(minSize, maxSize, true, partitionSize);
    }

    private void initGetterPool(DesktopAppContext dac) {
        int partitionSize;
        int maxSize;
        int minSize = dac.getGetterPoolMinSize();
        if (minSize < 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0014", new String[]{Integer.toString(minSize), Integer.toString(DEFAULT_MIN_SIZE)});
            minSize = DEFAULT_MIN_SIZE;
        }
        if ((maxSize = dac.getGetterPoolMaxSize()) < 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0015", new String[]{Integer.toString(maxSize), Integer.toString(DEFAULT_MAX_SIZE)});
            maxSize = DEFAULT_MAX_SIZE;
        }
        if ((partitionSize = dac.getGetterPoolPartitionSize()) <= 0) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0016", new String[]{Integer.toString(partitionSize), Integer.toString(DEFAULT_PARTITION_SIZE)});
            partitionSize = DEFAULT_PARTITION_SIZE;
        }
        getterPool = new ProviderGetterPool(minSize, maxSize, true, partitionSize);
    }

    private boolean isPortlet(String channel) {
        boolean result;
        block4: {
            result = false;
            try {
                String className = this.getClassName(channel);
                if (className == null) {
                    if (debugLogger.isLoggable(Level.WARNING)) {
                        LogRecord logRecord = new LogRecord(Level.WARNING, "PSDT_CSPDC0005");
                        logRecord.setLoggerName(debugLogger.getName());
                        logRecord.setParameters(new String[]{channel});
                        debugLogger.log(logRecord);
                    }
                    return result;
                }
                result = className.endsWith("PortletWindowProvider") || className.endsWith("WSRPWindowProvider");
            }
            catch (ProviderContextException pce) {
                if (!debugLogger.isLoggable(Level.WARNING)) break block4;
                LogRecord logRecord = new LogRecord(Level.WARNING, "PSDT_CSPDC0005");
                logRecord.setLoggerName(debugLogger.getName());
                logRecord.setParameters(new String[]{channel});
                logRecord.setThrown(pce);
                debugLogger.log(logRecord);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

