/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.liberty.LibertyManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.context.ServiceContext;
import com.sun.portal.log.common.PortalLogger;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class DSAMEServiceContext
implements ServiceContext,
DSAMEConstants {
    private static Set prefetchAttrs = new HashSet();
    private static DSAMEMultiPortalConstants dmpc = DSAMEMultiPortalConstants.getInstance();
    protected DSAMEConnection dsameConn = null;
    protected static final String defaultLocaleString;
    protected static final String LOCALE_STRING = "localeString";
    protected static String serverProtocol;
    protected static String serverPort;
    protected static String serverHost;
    protected static String serverURL;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$DSAMEServiceContext;

    public void init(SSOToken ssoToken) {
        this.dsameConn = new DSAMEConnection(ssoToken);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
    }

    public void init(HttpServletRequest req) {
        this.dsameConn = new DSAMEConnection(req);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.dsameConn = new DSAMEConnection(uid, pw);
        this.dsameConn.prefetchAttributes(prefetchAttrs);
    }

    public String getLocaleString() {
        String localeString = null;
        if (ROC.containsObject(LOCALE_STRING)) {
            localeString = (String)ROC.getObject(LOCALE_STRING);
        } else {
            localeString = this.dsameConn.getAttributeFromROC("preferredlocale");
            if (localeString == null) {
                localeString = Locale.getLocaleStringFromAcceptLangHeader((String)RequestThreadLocalizer.getRequest().getHeader("accept-language"));
            }
            if (localeString == null) {
                localeString = this.dsameConn.getOrgAttributeFromROC("iPlanetAMAuthService", "iplanet-am-auth-locale");
            }
            if (localeString == null) {
                localeString = defaultLocaleString;
            }
            ROC.setObject(LOCALE_STRING, localeString);
        }
        return localeString;
    }

    public String getDesktopType() {
        return this.dsameConn.getAttributeFromROC(DSAMEServiceContext.dmpc.MP_ATTR_DESKTOP_TYPE);
    }

    public String getDefaultChannelName() {
        return this.dsameConn.getAttributeFromROC(DSAMEServiceContext.dmpc.MP_ATTR_DEFAULTCHANNELNAME);
    }

    public String getEditProviderContainerName() {
        return this.dsameConn.getAttributeFromROC(DSAMEServiceContext.dmpc.MP_ATTR_EDITPROVIDERCONTAINERNAME);
    }

    public String getDPContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpContextClassName");
    }

    public String getDPUserContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpUserContextClassName");
    }

    public String getContainerProviderContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopContainerProviderContextClassName");
    }

    public String getProviderManagerContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopProviderManagerContextClassName");
    }

    public String getPropertiesContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopPropertiesContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopTemplateContextClassName");
    }

    public String getClientContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopClientContextClassName");
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public String getLogoutURL() {
        Boolean federationEnabled = Boolean.valueOf(this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopEnableFederation"));
        StringBuffer logoutURLBuff = new StringBuffer(serverURL);
        if (federationEnabled.booleanValue()) {
            String providerID = this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopHostedProviderID");
            String metaAlias = null;
            if (providerID != null || providerID.length() != 0) {
                try {
                    metaAlias = LibertyManager.getMetaAlias((String)providerID);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "PSDT_CSPDC0034", e);
                    metaAlias = null;
                }
            }
            if (providerID == null || providerID.length() == 0 || metaAlias == null || metaAlias.length() == 0) {
                return this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-logout-url");
            }
            logoutURLBuff.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor")).append("/").append("liberty-logout").append("?").append(LibertyManager.getMetaAliasKey()).append("=").append(metaAlias);
            return logoutURLBuff.toString();
        }
        String attrLogoutURL = this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-logout-url");
        if (attrLogoutURL != null) {
            if (attrLogoutURL.indexOf("://") != -1) {
                return attrLogoutURL;
            }
            return logoutURLBuff.append(attrLogoutURL).toString();
        }
        return null;
    }

    public String getLoginURL() {
        String attrLoginURL = this.dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-login-url");
        if (attrLoginURL != null) {
            if (attrLoginURL.indexOf("://") != -1) {
                return attrLoginURL;
            }
            StringBuffer loginURLBuff = new StringBuffer(serverURL);
            return loginURLBuff.append(attrLoginURL).toString();
        }
        return null;
    }

    public String getDebugContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionContextClassName");
    }

    public String getAuthlessSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopAuthlessSessionContextClassName");
    }

    public String getWSRPSessionContextClassName() {
        return this.dsameConn.getGlobalAttributeFromROC(DSAMEServiceContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopWSRPSessionContextClassName");
    }

    public String getStringAttribute(String name) {
        return this.dsameConn.getAttributeFromROC(name);
    }

    public void setStringAttribute(String name, String val) {
        this.dsameConn.setAttribute(name, val);
    }

    public String getStringAttribute(String name, java.util.Locale locale) {
        String lang = locale.getLanguage().toLowerCase();
        String country = locale.getCountry().toLowerCase();
        String val = null;
        if (country != null && country.length() > 0) {
            val = this.getStringAttribute(name + ";lang-" + lang + "-" + country);
        }
        if (!(val != null && val.length() != 0 || (val = this.getStringAttribute(name + ";lang-" + lang)) != null && val.length() != 0)) {
            val = this.getStringAttribute(name);
        }
        return val;
    }

    public Set getRoles() {
        return this.dsameConn.getRoleDNsFromROC();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        prefetchAttrs.add(DSAMEServiceContext.dmpc.MP_ATTR_DEFAULTCHANNELNAME);
        prefetchAttrs.add(DSAMEServiceContext.dmpc.MP_ATTR_EDITPROVIDERCONTAINERNAME);
        prefetchAttrs.add(DSAMEServiceContext.dmpc.MP_ATTR_DESKTOP_TYPE);
        prefetchAttrs.add("preferredlocale");
        prefetchAttrs.add(DSAMEServiceContext.dmpc.MP_ATTR_DP_DOCUMENT_USER);
        prefetchAttrs.add(DSAMEServiceContext.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER);
        defaultLocaleString = java.util.Locale.getDefault().toString();
        serverProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
        serverPort = SystemProperties.get((String)"com.iplanet.am.server.port");
        serverHost = SystemProperties.get((String)"com.iplanet.am.server.host");
        serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$DSAMEServiceContext == null ? (class$com$sun$portal$desktop$context$DSAMEServiceContext = DSAMEServiceContext.class$("com.sun.portal.desktop.context.DSAMEServiceContext")) : class$com$sun$portal$desktop$context$DSAMEServiceContext));
    }
}

