/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.SystemProperties;
import com.sun.liberty.LibertyManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.context.ServiceAppContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.SSOUtil;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSAMEServiceAppContext
implements ServiceAppContext,
DSAMEConstants {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$DSAMEServiceAppContext == null ? (class$com$sun$portal$desktop$context$DSAMEServiceAppContext = DSAMEServiceAppContext.class$("com.sun.portal.desktop.context.DSAMEServiceAppContext")) : class$com$sun$portal$desktop$context$DSAMEServiceAppContext));
    protected static String serverProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    protected static String serverPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    protected static String serverHost = SystemProperties.get((String)"com.iplanet.am.server.host");
    protected static String serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
    private static final String ROC_AUTHORIZED_AUTHLESS_UIDS = "authorizedAuthlessUIDs";
    private static DSAMEConnection dsameConn = null;
    private static DSAMEMultiPortalConstants dmpc = null;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$DSAMEServiceAppContext;

    public synchronized void init(String portalId) {
        DSAMEMultiPortalConstants.createInstance(portalId);
        dmpc = DSAMEMultiPortalConstants.getInstance();
        this.initAdminDSAMEConnection();
    }

    protected DSAMEConnection getAdminDSAMEConnection() {
        if (dsameConn == null) {
            throw new ContextError("DSAMEServiceAppContext.getAdminDSAMEConnection(): not initialized");
        }
        return dsameConn;
    }

    private DSAMEConnection initAdminDSAMEConnection() {
        if (dsameConn == null) {
            dsameConn = new DSAMEConnection(SSOUtil.getAdminSSOToken());
        }
        return dsameConn;
    }

    public String getDebugContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDebugContextClassName");
    }

    public String getSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionAppContextClassName");
    }

    public String getAuthlessSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopAuthlessSessionAppContextClassName");
    }

    public String getWSRPSessionAppContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopWSRPSessionAppContextClassName");
    }

    public String getDesktopContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDesktopContextClassName");
    }

    public String getSessionContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionContextClassName");
    }

    public String getServiceContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopServiceContextClassName");
    }

    public String getClientContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopClientContextClassName");
    }

    public String getTemplateContextClassName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopTemplateContextClassName");
    }

    public String getNoSessionURL() {
        String noSessionURL = dsameConn.getGlobalAttributeFromROC("iPlanetAMPlatformService", "iplanet-am-platform-login-url");
        if (noSessionURL != null) {
            if (noSessionURL.indexOf("://") != -1) {
                return noSessionURL;
            }
            StringBuffer fullURL = new StringBuffer(serverURL);
            return fullURL.append(noSessionURL).toString();
        }
        return null;
    }

    public String getSessionReturnURLParamName() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionReturnURLParamName");
    }

    public Map getAuthorizedAuthlessUIDs() {
        HashMap<String, String> authorized = (HashMap<String, String>)ROC.getObject(ROC_AUTHORIZED_AUTHLESS_UIDS);
        if (authorized == null) {
            Set uidPasswordPairs = this.getAdminDSAMEConnection().getGlobalAttributeMultiValueFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopAuthorizedAuthlessUIDs");
            authorized = new HashMap<String, String>();
            Iterator i = uidPasswordPairs.iterator();
            while (i.hasNext()) {
                String pair = (String)i.next();
                int sep = pair.indexOf(124);
                if (sep != -1) {
                    authorized.put(pair.substring(0, sep).toLowerCase(), pair.substring(sep + 1));
                    continue;
                }
                authorized.put(pair.toLowerCase(), null);
            }
            ROC.setObject(ROC_AUTHORIZED_AUTHLESS_UIDS, authorized);
        }
        return authorized;
    }

    public String getDefaultAuthlessUID() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDefaultAuthlessUID");
    }

    public String getAccessURL() {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopAccessURL");
    }

    public long getReapInterval() {
        long interval = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionReapInterval"));
        return interval;
    }

    public long getInactiveMax() {
        long maxInactive = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopSessionInactiveMaximum"));
        return maxInactive;
    }

    public long getClientSessionReapInterval() {
        long interval = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopClientSessionReapInterval"));
        return interval;
    }

    public long getClientSessionInactiveMax() {
        long maxInactive = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopClientSessionInactiveMaximum"));
        return maxInactive;
    }

    public long getClientSessionsMax() {
        long sessionsMax = Long.parseLong(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopClientSessionsMaximum"));
        return sessionsMax;
    }

    public boolean isAuthlessEnabled() {
        Boolean authlessEnabled = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopEnableAuthlessDesktop"));
        return authlessEnabled;
    }

    protected boolean isAuthlessEnabledForFederatedUsers() {
        Boolean authlessDisabledForFederatedUsers = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDisableAuthlessForFederatedUsers"));
        return authlessDisabledForFederatedUsers == false;
    }

    public boolean isFederationEnabled() {
        Boolean federationEnabled = Boolean.valueOf(this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopEnableFederation"));
        return federationEnabled;
    }

    public String getPreLoginURL(String returnURL, String libertySSOFailedParamName) {
        StringBuffer preLoginURL = new StringBuffer(serverURL);
        String providerID = this.getStringAttribute("sunPortalDesktopHostedProviderID");
        String metaAlias = null;
        if (providerID != null || providerID.length() != 0) {
            try {
                metaAlias = LibertyManager.getMetaAlias((String)providerID);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "PSDT_CSPDC0034", e);
                return null;
            }
        }
        if (providerID == null || providerID.length() == 0 || metaAlias == null || metaAlias.length() == 0) {
            return null;
        }
        String deployDescriptor = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        preLoginURL.append(deployDescriptor).append("/").append("preLogin").append("?").append(LibertyManager.getMetaAliasKey()).append("=").append(metaAlias);
        if (this.isAuthlessEnabled()) {
            if (this.isAuthlessEnabledForFederatedUsers()) {
                preLoginURL.append("&").append("isPassive").append("=true");
            } else {
                preLoginURL.append("&").append("isPassive").append("=false");
            }
            preLoginURL.append("&").append("gotoOnFedCookieNo").append("=");
            StringBuffer onFedCookieNoURL = new StringBuffer(returnURL);
            if (returnURL.indexOf(63) != -1) {
                onFedCookieNoURL.append("&");
            } else {
                onFedCookieNoURL.append("?");
            }
            onFedCookieNoURL.append(libertySSOFailedParamName).append("=true");
            preLoginURL.append(URLEncoder.encode(onFedCookieNoURL.toString()));
        }
        preLoginURL.append("&goto=").append(URLEncoder.encode(returnURL));
        return preLoginURL.toString();
    }

    public String getStringAttribute(String name) {
        return this.getAdminDSAMEConnection().getGlobalAttributeFromROC(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, name);
    }

    public void setStringAttribute(String name, String val) {
        this.getAdminDSAMEConnection().setGlobalAttribute(DSAMEServiceAppContext.dmpc.MP_SUN_DESKTOP_SERVICE, name, val);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

