/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConstants;
import java.util.HashMap;
import java.util.Map;

public class DSAMEMultiPortalConstants
implements DSAMEConstants {
    private static Map instances = new HashMap(2);
    private static String loneId = null;
    public String MP_ATTR_PREFIX = "sunPortalDesktop";
    public String MP_SUN_DESKTOP_SERVICE = "SunPortalDesktopService";
    public String MP_SUN_DESKTOP_OBJECT_CLASS = "SunPortalDesktopPerson";
    public String MP_ATTR_DEFAULTCHANNELNAME = "sunPortalDesktopDefaultChannelName";
    public String MP_ATTR_EDITPROVIDERCONTAINERNAME = "sunPortalDesktopEditProviderContainerName";
    public String MP_ATTR_COMMUNITY_PARENT_CONTAINER_URL_PARAMETER = "sunPortalDesktopCommunityParentContainerURLParameter";
    public String MP_ATTR_COMMUNITY_HOME_CONTAINER_NAME = "sunPortalDesktopCommunityHomeContainerName";
    public String MP_ATTR_COMMUNITY_CREATE_CONTAINER_NAME = "sunPortalDesktopCommunityCreateContainerName";
    public String MP_ATTR_DESKTOP_TYPE = "sunPortalDesktopType";
    public String MP_ATTR_DP_DOCUMENT_USER = "sunPortalDesktopDpDocumentUser";
    public String MP_ATTR_DP_LAST_MODIFIED_USER = "sunPortalDesktopDpLastModifiedUser";

    private DSAMEMultiPortalConstants(String id) {
        this.validateId(id);
        if (!id.equals("Upgraded")) {
            id = id.trim();
            this.MP_ATTR_PREFIX = "sunPortal" + id + "Desktop";
            this.MP_SUN_DESKTOP_SERVICE = "SunPortal" + id + "DesktopService";
            this.MP_SUN_DESKTOP_OBJECT_CLASS = "SunPortal" + id + "DesktopPerson";
            this.MP_ATTR_DEFAULTCHANNELNAME = this.MP_ATTR_PREFIX + "DefaultChannelName";
            this.MP_ATTR_EDITPROVIDERCONTAINERNAME = this.MP_ATTR_PREFIX + "EditProviderContainerName";
            this.MP_ATTR_COMMUNITY_PARENT_CONTAINER_URL_PARAMETER = this.MP_ATTR_PREFIX + "CommunityParentContainerURLParameter";
            this.MP_ATTR_COMMUNITY_HOME_CONTAINER_NAME = this.MP_ATTR_PREFIX + "CommunityHomeContainerName";
            this.MP_ATTR_COMMUNITY_CREATE_CONTAINER_NAME = this.MP_ATTR_PREFIX + "CommunityCreateContainerName";
            this.MP_ATTR_DESKTOP_TYPE = this.MP_ATTR_PREFIX + "Type";
            this.MP_ATTR_DP_DOCUMENT_USER = this.MP_ATTR_PREFIX + "DpDocumentUser";
            this.MP_ATTR_DP_LAST_MODIFIED_USER = this.MP_ATTR_PREFIX + "DpLastModifiedUser";
        }
    }

    private void validateId(String id) {
        if (id == null || id.length() == 0) {
            throw new ContextError("Invalid portal identifier");
        }
        if (id.matches(".*[^a-zA-Z0-9-].*")) {
            throw new ContextError("Invalid portal identifier");
        }
    }

    public static synchronized void createInstance(String id) {
        if (!instances.containsKey(id)) {
            instances.put(id, new DSAMEMultiPortalConstants(id));
            if (instances.size() == 1) {
                loneId = id;
            }
        }
    }

    public static DSAMEMultiPortalConstants getInstance() {
        int n = instances.size();
        if (n == 0) {
            throw new ContextError("Instance does not exist");
        }
        if (n > 1) {
            throw new ContextError("Invalid use of getInstance:  More than one instance exists");
        }
        return (DSAMEMultiPortalConstants)instances.get(loneId);
    }

    public static DSAMEMultiPortalConstants getInstance(String id) {
        if (!instances.containsKey(id)) {
            throw new ContextError("Instance does not exist");
        }
        return (DSAMEMultiPortalConstants)instances.get(id);
    }
}

