/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.util.SSOUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEDPContext
implements DPContext,
DSAMEConstants {
    protected DesktopAppContext desktopAppContext = null;
    protected DSAMEConnection dsameConn = null;
    protected Map dpDocumentsLastRead = new HashMap();
    private DSAMEMultiPortalConstants dmpc = null;

    public void init(HttpServletRequest req) {
        this.desktopAppContext = DesktopAppContextThreadLocalizer.get();
        this.dmpc = DSAMEMultiPortalConstants.getInstance();
        this.dsameConn = new DSAMEConnection(SSOUtil.getAdminSSOToken());
    }

    public void init(String portalId) {
        DSAMEMultiPortalConstants.createInstance(portalId);
        this.dmpc = DSAMEMultiPortalConstants.getInstance(portalId);
        this.dsameConn = new DSAMEConnection(SSOUtil.getAdminSSOToken(), portalId);
    }

    public boolean isValidating() {
        String val = this.dsameConn.getGlobalAttributeFromROC(this.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpIsValidating");
        return Boolean.valueOf(val);
    }

    public String getNameSpaceURI() {
        return this.dsameConn.getGlobalAttributeFromROC(this.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpNamespaceURI");
    }

    public String getDPDocument(String name) {
        boolean isDesktopServiceAssigned;
        if (!this.dsameConn.isGlobal(name) && !(isDesktopServiceAssigned = this.dsameConn.isServiceAssigned(name, this.dmpc.MP_SUN_DESKTOP_SERVICE))) {
            throw new ContextError("DSAMEAdminDPContext.getDPDocument(): DesktopService not assigned to this dn : " + name);
        }
        String d = this.dsameConn.getAttributeByDNFromROC(name, "sunPortalDesktopDpDocument");
        this.setDPDocumentLastRead(name);
        return d;
    }

    public Set getDPDocumentNames(String name) {
        return this.dsameConn.getNodeNames(name);
    }

    public long getDPDocumentLastModified(String name) {
        long lastModified;
        String lm = this.dsameConn.getAttributeByDNFromROC(name, "sunPortalDesktopDpLastModified");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPDocumentLastRead(String name) {
        Long l = (Long)this.dpDocumentsLastRead.get(name);
        long lastRead = -1L;
        if (l != null) {
            lastRead = l;
        }
        return lastRead;
    }

    protected void setDPDocumentLastRead(String name) {
        Long l = new Long(System.currentTimeMillis());
        this.dpDocumentsLastRead.put(name, l);
    }
}

