/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.util.SSOUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEConnection
implements DSAMEConstants {
    public static final String ROC_NODE_NAMES = "nodeNames";
    public static final String ROC_ROLES = "roles";
    protected static final String GLOBAL_KEY = "_!global!_";
    protected AMUser user = null;
    protected AMStoreConnection connection = null;
    protected ServiceManager serviceManager = null;
    private static SSOTokenManager _tokenMgr = null;
    private static AMStoreConnection adminConnection = null;
    private SSOToken ssoToken = null;
    private static DesktopAppContext dac = null;
    private DSAMEMultiPortalConstants dmpc = null;

    public DSAMEConnection(HttpServletRequest req) {
        this(DSAMEConnection.getSSOToken(req));
        this.dmpc = DSAMEMultiPortalConstants.getInstance();
    }

    public DSAMEConnection(SSOToken token) {
        try {
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new ContextError(se, "session");
        }
        this.init(token);
        this.dmpc = DSAMEMultiPortalConstants.getInstance();
    }

    public DSAMEConnection(SSOToken token, String portalId) {
        try {
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new ContextError(se, "session");
        }
        this.init(token);
        this.dmpc = DSAMEMultiPortalConstants.getInstance(portalId);
    }

    public DSAMEConnection(String uid, String pw) {
        SSOToken token = null;
        try {
            token = SSOUtil.createSSOToken((String)uid, (String)pw);
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new ContextError(se, "session");
        }
        this.init(token);
        this.dmpc = DSAMEMultiPortalConstants.getInstance();
    }

    protected void init(SSOToken token) {
        this.ssoToken = token;
        try {
            String uid = token.getPrincipal().getName();
            this.user = this.connection.getUser(uid);
            this.serviceManager = new ServiceManager(this.ssoToken);
        }
        catch (SSOException se) {
            throw new ContextError(se, "session");
        }
        catch (SMSException smse) {
            throw new ContextError(smse);
        }
    }

    public Set getRoleDNsFromROC() {
        Set names = null;
        if (ROC.containsObject(ROC_ROLES)) {
            names = (Set)ROC.getObject(ROC_ROLES);
        } else {
            names = this.getRoleDNs();
            ROC.setObject(ROC_ROLES, names);
        }
        return names;
    }

    public Set getNodeNamesFromROC() {
        Set names = null;
        if (ROC.containsObject(ROC_NODE_NAMES)) {
            names = (Set)ROC.getObject(ROC_NODE_NAMES);
        } else {
            names = this.getNodeNames();
            ROC.setObject(ROC_NODE_NAMES, names);
        }
        return names;
    }

    public Set getNodeNames(String dn) {
        HashSet<String> names = new HashSet<String>();
        try {
            int objType = this.getAdminConnection().getAMObjectType(dn);
            switch (objType) {
                case 1: {
                    AMUser user = this.getAdminConnection().getUser(dn);
                    names.addAll(this.getUserNodeNames(user));
                    break;
                }
                case 2: {
                    AMOrganization org = this.getAdminConnection().getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("organization not found for dn: " + dn);
                    }
                    names.add(GLOBAL_KEY);
                    String rootDN = DSAMEConnection.getRootDN();
                    if (org.getDN().equals(rootDN)) break;
                    names.add(rootDN);
                    String orgDN = org.getParentDN();
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                case 6: {
                    AMRole role = this.getAdminConnection().getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.getNodeNames(): Role not found.  dn=" + dn);
                    }
                    String orgDN = role.getParentDN();
                    String rootDN = DSAMEConnection.getRootDN();
                    names.add(GLOBAL_KEY);
                    names.add(rootDN);
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                case 8: {
                    AMFilteredRole frole = this.getAdminConnection().getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("filtered role not found for dn: " + dn);
                    }
                    String orgDN = frole.getParentDN();
                    String rootDN = DSAMEConnection.getRootDN();
                    names.add(GLOBAL_KEY);
                    names.add(rootDN);
                    if (orgDN != null && orgDN.length() > 0) {
                        while (!orgDN.equals(rootDN)) {
                            AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                            names.add(orgDN);
                            orgDN = org.getParentDN();
                        }
                    }
                    break;
                }
                default: {
                    throw new ContextError("unsupported AMObject found for dn: " + dn);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("dn: " + dn, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError(sso, "session");
        }
        return names;
    }

    public Set getNodeNames() {
        Set names = this.getUserNodeNames(this.user);
        return names;
    }

    public Set getChildrenNodeNames(String dn, int level) {
        HashSet<String> names = new HashSet<String>();
        try {
            int objType = this.getAdminConnection().getAMObjectType(dn);
            switch (objType) {
                case 1: {
                    break;
                }
                case 2: {
                    AMOrganization org = this.getAdminConnection().getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.getChildrenNodeNames(): Organization not found.  dn=" + dn);
                    }
                    names.add(dn);
                    Set subOrgs = org.getSubOrganizations(level);
                    Set roles = org.getRoles(level);
                    Iterator i = subOrgs.iterator();
                    while (i.hasNext()) {
                        names.add((String)i.next());
                    }
                    i = roles.iterator();
                    while (i.hasNext()) {
                        names.add((String)i.next());
                    }
                    break;
                }
                case 6: {
                    names.add(dn);
                    break;
                }
                case 8: {
                    names.add(dn);
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.getChildrenNodeNames(): Unsupported AMObject found.  dn=" + dn);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnectoin.getChildrenNodeNames(): dn=" + dn, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn, sso, "session");
        }
        return names;
    }

    public Set getRoleDNs() {
        Set roleDNs = null;
        HashSet<String> names = new HashSet<String>();
        try {
            roleDNs = this.user.getRoleDNs();
            Iterator i = roleDNs.iterator();
            while (i.hasNext()) {
                String roleDN = (String)i.next();
                if (roleDN == null || roleDN.length() <= 0) continue;
                names.add(roleDN);
            }
            Set filteredRoleDNs = this.user.getFilteredRoleDNs();
            Iterator i2 = filteredRoleDNs.iterator();
            while (i2.hasNext()) {
                String filteredRoleDN = (String)i2.next();
                if (filteredRoleDN == null || filteredRoleDN.length() <= 0) continue;
                names.add(filteredRoleDN);
            }
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getRoleDNs(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError(ssoe, "session");
        }
        return names;
    }

    public Set getChildrenNodeNames(int level) {
        String rootDN = DSAMEConnection.getRootDN();
        return this.getChildrenNodeNames(rootDN, level);
    }

    private Set getUserNodeNames(AMUser user) {
        HashSet<String> names = new HashSet<String>();
        try {
            Set roleDNs;
            String orgDN = user.getOrganizationDN();
            String rootDN = DSAMEConnection.getRootDN();
            names.add(GLOBAL_KEY);
            names.add(rootDN);
            if (orgDN != null && orgDN.length() > 0) {
                while (!orgDN.equalsIgnoreCase(rootDN)) {
                    AMOrganization org = this.getAdminConnection().getOrganization(orgDN);
                    names.add(orgDN);
                    orgDN = org.getParentDN();
                }
            }
            if (this.user == user) {
                roleDNs = this.getRoleDNsFromROC();
                Iterator i = roleDNs.iterator();
                while (i.hasNext()) {
                    String roleDN = (String)i.next();
                    if (roleDN == null || roleDN.length() <= 0) continue;
                    names.add(roleDN);
                }
            } else {
                roleDNs = user.getRoleDNs();
                Iterator i = roleDNs.iterator();
                while (i.hasNext()) {
                    String roleDN = (String)i.next();
                    if (roleDN == null || roleDN.length() <= 0) continue;
                    names.add(roleDN);
                }
                Set filteredRoleDNs = user.getFilteredRoleDNs();
                Iterator i2 = filteredRoleDNs.iterator();
                while (i2.hasNext()) {
                    String froleDN = (String)i2.next();
                    if (froleDN == null || froleDN.length() <= 0) continue;
                    names.add(froleDN);
                }
            }
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getUserNodeNames(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError(ssoe, "session");
        }
        return names;
    }

    private AMStoreConnection getAdminConnection() {
        if (adminConnection == null) {
            try {
                adminConnection = new AMStoreConnection(SSOUtil.getAdminSSOToken());
            }
            catch (SSOException se) {
                throw new ContextError(se, "session");
            }
        }
        return adminConnection;
    }

    public String getAttributeByDN(String dn, String key) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.getAttributeByDN(): DN passed in was NULL.");
        }
        String value = null;
        try {
            if (dn.equals(GLOBAL_KEY)) {
                value = this.getGlobalAttribute(this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    AMUser u = this.connection.getUser(dn);
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.getAttributeByDN(): User not found.  dn=" + dn);
                    }
                    if (key.equals("sunPortalDesktopDpDocument")) {
                        key = this.dmpc.MP_ATTR_DP_DOCUMENT_USER;
                    } else if (key.equals("sunPortalDesktopDpLastModified")) {
                        key = this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER;
                    }
                    Set vals = u.getAttribute(key);
                    if (vals != null && vals.size() > 0) {
                        Iterator iter = vals.iterator();
                        value = (String)iter.next();
                    }
                } else {
                    value = this.getTemplateAttribute(dn, this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.getAttributeByDN(): dn=" + dn + ": ", dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn, sso, "session");
        }
        return value;
    }

    private String getTemplateAttribute(String dn, String serviceName, String key) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.getTemplateAttribute(): DN passed in was NULL.");
        }
        String value = null;
        AMTemplate temp = this.getTemplate(dn, serviceName);
        if (temp != null) {
            try {
                Set vals = temp.getAttribute(key);
                if (vals != null && vals.size() > 0) {
                    Iterator iter = vals.iterator();
                    value = (String)iter.next();
                }
            }
            catch (AMException dpe) {
                throw new ContextError("DSAMEConnection.getTemplateAttribute():  temp: " + temp + "dn=" + dn + ", serviceName=" + serviceName + ", attributeName=" + key, dpe);
            }
            catch (SSOException sso) {
                throw new ContextError("dn: " + dn + ", serviceName: " + serviceName + ", attributeName: " + key, sso, "session");
            }
        }
        return value;
    }

    public Set getTemplateAttributeMultiVal(String dn, String serviceName, String attributeName) {
        Set vals = null;
        try {
            AMTemplate temp = this.getTemplate(dn, serviceName);
            if (temp != null) {
                vals = temp.getAttribute(attributeName);
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.getTemplateAttributeMultiVal(): dn=" + dn + ", serviceName=" + serviceName + ", attributeName=" + attributeName, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", serviceName: " + serviceName + ", attributeName: " + attributeName, sso, "session");
        }
        return vals;
    }

    public void setAttributeByDN(String dn, String key, String val) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): DN passed in was NULL.");
        }
        if (key == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): attrbiute key was NULL.");
        }
        if (val == null) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): attrbiute value was NULL.");
        }
        try {
            if (dn.equals(GLOBAL_KEY)) {
                this.setGlobalAttribute(this.dmpc.MP_SUN_DESKTOP_SERVICE, key, val);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    AMUser u = this.connection.getUser(dn);
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.setAttributeByDN(): User not found: " + dn);
                    }
                    if (key.equals("sunPortalDesktopDpDocument")) {
                        key = this.dmpc.MP_ATTR_DP_DOCUMENT_USER;
                    } else if (key.equals("sunPortalDesktopDpLastModified")) {
                        key = this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER;
                    }
                    u.setStringAttribute(key, val);
                    u.store();
                } else {
                    this.setTemplateAttribute(dn, this.dmpc.MP_SUN_DESKTOP_SERVICE, key, val);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setAttributeByDN(): dn=" + dn + ", key=" + key, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", key: " + key, sso, "session");
        }
    }

    public void removeAttributeByDN(String dn, String key) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.removeAttributeByDN(): DN passed in was NULL.");
        }
        try {
            if (dn.equals(GLOBAL_KEY)) {
                this.removeGlobalAttribute(this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    AMUser u = this.connection.getUser(dn);
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.removeAttributeByDN(): User not found.  dn=" + dn);
                    }
                    HashSet<String> attrs = new HashSet<String>();
                    if (key.equals("sunPortalDesktopDpDocument")) {
                        key = this.dmpc.MP_ATTR_DP_DOCUMENT_USER;
                    } else if (key.equals("sunPortalDesktopDpLastModified")) {
                        key = this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER;
                    }
                    attrs.add(key);
                    u.removeAttributes(attrs);
                } else {
                    this.removeTemplateAttribute(dn, this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.removeAttributeByDN(): dn=" + dn, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn, sso, "session");
        }
    }

    public void setAttributesByDN(String dn, String serviceName, String key, Set vals) {
        if (dn == null) {
            throw new ContextError("DSAMEConnection.setAttributesByDN(): DN passed in was NULL.");
        }
        if (key == null) {
            throw new ContextError("DSAMEConnection.setAttributesByDN(): attrbiute key was NULL.");
        }
        if (vals == null) {
            throw new ContextError("DSAMEConnection.setAttributesByDN(): attrbiute value was NULL.");
        }
        try {
            if (dn.equals(GLOBAL_KEY)) {
                this.setGlobalAttributes(serviceName, key, vals);
            } else {
                int objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 1) {
                    AMUser u = this.connection.getUser(dn);
                    if (u == null) {
                        throw new ContextError("DSAMEConnection.setAttributesByDN(): User not found: " + dn);
                    }
                    HashMap<String, Set> map = new HashMap<String, Set>();
                    map.put(key + "User", vals);
                    u.setAttributes(map);
                    u.store();
                } else {
                    this.setTemplateAttributes(dn, serviceName, key, vals);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setAttributesByDN(): dn=" + dn + ", key=" + key, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", key: " + key, sso, "session");
        }
    }

    public String getAttribute(String attributeName) {
        String val = null;
        Set vals = this.getAttributeMultiVal(attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public byte[] getAttributeByteArray(String attributeName) {
        byte[] val = null;
        byte[][] vals = null;
        try {
            vals = this.user.getAttributeByteArray(attributeName);
        }
        catch (AMException ame) {
            throw new ContextError("DSAMEConnection.getAttributeByteArray()", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError(ssoe, "session");
        }
        if (vals != null && vals.length > 0) {
            val = vals[0];
        }
        return val;
    }

    public int getIntAttribute(String attributeName) {
        String valStr = this.getAttribute(attributeName);
        int valInt = -1;
        try {
            valInt = Integer.parseInt(valStr);
        }
        catch (NumberFormatException nfe) {
            throw new ContextError("DSAMEConnection.getIntAttribute(): Invalid integer value returned.  attribute=" + attributeName, nfe);
        }
        return valInt;
    }

    public Set getAttributeMultiVal(String attributeName) {
        Set vals = null;
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getAttributeMultiVal(): attributeName=" + attributeName, e);
        }
        return vals;
    }

    public void setAttribute(String attributeName, String val) {
        try {
            this.user.setStringAttribute(attributeName, val);
            this.user.store();
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.setAttribute(): attributeName=" + attributeName + " value=" + val + "  Exception:  ", e);
        }
    }

    public String getOrganizationAttribute(String serviceName, String attributeName) {
        String val = null;
        String dn = null;
        try {
            boolean tempExists;
            dn = this.user.getOrganizationDN();
            AMOrganization amo = null;
            int type = this.getAdminConnection().getAMObjectType(dn);
            switch (type) {
                case 2: {
                    amo = this.getAdminConnection().getOrganization(dn);
                    break;
                }
                case 3: {
                    amo = this.getAdminConnection().getOrganizationalUnit(dn);
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.getOrganizationAttribute(): unknown am object type for dn=" + dn + ", serviceName=" + serviceName);
                }
            }
            if (amo == null) {
                throw new ContextError("DSAMEConnection.getOrganizationAttribute(): org / org unit  not found, dn=" + dn + ", serviceName=" + serviceName);
            }
            AMTemplate temp = amo.getTemplate(serviceName, 302);
            boolean bl = tempExists = temp != null && temp.isExists();
            if (!tempExists) {
                throw new ContextError("DSAMEConnection.getOrganizationAttribute(): No template found.  dn=" + dn + ", serviceName=" + serviceName);
            }
            Set vals = temp.getAttribute(attributeName);
            if (vals != null && vals.size() > 0) {
                Iterator iter = vals.iterator();
                val = (String)iter.next();
            }
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getOrganizationAttribute(): dn=" + dn + "serviceName=" + serviceName + ", attributeName=" + attributeName, e);
        }
        return val;
    }

    public String getGlobalAttribute(String serviceName, String attributeName) {
        Set vals = this.getGlobalAttributeMultiVal(serviceName, attributeName);
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    public Set getGlobalAttributeMultiVal(String serviceName, String attributeName) {
        Map attrs = this.getGlobalAttributes(serviceName);
        Set vals = (Set)attrs.get(attributeName);
        return vals;
    }

    public Map getGlobalAttributes(String serviceName) {
        Map attrs = null;
        try {
            ServiceSchemaManager schemaMgr = this.serviceManager.getSchemaManager(serviceName, "1.0");
            ServiceSchema schema = schemaMgr.getGlobalSchema();
            attrs = schema.getReadOnlyAttributeDefaults();
        }
        catch (Exception ex) {
            throw new ContextError("DSAMEConnection.getGlobalAttributes(): " + serviceName, ex);
        }
        return attrs;
    }

    public void setGlobalAttribute(String serviceName, String attributeName, String val) {
        try {
            ServiceSchemaManager schemaMgr = this.serviceManager.getSchemaManager(serviceName, "1.0");
            ServiceSchema schema = schemaMgr.getGlobalSchema();
            HashSet<String> vals = new HashSet<String>();
            vals.add(val);
            schema.setAttributeDefaults(attributeName, vals);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.setGlobalAttribute(): " + serviceName + "." + attributeName + "=" + val, e);
        }
    }

    public void setGlobalAttributes(String serviceName, String attributeName, Set vals) {
        try {
            ServiceSchemaManager schemaMgr = this.serviceManager.getSchemaManager(serviceName, "1.0");
            ServiceSchema schema = schemaMgr.getGlobalSchema();
            schema.setAttributeDefaults(attributeName, vals);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.setGlobalAttributes(): " + serviceName + "." + attributeName + "=" + vals, e);
        }
    }

    public void removeGlobalAttribute(String serviceName, String attributeName) {
        HashSet<String> attrs = new HashSet<String>();
        attrs.add(attributeName);
        try {
            ServiceSchemaManager schemaMgr = this.serviceManager.getSchemaManager(serviceName, "1.0");
            ServiceSchema schema = schemaMgr.getGlobalSchema();
            schema.removeAttributeDefaults(attrs);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.removeGlobalAttribute(): " + serviceName + "." + attributeName, e);
        }
    }

    public String getPolicyAttribute(String attributeName) {
        Set vals = null;
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (Exception e) {
            throw new ContextError("DSAMEConnection.getPolicyAttribute(): " + attributeName, e);
        }
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    private AMTemplate getTemplate(String dn, String serviceName) {
        int objType = -1;
        AMTemplate temp = null;
        try {
            boolean tempExists;
            objType = this.getAdminConnection().getAMObjectType(dn);
            if (objType == 2) {
                AMOrganization org = this.getAdminConnection().getOrganization(dn);
                if (org == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = org.getTemplate(serviceName, 301);
            } else if (objType == 6) {
                AMRole role = this.getAdminConnection().getRole(dn);
                if (role == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = role.getTemplate(serviceName, 301);
            } else if (objType == 8) {
                AMFilteredRole frole = this.getAdminConnection().getFilteredRole(dn);
                if (frole == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = frole.getTemplate(serviceName, 301);
            } else if (objType == 3) {
                AMOrganizationalUnit ou = this.getAdminConnection().getOrganizationalUnit(dn);
                if (ou == null) {
                    throw new ContextError("DSAMEConnection.getTemplateAttribute(): ou not found.  dn=" + dn + ", serviceName=" + serviceName);
                }
                temp = ou.getTemplate(serviceName, 301);
            } else {
                throw new ContextError("DSAMEConnection.getTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName + ", objectType=" + objType);
            }
            boolean bl = tempExists = temp != null && temp.isExists();
            if (!tempExists) {
                return null;
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.getTemplateAttribute(): dn=" + dn + ", serviceName=" + serviceName, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", serviceName: " + serviceName, sso, "session");
        }
        return temp;
    }

    private void setTemplateAttribute(String dn, String serviceName, String attributeName, String val) {
        try {
            int objType = this.connection.getAMObjectType(dn);
            switch (objType) {
                case 2: {
                    boolean tempExists;
                    AMOrganization org = this.connection.getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = org.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        org.createTemplate(301, serviceName, null);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                case 6: {
                    boolean tempExists;
                    AMRole role = this.connection.getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = role.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        role.createTemplate(301, serviceName, null);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                case 8: {
                    boolean tempExists;
                    AMFilteredRole frole = this.connection.getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = frole.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        frole.createTemplate(301, serviceName, null);
                    }
                    temp.setStringAttribute(attributeName, val);
                    temp.store();
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.setTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName + "=" + val, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", serviceName: " + serviceName + ", " + attributeName + "=" + val, sso, "session");
        }
    }

    private void setTemplateAttributes(String dn, String serviceName, String attributeName, Set vals) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attributeName, vals);
        try {
            int objType = this.connection.getAMObjectType(dn);
            switch (objType) {
                case 2: {
                    boolean tempExists;
                    AMOrganization org = this.connection.getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttributes(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = org.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        org.createTemplate(301, serviceName, null);
                    }
                    temp.setAttributes(map);
                    temp.store();
                    break;
                }
                case 6: {
                    boolean tempExists;
                    AMRole role = this.connection.getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttributes(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = role.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        role.createTemplate(301, serviceName, null);
                    }
                    temp.setAttributes(map);
                    temp.store();
                    break;
                }
                case 8: {
                    boolean tempExists;
                    AMFilteredRole frole = this.connection.getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.setTemplateAttributes(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = frole.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        frole.createTemplate(301, serviceName, null);
                    }
                    temp.setAttributes(map);
                    temp.store();
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.setTemplateAttributes(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.setTemplateAttributes(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName + "=" + vals, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", serviceName: " + serviceName + ", " + attributeName + "=" + vals, sso, "session");
        }
    }

    private void removeTemplateAttribute(String dn, String serviceName, String attributeName) {
        try {
            int objType = this.connection.getAMObjectType(dn);
            HashSet<String> attrs = new HashSet<String>();
            attrs.add(attributeName);
            switch (objType) {
                case 2: {
                    boolean tempExists;
                    AMOrganization org = this.connection.getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Organization not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = org.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        org.createTemplate(301, serviceName, null);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                case 6: {
                    boolean tempExists;
                    AMRole role = this.connection.getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = role.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        role.createTemplate(301, serviceName, null);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                case 8: {
                    boolean tempExists;
                    AMFilteredRole frole = this.connection.getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.removeTemplateAttribute(): filtered role not found.  dn=" + dn + ", serviceName=" + serviceName);
                    }
                    AMTemplate temp = frole.getTemplate(serviceName, 301);
                    boolean bl = tempExists = temp != null && temp.isExists();
                    if (!tempExists) {
                        frole.createTemplate(301, serviceName, null);
                    }
                    temp.removeAttributes(attrs);
                    temp.store();
                    break;
                }
                default: {
                    throw new ContextError("DSAMEConnection.removeTemplateAttribute(): Unsupported AMObject found.  dn=" + dn + ", serviceName=" + serviceName);
                }
            }
        }
        catch (AMException dpe) {
            throw new ContextError("DSAMEConnection.removeTemplateAttribute(): , dn=" + dn + ", serviceName= " + serviceName + ", " + attributeName, dpe);
        }
        catch (SSOException sso) {
            throw new ContextError("dn: " + dn + ", serviceName: " + serviceName + ", " + attributeName, sso, "session");
        }
    }

    protected static SSOToken getSSOToken(HttpServletRequest request) {
        SSOToken token = null;
        try {
            token = DSAMEConnection.getSSOTokenManager().createSSOToken(request);
        }
        catch (SSOException se) {
            throw new ContextError("Failed to get SSOToken", se, "session");
        }
        return token;
    }

    protected static SSOTokenManager getSSOTokenManager() {
        if (_tokenMgr == null) {
            try {
                _tokenMgr = SSOTokenManager.getInstance();
                if (_tokenMgr == null) {
                    throw new ContextError("DSAMEConnection.getSSOTokenMgr(): Failed to get SSOTokenManager. ");
                }
            }
            catch (SSOException se) {
                throw new ContextError("failed to get SSOTokenManager", se, "session");
            }
        }
        return _tokenMgr;
    }

    public static String getRootDN() {
        return SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    }

    public void prefetchAttributes(Set names) {
        try {
            this.user.getAttributes(names);
        }
        catch (AMException dpe) {
            throw new ContextError("DAMEConnection.prefetchAttributes(): names=" + names, dpe);
        }
        catch (SSOException ssoe) {
            throw new ContextError("names=" + names, ssoe, "session");
        }
    }

    public String getAttributeFromROC(String key) {
        String v = null;
        if (ROC.containsObject(key)) {
            v = (String)ROC.getObject(key);
        } else {
            v = this.getAttribute(key);
            ROC.setObject(key, v);
        }
        return v;
    }

    public byte[] getAttributeByteArrayFromROC(String key) {
        byte[] v = null;
        if (ROC.containsObject(key)) {
            v = (byte[])ROC.getObject(key);
        } else {
            v = this.getAttributeByteArray(key);
            ROC.setObject(key, v);
        }
        return v;
    }

    public String getOrgAttributeFromROC(String service, String key) {
        String s = null;
        if (ROC.containsObject(key)) {
            s = (String)ROC.getObject(key);
        } else {
            s = this.getOrganizationAttribute(service, key);
            ROC.setObject(key, s);
        }
        return s;
    }

    protected String getGlobalAttributeFromROC(String service, String key) {
        Set vals = this.getGlobalAttributeMultiValueFromROC(service, key);
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    protected Set getGlobalAttributeMultiValueFromROC(String service, String key) {
        String rocKey = service + "." + key;
        Map attrs = (Map)ROC.getObject(rocKey);
        if (attrs == null) {
            attrs = this.getGlobalAttributes(service);
            ROC.setObject(rocKey, attrs);
        }
        Set vals = (Set)attrs.get(key);
        return vals;
    }

    public String getAttributeByDNFromROC(String dn, String key) {
        String value = null;
        if (dn.equals(GLOBAL_KEY)) {
            value = this.getGlobalAttributeFromROC(this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
        } else {
            int objType;
            try {
                objType = this.getAdminConnection().getAMObjectType(dn);
            }
            catch (AMException ame) {
                throw new ContextError("DSAMEConnection.getAttrbiuteByDNFromROC()", ame);
            }
            catch (SSOException ssoe) {
                throw new ContextError(ssoe, "session");
            }
            if (objType == 1) {
                if (key.equals("sunPortalDesktopDpDocument")) {
                    key = this.dmpc.MP_ATTR_DP_DOCUMENT_USER;
                } else if (key.equals("sunPortalDesktopDpLastModified")) {
                    key = this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER;
                }
                value = this.getAttributeFromROC(key);
            } else {
                value = this.getTemplateAttribute(dn, this.dmpc.MP_SUN_DESKTOP_SERVICE, key);
            }
        }
        return value;
    }

    public boolean isGlobal(String dn) {
        return dn.equals(GLOBAL_KEY);
    }

    public boolean isServiceAssigned(String dn, String serviceName) {
        boolean isServiceAssigned;
        block16: {
            Set services = null;
            int objType = -1;
            isServiceAssigned = false;
            try {
                objType = this.getAdminConnection().getAMObjectType(dn);
                if (objType == 2) {
                    AMOrganization org = this.getAdminConnection().getOrganization(dn);
                    if (org == null) {
                        throw new ContextError("DSAMEConnection.isServiceAssigned(): Organization not found.  dn=" + dn);
                    }
                    services = org.getRegisteredServiceNames();
                    if (services != null && services.contains(serviceName)) {
                        isServiceAssigned = true;
                    }
                    break block16;
                }
                if (objType == 6) {
                    AMRole role = this.getAdminConnection().getRole(dn);
                    if (role == null) {
                        throw new ContextError("DSAMEConnection.isServiceAssigned(): Role not found.  dn=" + dn);
                    }
                    String orgDN = role.getOrganizationDN();
                    isServiceAssigned = this.isServiceAssigned(orgDN, serviceName);
                    break block16;
                }
                if (objType == 8) {
                    AMFilteredRole frole = this.getAdminConnection().getFilteredRole(dn);
                    if (frole == null) {
                        throw new ContextError("DSAMEConnection.isServiceAssigned(): filtered role not found.  dn=" + dn);
                    }
                    String orgDN = frole.getOrganizationDN();
                    isServiceAssigned = this.isServiceAssigned(orgDN, serviceName);
                    break block16;
                }
                if (objType == 3) {
                    AMOrganizationalUnit ou = this.getAdminConnection().getOrganizationalUnit(dn);
                    if (ou == null) {
                        throw new ContextError("DSAMEConnection.isServiceAssigned(): ou not found.  dn=" + dn);
                    }
                    services = ou.getRegisteredServiceNames();
                    if (services != null && services.contains(serviceName)) {
                        isServiceAssigned = true;
                    }
                    break block16;
                }
                if (objType == 1) {
                    AMUser usr = this.getAdminConnection().getUser(dn);
                    if (usr == null) {
                        throw new ContextError("DSAMEConnection.isServiceAssigned(): user not found.  dn=" + dn);
                    }
                    services = usr.getAssignedServices();
                    if (services != null && services.contains(serviceName)) {
                        isServiceAssigned = true;
                    }
                    break block16;
                }
                throw new ContextError("DSAMEConnection.isServiceAssigned(): Unsupported AMObject found.  dn=" + dn + ", objectType=" + objType);
            }
            catch (AMException dpe) {
                throw new ContextError("DSAMEConnection.isServiceAssigned(): dn=" + dn, dpe);
            }
            catch (SSOException sso) {
                throw new ContextError("dn: " + dn, sso, "session");
            }
        }
        return isServiceAssigned;
    }
}

