/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

class DSAMEClientContext
implements ClientContext {
    protected AMClientDetector cd = null;
    private static final String CLIENT_OBJECT = "clientObject.";
    private static final String DSAME_KEY_COOKIE_SUPPORT = "cookieSupport";
    private static final String DSAME_COOKIE_SUPPORT_TRUE = "true";
    private static final String DSAME_COOKIE_SUPPORT_FALSE = "false";
    private static Map AUTHLESS_STATES = null;
    private static DesktopAppContext dac = null;
    private static Logger debugLogger;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$DSAMEClientContext;

    public void init() {
        this.cd = new AMClientDetector();
    }

    private Client getClient(String clientType) {
        String clientObjectKey = CLIENT_OBJECT + clientType;
        Client client = (Client)ROC.getObject(clientObjectKey);
        if (client == null) {
            try {
                client = Client.getInstance((String)clientType);
            }
            catch (ClientException c) {
                throw new ContextError("DSAMEDPContext.init(): can not get client instance", c);
            }
            ROC.setObject(clientObjectKey, client);
        }
        return client;
    }

    public String getContentType(String clientType) {
        return this.getClientTypeProperty(clientType, "contentType");
    }

    public String getClientPath(String clientType) {
        return this.getClientTypeProperty(clientType, "filePath");
    }

    public String getClientType(HttpServletRequest req) {
        return this.cd.getClientType(req);
    }

    public String getDefaultClientType() {
        Client cli = Client.getDefaultInstance();
        return cli.getClientType();
    }

    public String getClientTypeProperty(String clientType, String key) {
        Client client = this.getClient(clientType);
        return client.getProperty(key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        Client client = this.getClient(clientType);
        Set properties = client.getProperties(key);
        return properties;
    }

    public String getCharset(String clientType, Locale locale) {
        Client client = this.getClient(clientType);
        return client.getCharset(locale);
    }

    public short getCookieSupport(String clientType) {
        Client client = this.getClient(clientType);
        String cookieSupport = client.getProperty(DSAME_KEY_COOKIE_SUPPORT);
        int retval = 2;
        debugLogger.log(Level.FINE, "PSDT_CSPDC0003", cookieSupport);
        if (cookieSupport != null) {
            retval = cookieSupport.equalsIgnoreCase(DSAME_COOKIE_SUPPORT_TRUE) ? 1 : (cookieSupport.equalsIgnoreCase(DSAME_COOKIE_SUPPORT_FALSE) ? 0 : 2);
        }
        return (short)retval;
    }

    private short getDefaultAuthlessState(String clientType) {
        boolean genericHTML = false;
        String property = this.getClientTypeProperty(clientType, "genericHTML");
        if (property != null) {
            genericHTML = property.equals(DSAME_COOKIE_SUPPORT_TRUE);
        } else if (clientType.equals("genericHTML")) {
            genericHTML = true;
        }
        if (genericHTML) {
            return 2;
        }
        return 3;
    }

    public short getAuthlessState(String clientType) {
        Client client = this.getClient(clientType);
        String authlessState = client.getProperty("authlessState");
        if (authlessState == null || authlessState.length() == 0) {
            return this.getDefaultAuthlessState(clientType);
        }
        Short as = (Short)AUTHLESS_STATES.get(authlessState);
        if (as == null) {
            return this.getDefaultAuthlessState(clientType);
        }
        return as;
    }

    public String getEncoderClassName(String clientType) {
        Client client = this.getClient(clientType);
        String cn = client.getProperty("encoderClassName");
        if (cn != null && cn.length() != 0) {
            return cn;
        }
        return "com.sun.portal.desktop.encode.HTMLEncoder";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AUTHLESS_STATES = new HashMap();
        AUTHLESS_STATES.put("none", new Short(3));
        AUTHLESS_STATES.put("server", new Short(1));
        AUTHLESS_STATES.put("client", new Short(2));
        dac = DesktopAppContextThreadLocalizer.get();
        debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$DSAMEClientContext == null ? (class$com$sun$portal$desktop$context$DSAMEClientContext = DSAMEClientContext.class$("com.sun.portal.desktop.context.DSAMEClientContext")) : class$com$sun$portal$desktop$context$DSAMEClientContext));
    }
}

