/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.util.ResourceLoader;
import com.sun.portal.util.SSOUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEAdminDPContext
implements AdminDPContext,
DSAMEConstants {
    protected DSAMEConnection dsameConn = null;
    protected Map dpDocumentsLastRead = new HashMap();
    protected Map dpDocumentsLastReadPerPortal = new HashMap();
    private static DSAMEMultiPortalConstants dmpc = null;
    private String portalId = null;

    public void init(HttpServletRequest req) {
        SSOToken ssoToken = DSAMEConnection.getSSOToken(req);
        this.dsameConn = new DSAMEConnection(ssoToken);
        dmpc = DSAMEMultiPortalConstants.getInstance();
        this.portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
    }

    public void init(HttpServletRequest req, SSOToken ssoToken) {
        this.dsameConn = new DSAMEConnection(ssoToken);
        dmpc = DSAMEMultiPortalConstants.getInstance();
        this.portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.dsameConn = new DSAMEConnection(uid, pw);
        dmpc = DSAMEMultiPortalConstants.getInstance();
        this.portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
    }

    public void init(String uid, String password, String propertiesFile, String portalId) {
        DSAMEMultiPortalConstants.createInstance(portalId);
        dmpc = DSAMEMultiPortalConstants.getInstance(portalId);
        this.portalId = portalId;
        SSOToken ssoToken = null;
        try {
            ssoToken = SSOUtil.createSSOToken((String)uid, (String)password);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEAdminContext.init(): Failed to create SSOToken.  ", se);
        }
        this.dsameConn = new DSAMEConnection(ssoToken, portalId);
    }

    public void init(SSOToken ssoToken, String propertiesFile, String portalId) {
        DSAMEMultiPortalConstants.createInstance(portalId);
        dmpc = DSAMEMultiPortalConstants.getInstance(portalId);
        this.portalId = portalId;
        this.dsameConn = new DSAMEConnection(ssoToken, portalId);
    }

    public boolean isValidating() {
        return true;
    }

    public String getNameSpaceURI() {
        return this.dsameConn.getGlobalAttribute(DSAMEAdminDPContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpNamespaceURI");
    }

    public synchronized Locale getLocale() {
        return Locale.getDefault();
    }

    public Set getAllNamesFromBase(String base, int level, boolean includeParent) {
        Set allNodeNames = this.dsameConn.getChildrenNodeNames(base, level);
        if (includeParent) {
            Set allParentNodeNames = this.getDPDocumentNames(base);
            allNodeNames.addAll(allParentNodeNames);
        }
        return allNodeNames;
    }

    public Set getAllNames(int level) {
        Set childrenNodeNames = this.dsameConn.getChildrenNodeNames(level);
        Set allNodeNames = this.getDPDocumentNames();
        Iterator i = childrenNodeNames.iterator();
        while (i.hasNext()) {
            allNodeNames.add((String)i.next());
        }
        return allNodeNames;
    }

    public Set getDPDocumentNames() {
        return this.dsameConn.getNodeNames();
    }

    public Set getDPDocumentNames(String name) {
        return this.dsameConn.getNodeNames(name);
    }

    public String getDPDocument(String name) {
        boolean isDesktopServiceAssigned;
        if (!this.isGlobal(name) && !(isDesktopServiceAssigned = this.dsameConn.isServiceAssigned(name, DSAMEAdminDPContext.dmpc.MP_SUN_DESKTOP_SERVICE))) {
            throw new ContextError("DSAMEAdminDPContext.getDPDocument(): DesktopService not assigned to this dn : " + name);
        }
        String dp = this.dsameConn.getAttributeByDN(name, "sunPortalDesktopDpDocument");
        if (dp != null) {
            this.setDPDocumentLastRead(name);
        }
        return dp;
    }

    public String getGlobalDPDocument() {
        String dp = this.dsameConn.getGlobalAttribute(DSAMEAdminDPContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpDocument");
        if (dp != null) {
            this.setDPDocumentLastRead("_!global!_");
        }
        return dp;
    }

    public boolean isGlobal(String base) {
        return this.dsameConn.isGlobal(base);
    }

    public String getDPDocumentByDN(String dn) {
        return this.getDPDocument(dn);
    }

    protected void setDPDocumentLastModified(String name) {
        this.dsameConn.setAttributeByDN(name, "sunPortalDesktopDpLastModified", Long.toString(System.currentTimeMillis()));
    }

    public void storeDPDocument(String name, String dp) {
        if (dp == null) {
            throw new ContextError("DSAMEAdminDPContext.storeDPDocumentByDN(): Passed in DP doc is null. ");
        }
        this.dsameConn.setAttributeByDN(name, "sunPortalDesktopDpDocument", dp);
        this.setDPDocumentLastModified(name);
        this.setDPDocumentLastRead(name);
    }

    public void storeDPDocumentByDN(String dn, String dp) {
        this.storeDPDocument(dn, dp);
    }

    public void storeGlobalDPDocument(String dp) {
        this.dsameConn.setGlobalAttribute(DSAMEAdminDPContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpDocument", dp);
        this.setDPDocumentLastModified("_!global!_");
        this.setDPDocumentLastRead("_!global!_");
    }

    public void removeDPDocument(String name) {
        this.dsameConn.removeAttributeByDN(name, "sunPortalDesktopDpDocument");
        this.setDPDocumentLastModified(name);
        this.setDPDocumentLastRead(name);
    }

    public void removeDPDocumentByDN(String dn) {
        this.removeDPDocument(dn);
    }

    public void removeGlobalDPDocument() {
        this.dsameConn.removeGlobalAttribute(DSAMEAdminDPContext.dmpc.MP_SUN_DESKTOP_SERVICE, "sunPortalDesktopDpDocument");
        this.setDPDocumentLastModified("_!global!_");
        this.setDPDocumentLastRead("_!global!_");
    }

    protected void setDPDocumentLastRead(String name) {
        Long l = new Long(System.currentTimeMillis());
        this.dpDocumentsLastRead.put(name, l);
        this.dpDocumentsLastReadPerPortal.put(this.portalId, this.dpDocumentsLastRead);
    }

    public long getDPDocumentLastModified(String name) {
        long lastModified;
        String lm = this.dsameConn.getAttributeByDN(name, "sunPortalDesktopDpLastModified");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPDocumentLastRead(String name) {
        Long l = null;
        if (this.dpDocumentsLastReadPerPortal.containsKey(this.portalId)) {
            this.dpDocumentsLastRead = (Map)this.dpDocumentsLastReadPerPortal.get(this.portalId);
            l = (Long)this.dpDocumentsLastRead.get(name);
        }
        long lastRead = -1L;
        if (l != null) {
            lastRead = l;
        }
        return lastRead;
    }

    public String getDTAttribute(String baseName, String name) {
        return this.dsameConn.getAttributeByDN(baseName, name);
    }

    public void setDTAttribute(String baseName, String name, String val) {
        this.dsameConn.setAttributeByDN(baseName, name, val);
    }

    public Set getGlobalAttributeMultiVal(String serviceName, String name) {
        return this.dsameConn.getGlobalAttributeMultiVal(serviceName, name);
    }

    public Set getAttributeMultiVal(String baseName, String serviceName, String name) {
        return this.dsameConn.getTemplateAttributeMultiVal(baseName, serviceName, name);
    }

    public void setGlobalAttributeMultiVal(String serviceName, String name, Set vals) {
        this.dsameConn.setGlobalAttributes(serviceName, name, vals);
    }

    public void setAttributeMultiVal(String baseName, String serviceName, String name, Set vals) {
        this.dsameConn.setAttributesByDN(baseName, serviceName, name, vals);
    }
}

