/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.community.mc.CMCException;
import com.sun.portal.community.mc.CMCUser;
import com.sun.portal.community.mc.ConfigTable;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DPCacheManager {
    public static final int DP_SCAN_INTERVAL_NEVER = -1;
    public static final int DP_SCAN_INTERVAL_ALWAYS = 0;
    private static Map dpRootsUser = Collections.synchronizedMap(new HashMap());
    private static Map dpRootsUserCustomized = Collections.synchronizedMap(new HashMap());
    private static Map lastReadTimesDPUserDocuments = Collections.synchronizedMap(new HashMap());
    private static Map dpRootsShared = Collections.synchronizedMap(new HashMap());
    private static ConfigTable lastReadTimesDPSharedDocuments = new ConfigTable(Collections.synchronizedMap(new HashMap()));
    private static Map lastScanTimesDPSharedDocuments = Collections.synchronizedMap(new HashMap());
    private static Map dpRootsDummyUser = Collections.synchronizedMap(new HashMap());
    private static Map lastUpdateTimesDPRootsDummyUser = Collections.synchronizedMap(new HashMap());

    public static DPRoot getUserDPRoot(String uid) {
        return (DPRoot)dpRootsUser.get(uid);
    }

    public static void putUserDPRoot(String uid, DPRoot dpRoot) {
        dpRootsUser.put(uid, dpRoot);
        dpRootsUserCustomized.put(uid, Boolean.TRUE);
        lastReadTimesDPUserDocuments.put(uid, new Long(System.currentTimeMillis()));
    }

    public static void removeUserDPRoot(String uid) {
        dpRootsUser.remove(uid);
        dpRootsUserCustomized.remove(uid);
        lastReadTimesDPUserDocuments.remove(uid);
    }

    public static void setUserDocumentLastRead(String uid) {
        lastReadTimesDPUserDocuments.put(uid, new Long(System.currentTimeMillis()));
    }

    public static long getUserDocumentLastRead(String uid) {
        Long lastRead = (Long)lastReadTimesDPUserDocuments.get(uid);
        if (lastRead != null) {
            return lastRead;
        }
        return -1L;
    }

    public static void setCustomized(String uid, boolean state) {
        dpRootsUserCustomized.put(uid, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean hasCustomized(String uid) {
        Boolean customized = (Boolean)dpRootsUserCustomized.get(uid);
        if (customized != null) {
            return customized;
        }
        return false;
    }

    private static String getDummyDPRootKey(Set membership) {
        return membership.toString();
    }

    private static DPRoot getDummyUserDPRoot(String uniqueKey) {
        return (DPRoot)dpRootsDummyUser.get(uniqueKey);
    }

    private static void putDummyUserDPRoot(String uniqueKey, DPRoot dpRoot) {
        dpRootsDummyUser.put(uniqueKey, dpRoot);
        lastUpdateTimesDPRootsDummyUser.put(uniqueKey, new Long(System.currentTimeMillis()));
    }

    private static void removeDummyUserDPRoot(String uniqueKey) {
        lastUpdateTimesDPRootsDummyUser.remove(uniqueKey);
        dpRootsDummyUser.remove(uniqueKey);
    }

    private static DPRoot getSharedDPRoot(ConfigTable.ConfigKey configKey) {
        return (DPRoot)dpRootsShared.get(configKey);
    }

    private static void putSharedDPRoot(ConfigTable.ConfigKey configKey, DPRoot dpRoot) {
        dpRootsShared.put(configKey, dpRoot);
    }

    private static List getMergers(Set configKeys) {
        ArrayList<DPRoot> mergers = new ArrayList<DPRoot>();
        Iterator iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
            DPRoot dpr = DPCacheManager.getSharedDPRoot(configKey);
            if (dpr == null) continue;
            mergers.add(dpr);
        }
        return mergers;
    }

    private static void updateDummyUserDPRoots(DPContext dpc, Set setMembership) {
        TreeSet copySetMembership = new TreeSet();
        copySetMembership.addAll(setMembership);
        ConfigTable.ConfigKey[] memberships = copySetMembership.toArray(new ConfigTable.ConfigKey[copySetMembership.size()]);
        int i = memberships.length - 1;
        while (!copySetMembership.isEmpty()) {
            XMLDPRoot dpRootDummyUser = new XMLDPRoot(dpc);
            List mergers = DPCacheManager.getMergers(copySetMembership);
            dpRootDummyUser.addMergers(mergers);
            String uniqueKey = DPCacheManager.getDummyDPRootKey(copySetMembership);
            DPCacheManager.putDummyUserDPRoot(uniqueKey, dpRootDummyUser);
            copySetMembership.remove(memberships[i--]);
        }
    }

    private static void updateSharedDPRoots(DPContext dpc, ConfigTable configTable, Set membership) {
        Set configKeys = configTable.getConfigKeys();
        Iterator iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
            byte[] dp = (byte[])configTable.get(configKey);
            ByteArrayInputStream is = new ByteArrayInputStream(dp);
            XMLDPRoot dprMerger = new XMLDPRoot(dpc, is);
            DPCacheManager.putSharedDPRoot(configKey, dprMerger);
        }
        DPCacheManager.updateDummyUserDPRoots(dpc, membership);
    }

    private static Set getFetchOrScanMembership(Set effectiveMembership, int dpScanInterval) {
        if (dpScanInterval == 0) {
            return effectiveMembership;
        }
        TreeSet<ConfigTable.ConfigKey> result = new TreeSet<ConfigTable.ConfigKey>();
        if (dpScanInterval == -1) {
            Iterator iterator = effectiveMembership.iterator();
            while (iterator.hasNext()) {
                ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
                if (lastScanTimesDPSharedDocuments.get(configKey) != null) continue;
                result.add(configKey);
            }
        } else {
            long currentTime = System.currentTimeMillis();
            Iterator iterator = effectiveMembership.iterator();
            while (iterator.hasNext()) {
                ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
                Long lastScanTime = (Long)lastScanTimesDPSharedDocuments.get(configKey);
                if (lastScanTime == null) {
                    result.add(configKey);
                    continue;
                }
                if (currentTime - lastScanTime <= (long)(dpScanInterval * 1000)) continue;
                result.add(configKey);
            }
        }
        return result.size() == 0 ? null : result;
    }

    private static void updateSharedDPDocumentsScanTimes(Set scanMembership, int dpScanInterval) {
        if (scanMembership == null) {
            return;
        }
        if (dpScanInterval == 0) {
            return;
        }
        Long currentTime = new Long(System.currentTimeMillis());
        Iterator iterator = scanMembership.iterator();
        while (iterator.hasNext()) {
            ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
            lastScanTimesDPSharedDocuments.put(configKey, currentTime);
        }
    }

    private static boolean checkDPRootDummyUserForUpdate(int dpScanInterval, String uniqueKey, Set effectiveMembership) {
        if (dpScanInterval == -1) {
            return false;
        }
        boolean modified = false;
        Long lastDPRootDummyUserUpdateTime = (Long)lastUpdateTimesDPRootsDummyUser.get(uniqueKey);
        if (lastDPRootDummyUserUpdateTime == null) {
            return modified;
        }
        if (effectiveMembership != null) {
            Iterator iterator = effectiveMembership.iterator();
            while (iterator.hasNext()) {
                ConfigTable.ConfigKey configKey = (ConfigTable.ConfigKey)iterator.next();
                Long lastReadTimeDPSharedDocument = (Long)lastReadTimesDPSharedDocuments.get(configKey);
                if (lastReadTimeDPSharedDocument == null || lastReadTimeDPSharedDocument <= lastDPRootDummyUserUpdateTime) continue;
                modified = true;
                break;
            }
        }
        return modified;
    }

    public static boolean sharedDPRootsModified(CMCUser cu, Set effectiveMembership, DPContext dpc, int dpScanInterval) {
        boolean modified = false;
        ConfigTable configTable = null;
        String uniqueKey = DPCacheManager.getDummyDPRootKey(effectiveMembership);
        Set fetchOrScanMembership = DPCacheManager.getFetchOrScanMembership(effectiveMembership, dpScanInterval);
        if (fetchOrScanMembership != null) {
            try {
                configTable = cu.getDPDocuments(lastReadTimesDPSharedDocuments, fetchOrScanMembership);
                DPCacheManager.updateSharedDPDocumentsScanTimes(effectiveMembership, dpScanInterval);
                if (configTable.size() > 0) {
                    DPCacheManager.removeDummyUserDPRoot(uniqueKey);
                    DPCacheManager.updateSharedDPRoots(dpc, configTable, effectiveMembership);
                    modified = true;
                }
            }
            catch (CMCException e) {
                throw new ContextError("DPCacheManager.sharedDPRootsModified()", e);
            }
        }
        if (!modified && (modified = DPCacheManager.checkDPRootDummyUserForUpdate(dpScanInterval, uniqueKey, effectiveMembership))) {
            DPCacheManager.removeDummyUserDPRoot(uniqueKey);
        }
        return modified;
    }

    private static void addMergers(DPRoot dpRoot, Set membership) {
        List mergers = DPCacheManager.getMergers(membership);
        dpRoot.addMergers(mergers);
    }

    public static DPRoot getDPRoot(Set effectiveMembership, DPContext dpc, DPUserContext dpuc, boolean personalize) {
        String uniqueKey;
        DPRoot dpRootDummyUser;
        DPRoot result = null;
        if (!personalize && (dpRootDummyUser = DPCacheManager.getDummyUserDPRoot(uniqueKey = DPCacheManager.getDummyDPRootKey(effectiveMembership))) != null) {
            result = dpRootDummyUser;
        }
        if (result == null) {
            byte[] userDoc = dpuc.getDPUserDocument();
            if (userDoc == null || userDoc.length == 0) {
                result = new XMLDPRoot(dpc);
            } else {
                ByteArrayInputStream s = new ByteArrayInputStream(userDoc);
                result = new XMLDPRoot(dpc, s);
            }
            DPCacheManager.addMergers(result, effectiveMembership);
            if (!personalize) {
                String uniqueKey2 = DPCacheManager.getDummyDPRootKey(effectiveMembership);
                DPCacheManager.putDummyUserDPRoot(uniqueKey2, result);
            }
        }
        return result;
    }
}

