/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionAppContext;
import com.sun.portal.desktop.context.SessionContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.util.Base64;
import com.sun.portal.desktop.util.PIParser;
import com.sun.portal.log.common.PortalLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthlessSessionContext
implements SessionContext,
SessionAppContext {
    private static final String ROC_COOKIES = "cookies";
    private static final short MODE_COOKIE = 0;
    private static final short MODE_URL = 1;
    private static final short MODE_BOTH = 2;
    private static final String KEY_COOKIE_DETECT = "_eikooc_tceted_";
    private static final String COOKIE_DETECT_VALUE = "check";
    private static final String ATTR_COOKIE_DETECT = "com.sun.portal.desktop.context.authless.cookiedetect";
    private static final String ATTR_COOKIE_SUPPORT_MODE = "com.sun.portal.desktop.context.authless.cookiesupport";
    private static final String ROC_SUID = "suid";
    private static final String SUID;
    private static final String CLIENT_SID;
    private static final String ROC_CLIENT_SID = "clientSID";
    private static final String CLIENT_PROPERTIES;
    private static final String ROC_CLIENT_PROPERTIES = "clientProperties";
    private static final String ROC_SESSION_VALID = "sessionValid";
    private static final String ROC_CLIENT_PROPERTIES_ENCODED = "clientPropertiesEncoded";
    private static HashMap clientProperties;
    private static Map syncClientProperties;
    private static long lastClientSessionReap;
    private static Random random;
    private static DesktopAppContext dac;
    private static Logger debugLogger;
    static /* synthetic */ Class class$com$sun$portal$desktop$context$AuthlessSessionContext;

    public void init(HttpServletRequest req, String portalId) {
    }

    private static ClientSessionData getClientSessionData(String sid) {
        ClientSessionData csd = (ClientSessionData)syncClientProperties.get(sid);
        if (csd != null) {
            csd.setLastAccess();
        }
        return csd;
    }

    private static String getParameter(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        return value;
    }

    private static Map getCookieMap(HttpServletRequest req) {
        Cookie[] cookies;
        HashMap<String, Cookie> cookieMap = (HashMap<String, Cookie>)ROC.getObject(ROC_COOKIES);
        if (cookieMap == null && (cookies = req.getCookies()) != null) {
            cookieMap = new HashMap<String, Cookie>();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie c = cookies[i];
                cookieMap.put(c.getName(), c);
            }
            ROC.setObject(ROC_COOKIES, cookieMap);
        }
        return cookieMap;
    }

    private static Cookie getCookie(HttpServletRequest req, String name) {
        Map cookieMap = AuthlessSessionContext.getCookieMap(req);
        if (cookieMap == null) {
            return null;
        }
        return (Cookie)cookieMap.get(name);
    }

    private static String getCookieValue(HttpServletRequest req, String name) {
        Cookie c = AuthlessSessionContext.getCookie(req, name);
        String value = null;
        if (c != null) {
            value = c.getValue();
        }
        return value;
    }

    public String getStringProperty(String name) {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        return AuthlessSessionContext.getStringProperty(req, name);
    }

    private static Map decodeClientProperties(HttpServletRequest req) {
        Map cp = null;
        String p = null;
        short mode = AuthlessSessionContext.getCookieSupportMode();
        if (mode == 0 || mode == 2) {
            p = AuthlessSessionContext.getCookieValue(req, CLIENT_PROPERTIES);
            cp = PIParser.decodeKeyValueString(p);
        }
        if (mode == 1 || mode == 2) {
            String pi = req.getPathInfo();
            Map piMap = PIParser.parse(pi);
            cp = (Map)piMap.get("desktop.authless");
        }
        return cp;
    }

    private static String getStringPropertyServer(HttpServletRequest req, String name) {
        ClientSessionData csd;
        String clientSID = AuthlessSessionContext.getClientSID(req);
        String value = null;
        if (clientSID != null && (csd = AuthlessSessionContext.getClientSessionData(clientSID)) != null) {
            Map properties = csd.getProperties();
            value = (String)properties.get(name);
        }
        return value;
    }

    private static String getStringPropertyClient(HttpServletRequest req, String name) {
        String value = null;
        Map cp = AuthlessSessionContext.getClientProperties(req, false);
        if (cp != null) {
            value = (String)cp.get(name);
        }
        return value;
    }

    private static String getStringProperty(HttpServletRequest req, String name) {
        String value = null;
        short authlessState = dac.getAuthlessState(dac.getClientType(req));
        if (authlessState == 1) {
            value = AuthlessSessionContext.getStringPropertyServer(req, name);
        } else if (authlessState == 2) {
            value = AuthlessSessionContext.getStringPropertyClient(req, name);
        }
        if (value == null) {
            value = (String)req.getAttribute(name);
        }
        return value;
    }

    public void setStringProperty(String name, String val) {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        HttpServletResponse res = RequestThreadLocalizer.getResponse();
        AuthlessSessionContext.setStringProperty(req, res, name, val);
    }

    private static String getNewClientSID(HttpServletRequest req) {
        String sid = null;
        long clientSessionsMax = dac.getClientSessionsMax();
        if ((long)syncClientProperties.size() >= clientSessionsMax) {
            debugLogger.log(Level.FINE, "PSDT_CSPDC0001", Long.toString(clientSessionsMax));
        } else {
            String server = req.getServerName();
            String pr = Integer.toString(random.nextInt());
            sid = pr + "@" + server;
            sid = Base64.encode(sid);
        }
        return sid;
    }

    protected static void setCookie(HttpServletResponse res, String key, String val) {
        Cookie c = new Cookie(key, val);
        c.setPath("/");
        res.addCookie(c);
    }

    protected static void setClientSID(HttpServletRequest req, HttpServletResponse res, String sid) {
        short mode = AuthlessSessionContext.getCookieSupportMode();
        if (mode == 0 || mode == 2) {
            AuthlessSessionContext.setCookie(res, CLIENT_SID, sid);
        }
        ROC.setObject(ROC_CLIENT_SID, sid);
    }

    private static void setStringPropertyServer(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        String clientSID = AuthlessSessionContext.getClientSID(req);
        if (clientSID == null) {
            clientSID = AuthlessSessionContext.getNewClientSID(req);
        }
        if (clientSID != null) {
            AuthlessSessionContext.setClientSID(req, res, clientSID);
            ClientSessionData csd = AuthlessSessionContext.getClientSessionData(clientSID);
            if (csd == null) {
                csd = new ClientSessionData();
                syncClientProperties.put(clientSID, csd);
            }
            Map properties = csd.getProperties();
            properties.put(name, val);
        }
    }

    private static void setStringPropertyClient(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        String pathInfo;
        Map cp = AuthlessSessionContext.getClientProperties(req, true);
        cp.put(name, val);
        AuthlessSessionContext.setEncodedClientProperties(cp);
        short mode = AuthlessSessionContext.getCookieSupportMode();
        if ((mode == 0 || mode == 2) && (pathInfo = AuthlessSessionContext.getEncodedClientProperties()) != null) {
            int startIndex = pathInfo.indexOf(61, pathInfo.indexOf("desktop.authless")) + 1;
            String p = pathInfo.substring(startIndex);
            AuthlessSessionContext.setCookie(res, CLIENT_PROPERTIES, p);
        }
    }

    private static void setStringProperty(HttpServletRequest req, HttpServletResponse res, String name, String val) {
        short authlessState = dac.getAuthlessState(dac.getClientType(req));
        if (authlessState == 1) {
            AuthlessSessionContext.setStringPropertyServer(req, res, name, val);
        } else if (authlessState == 2) {
            AuthlessSessionContext.setStringPropertyClient(req, res, name, val);
        }
        req.setAttribute(name, (Object)val);
    }

    public String getSessionID() {
        return this.getUserID();
    }

    public String getSessionID(HttpServletRequest req) {
        return this.getUserID(req);
    }

    public String getUserID() {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        String uid = this.getUserID(req);
        return uid;
    }

    public String getUserID(HttpServletRequest req) {
        String uid = AuthlessSessionContext.getSUID(req);
        return uid;
    }

    public void addSessionListener(SessionListener sl) {
    }

    public void addUserReference() {
    }

    public void addUserListener(UserListener sl) {
    }

    private static Map getClientProperties(HttpServletRequest req, boolean create) {
        HashMap cp = null;
        if (!ROC.containsObject(ROC_CLIENT_PROPERTIES)) {
            cp = AuthlessSessionContext.decodeClientProperties(req);
            if (cp == null && create) {
                cp = new HashMap();
            }
            if (cp != null) {
                ROC.setObject(ROC_CLIENT_PROPERTIES, cp);
            }
        } else {
            cp = (Map)ROC.getObject(ROC_CLIENT_PROPERTIES);
        }
        return cp;
    }

    private static void setEncodedClientProperties() {
        Map m = (Map)ROC.getObject(ROC_CLIENT_PROPERTIES);
        AuthlessSessionContext.setEncodedClientProperties(m);
    }

    private static void setEncodedClientProperties(Map m) {
        if (m != null) {
            HashMap<String, Map> piMap = new HashMap<String, Map>();
            piMap.put("desktop.authless", m);
            String pathInfo = PIParser.getPathInfoString(piMap);
            ROC.setObject(ROC_CLIENT_PROPERTIES_ENCODED, pathInfo);
        }
    }

    private static String getEncodedClientProperties() {
        if (!ROC.containsObject(ROC_CLIENT_PROPERTIES_ENCODED)) {
            AuthlessSessionContext.setEncodedClientProperties();
        }
        String p = (String)ROC.getObject(ROC_CLIENT_PROPERTIES_ENCODED);
        return p;
    }

    public String encodeURL(String url) {
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        short mode = AuthlessSessionContext.getCookieSupportMode();
        if (mode == 1 || mode == 2) {
            String p;
            String detect = (String)req.getAttribute(ATTR_COOKIE_DETECT);
            if (detect != null && detect.equals("true")) {
                StringBuffer sb = new StringBuffer();
                sb.append(KEY_COOKIE_DETECT).append("=").append(COOKIE_DETECT_VALUE);
                url = this.appendPI(url, sb.toString());
            }
            if (dac.getAuthlessState(dac.getClientType(req)) == 1) {
                String clientSID = AuthlessSessionContext.getClientSID(req);
                if (clientSID != null) {
                    StringBuffer piBuffer = new StringBuffer();
                    piBuffer.append(ROC_CLIENT_SID).append("=").append(clientSID);
                    url = this.appendPI(url, piBuffer.toString());
                }
            } else if (dac.getAuthlessState(dac.getClientType(req)) == 2 && (p = AuthlessSessionContext.getEncodedClientProperties()) != null) {
                url = this.appendPI(url, p);
            }
        }
        return url;
    }

    private String appendPI(String url, String pi) {
        String updatedURL = null;
        String sep = "$";
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        String servletPath = req.getServletPath();
        int i = url.indexOf("?");
        if (i != -1) {
            String uri = url.substring(0, i);
            String query = url.substring(i, url.length());
            if (servletPath != null && uri.endsWith(servletPath)) {
                sep = "/";
            }
            updatedURL = uri + sep + pi + query;
        } else {
            if (servletPath != null && url.endsWith(servletPath)) {
                sep = "/";
            }
            updatedURL = url + sep + pi;
        }
        return updatedURL;
    }

    private static String getClientSID(HttpServletRequest req) {
        String clientSID = (String)ROC.getObject(ROC_CLIENT_SID);
        if (clientSID == null) {
            int index;
            String pi;
            short mode = AuthlessSessionContext.getCookieSupportMode();
            if (mode == 0 || mode == 2) {
                clientSID = AuthlessSessionContext.getCookieValue(req, CLIENT_SID);
            }
            if ((mode == 1 || mode == 2) && (pi = req.getPathInfo()) != null && pi.length() > 1 && (index = (pi = pi.substring(1)).indexOf(ROC_CLIENT_SID)) != -1) {
                int startIndex = pi.indexOf(61, index) + 1;
                clientSID = pi.indexOf("$", index) == -1 ? pi.substring(startIndex) : pi.substring(startIndex, pi.indexOf("$", index));
            }
            if (clientSID != null) {
                if (!syncClientProperties.containsKey(clientSID)) {
                    clientSID = null;
                } else {
                    ROC.setObject(ROC_CLIENT_SID, clientSID);
                }
            }
        }
        return clientSID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reapClientSessions() {
        boolean needReap = false;
        long now = System.currentTimeMillis();
        Map map = syncClientProperties;
        synchronized (map) {
            long reapInterval = dac.getClientSessionReapInterval();
            boolean bl = needReap = reapInterval != -1L && now > lastClientSessionReap + reapInterval * 1000L;
            if (needReap) {
                lastClientSessionReap = now;
            }
        }
        if (needReap) {
            HashMap cpClone = null;
            Map reapInterval = syncClientProperties;
            synchronized (reapInterval) {
                cpClone = (HashMap)clientProperties.clone();
            }
            Iterator i = cpClone.keySet().iterator();
            while (i.hasNext()) {
                String sid = (String)i.next();
                ClientSessionData csd = (ClientSessionData)cpClone.get(sid);
                long lastAccess = csd.getLastAccess();
                if (lastAccess == -1L || lastAccess + dac.getClientSessionInactiveMax() * 1000L >= now) continue;
                syncClientProperties.remove(sid);
            }
        }
    }

    private static short getCookieSupportMode() {
        boolean detect = false;
        short retval = 2;
        HttpServletRequest req = RequestThreadLocalizer.getRequest();
        HttpServletResponse res = RequestThreadLocalizer.getResponse();
        Short mode = null;
        if (req != null) {
            Short s = mode = req.getAttribute(ATTR_COOKIE_SUPPORT_MODE) == null ? null : (Short)req.getAttribute(ATTR_COOKIE_SUPPORT_MODE);
        }
        if (mode != null) {
            retval = mode;
        } else {
            short cookieSupport = dac.getCookieSupport(dac.getClientType(req));
            retval = cookieSupport == 1 ? (short)0 : (cookieSupport == 0 ? (short)1 : AuthlessSessionContext.detectCookieSupport(req, res));
            if (req != null) {
                req.setAttribute(ATTR_COOKIE_SUPPORT_MODE, (Object)new Short(retval));
            }
        }
        debugLogger.log(Level.FINE, "PSDT_CSPDC0002", Integer.toString(retval));
        return retval;
    }

    private static short detectCookieSupport(HttpServletRequest req, HttpServletResponse res) {
        short retval = 2;
        Cookie[] cookies = req.getCookies();
        if (cookies != null && cookies.length > 0) {
            retval = 0;
        } else {
            if (AuthlessSessionContext.isCookieDetectFoundInURI(req.getRequestURI())) {
                retval = 1;
            } else {
                retval = 2;
                AuthlessSessionContext.setCookie(res, KEY_COOKIE_DETECT, COOKIE_DETECT_VALUE);
            }
            req.setAttribute(ATTR_COOKIE_DETECT, (Object)"true");
        }
        return retval;
    }

    private static boolean isCookieDetectFoundInURI(String reqUri) {
        boolean retval = false;
        if (reqUri != null && reqUri.indexOf(KEY_COOKIE_DETECT) != -1) {
            retval = true;
        }
        return retval;
    }

    public boolean validateSession(HttpServletRequest req) {
        Boolean valid = (Boolean)ROC.getObject(ROC_SESSION_VALID);
        if (valid == null) {
            String suid = AuthlessSessionContext.getSUID(req);
            if (suid == null) {
                valid = Boolean.FALSE;
            } else {
                boolean v = dac.isAuthorizedAuthlessUID(suid);
                if (v) {
                    valid = Boolean.TRUE;
                    this.setStringProperty(SUID, suid);
                } else {
                    valid = Boolean.FALSE;
                    this.setStringProperty(SUID, null);
                }
            }
            ROC.setObject(ROC_SESSION_VALID, valid);
        }
        AuthlessSessionContext.reapClientSessions();
        return valid;
    }

    protected static String getSUID(HttpServletRequest req) {
        String value = null;
        value = (String)ROC.getObject(ROC_SUID);
        if (value == null || value.length() == 0) {
            value = AuthlessSessionContext.getSUIDParameter(req);
            if (value == null || value.length() == 0) {
                value = AuthlessSessionContext.getStringProperty(req, SUID);
            }
            if (value == null || value.length() == 0) {
                value = dac.getDefaultAuthlessUID();
            }
            if (value != null) {
                ROC.setObject(ROC_SUID, value);
            }
        }
        return value;
    }

    protected static String getSUIDParameter(HttpServletRequest req) {
        String value = AuthlessSessionContext.getParameter(req, SUID);
        return value;
    }

    public String getAuthenticationType() {
        return "desktop.authless";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        clientProperties = null;
        syncClientProperties = null;
        lastClientSessionReap = 0L;
        random = null;
        dac = null;
        debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$context$AuthlessSessionContext == null ? (class$com$sun$portal$desktop$context$AuthlessSessionContext = AuthlessSessionContext.class$("com.sun.portal.desktop.context.AuthlessSessionContext")) : class$com$sun$portal$desktop$context$AuthlessSessionContext));
        dac = DesktopAppContextThreadLocalizer.get();
        String cookiePrefix = dac.getCookiePrefix();
        CLIENT_PROPERTIES = cookiePrefix + ROC_CLIENT_PROPERTIES;
        CLIENT_SID = cookiePrefix + ROC_CLIENT_SID;
        SUID = cookiePrefix + ROC_SUID;
        clientProperties = new HashMap();
        syncClientProperties = Collections.synchronizedMap(clientProperties);
        random = new Random(System.currentTimeMillis());
    }

    private static class ClientSessionData {
        private Map properties = null;
        private long lastAccess = -1L;

        public Map getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            return this.properties;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess() {
            this.lastAccess = System.currentTimeMillis();
        }
    }
}

