/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DADPModelImpl;
import com.sun.portal.desktop.admin.model.SelectChannelsModel;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SelectChannelsModelImpl
extends DADPModelImpl
implements SelectChannelsModel {
    private String containerPath = null;
    private Set existingChannels = Collections.EMPTY_SET;
    private Set availableChannels = Collections.EMPTY_SET;
    private Set selectedChannels = Collections.EMPTY_SET;
    private DPNode currentNode = null;

    public SelectChannelsModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
        this.containerPath = (String)map.get("com.sun.portal.desktop.admin.fqcn");
    }

    public void initData() throws DAConsoleException {
        this.currentNode = this.containerPath == null || this.containerPath.length() < 2 ? this.dpRoot : this.dpRoot.getChannel(this.containerPath);
        if (this.currentNode == null) {
            throw new DAConsoleException(10);
        }
        short currentNodeType = this.currentNode.getType();
        if (currentNodeType != 13 && currentNodeType != 5) {
            this.currentNode = this.dpRoot;
            this.error("SelectChannelsModelImpl:initData Incorrect Node");
        }
        if (this.currentNode.getType() != 13) {
            this.initChannelMgmtData();
        }
    }

    private void initChannelMgmtData() throws DPError {
        DPContainerChannel container = (DPContainerChannel)this.currentNode;
        this.existingChannels = this.getAssignableChannels();
        TreeSet<Object> nonExistingChannels = new TreeSet<Object>(this.getCollator());
        String channelName = null;
        this.availableChannels = container.getAvailable().getNames();
        Iterator iterator = this.availableChannels.iterator();
        while (iterator.hasNext()) {
            channelName = (String)iterator.next();
            if (this.dpRoot.channelExists(channelName)) continue;
            nonExistingChannels.add(channelName);
        }
        if (!nonExistingChannels.isEmpty()) {
            this.availableChannels.removeAll(nonExistingChannels);
            container.setAvailable(new ArrayList(this.availableChannels));
        }
        nonExistingChannels.clear();
        this.selectedChannels = container.getSelected().getNames();
        iterator = this.selectedChannels.iterator();
        while (iterator.hasNext()) {
            channelName = (String)iterator.next();
            if (this.dpRoot.channelExists(channelName)) continue;
            nonExistingChannels.add(channelName);
        }
        if (!nonExistingChannels.isEmpty()) {
            this.selectedChannels.removeAll(nonExistingChannels);
            container.setSelected(new ArrayList(this.selectedChannels));
        }
        this.availableChannels.removeAll(this.selectedChannels);
        this.existingChannels.removeAll(this.selectedChannels);
        this.existingChannels.removeAll(this.availableChannels);
    }

    protected Set getAssignableChannels() {
        TreeSet<Object> result = new TreeSet<Object>(this.getCollator());
        Set channelNames = this.currentNode.getChannelNames();
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            String fQCN = this.toFullyQualifiedName(this.currentNode, channelName);
            if (!this.isDisplayable(fQCN)) continue;
            result.add(fQCN);
        }
        for (DPNode parentNode = this.currentNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            channelNames = parentNode.getChannelNames();
            iterator = channelNames.iterator();
            while (iterator.hasNext()) {
                String channelName = (String)iterator.next();
                String fQCN = this.toFullyQualifiedName(parentNode, channelName);
                if (!this.isDisplayable(fQCN)) continue;
                result.add(fQCN);
            }
        }
        result.remove(this.currentNode.getName());
        return result;
    }

    protected String toFullyQualifiedName(DPNode container, String shortName) {
        return (container instanceof DPRoot ? "" : container.getName() + '/') + shortName;
    }

    private boolean isDisplayable(String fqcn) {
        boolean isDisplayable = true;
        DPChannel channel = this.dpRoot.getChannel(fqcn);
        String shortName = this.getTail(fqcn);
        if (channel == null || channel.isAdvanced() || shortName.startsWith("_")) {
            isDisplayable = false;
        }
        return isDisplayable;
    }

    public void setAvailableAndSelected(List available, List selected) throws DAConsoleException {
        ((DPContainerChannel)this.currentNode).setSelected(selected);
        ArrayList<String> availableList = new ArrayList<String>(selected);
        Iterator avlItr = available.iterator();
        while (avlItr.hasNext()) {
            String fqcn = (String)avlItr.next();
            if (fqcn == null || availableList.contains(fqcn)) continue;
            availableList.add(fqcn);
        }
        ((DPContainerChannel)this.currentNode).setAvailable(availableList);
        this.store();
        this.initChannelMgmtData();
    }

    public Set getExistingChannels() {
        return this.existingChannels;
    }

    public Set getAvailableChannels() {
        return this.availableChannels;
    }

    public Set getSelectedChannels() {
        return this.selectedChannels;
    }

    public boolean isDisplayProfileRoot() {
        boolean isDPRoot = false;
        if (this.currentNode == null || this.currentNode.getType() == 13) {
            isDPRoot = true;
        }
        return isDPRoot;
    }

    public String getShortName(String fqcn) {
        return this.getTail(fqcn);
    }
}

