/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.jato.model.ModelControlException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.admin.model.EditDisplayProfileModel;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.log.common.PortalLogger;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EditDisplayProfileModelImpl
extends AMModelBase
implements EditDisplayProfileModel {
    private SchemaType schemaType = SchemaType.USER;
    private boolean isTemplate = false;
    private String serviceName = null;
    private long lastRead = -1L;
    private HttpServletRequest request = null;
    private String userDN = null;
    private DSAMEMultiPortalConstants dmpc = DSAMEMultiPortalConstants.getInstance();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$model$EditDisplayProfileModelImpl == null ? (class$com$sun$portal$desktop$admin$model$EditDisplayProfileModelImpl = EditDisplayProfileModelImpl.class$("com.sun.portal.desktop.admin.model.EditDisplayProfileModelImpl")) : class$com$sun$portal$desktop$admin$model$EditDisplayProfileModelImpl));
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$model$EditDisplayProfileModelImpl;

    public EditDisplayProfileModelImpl(HttpServletRequest req, String rbName, Map map) throws ModelControlException {
        super(req, rbName, map);
        this.request = req;
        this.serviceName = (String)map.get("com.iplanet.am.console.service.svcName");
        String type = (String)map.get("schemaType");
        String template = (String)map.get("com.iplanet.am.console.service.templateLevel");
        if (template != null && template.equals("true")) {
            this.isTemplate = true;
        }
        this.userDN = (String)map.get("com-iplanet-am-admin-user-current-object");
        this.init(type);
    }

    private void init(String type) throws ModelControlException {
        if (this.serviceName == null || this.serviceName.length() == 0) {
            throw new ModelControlException("EditDisplayProfileModelImpl: No Service.");
        }
        if (type == null || type.length() == 0) {
            if (this.userDN == null || this.userDN.length() == 0) {
                throw new ModelControlException("EditDisplayProfileModelImpl: No user DN.");
            }
            this.schemaType = SchemaType.USER;
            return;
        }
        try {
            int scmType = Integer.parseInt(type);
            switch (scmType) {
                case 0: {
                    this.schemaType = SchemaType.GLOBAL;
                    break;
                }
                case 1: {
                    this.schemaType = SchemaType.ORGANIZATION;
                    break;
                }
                case 2: {
                    this.schemaType = SchemaType.DYNAMIC;
                    break;
                }
                case 3: {
                    this.schemaType = SchemaType.USER;
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new ModelControlException("EditDisplayProfileModelImpl: Unknown Schema type.");
        }
    }

    public void setCurrentUser(String userDN) {
        this.userDN = userDN;
    }

    public String getDisplayProfile() {
        Iterator iter;
        String profile = "";
        Map attrMap = new HashMap(1);
        try {
            if (this.schemaType == SchemaType.USER) {
                AMUser user = this.dpStoreConn.getUser(this.userDN);
                if (user != null) {
                    attrMap = user.getServiceAttributes(this.dmpc.MP_SUN_DESKTOP_SERVICE);
                }
            } else if (!this.isTemplate) {
                ServiceSchemaManager sm = this.getServiceSchemaManager(this.dmpc.MP_SUN_DESKTOP_SERVICE);
                ServiceSchema schema = sm.getSchema(this.schemaType);
                attrMap = schema.getAttributeDefaults();
            } else {
                AMTemplate template = this.getServiceTemplate(this.serviceName, SchemaType.DYNAMIC);
                if (template != null) {
                    attrMap = template.getAttributes();
                }
            }
            this.lastRead = System.currentTimeMillis();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSDT_CSPDAM0074", new Object[]{e.getMessage()});
            attrMap = new HashMap(1);
        }
        Set values = (Set)attrMap.get(this.schemaType == SchemaType.USER ? this.dmpc.MP_ATTR_DP_DOCUMENT_USER : "sunPortalDesktopDpDocument");
        if (values != null && (iter = values.iterator()).hasNext()) {
            profile = (String)iter.next();
        }
        return profile;
    }

    public void setDisplayProfile(byte[] profile) throws AMConsoleException {
        if (profile == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getLocalizedString("schema.setAttributeError"));
            list.add("");
            throw new AMConsoleException(list);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(profile);
        String profileStr = null;
        try {
            DSAMEAdminDPContext dpc = new DSAMEAdminDPContext();
            dpc.init(this.request);
            DPRoot dpRoot = XMLDPFactory.getInstance().createRoot((DPContext)dpc, bis);
            StringBuffer buffer = new StringBuffer(profile.length);
            dpRoot.toXML(buffer, 0);
            profileStr = buffer.toString();
        }
        catch (DPError dpe) {
            Throwable t = dpe.getCause();
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0075", new Object[]{t == null ? dpe.getMessage() : t.getMessage()});
            throw this.createException(t);
        }
        this.storeDP(profileStr, false);
    }

    public void setDisplayProfile(String profile) throws AMConsoleException {
        boolean delete;
        if (profile == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getLocalizedString("schema.setAttributeError"));
            list.add("");
            throw new AMConsoleException(list);
        }
        String dpText = profile.trim();
        boolean bl = delete = dpText.length() == 0;
        if (delete) {
            profile = dpText;
        } else {
            if (!dpText.startsWith("<?xml")) {
                debugLogger.fine("PSDT_CSPDAM0076");
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.getLocalizedString("dp.error.title"));
                list.add(this.getLocalizedString("dp.error.noHeader"));
                throw new AMConsoleException(list);
            }
            int endOfHeader = dpText.indexOf(62);
            dpText = dpText.substring(endOfHeader + 1);
            dpText = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>" + dpText;
            try {
                DSAMEAdminDPContext dpc = new DSAMEAdminDPContext();
                dpc.init(this.request);
                DPRoot dpRoot = XMLDPFactory.getInstance().createRoot((DPContext)dpc, dpText);
                StringBuffer buffer = new StringBuffer(profile.length());
                dpRoot.toXML(buffer, 0);
                profile = buffer.toString();
            }
            catch (DPError dpe) {
                profile = null;
                Throwable t = dpe.getCause();
                debugLogger.log(Level.FINE, "PSDT_CSPDAM0075", new Object[]{t == null ? dpe.getMessage() : t.getMessage()});
                throw this.createException(t);
            }
        }
        this.storeDP(profile, delete);
    }

    private AMConsoleException createException(Throwable t) {
        String msg = "";
        String pattern = "";
        if (t != null && t instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)t;
            pattern = this.getLocalizedString("dp.error.saxParseException");
            MessageFormat mf = new MessageFormat(pattern);
            mf.setLocale(this.getUserLocale());
            Object[] args = new Object[]{new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber()), spe.getMessage()};
            msg = mf.format(args);
        } else if (t != null && t instanceof SAXException) {
            SAXException se = (SAXException)t;
            pattern = this.getLocalizedString("dp.error.saxException");
            MessageFormat mf = new MessageFormat(pattern);
            mf.setLocale(this.getUserLocale());
            Object[] arg = new Object[]{se.getMessage()};
            msg = mf.format(arg);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getLocalizedString("dp.error.title"));
        list.add(msg);
        return new AMConsoleException(list);
    }

    private void storeDP(String profile, boolean delete) throws AMConsoleException {
        HashSet<String> attrs = new HashSet<String>(1);
        HashSet<String> values = new HashSet<String>(1);
        values.add(profile);
        HashMap<String, HashSet<String>> attrMap = new HashMap<String, HashSet<String>>(1);
        try {
            if (this.schemaType == SchemaType.USER) {
                AMUser user = this.dpStoreConn.getUser(this.userDN);
                if (user != null) {
                    if (delete) {
                        if (this.getDisplayProfile().length() > 0) {
                            attrs.add(this.dmpc.MP_ATTR_DP_DOCUMENT_USER);
                            user.removeAttributes(attrs);
                        }
                    } else {
                        attrMap.put(this.dmpc.MP_ATTR_DP_DOCUMENT_USER, values);
                        user.setAttributes(attrMap);
                        user.store();
                    }
                    user.setStringAttribute(this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER, Long.toString(System.currentTimeMillis()));
                    user.store();
                }
            } else if (!this.isTemplate) {
                ServiceSchemaManager sm = this.getServiceSchemaManager(this.dmpc.MP_SUN_DESKTOP_SERVICE);
                ServiceSchema schema = sm.getSchema(this.schemaType);
                if (delete) {
                    attrs.add("sunPortalDesktopDpDocument");
                    schema.removeAttributeDefaults(attrs);
                } else {
                    schema.setAttributeDefaults("sunPortalDesktopDpDocument", values);
                }
                if (this.schemaType.equals((Object)SchemaType.GLOBAL)) {
                    values.clear();
                    values.add(Long.toString(System.currentTimeMillis()));
                    schema.setAttributeDefaults("sunPortalDesktopDpLastModified", values);
                }
            } else {
                AMTemplate template = this.getServiceTemplate(this.serviceName, SchemaType.DYNAMIC);
                if (template != null) {
                    if (delete) {
                        if (this.getDisplayProfile().length() > 0) {
                            attrs.add("sunPortalDesktopDpDocument");
                            template.removeAttributes(attrs);
                        }
                    } else {
                        attrMap.put("sunPortalDesktopDpDocument", values);
                        template.setAttributes(attrMap);
                    }
                    template.store();
                    template.setStringAttribute("sunPortalDesktopDpLastModified", Long.toString(System.currentTimeMillis()));
                    template.store();
                }
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0077", new Object[]{e.getMessage()});
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getLocalizedString("schema.setAttributeError"));
            list.add("");
            throw new AMConsoleException(list);
        }
    }

    public long getDPDocumentLastRead() {
        return this.lastRead;
    }

    public long getDPDocumentLastModified() {
        if (this.schemaType == SchemaType.USER) {
            try {
                AMUser user = this.dpStoreConn.getUser(this.userDN);
                Set values = user.getAttribute(this.dmpc.MP_ATTR_DP_LAST_MODIFIED_USER);
                return Long.parseLong((String)values.iterator().next());
            }
            catch (Exception e) {
                return -1L;
            }
        }
        if (!this.isTemplate && !this.schemaType.equals((Object)SchemaType.GLOBAL)) {
            return -1L;
        }
        if (this.isTemplate) {
            DSAMEAdminDPContext dpc = new DSAMEAdminDPContext();
            dpc.init(this.request);
            return dpc.getDPDocumentLastModified(this.locationDN);
        }
        try {
            ServiceSchemaManager sm = this.getServiceSchemaManager(this.dmpc.MP_SUN_DESKTOP_SERVICE);
            ServiceSchema schema = sm.getSchema(this.schemaType);
            Map map = schema.getAttributeDefaults();
            Set values = (Set)map.get("sunPortalDesktopDpLastModified");
            return Long.parseLong((String)values.iterator().next());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public boolean isGlobal() {
        return this.schemaType == SchemaType.GLOBAL;
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

