/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplayImpl;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.DynamicGUIGenerator;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.admin.model.DesktopAdminUserProfileModel;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.log.common.PortalLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class DesktopAdminUserProfileModelImpl
extends AMModelBase
implements DesktopAdminUserProfileModel {
    private String svcName;
    private Map displayOptions;
    private String curUserDN;
    private AMUser curUser;
    private Map mapUserAttrs;
    private Map mapDynAttrs;
    private Map userSchemaCache;
    private Map dynSchemaCache;
    private Set userAttrNames;
    private Set dynAttrNames;
    private Map userAttrStatus;
    private ServiceSchemaManager svcSchemaMgr;
    private String userServiceDisplay;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$model$DesktopAdminUserProfileModelImpl == null ? (class$com$sun$portal$desktop$admin$model$DesktopAdminUserProfileModelImpl = DesktopAdminUserProfileModelImpl.class$("com.sun.portal.desktop.admin.model.DesktopAdminUserProfileModelImpl")) : class$com$sun$portal$desktop$admin$model$DesktopAdminUserProfileModelImpl));
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$model$DesktopAdminUserProfileModelImpl;

    public DesktopAdminUserProfileModelImpl(HttpServletRequest req, Map map) {
        super(req, "psDesktopAdmin", map);
        this.svcName = DSAMEMultiPortalConstants.getInstance().MP_SUN_DESKTOP_SERVICE;
        this.displayOptions = null;
        this.curUserDN = "";
        this.curUser = null;
        this.mapUserAttrs = null;
        this.mapDynAttrs = null;
        this.userSchemaCache = null;
        this.dynSchemaCache = null;
        this.userAttrNames = null;
        this.dynAttrNames = null;
        this.userAttrStatus = null;
        this.svcSchemaMgr = null;
        this.userServiceDisplay = "UserOnly";
        this.setCurrentUser((String)map.get("com-iplanet-am-admin-user-current-object"));
    }

    public void initModel() {
        this.displayOptions = this.getDisplayOptions();
        this.getAttrSchema();
        this.getAttrSchema();
        if (this.userAttrNames != null && !this.userAttrNames.isEmpty()) {
            this.mapUserAttrs = this.getUserAttrValues();
        }
        if (this.dynAttrNames != null && !this.dynAttrNames.isEmpty()) {
            this.mapDynAttrs = this.getDynAttrValues();
        }
        if (this.userAttrStatus != null) {
            this.userAttrStatus.clear();
        }
    }

    public String getCurrentUserDN() {
        return this.curUser.getDN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttributes(Map userOnlyAttrs, Map customizedAttrs, Set inheritedAttrs) throws AMConsoleException {
        Set attrValues;
        String attrName;
        ArrayList errorList = null;
        HashMap<String, Set> attrs = new HashMap<String, Set>(userOnlyAttrs.size());
        Set namesSet = userOnlyAttrs.keySet();
        Iterator<Object> iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            if (this.isAttrReadOnly(0, attrName) || (attrValues = (Set)userOnlyAttrs.get(attrName)) == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)this.curUser, attrs, false);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0005", ssoe);
            return;
        }
        attrs = new HashMap(customizedAttrs.size());
        namesSet = customizedAttrs.keySet();
        iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            if (this.isAttrReadOnly(0, attrName) || (attrValues = (Set)customizedAttrs.get(attrName)) == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)this.curUser, attrs, true);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0005", ssoe);
            return;
        }
        if (!inheritedAttrs.isEmpty()) {
            if (errorList == null) {
                errorList = new ArrayList(inheritedAttrs.size());
            }
            HashSet<String> attr = new HashSet<String>(1);
            iter = inheritedAttrs.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                attr.add(name);
                try {
                    this.curUser.removeAttributes(attr);
                    this.logger.doLog("attribute.remove", name);
                }
                catch (AMException ame) {
                    if (!debugLogger.isLoggable(Level.FINE)) continue;
                    LogRecord logRecord = new LogRecord(Level.FINE, "PSDT_CSPDAM0006");
                    logRecord.setLoggerName(debugLogger.getName());
                    logRecord.setParameters(new String[]{name});
                    logRecord.setThrown(ame);
                    debugLogger.log(logRecord);
                }
                catch (SSOException ssoe) {
                    debugLogger.log(Level.FINE, "PSDT_CSPDAM0005", ssoe);
                    return;
                }
                finally {
                    attr.clear();
                }
            }
        }
        if (errorList != null && !errorList.isEmpty()) {
            throw new AMConsoleException(errorList);
        }
    }

    public boolean canViewDTAttributes() {
        boolean canView = true;
        try {
            Iterator ri = this.dpUser.getRoleDNs().iterator();
            while (ri.hasNext() && canView) {
                String value;
                AMRole amRole = this.dpStoreConn.getRole((String)ri.next());
                if (amRole == null || !amRole.isExists()) continue;
                debugLogger.log(Level.FINER, "PSDT_CSPDAM0001", amRole.getDN());
                AMTemplate amTemplate = amRole.getTemplate(this.svcName, 301);
                if (amTemplate == null || !amTemplate.isExists() || (value = amTemplate.getStringAttribute("sunPortalDesktopDpCanView")).length() <= 0) continue;
                canView = Boolean.valueOf(value);
            }
        }
        catch (AMException dpe) {
            debugLogger.log(Level.FINER, "PSDT_CSPDAM0002", dpe);
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0002", ssoe);
            canView = false;
        }
        return canView;
    }

    private ServiceSchemaManager getSvcSchemaMgr() {
        if (this.svcSchemaMgr == null) {
            try {
                this.svcSchemaMgr = this.getServiceSchemaManager(this.svcName);
            }
            catch (SSOException ssoe) {
                debugLogger.log(Level.FINE, "PSDT_CSPDAM0007", ssoe);
            }
            catch (SMSException smse) {
                debugLogger.log(Level.INFO, "PSDT_CSPDAM0007", smse);
            }
        }
        return this.svcSchemaMgr;
    }

    public void setAttributeValues(Map avMap) throws AMConsoleException {
        this.mapUserAttrs = avMap != null ? avMap : new HashMap(0);
    }

    public boolean isAttributeAccessDenied() {
        if (this.isCombinedDisplay()) {
            return !(this.userAttrNames != null && !this.userAttrNames.isEmpty() || this.dynAttrNames != null && !this.dynAttrNames.isEmpty());
        }
        if (this.hasSchemaType(SchemaType.USER)) {
            return this.userAttrNames == null || this.userAttrNames.isEmpty();
        }
        return false;
    }

    public boolean hasEditableAttributes() {
        if (this.isServiceDenied(this.svcName)) {
            return false;
        }
        if (this.userAttrNames == null || this.userAttrNames.isEmpty()) {
            return false;
        }
        boolean editable = false;
        Iterator attrIter = this.userAttrNames.iterator();
        while (attrIter.hasNext()) {
            String attrName = (String)attrIter.next();
            if (this.isAttrReadOnly(0, attrName)) continue;
            editable = true;
            break;
        }
        return editable;
    }

    protected AMUser getCurrentUser() {
        return this.curUser;
    }

    protected void setCurrentUser(String dn) {
        this.curUserDN = dn;
        debugLogger.log(Level.FINER, "PSDT_CSPDAM0008", dn);
        try {
            if (this.curUserDN != null && this.curUserDN.length() > 0) {
                this.curUser = this.dpStoreConn.getUser(this.curUserDN);
                if (this.curUser != null && !this.curUser.isExists()) {
                    this.curUser = null;
                }
            }
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.INFO, "PSDT_CSPDAM0009", ssoe);
        }
    }

    protected AMOrganization getAuthenticatedOrg() {
        AMStoreConnection storeConn = null;
        if (!this.isAdministrator()) {
            storeConn = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException se) {
                        debugLogger.log(Level.INFO, "PSDT_CSPDAM0010", se);
                        return null;
                    }
                }
            });
        }
        if (storeConn == null) {
            storeConn = this.dpStoreConn;
        }
        AMOrganization org = null;
        try {
            org = storeConn.getOrganization(this.getAuthenticatedOrgDN());
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0011", ssoe);
        }
        return org;
    }

    public Set getDateInDefaultLocale(Set dates) throws AMConsoleException {
        return super.getDateInDefaultLocale(dates);
    }

    public String getRequiredMessage() {
        return this.getLocalizedString("missingAttributes.message");
    }

    public String getInheritLabel() {
        return this.getLocalizedString("dynGUIInheritAttribute.label");
    }

    public String getInheritValue() {
        return "0";
    }

    public String getCustomizeLabel() {
        return this.getLocalizedString("dynGUICustomizeAttribute.label");
    }

    public String getCustomizeValue() {
        return "1";
    }

    public String getSkipLabel() {
        return this.getLocalizedString("dynGUISkipAttribute.label");
    }

    public String getSkipValue() {
        return "2";
    }

    public boolean isCombinedDisplay() {
        return this.userServiceDisplay.equalsIgnoreCase("Combined");
    }

    private Map getDisplayOptions() {
        Map options = null;
        AMAttributeDisplayImpl ad = new AMAttributeDisplayImpl(this.dpStoreConn, this.ssoToken);
        try {
            ServiceSchemaManager mgr = this.getSvcSchemaMgr();
            if (mgr != null) {
                options = ad.getServiceDisplayOptions(this.svcName, mgr, this.dpUser);
            }
        }
        catch (AMException ame) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0012", ame);
        }
        catch (SMSException smse) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0012", smse);
        }
        catch (SSOException soe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0012", soe);
        }
        return options;
    }

    private Map getUserAttrValues() {
        if (this.curUser == null) {
            return new HashMap(0);
        }
        if (!this.hasSchemaType(SchemaType.USER)) {
            return new HashMap(0);
        }
        HashMap userAVMap = null;
        try {
            userAVMap = this.curUser.getAttributes(this.userAttrNames);
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0013", ssoe);
        }
        catch (AMException de) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0013", de);
        }
        if (userAVMap == null) {
            userAVMap = new HashMap(0);
        }
        return userAVMap;
    }

    public Set getUserAttributeNames(int schemaType) {
        Set names = Collections.EMPTY_SET;
        Set source = null;
        source = schemaType == 1 ? this.dynAttrNames : this.userAttrNames;
        if (source != null) {
            names = source;
        }
        return names;
    }

    private Map getDynAttrValues() {
        if (this.curUser == null) {
            return new HashMap(0);
        }
        if (!this.hasSchemaType(SchemaType.DYNAMIC)) {
            return new HashMap(0);
        }
        HashMap dynAVMap = null;
        try {
            dynAVMap = this.curUser.getAttributes(this.dynAttrNames);
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0014", ssoe);
        }
        catch (AMException de) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0014", de);
        }
        if (dynAVMap == null) {
            dynAVMap = new HashMap(0);
        }
        return dynAVMap;
    }

    private void getAttrSchema() {
        if (this.hasSchemaType(SchemaType.USER)) {
            this.userSchemaCache = this.getAttrSchema(SchemaType.USER);
            if (this.userSchemaCache != null && !this.userSchemaCache.isEmpty()) {
                this.userAttrNames = this.userSchemaCache.keySet();
            }
        }
        if (this.hasSchemaType(SchemaType.DYNAMIC)) {
            this.dynSchemaCache = this.getAttrSchema(SchemaType.DYNAMIC);
            if (this.dynSchemaCache != null && !this.dynSchemaCache.isEmpty()) {
                this.dynAttrNames = this.dynSchemaCache.keySet();
            }
        }
    }

    private Map getAttrSchema(SchemaType schemaType) {
        HashMap<String, AttributeSchema> schemaMap = null;
        try {
            ServiceSchemaManager mgr = this.getSvcSchemaMgr();
            if (mgr != null) {
                ServiceSchema schema = mgr.getSchema(schemaType);
                Set asnSet = schema.getAttributeSchemaNames();
                schemaMap = new HashMap<String, AttributeSchema>(asnSet.size());
                Iterator iter = asnSet.iterator();
                while (iter.hasNext()) {
                    String sname = (String)iter.next();
                    AttributeSchema attrSchema = schema.getAttributeSchema(sname);
                    if (!this.toDisplayAttr(schemaType, attrSchema)) continue;
                    schemaMap.put(sname, attrSchema);
                }
            }
        }
        catch (SMSException smse) {
            debugLogger.log(Level.INFO, "PSDT_CSPDAM0015", smse);
        }
        return schemaMap;
    }

    private boolean toDisplayAttr(SchemaType schemaType, AttributeSchema attrSchema) {
        if (this.displayOptions == null) {
            return this.isAttrDisplayInSchema(schemaType, attrSchema);
        }
        if (this.displayOptions.isEmpty()) {
            return false;
        }
        Set options = (Set)this.displayOptions.get(attrSchema.getName());
        if (options == null || options.isEmpty()) {
            return false;
        }
        return options.contains("display") || options.contains("readOnly") || options.contains("userReadOnly") || this.isAdministrator() && options.contains("adminDisplay");
    }

    private boolean isAttrDisplayInSchema(SchemaType schemaType, AttributeSchema attrSchema) {
        boolean display = false;
        if (!schemaType.equals((Object)SchemaType.USER)) {
            String i18nKey = attrSchema.getI18NKey();
            if (i18nKey != null && i18nKey.length() > 0) {
                display = true;
            }
        } else {
            display = AMAdminUtils.isAttrDisplayable((int)this.getUserType(), (AttributeSchema)attrSchema);
        }
        return display;
    }

    private boolean hasSchemaType(SchemaType type) {
        boolean has = false;
        ServiceSchemaManager mgr = this.getSvcSchemaMgr();
        if (mgr != null) {
            try {
                Set schemaTypes = mgr.getSchemaTypes();
                has = AMAdminUtils.containsSchemaType((Set)schemaTypes, (SchemaType)type);
            }
            catch (SMSException smse) {
                debugLogger.log(Level.INFO, "PSDT_CSPDAM0016", smse);
            }
        }
        return has;
    }

    public List getDynamicGUIs(int schemaType, Map mapAttrInfo) {
        ArrayList<DynamicGUI> dynGUIs = Collections.EMPTY_LIST;
        HashSet names = null;
        if (schemaType == 1) {
            if (this.dynAttrNames != null && !this.dynAttrNames.isEmpty()) {
                names = new HashSet(this.dynAttrNames.size());
                names.addAll(this.dynAttrNames);
                if (this.userAttrNames != null && !this.userAttrNames.isEmpty()) {
                    names.removeAll(this.userAttrNames);
                }
            }
        } else if (schemaType == 0) {
            names = this.userAttrNames;
        }
        ArrayList<String> statusOptionLabels = new ArrayList<String>(3);
        statusOptionLabels.add(this.getCustomizeLabel());
        statusOptionLabels.add(this.getInheritLabel());
        statusOptionLabels.add(this.getSkipLabel());
        ArrayList<String> statusOptions = new ArrayList<String>(3);
        statusOptions.add(this.getCustomizeValue());
        statusOptions.add(this.getInheritValue());
        statusOptions.add(this.getSkipValue());
        if (names != null && !names.isEmpty()) {
            DynamicGUIGenerator gen = DynamicGUIGenerator.getInstance();
            dynGUIs = new ArrayList<DynamicGUI>(names.size());
            List orderedNames = this.orderAttrNamesByI18nKeys(schemaType, names);
            Iterator iter = orderedNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                AttributeSchema as = this.getAttrSchemaFromCache(schemaType, name);
                boolean readOnly = this.isAttrReadOnly(schemaType, name);
                String status = null;
                if (!readOnly && (status = this.getAttributeStatus(name)) != null && status.length() == 0) {
                    status = null;
                }
                DynamicGUI dg = gen.createDynamicGUI(as, this.svcName, this.getAttributeValues(schemaType, name, gen), readOnly, status, statusOptionLabels, statusOptions, (AMModel)this);
                int syntax = AMDisplayTypeConverter.getDisplaySyntax((AttributeSchema)as);
                if (syntax == 6 || syntax == 7) {
                    this.storeDynGUILinkInfo(schemaType, name, mapAttrInfo);
                }
                dynGUIs.add(dg);
            }
        }
        return dynGUIs;
    }

    protected void storeDynGUILinkInfo(int schemaType, String attrName, Map map) {
        String type = Integer.toString(3);
        if (schemaType == 1) {
            type = Integer.toString(2);
        }
        String[] info = new String[]{this.svcName, type};
        map.put(attrName, info);
    }

    protected List orderAttrNamesByI18nKeys(int schemaType, Set names) {
        HashSet<String> set;
        String i18nKey;
        ArrayList<String> sortedList = new ArrayList<String>(names.size());
        HashMap<String, HashSet<String>> mapi18nKeyToName = new HashMap<String, HashSet<String>>();
        HashSet<String> unordered = new HashSet<String>();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            i18nKey = this.getI18nKey(schemaType, name);
            unordered.add(i18nKey);
            set = (HashSet<String>)mapi18nKeyToName.get(i18nKey);
            if (set == null) {
                set = new HashSet<String>(3);
                mapi18nKeyToName.put(i18nKey, set);
            }
            set.add(name);
        }
        List ordered = AMFormatUtils.sortItemsInSet(unordered, (Locale)this.getUserLocale());
        iter = ordered.iterator();
        while (iter.hasNext()) {
            i18nKey = (String)iter.next();
            set = (Set)mapi18nKeyToName.get(i18nKey);
            sortedList.addAll(set);
        }
        return sortedList;
    }

    public String getI18nKey(int schemaType, String name) {
        String i18nKey = "";
        AttributeSchema schema = this.getAttrSchemaFromCache(schemaType, name);
        if (schema != null) {
            i18nKey = schema.getI18NKey();
        }
        return i18nKey;
    }

    public boolean isAttrReadOnly(int schemaType, String name) {
        if (schemaType == 1) {
            return true;
        }
        if (this.displayOptions == null) {
            return this.isAttrReadOnlyInSchema(schemaType, name);
        }
        if (this.displayOptions.isEmpty()) {
            return false;
        }
        Set options = (Set)this.displayOptions.get(name);
        if (options == null || options.isEmpty()) {
            return false;
        }
        boolean readOnly = false;
        if (options.contains("readOnly") || options.contains("userReadOnly") && this.getUserType() == 3) {
            readOnly = true;
        }
        return readOnly;
    }

    private boolean isAttrReadOnlyInSchema(int schemaType, String name) {
        boolean readOnly = false;
        AttributeSchema schema = this.getAttrSchemaFromCache(schemaType, name);
        if (schema != null) {
            SchemaType type = SchemaType.USER;
            if (schemaType == 1) {
                type = SchemaType.DYNAMIC;
            }
            readOnly = !AMAdminUtils.isUserAttrEditable((int)this.getUserType(), (AttributeSchema)schema, (SchemaType)type);
        }
        return readOnly;
    }

    private Set getAttributeValues(int schemaType, String name, DynamicGUIGenerator gen) {
        Set values = null;
        if (schemaType == 0 && this.mapUserAttrs != null) {
            values = (Set)this.mapUserAttrs.get(name);
            if (values == null) {
                values = (Set)this.mapUserAttrs.get(name.toLowerCase());
            }
        } else if (schemaType == 1 && this.mapDynAttrs != null && (values = (Set)this.mapDynAttrs.get(name)) == null) {
            values = (Set)this.mapDynAttrs.get(name.toLowerCase());
        }
        if (values == null) {
            values = Collections.EMPTY_SET;
        } else {
            AttributeSchema as = this.getAttrSchemaFromCache(schemaType, name);
            if (as != null && AMDisplayTypeConverter.getDisplaySyntax((AttributeSchema)as) == 4) {
                values = this.getDateInUserLocale(values);
            }
        }
        return values;
    }

    public void setAttributeStatus(Map map) {
        this.userAttrStatus = map == null ? new HashMap(0) : map;
    }

    private String getAttributeStatus(String attrName) {
        String status = null;
        if (this.hasDynamicAttribute(attrName)) {
            if (this.userAttrStatus != null) {
                status = (String)this.userAttrStatus.get(attrName);
            }
            if (status == null || status.length() == 0) {
                status = this.getSkipValue();
            }
        }
        return status;
    }

    private AttributeSchema getAttrSchemaFromCache(int schemaType, String attrName) {
        Map source = this.userSchemaCache;
        if (schemaType == 1) {
            source = this.dynSchemaCache;
        }
        return (AttributeSchema)source.get(attrName);
    }

    private boolean hasDynamicAttribute(String attrName) {
        if (this.dynAttrNames == null || this.dynAttrNames.isEmpty()) {
            return false;
        }
        return this.dynAttrNames.contains(attrName);
    }

    public String getLocalizedSvcName(String svcName) {
        debugLogger.log(Level.FINER, "PSDT_CSPDAM0017", svcName);
        return this.getL10NServiceName(svcName);
    }

    public Set getAttributeValues(int schemaType, String name) {
        Set values = null;
        if (schemaType == 0 && this.mapUserAttrs != null) {
            values = (Set)this.mapUserAttrs.get(name);
            if (values == null) {
                values = (Set)this.mapUserAttrs.get(name.toLowerCase());
            }
        } else if (schemaType == 1 && this.mapDynAttrs != null && (values = (Set)this.mapDynAttrs.get(name)) == null) {
            values = (Set)this.mapDynAttrs.get(name.toLowerCase());
        }
        if (values == null) {
            values = Collections.EMPTY_SET;
        }
        return values;
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

