/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.service.model.SMDataModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.sun.portal.log.common.PortalLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class DesktopAdminServiceModelImpl
extends SMDataModelImpl {
    public static final String CLASS_NAME = "DesktopAdminServiceModelImpl.";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$model$DesktopAdminServiceModelImpl == null ? (class$com$sun$portal$desktop$admin$model$DesktopAdminServiceModelImpl = DesktopAdminServiceModelImpl.class$("com.sun.portal.desktop.admin.model.DesktopAdminServiceModelImpl")) : class$com$sun$portal$desktop$admin$model$DesktopAdminServiceModelImpl));
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$model$DesktopAdminServiceModelImpl;

    public DesktopAdminServiceModelImpl(HttpServletRequest req, String rbName, Map map, String svcName, boolean processTemplate) {
        super(req, rbName, map, svcName, processTemplate);
    }

    public boolean canViewDTAttributes() {
        boolean canView = true;
        try {
            Iterator ri = this.dpUser.getRoleDNs().iterator();
            while (ri.hasNext() && canView) {
                String value;
                AMRole amRole = this.dpStoreConn.getRole((String)ri.next());
                if (amRole == null || !amRole.isExists()) continue;
                debugLogger.log(Level.FINER, "PSDT_CSPDAM0001", amRole.getDN());
                AMTemplate amTemplate = amRole.getTemplate(this.getServiceName(), 301);
                if (amTemplate == null || !amTemplate.isExists() || (value = amTemplate.getStringAttribute("sunPortalDesktopDpCanView")).length() <= 0) continue;
                canView = Boolean.valueOf(value);
            }
        }
        catch (AMException dpe) {
            debugLogger.log(Level.FINER, "PSDT_CSPDAM0002", dpe);
        }
        catch (SSOException ssoe) {
            debugLogger.log(Level.FINE, "PSDT_CSPDAM0002", ssoe);
            canView = false;
        }
        return canView;
    }

    public void disableAuthless() throws AMConsoleException {
        HashMap map = new HashMap(1);
        HashSet<String> values = new HashSet<String>(1);
        values.add("false");
        map.put("sunPortalDesktopEnableAuthlessDesktop", values);
        try {
            this.store(0, map);
        }
        catch (AMConsoleException ame) {
            debugLogger.log(Level.INFO, "PSDT_CSPDAM0003", ame);
            throw new AMConsoleException(this.getLocalizedString("generic.error"));
        }
    }

    public void saveAuthlessConfig(DynamicGUI defaultUid, DynamicGUI uidList, DynamicGUI authlessForFedUsers) throws AMConsoleException {
        if (defaultUid == null || uidList == null) {
            debugLogger.info("PSDT_CSPDAM0004");
            throw new AMConsoleException(this.getLocalizedString("generic.error.message"));
        }
        Set defUidValues = defaultUid.getValues();
        Set uidListValues = uidList.getValues();
        Set authlessForFedUsersValues = authlessForFedUsers.getValues();
        HashSet<String> values = new HashSet<String>(1);
        values.add("true");
        if (this.validateAuthlessConfig(defUidValues, uidListValues)) {
            HashMap<String, Set> map = new HashMap<String, Set>(4);
            map.put("sunPortalDesktopEnableAuthlessDesktop", values);
            map.put("sunPortalDesktopDisableAuthlessForFederatedUsers", authlessForFedUsersValues);
            map.put("sunPortalDesktopDefaultAuthlessUID", defUidValues);
            map.put("sunPortalDesktopAuthorizedAuthlessUIDs", uidListValues);
            this.store(0, map);
        }
    }

    private boolean validateAuthlessConfig(Set defUidValues, Set uidListValues) throws AMConsoleException {
        if (defUidValues.isEmpty() || uidListValues.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("desktopadminservice.error.authless.emptyvalues"));
        }
        String defUid = null;
        Iterator iter = defUidValues.iterator();
        if (iter.hasNext()) {
            defUid = (String)iter.next();
        }
        HashSet<String> uids = new HashSet<String>(5);
        iter = uidListValues.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            int index = value.indexOf(124);
            if (index == -1) {
                throw new AMConsoleException(this.getLocalizedString("desktopadminservice.error.authless.formatinvalid"));
            }
            value = value.substring(0, index);
            uids.add(value);
        }
        if (!uids.contains(defUid)) {
            throw new AMConsoleException(this.getLocalizedString("desktopadminservice.error.authless.defaultuidinvalid"));
        }
        return true;
    }

    public String getHelpDocURL() {
        return this.getHelpDocURL(this.resBundle);
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

