/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.sdk.AMUser;
import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DADPModel;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class DADPModelImpl
extends AMProfileModelBase
implements DADPModel {
    public static final String DEFAULT_CONTAINER_PATH = "_root";
    private static final String GLOBAL_KEY = "_!global!_";
    private Collator collator = null;
    protected DPRoot dpRoot = null;
    protected DSAMEAdminDPContext dpContext = null;
    private List dpDocDNs = new ArrayList();
    private String currentUserDN = null;
    private XMLDPFactory dpFactory = null;
    private boolean isGlobal = true;
    private List dpMergeList = new ArrayList();

    public DADPModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
        String template;
        this.currentUserDN = (String)map.get("com-iplanet-am-admin-user-current-object");
        if (this.currentUserDN != null && this.currentUserDN.length() == 0) {
            this.currentUserDN = null;
        }
        if ((template = (String)map.get("com.iplanet.am.console.service.templateLevel")) != null && template.equals("true") || this.currentUserDN != null) {
            this.isGlobal = false;
        }
        this.collator = Collator.getInstance(this.getUserLocale());
        this.createDPRoot(req);
        if (this.dpRoot != null) {
            this.mergeDPDocuments();
        }
    }

    private void createDPRoot(HttpServletRequest req) throws DAConsoleException {
        try {
            this.dpContext = new DSAMEAdminDPContext();
            if (this.dpContext != null) {
                this.dpContext.init(req);
                this.dpFactory = XMLDPFactory.getInstance();
                String dpText = null;
                if (this.isGlobal) {
                    dpText = this.dpContext.getGlobalDPDocument();
                    this.dpDocDNs.add(GLOBAL_KEY);
                } else if (this.currentUserDN == null) {
                    dpText = this.dpContext.getDPDocumentByDN(this.locationDN);
                    this.dpDocDNs.add(this.locationDN);
                } else {
                    dpText = this.dpContext.getDPDocumentByDN(this.currentUserDN);
                    this.dpDocDNs.add(this.currentUserDN);
                }
                if (dpText != null && dpText.length() > 0) {
                    this.message("DP doc available:\n");
                    this.dpRoot = this.dpFactory.createRoot((DPContext)this.dpContext, dpText);
                } else {
                    this.message("DP doc not available, so creating one");
                    this.dpRoot = this.dpFactory.createRoot(this.dpContext);
                }
            }
        }
        catch (DPError e) {
            this.error("DADPModelImpl.createDPRoot: Error creating dp root - " + e.getMessage());
            throw new DAConsoleException(0, (Throwable)e);
        }
    }

    private void mergeDPDocuments() throws DAConsoleException {
        try {
            if (this.isGlobal) {
                return;
            }
            if (this.locationDN != null) {
                this.mergeOrgOrRoleLevelDPs(this.dpMergeList, this.locationDN);
            }
            if (this.currentUserDN != null) {
                this.mergeUserLevelDPs(this.dpMergeList);
            }
            if (this.dpRoot != null) {
                this.dpRoot.addMergers(this.dpMergeList);
            }
        }
        catch (DPError e) {
            this.error("DADPModelImpl.mergeDPDocuments: Error merging dp docs - " + e.getMessage());
            throw new DAConsoleException(0, (Throwable)e);
        }
    }

    private void mergeUserLevelDPs(List dpMergeList) throws DAConsoleException {
        try {
            AMUser user = this.dpStoreConn.getUser(this.currentUserDN);
            Iterator roleDNs = user.getRoleDNs().iterator();
            String dpText = null;
            while (roleDNs.hasNext()) {
                String roleDN = (String)roleDNs.next();
                dpText = this.dpContext.getDPDocumentByDN(roleDN);
                if (dpText == null) continue;
                dpMergeList.add(this.dpFactory.createRoot((DPContext)this.dpContext, dpText));
                this.dpDocDNs.add(roleDN);
            }
            String currentDN = user.getOrganizationDN();
            dpText = this.dpContext.getDPDocumentByDN(currentDN);
            if (dpText != null) {
                dpMergeList.add(this.dpFactory.createRoot((DPContext)this.dpContext, dpText));
                this.dpDocDNs.add(currentDN);
            }
            this.mergeOrgOrRoleLevelDPs(dpMergeList, currentDN);
        }
        catch (Exception e) {
            this.error("DADPModelImpl.mergeUserLevelDPs: Error merging user level dp docs - " + e.getMessage());
            throw new DAConsoleException(0, (Throwable)e);
        }
    }

    private void mergeOrgOrRoleLevelDPs(List dpMergeList, String currentDN) {
        String dpText = null;
        String rootSuffix = AMSystemConfig.rootSuffix;
        while (!currentDN.equalsIgnoreCase(rootSuffix)) {
            dpText = this.dpContext.getDPDocumentByDN(currentDN = AMAdminUtils.getParent((String)currentDN));
            if (dpText == null) continue;
            dpMergeList.add(this.dpFactory.createRoot((DPContext)this.dpContext, dpText));
            this.dpDocDNs.add(currentDN);
        }
        this.mergeGlobalLevelDP(dpMergeList);
    }

    private void mergeGlobalLevelDP(List dpMergeList) {
        String dpText = this.dpContext.getGlobalDPDocument();
        if (dpText != null) {
            dpMergeList.add(this.dpFactory.createRoot((DPContext)this.dpContext, dpText));
            this.dpDocDNs.add(GLOBAL_KEY);
        }
    }

    public Collator getCollator() {
        return this.collator;
    }

    public long getDPDocumentLastRead() {
        long result = -1L;
        Iterator dpDNs = this.dpDocDNs.iterator();
        while (dpDNs.hasNext()) {
            long time = this.dpContext.getDPDocumentLastRead((String)dpDNs.next());
            if (time <= result) continue;
            result = time;
        }
        return result;
    }

    public long getDPDocumentLastModified() {
        long result = -1L;
        Iterator dpDNs = this.dpDocDNs.iterator();
        while (dpDNs.hasNext()) {
            long time = this.dpContext.getDPDocumentLastModified((String)dpDNs.next());
            if (time <= result) continue;
            result = time;
        }
        return result;
    }

    protected String getHead(String rpn) {
        String head = null;
        if (rpn != null && rpn.length() != 0) {
            int index = rpn.indexOf("/");
            head = index == -1 ? rpn : rpn.substring(0, index);
        }
        return head;
    }

    protected String getTail(String rpn) {
        String tail = null;
        if (rpn != null && rpn.length() != 0) {
            int index = rpn.lastIndexOf("/");
            tail = index == -1 ? rpn : rpn.substring(index + 1, rpn.length());
        }
        return tail;
    }

    protected String getPreceding(String source, String substring) {
        String preceeding = null;
        int index = -1;
        if (source != null && substring != null && (index = source.indexOf(substring)) != -1) {
            preceeding = source.substring(0, index);
            if (preceeding.endsWith("/")) {
                preceeding = preceeding.substring(0, preceeding.length() - 1);
            }
            preceeding = preceeding.length() == 0 ? null : preceeding;
        }
        return preceeding;
    }

    protected String getFollowing(String source, String substring) {
        String following = null;
        int index = -1;
        if (source != null && substring != null && (index = source.indexOf(substring)) != -1) {
            following = source.substring(index + substring.length());
            if (following.startsWith("/")) {
                following = following.substring(1);
            }
            following = following.length() == 0 ? null : following;
        }
        return following;
    }

    public String[][] getContainerPath(String fqcn) {
        StringTokenizer st = new StringTokenizer(fqcn == null ? "" : fqcn, "/");
        int nTokens = st.countTokens();
        String[][] tokens = new String[nTokens + 1][2 * (nTokens + 1)];
        tokens[0][0] = DEFAULT_CONTAINER_PATH;
        tokens[0][1] = "";
        int i = 1;
        while (st.hasMoreTokens()) {
            String label;
            tokens[i][0] = label = st.nextToken();
            String value = this.getPreceding(fqcn, label);
            value = value == null ? label : value + "/" + label;
            tokens[i][1] = value;
            ++i;
        }
        return tokens;
    }

    public void store() throws DAConsoleException {
        if (!this.dpRoot.isDirty()) {
            return;
        }
        this.dpRoot.setDirty(false);
        StringBuffer buff = new StringBuffer(100);
        this.dpRoot.toXML(buff, 0);
        String dpText = buff.toString();
        try {
            if (this.isGlobal) {
                this.dpContext.storeGlobalDPDocument(dpText);
            } else {
                this.dpContext.storeDPDocumentByDN(this.currentUserDN == null ? this.locationDN : this.currentUserDN, dpText);
            }
        }
        catch (ContextError e) {
            this.error("DADPModelImpl.store: " + e.toString());
            throw new DAConsoleException(0, (Throwable)e);
        }
    }

    public final void error(String message) {
        debug.error(message);
    }

    public final void error(String message, Throwable e) {
        debug.error(message, e);
    }

    public final void warning(String message) {
        if (debug.warningEnabled()) {
            debug.warning(message);
        }
    }

    public final void warning(String message, Throwable e) {
        if (debug.warningEnabled()) {
            debug.warning(message, e);
        }
    }

    public final void message(String message) {
        if (debug.messageEnabled()) {
            debug.message(message);
        }
    }

    public final void message(String message, Exception e) {
        if (debug.messageEnabled()) {
            debug.message(message, (Throwable)e);
        }
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }
}

