/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.sun.portal.admin.common.DesktopConstants;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.fabric.common.GenericDSAMEAttributeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DesktopGetSetAttributeHandler
extends GenericDSAMEAttributeHandler
implements DesktopConstants {
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private static final int SINGLE_COMMA_SEPERATED_STRING = 99;
    private DSAMEMultiPortalConstants dmpc = null;
    private Map dynAttrMap = new HashMap();
    private Map globalAttrMap = new HashMap();
    private Map attrInfoMap = new HashMap();

    public void init(String component, String domainId, String portalId) throws PSMBeanException {
        super.init(component, domainId, portalId);
        DSAMEMultiPortalConstants.createInstance(portalId);
        this.dmpc = DSAMEMultiPortalConstants.getInstance(portalId);
        this.buildAttrMaps();
    }

    private void buildAttrMaps() {
        this.dynAttrMap.put("DesktopType", this.dmpc.MP_ATTR_DESKTOP_TYPE);
        this.dynAttrMap.put("EditChannel", this.dmpc.MP_ATTR_EDITPROVIDERCONTAINERNAME);
        this.dynAttrMap.put("DefaultChannel", this.dmpc.MP_ATTR_DEFAULTCHANNELNAME);
        this.dynAttrMap.put("ShowDesktopAttribute", "sunPortalDesktopDpCanView");
        this.dynAttrMap.put("CommunityParentContainerURLParameter", this.dmpc.MP_ATTR_COMMUNITY_PARENT_CONTAINER_URL_PARAMETER);
        this.dynAttrMap.put("CommunityHomeContainer", this.dmpc.MP_ATTR_COMMUNITY_HOME_CONTAINER_NAME);
        this.dynAttrMap.put("CommunityCreateContainer", this.dmpc.MP_ATTR_COMMUNITY_CREATE_CONTAINER_NAME);
        this.dynAttrMap.put("COSPriority", "priority");
        this.globalAttrMap.put("NamespaceURI", "sunPortalDesktopDpNamespaceURI");
        this.globalAttrMap.put("EnableAuthless", "sunPortalDesktopEnableAuthlessDesktop");
        this.globalAttrMap.put("EnableFederation", "sunPortalDesktopEnableFederation");
        this.globalAttrMap.put("HostedProviderId", "sunPortalDesktopHostedProviderID");
        this.globalAttrMap.put("MaxClientSessions", "sunPortalDesktopClientSessionsMaximum");
        this.globalAttrMap.put("DefaultAuthlessUID", "sunPortalDesktopDefaultAuthlessUID");
        this.globalAttrMap.put("EnableXMLValidation", "sunPortalDesktopDpIsValidating");
        this.globalAttrMap.put("AuthorizedAuthlessUserIds", "sunPortalDesktopAuthorizedAuthlessUIDs");
        this.globalAttrMap.put("ClientSessionReapInterval", "sunPortalDesktopClientSessionReapInterval");
        this.globalAttrMap.put("ClientSessionMaximumInactive", "sunPortalDesktopClientSessionInactiveMaximum");
        this.globalAttrMap.put("DisableAuthlessForFederatedUsers", "sunPortalDesktopDisableAuthlessForFederatedUsers");
        this.globalAttrMap.put("AccessURL", "sunPortalDesktopAccessURL");
        this.attrInfoMap.put("DesktopType", new Integer(99));
        this.attrInfoMap.put("EditChannel", new Integer(1));
        this.attrInfoMap.put("DefaultChannel", new Integer(1));
        this.attrInfoMap.put("ShowDesktopAttribute", new Integer(0));
        this.attrInfoMap.put("NamespaceURI", new Integer(1));
        this.attrInfoMap.put("EnableAuthless", new Integer(0));
        this.attrInfoMap.put("EnableFederation", new Integer(0));
        this.attrInfoMap.put("HostedProviderId", new Integer(1));
        this.attrInfoMap.put("MaxClientSessions", new Integer(2));
        this.attrInfoMap.put("DefaultAuthlessUID", new Integer(1));
        this.attrInfoMap.put("EnableXMLValidation", new Integer(0));
        this.attrInfoMap.put("AuthorizedAuthlessUserIds", new Integer(4));
        this.attrInfoMap.put("ClientSessionReapInterval", new Integer(2));
        this.attrInfoMap.put("ClientSessionMaximumInactive", new Integer(2));
        this.attrInfoMap.put("DisableAuthlessForFederatedUsers", new Integer(0));
        this.attrInfoMap.put("CommunityParentContainerURLParameter", new Integer(1));
        this.attrInfoMap.put("CommunityHomeContainer", new Integer(1));
        this.attrInfoMap.put("CommunityCreateContainer", new Integer(1));
        this.attrInfoMap.put("COSPriority", new Integer(2));
        this.attrInfoMap.put("AccessURL", new Integer(1));
    }

    public String getComponentName(String userFriendlyName) {
        return this.dmpc.MP_SUN_DESKTOP_SERVICE;
    }

    public String getAttributeName(String userFriendlyName) {
        String name = (String)this.dynAttrMap.get(userFriendlyName);
        if (name == null) {
            name = (String)this.globalAttrMap.get(userFriendlyName);
        }
        return name;
    }

    public List getAttribute(Map optionsMap) throws PSMBeanException {
        this.setAttributeType(optionsMap);
        return super.getAttribute(optionsMap);
    }

    public void setAttribute(List values, Map optionsMap) throws PSMBeanException {
        boolean inheritStr = Boolean.valueOf((String)optionsMap.get("inherit"));
        String attributeName = (String)optionsMap.get("attribute-name");
        int attributeValueType = (Integer)this.attrInfoMap.get(attributeName);
        if (!inheritStr) {
            if (attributeValueType == 4) {
                this.validateListTypeAttribute(attributeName, values, optionsMap);
            }
            if (attributeValueType != 4 && attributeValueType != 99) {
                this.validateSingleValueAttribute(values, optionsMap, attributeValueType);
            }
            if (attributeValueType == 99) {
                values = this.doAttributeValuesMassage(values, optionsMap);
            }
        }
        this.setAttributeType(optionsMap);
        try {
            super.setAttribute(values, optionsMap);
        }
        catch (Exception e) {
            throw new PSMBeanException("error.psadmin.set.failed", e.getMessage(), (Throwable)e);
        }
    }

    public void setAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        Set attrNames = (Set)optionsMap.get("attribute-names");
        HashMap globalAttrNameValueMap = new HashMap();
        HashMap dymanicAttrNameValueMap = new HashMap();
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String attributeName = (String)iter.next();
            if (this.isDynamic(attributeName)) {
                dymanicAttrNameValueMap.put(attributeName, nameValues.get(attributeName));
                continue;
            }
            globalAttrNameValueMap.put(attributeName, nameValues.get(attributeName));
        }
        if (dymanicAttrNameValueMap.size() > 0) {
            optionsMap.put("attribute-names", dymanicAttrNameValueMap.keySet());
            optionsMap.put("global", FALSE_VALUE);
            super.setAttributes(dymanicAttrNameValueMap, optionsMap);
        }
        if (globalAttrNameValueMap.size() > 0) {
            optionsMap.put("attribute-names", globalAttrNameValueMap.keySet());
            optionsMap.put("global", TRUE_VALUE);
            super.setAttributes(globalAttrNameValueMap, optionsMap);
        }
    }

    public Map getAttributes(Map optionsMap) throws PSMBeanException {
        HashMap retMap = new HashMap();
        Set attrNames = (Set)optionsMap.get("attribute-names");
        HashSet<String> globalAttrSet = new HashSet<String>();
        HashSet<String> dymanicAttrSet = new HashSet<String>();
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String attributeName = (String)iter.next();
            if (this.isDynamic(attributeName)) {
                dymanicAttrSet.add(attributeName);
                continue;
            }
            globalAttrSet.add(attributeName);
        }
        if (globalAttrSet.size() > 0) {
            optionsMap.put("attribute-names", globalAttrSet);
            optionsMap.put("global", TRUE_VALUE);
            retMap.putAll(super.getAttributes(optionsMap));
        }
        if (dymanicAttrSet.size() > 0) {
            optionsMap.put("attribute-names", dymanicAttrSet);
            optionsMap.put("global", FALSE_VALUE);
            retMap.putAll(super.getAttributes(optionsMap));
        }
        return retMap;
    }

    public void validate(List values, Map optionsMap) throws PSMBeanException {
        String operationName = (String)optionsMap.get("operation");
        if (operationName.equals("list")) {
            return;
        }
        if (optionsMap.get("attribute-name") == null) {
            return;
        }
        this.doSingleAttributeValidation(optionsMap);
    }

    private void doSingleAttributeValidation(Map optionsMap) throws PSMBeanException {
        String attributeName = (String)optionsMap.get("attribute-name");
        boolean isDynamicAttribute = false;
        if (this.dynAttrMap.containsKey(attributeName)) {
            isDynamicAttribute = true;
        } else if (!this.globalAttrMap.containsKey(attributeName)) {
            throw new PSMBeanException("error.psadmin.invalid.attribute.name");
        }
        boolean inheritStr = Boolean.valueOf((String)optionsMap.get("inherit"));
        String dn = (String)optionsMap.get("dn");
        if (!isDynamicAttribute && dn != null) {
            throw new PSMBeanException("error.psadmin.attribute.not.dn.specific");
        }
        if (inheritStr && !isDynamicAttribute) {
            throw new PSMBeanException("error.psadmin.inherit.available.only.for.dynamic.attribute");
        }
    }

    public Map listAttributes(Map optionsMap) throws PSMBeanException {
        HashMap<String, List> attributeMap = new HashMap<String, List>();
        attributeMap.put("DesktopType", this.getAttributeInfoList(4, "psadmin.list.desktop.desktoptype.desc", 0, null));
        attributeMap.put("DefaultChannel", this.getAttributeInfoList(1, "psadmin.list.desktop.defaultchannel.desc", 0, null));
        attributeMap.put("EditChannel", this.getAttributeInfoList(1, "psadmin.list.desktop.editchannel.desc", 0, null));
        attributeMap.put("ShowDesktopAttribute", this.getAttributeInfoList(0, "psadmin.list.desktop.showdesktopattribute.desc", 0, null));
        attributeMap.put("ClientSessionReapInterval", this.getAttributeInfoList(2, "psadmin.list.desktop.clientsessionreapinterval.desc", 0, null));
        attributeMap.put("ClientSessionMaximumInactive", this.getAttributeInfoList(2, "psadmin.list.desktop.clientsessionmaximuminactive.desc", 0, null));
        attributeMap.put("MaxClientSessions", this.getAttributeInfoList(2, "psadmin.list.desktop.maxclientsessions.desc", 0, null));
        attributeMap.put("EnableXMLValidation", this.getAttributeInfoList(0, "psadmin.list.desktop.enablexmlvalidation.desc", 0, null));
        attributeMap.put("NamespaceURI", this.getAttributeInfoList(1, "psadmin.list.desktop.namespaceuri.desc", 0, null));
        attributeMap.put("EnableFederation", this.getAttributeInfoList(0, "psadmin.list.desktop.enablefederation.desc", 0, null));
        attributeMap.put("HostedProviderId", this.getAttributeInfoList(1, "psadmin.list.desktop.hostedproviderid.desc", 0, null));
        attributeMap.put("DisableAuthlessForFederatedUsers", this.getAttributeInfoList(0, "psadmin.list.desktop.disableauthlessforfederatedusers.desc", 0, null));
        attributeMap.put("AccessURL", this.getAttributeInfoList(1, "psadmin.list.desktop.accessurl.desc", 0, null));
        attributeMap.put("DefaultAuthlessUID", this.getAttributeInfoList(1, "psadmin.list.desktop.defaultauthlessuid.desc", 0, null));
        attributeMap.put("AuthorizedAuthlessUserIds", this.getAttributeInfoList(4, "psadmin.list.desktop.authorizedauthlessuserids.desc", 0, null));
        attributeMap.put("EnableAuthless", this.getAttributeInfoList(0, "psadmin.list.desktop.enableauthless.desc", 0, null));
        attributeMap.put("CommunityParentContainerURLParameter", this.getAttributeInfoList(1, "psadmin.list.desktop.communityparentcontainerurlparameter.desc", 0, null));
        attributeMap.put("CommunityHomeContainer", this.getAttributeInfoList(1, "psadmin.list.desktop.communityhomecontainer.desc", 0, null));
        attributeMap.put("CommunityCreateContainer", this.getAttributeInfoList(1, "psadmin.list.desktop.communitycreatecontainer.desc", 0, null));
        attributeMap.put("COSPriority", this.getAttributeInfoList(2, "psadmin.list.desktop.cosPriority.desc", 0, null));
        return attributeMap;
    }

    private List getAttributeInfoList(int attributeType, String desc, int privilege, String exampleKey) {
        ArrayList<Object> infoList = new ArrayList<Object>();
        infoList.add(new Integer(attributeType));
        infoList.add(desc);
        infoList.add(new Integer(privilege));
        infoList.add(exampleKey);
        return infoList;
    }

    private void validateSingleValueAttribute(List values, Map optionsMap, int attributeType) throws PSMBeanException {
        List addValues = (List)optionsMap.get("add");
        List removeValues = (List)optionsMap.get("remove");
        if (addValues != null || removeValues != null || values.size() != 1) {
            throw new PSMBeanException("error.psadmin.attribute.is.single.valued");
        }
        String value_str = (String)values.get(0);
        switch (attributeType) {
            case 0: {
                if (value_str.equalsIgnoreCase(TRUE_VALUE) || value_str.equalsIgnoreCase(FALSE_VALUE)) break;
                throw new PSMBeanException("error.psadmin.attribute.is.boolean");
            }
            case 2: {
                try {
                    Integer.parseInt(value_str);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new PSMBeanException("error.psadmin.attribute.is.number");
                }
            }
        }
    }

    private void validateListTypeAttribute(String attributeName, List values, Map optionMap) throws PSMBeanException {
        if (attributeName.equals("AuthorizedAuthlessUserIds")) {
            this.validateAuthorizedAuthlessUserIds(values, optionMap);
        }
    }

    private void validateAuthorizedAuthlessUserIds(List values, Map optionMap) throws PSMBeanException {
        if (optionMap.get("remove") == null) {
            List valuesToVarify = values;
            if (valuesToVarify == null || values.size() == 0) {
                valuesToVarify = (List)optionMap.get("add");
            }
            if (valuesToVarify != null && valuesToVarify.size() > 0) {
                for (int i = 0; i < valuesToVarify.size(); ++i) {
                    String uid_pwd = (String)valuesToVarify.get(i);
                    if (uid_pwd.indexOf("|") >= 1) continue;
                    throw new PSMBeanException("desktop.errorAuthorizedAuthlessUserIds");
                }
            }
        }
    }

    private List getListFromCommaSeperatedString(List valuesList) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (valuesList == null || valuesList.size() == 0) {
            return valueList;
        }
        String commaSeperatedString = (String)valuesList.get(0);
        StringTokenizer st = new StringTokenizer(commaSeperatedString, ",");
        while (st.hasMoreTokens()) {
            valueList.add(st.nextToken());
        }
        return valueList;
    }

    private void removeValuesFromOrgList(List orgList, List removeItemList) {
        if (removeItemList != null && removeItemList.size() > 0) {
            orgList.removeAll(removeItemList);
        }
    }

    private void addValuesIntoOrgList(List orgList, List addItemList) {
        if (addItemList != null && addItemList.size() > 0) {
            orgList.addAll(addItemList);
        }
    }

    private String getCommaSeperatedStringFromList(List valuesList) {
        StringBuffer commSeperatedStringBuffer = new StringBuffer();
        Iterator ite = valuesList.iterator();
        while (ite.hasNext()) {
            commSeperatedStringBuffer.append(ite.next());
            commSeperatedStringBuffer.append(",");
        }
        if (commSeperatedStringBuffer.length() > 0) {
            commSeperatedStringBuffer.deleteCharAt(commSeperatedStringBuffer.length() - 1);
        }
        return commSeperatedStringBuffer.toString();
    }

    private List doAttributeValuesMassage(List values, Map optionsMap) throws PSMBeanException {
        String newValuesString = new String();
        if (values != null && values.size() > 0) {
            newValuesString = this.getCommaSeperatedStringFromList(values);
        } else {
            List orgListWithCommaSeperatedValues = this.getAttribute(optionsMap);
            List newValuesList = this.getListFromCommaSeperatedString(orgListWithCommaSeperatedValues);
            this.removeValuesFromOrgList(newValuesList, (List)optionsMap.get("remove"));
            optionsMap.remove("remove");
            this.addValuesIntoOrgList(newValuesList, (List)optionsMap.get("add"));
            optionsMap.remove("add");
            newValuesString = this.getCommaSeperatedStringFromList(newValuesList);
        }
        ArrayList<String> returnValues = new ArrayList<String>();
        returnValues.add(newValuesString);
        return returnValues;
    }

    private void setAttributeType(Map optionsMap) {
        String attributeName = (String)optionsMap.get("attribute-name");
        if (this.isDynamic(attributeName)) {
            optionsMap.put("global", FALSE_VALUE);
        } else {
            optionsMap.put("global", TRUE_VALUE);
        }
    }

    private boolean isDynamic(String name) {
        return this.dynAttrMap.containsKey(name);
    }
}

