/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.BackupVersion;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.desktop.admin.mbeans.tasks.DPHelper;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.deployment.DPBasedExCtx;
import com.sun.portal.desktop.deployment.DPBasedPPCtx;
import com.sun.portal.desktop.deployment.DPRootSpecifier;
import com.sun.portal.desktop.deployment.ExportFile;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.desktop.deployment.ProviderPackageContext;
import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class DesktopData {
    public static final String TEMPLATE_BASE_DIR_PROP = "templateBaseDir";
    public static final String COMMUNITY_TEMPLATE_BASE_DIR_PROP = "communityTemplateBaseDir";
    public static final String COMPILED = "compiled";
    public static final String DESKTOP = "desktop";
    public static final String PROVIDER = "provider";
    public static final String GLOBAL_KEY = "global";
    public static final String ORG_KEY = "organization";
    public static final String DEFAULT_ORG_KEY = "defaultOrganization";
    public static final String UTF8 = "UTF-8";
    public static final int SEARCH_LEVEL = 2;
    public static final String FS = File.separator;
    public static final String DEL = ";";
    private String m_Portal = null;
    private String m_Domain = null;
    private PSConfigContext m_PCC = null;
    private boolean m_Verbose = false;
    private SSOToken m_SSOToken = null;
    private Logger m_Logger = null;
    private ParFile m_Par = null;
    private String m_PortalUri = null;

    public DesktopData(SSOToken ssoToken, PSConfigContext pcc, String domainName, String portalName, boolean verbose, Logger logger, String portalUri) {
        this.m_SSOToken = ssoToken;
        this.m_PCC = pcc;
        this.m_Domain = domainName;
        this.m_Portal = portalName;
        this.m_Verbose = true;
        this.m_Logger = logger;
        this.m_PortalUri = portalUri;
    }

    public void exportProvider(String parFilePath, String dn, boolean global, byte[][] expfiles) throws DesktopDataException {
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0062");
        }
        try {
            ParFileBuilder pfb = null;
            String dconfFileName = this.getDesktopConfigFileName();
            System.setProperty("desktop.propertiesFile", dconfFileName);
            String pDataDir = this.m_PCC.getPSDataDir() + FS + "portals" + FS + this.m_Portal;
            String webSrcPath = pDataDir + FS + "web-src";
            System.setProperty("ps.staticDir", webSrcPath);
            String warDir = pDataDir + FS + "war";
            System.setProperty("ps.warDir", warDir);
            System.setProperty("ps.dataDir", pDataDir);
            DPRootSpecifier dpr = DPRootSpecifier.makeSpecifier(this.m_SSOToken, this.m_Portal);
            if (global) {
                dn = GLOBAL_KEY;
            }
            dpr.setDN(dn);
            DPBasedPPCtx ppctx = new DPBasedPPCtx(dpr, null);
            DPHelper dpHelper = DPHelper.getDPHelper(this.m_PCC, this.m_SSOToken, this.m_Portal);
            DPHelper.setLogger(this.m_Logger);
            String backupVersion = BackupVersion.generateBackupVersion((String)this.m_Domain, (String)this.m_Portal, (String)PROVIDER);
            pfb = new ParFileBuilder(this.m_Verbose, this.m_Logger, backupVersion);
            HashMap<String, String> namecheck = new HashMap<String, String>();
            for (int i = 0; i < expfiles.length; ++i) {
                File f = File.createTempFile(FileUtil.getRandomDirName(), null);
                FileOutputStream fo = new FileOutputStream(f);
                fo.write(expfiles[i]);
                ExportFile xpf = ExportFile.makeExportFile(f.getAbsolutePath(), dn, (ProviderPackageContext)ppctx);
                String nm = xpf.getDPEntryName();
                if (namecheck.get(nm) != null) {
                    Object[] tok = new Object[]{nm};
                    throw new ParFileException("errorExportDupEntry", tok);
                }
                namecheck.put(nm, nm);
                xpf.addEntry(pfb);
                f.delete();
            }
            pfb.makeParFile(parFilePath);
            if (this.m_Logger.isLoggable(Level.FINER)) {
                this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0063");
            }
        }
        catch (DesktopDataException pe) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0072", pe);
            throw pe;
        }
        catch (Exception e) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0073", e);
            throw new DesktopDataException("DesktopData.exportProvider(): " + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0074", t);
            throw new DesktopDataException("DesktopData.exportProvider(): " + t.getMessage(), t);
        }
    }

    public void importProvider(String parFile, List operations, boolean overwrite, String dpnode, boolean extractDP) throws DesktopDataException {
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0062");
        }
        boolean error = false;
        try {
            ParManifest pMan;
            String backupVersion;
            if (this.m_Par == null) {
                this.m_Par = ParFile.makeParFile(parFile);
            }
            if ((backupVersion = (pMan = this.m_Par.getParManifest()).getBackupVersion()) != null && BackupVersion.getType((String)backupVersion).equals(DESKTOP)) {
                throw new Exception("Not a Provider Par");
            }
            String dconfFileName = this.getDesktopConfigFileName();
            System.setProperty("desktop.propertiesFile", dconfFileName);
            String pDataDir = this.m_PCC.getPSDataDir() + FS + "portals" + FS + this.m_Portal;
            String webSrcPath = pDataDir + FS + "web-src";
            System.setProperty("ps.staticDir", webSrcPath);
            String warDir = pDataDir + FS + "war";
            System.setProperty("ps.warDir", warDir);
            System.setProperty("ps.dataDir", pDataDir);
            DPHelper dpHelper = DPHelper.getDPHelper(this.m_PCC, this.m_SSOToken, this.m_Portal);
            DPHelper.setLogger(this.m_Logger);
            DPRootSpecifier dpr = DPRootSpecifier.makeSpecifier(this.m_SSOToken, this.m_Portal);
            DPBasedExCtx pex = new DPBasedExCtx(dpr, this.m_Verbose, this.m_Logger, overwrite);
            if (dpnode != null) {
                dpr.setDN(dpnode);
            }
            if (operations.size() == 0) {
                this.m_Par.performAutoExtraction(pex, dpr.getDN(), extractDP);
            } else {
                for (int i = 0; i < operations.size(); ++i) {
                    String opstr = (String)operations.get(i);
                    ExtractOp op = ExtractOp.makeOpFromArgument(dpr.getDN(), opstr);
                    this.m_Par.performExtraction(pex, op, extractDP);
                }
            }
        }
        catch (DesktopDataException de) {
            throw de;
        }
        catch (Exception fn) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0073", fn);
            throw new DesktopDataException("DesktopData.importDesktop(): " + fn.getMessage(), fn);
        }
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0063");
        }
    }

    public void exportDesktop(String parFilePath, String base, boolean fsOnly, boolean dpOnly, String searchLevel) throws DesktopDataException {
        if (base == null) {
            base = GLOBAL_KEY;
        }
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0062");
        }
        try {
            Object[] tokens;
            ParFileBuilder pfb = null;
            DPBasedPPCtx ppctx = null;
            String dconfFileName = this.getDesktopConfigFileName();
            Map docs = null;
            HashMap<String, Document> parDocs = null;
            HashMap<String, Properties> properties = null;
            HashMap<String, String> dpMappings = new HashMap<String, String>();
            ppctx = new DPBasedPPCtx(null, null);
            System.setProperty("desktop.propertiesFile", dconfFileName);
            DPHelper dpHelper = DPHelper.getDPHelper(this.m_PCC, this.m_SSOToken, this.m_Portal);
            DPHelper.setLogger(this.m_Logger);
            if (!fsOnly) {
                Object[] tokens2;
                int level = this.getSearchLevel(searchLevel);
                Set nodes = dpHelper.getAllNames(level);
                parDocs = new HashMap<String, Document>();
                docs = dpHelper.getDocuments(nodes, level);
                Set keys = docs.keySet();
                String baseDn = this.m_PCC.getDefaultOrganization();
                int j = 0;
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    Document doc = (Document)docs.get(key);
                    Document parEntry = null;
                    parEntry = Par.makeParEntry(key, null, doc.getDocumentElement());
                    if (parEntry == null) continue;
                    if (this.m_Logger.isLoggable(Level.FINER)) {
                        tokens2 = new Object[]{key};
                        this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0064", tokens2);
                    }
                    if (dpHelper.isGlobal(key)) {
                        parDocs.put(GLOBAL_KEY, parEntry);
                        continue;
                    }
                    String nodeName = "node" + Integer.toString(++j);
                    key = key.equals(baseDn) ? "dpnode" : key.substring(0, key.toLowerCase().indexOf(baseDn.toLowerCase())) + "dpnode";
                    dpMappings.put(nodeName, key);
                    if (this.m_Logger.isLoggable(Level.FINER)) {
                        Object[] tokens3 = new Object[]{key, nodeName};
                        this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0065", tokens3);
                    }
                    parDocs.put(nodeName, parEntry);
                }
                if (!dpOnly) {
                    properties = new HashMap<String, Properties>();
                    Properties prop = null;
                    Iterator i2 = nodes.iterator();
                    while (i2.hasNext()) {
                        String node = (String)i2.next();
                        boolean hasProperty = dpHelper.getServiceAttributes(node, prop = new Properties());
                        if (!hasProperty) continue;
                        if (this.m_Logger.isLoggable(Level.FINER)) {
                            tokens2 = new Object[]{node};
                            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0066", tokens2);
                        }
                        if (dpHelper.isGlobal(node)) {
                            properties.put(GLOBAL_KEY, prop);
                            continue;
                        }
                        node = node.equals(baseDn) ? "dpnode" : node.substring(0, node.toLowerCase().indexOf(baseDn.toLowerCase())) + "dpnode";
                        Set nodeKeys = dpMappings.keySet();
                        if (dpMappings.containsValue(node)) {
                            Iterator k = nodeKeys.iterator();
                            while (k.hasNext()) {
                                String nodeKey = (String)k.next();
                                if (!((String)dpMappings.get(nodeKey)).equals(node)) continue;
                                properties.put(nodeKey, prop);
                            }
                            continue;
                        }
                        String nodeName = "node" + Integer.toString(++j);
                        dpMappings.put(nodeName, node);
                        properties.put(nodeName, prop);
                    }
                }
            }
            Vector files = new Vector();
            if (!dpOnly) {
                String pDataDir = this.m_PCC.getPSDataDir() + FS + "portals" + FS + this.m_Portal;
                System.setProperty("ps.dataDir", pDataDir);
                if (this.m_Logger.isLoggable(Level.FINER)) {
                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0067");
                }
                ppctx.addDirectory(TEMPLATE_BASE_DIR_PROP, null, true, false, null, 3, COMPILED, files);
                ppctx.addDirectory(COMMUNITY_TEMPLATE_BASE_DIR_PROP, null, true, true, null, 3, COMPILED, files);
                String webSrcPath = pDataDir + FS + "web-src";
                System.setProperty("ps.staticDir", webSrcPath);
                if (this.m_Logger.isLoggable(Level.FINER)) {
                    tokens = new Object[]{webSrcPath};
                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0068", tokens);
                }
                ppctx.addDirectory(null, null, true, true, null, 3, null, files);
                String warDir = pDataDir + FS + "war";
                String portalWarFile = this.m_PortalUri + ".war";
                System.setProperty("ps.warDir", warDir);
                System.setProperty("ps.warFile", portalWarFile.substring(1));
                if (this.m_Logger.isLoggable(Level.FINER)) {
                    Object[] tokens4 = new Object[]{warDir};
                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0069", tokens4);
                }
                ppctx.addDirectory("ps.warDir", null, false, true, null, 3, null, files);
            }
            String backupVersion = BackupVersion.generateBackupVersion((String)this.m_Domain, (String)this.m_Portal, (String)DESKTOP);
            pfb = new ParFileBuilder(this.m_Verbose, this.m_Logger, backupVersion);
            ExtractOp op = ExtractOp.makeOpWithDPMapping(DEFAULT_ORG_KEY, dpMappings);
            if (this.m_Logger.isLoggable(Level.FINER) && op != null) {
                tokens = new Object[]{op.toArg()};
                this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0070", tokens);
            }
            pfb.addDPEntry(base, parDocs, files, properties, op);
            if (this.m_Logger.isLoggable(Level.FINER)) {
                this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0071");
            }
            pfb.makeParFile(parFilePath);
            if (this.m_Logger.isLoggable(Level.FINER)) {
                this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0063");
            }
        }
        catch (DesktopDataException pe) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0072", pe);
            throw pe;
        }
        catch (Exception e) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0073", e);
            throw new DesktopDataException("DesktopData.exportDesktop(): " + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0074", t);
            throw new DesktopDataException("DesktopData.exportDesktop(): " + t.getMessage(), t);
        }
    }

    public boolean importDesktop(String parFile, boolean fsOnly, boolean dpOnly, boolean cont, String searchLevel, boolean overwrite, String dpnode) throws DesktopDataException {
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0062");
        }
        boolean error = false;
        try {
            if (this.m_Par == null) {
                this.m_Par = ParFile.makeParFile(parFile);
            }
            error = this.importPar(this.m_Par, fsOnly, dpOnly, cont, searchLevel, overwrite, dpnode);
        }
        catch (DesktopDataException de) {
            throw de;
        }
        catch (Exception fn) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0073", fn);
            throw new DesktopDataException("DesktopData.importDesktop(): " + fn.getMessage(), fn);
        }
        if (this.m_Logger.isLoggable(Level.FINER)) {
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0063");
        }
        return error;
    }

    /*
     * Loose catch block
     */
    private boolean importPar(ParFile par, boolean fsOnly, boolean dpOnly, boolean cont, String searchLevel, boolean overwrite, String dpnode) throws DesktopDataException {
        boolean error;
        block30: {
            block29: {
                error = false;
                String dconfFileName = this.getDesktopConfigFileName();
                System.setProperty("desktop.propertiesFile", dconfFileName);
                DPHelper dpHelper = DPHelper.getDPHelper(this.m_PCC, this.m_SSOToken, this.m_Portal);
                DPHelper.setLogger(this.m_Logger);
                ParManifest pMan = par.getParManifest();
                String entryName = this.getParEntryName(pMan);
                if (!fsOnly) {
                    Vector props;
                    Map dpMappings;
                    int level = this.getSearchLevel(searchLevel);
                    Vector docs = pMan.getDPEntryDPDocList(entryName);
                    ExtractOp op = pMan.getDPEntryAutoExtract(entryName);
                    Map map = dpMappings = op == null ? null : op.getDPMappings();
                    if (docs != null && (op == null || dpMappings == null)) {
                        this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0075");
                        throw new DesktopDataException("DesktopData.importDesktop(): Can not get AutoExtract string from par, exit");
                    }
                    if (this.m_Logger.isLoggable(Level.FINEST) && op != null) {
                        Object[] tokens = new Object[]{op.toArg()};
                        this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0070", tokens);
                    }
                    if (dpnode == null) {
                        dpnode = this.getDPNode(op);
                    }
                    Map docsMap = null;
                    if (docs != null && (docsMap = this.checkDocs(entryName, docs, dpMappings, dpnode, dpHelper, cont, level)) == null) {
                        error = true;
                    }
                    Map propsMap = null;
                    if (!dpOnly && (props = pMan.getDPEntryAttrPropList(entryName)) != null && !error) {
                        propsMap = this.checkProps(entryName, props, dpMappings, dpnode, dpHelper, cont, level);
                        if (props == null) {
                            error = true;
                        }
                    }
                    if (!error) {
                        Object[] tokens;
                        String base;
                        Iterator i;
                        String defaultOrg = this.m_PCC.getDefaultOrganization();
                        if (this.m_Logger.isLoggable(Level.FINEST)) {
                            Object[] tokens2 = new Object[]{defaultOrg};
                            this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0076", tokens2);
                        }
                        if (docsMap != null) {
                            Set docsKeySet = docsMap.keySet();
                            i = docsKeySet.iterator();
                            while (i.hasNext()) {
                                String nextDocKey = (String)i.next();
                                base = (String)docsMap.get(nextDocKey);
                                if (this.m_Logger.isLoggable(Level.FINER)) {
                                    tokens = new Object[]{base};
                                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0077", tokens);
                                }
                                Document doc = Par.streamToDom(par.getInputStream(pMan.getDPDocZip(nextDocKey)));
                                String dp = DPHelper.generateDPDocument(doc);
                                if (nextDocKey.equals(GLOBAL_KEY)) {
                                    if (overwrite) {
                                        dpHelper.storeGlobalDPDocument(dp);
                                        continue;
                                    }
                                    dpHelper.storeCombinedDPDocument(true, base, dp);
                                    continue;
                                }
                                if (overwrite) {
                                    dpHelper.storeDPDocument(base, dp);
                                    continue;
                                }
                                dpHelper.storeCombinedDPDocument(false, base, dp);
                            }
                        }
                        if (propsMap != null && !dpOnly) {
                            Set propsKeySet = propsMap.keySet();
                            i = propsKeySet.iterator();
                            while (i.hasNext()) {
                                String nextPropKey = (String)i.next();
                                base = (String)propsMap.get(nextPropKey);
                                if (this.m_Logger.isLoggable(Level.FINER)) {
                                    tokens = new Object[]{base};
                                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0078", tokens);
                                }
                                InputStream is = par.getInputStream(pMan.getPropertiesZip(nextPropKey));
                                Properties prop = new Properties();
                                prop.load(is);
                                is.close();
                                Enumeration<?> e = prop.propertyNames();
                                while (e.hasMoreElements()) {
                                    String key = (String)e.nextElement();
                                    String val = prop.getProperty(key);
                                    if (this.m_Logger.isLoggable(Level.FINEST)) {
                                        Object[] tokens3 = new Object[]{key, val};
                                        this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0079", tokens3);
                                    }
                                    dpHelper.setServiceAttribute(base, key, val, base.equals(GLOBAL_KEY));
                                }
                            }
                        }
                    }
                }
                DPBasedExCtx pex = new DPBasedExCtx(this.m_Verbose, this.m_Logger, overwrite);
                if (error || dpOnly) break block29;
                if (this.m_Logger.isLoggable(Level.FINER)) {
                    this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0080");
                }
                String pDataDir = this.m_PCC.getPSDataDir() + FS + "portals" + FS + this.m_Portal;
                String webSrcPath = pDataDir + FS + "web-src";
                System.setProperty("ps.staticDir", webSrcPath);
                String warDir = pDataDir + FS + "war";
                System.setProperty("ps.warDir", warDir);
                System.setProperty("ps.dataDir", pDataDir);
                par.performFileExtraction(pex, entryName, 3);
            }
            Object var31_33 = null;
            try {
                par.close();
            }
            catch (IOException ioe) {
                this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0081", ioe);
            }
            break block30;
            {
                catch (DesktopDataException pe) {
                    this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0072", pe);
                    throw pe;
                }
                catch (Throwable t) {
                    this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0074", t);
                    throw new DesktopDataException("DesktopData.importDesktop(): " + t.getMessage(), t);
                }
            }
            catch (Throwable throwable) {
                Object var31_34 = null;
                try {
                    par.close();
                }
                catch (IOException ioe) {
                    this.m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0081", ioe);
                }
                throw throwable;
            }
        }
        return error;
    }

    private String getDesktopConfigFileName() {
        String dtConfDir = this.m_PCC.getPSDataDir() + FS + "portals" + FS + this.m_Portal + FS + "config";
        String dtConf = dtConfDir + FS + "desktopconfig.properties";
        if (this.m_Logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{dtConf};
            this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0082", tokens);
        }
        return dtConf;
    }

    private String getParEntryName(ParManifest pMan) throws DesktopDataException {
        String entryName = null;
        try {
            Vector entries = pMan.getDPEntryList();
            if (entries.size() > 1) {
                throw new DesktopDataException("DesktopData.getParEntryName(): wrong backup file format.");
            }
            entryName = (String)entries.iterator().next();
            if (this.m_Logger.isLoggable(Level.FINER)) {
                Object[] tokens = new Object[]{entryName};
                this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0083", tokens);
            }
        }
        catch (Exception e) {
            throw new DesktopDataException("DesktopData.getParEntryName():" + e.getMessage());
        }
        return entryName;
    }

    private String getDPNode(ExtractOp op) {
        if (op == null) {
            return null;
        }
        String dpNode = op.getDPNode();
        if (dpNode.equals("") || dpNode.equals(DEFAULT_ORG_KEY)) {
            dpNode = this.m_PCC.getDefaultOrganization();
        }
        if (this.m_Logger.isLoggable(Level.FINER)) {
            Object[] tokens = new Object[]{dpNode};
            this.m_Logger.log(Level.FINER, "PSDT_CSPDAMT0084", tokens);
        }
        return dpNode;
    }

    private Map checkDocs(String base, Vector restoreV, Map dpMappings, String dpnode, DPHelper dpHelper, boolean cont, int level) throws DesktopDataException {
        HashMap<String, String> docsMap = new HashMap<String, String>();
        Set dpMapKeys = dpMappings.keySet();
        Set current = null;
        current = base != null && base.equals(GLOBAL_KEY) ? dpHelper.getAllNames(level) : dpHelper.getAllNamesFromBase(base, level, false);
        try {
            Iterator i = restoreV.iterator();
            while (i.hasNext()) {
                Object[] tokens;
                String docName = (String)i.next();
                String dn = null;
                docName = docName.substring(0, docName.indexOf("."));
                if (this.m_Logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{docName};
                    this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0085", tokens);
                }
                if (dpMapKeys.contains(docName)) {
                    dn = (String)dpMappings.get(docName);
                    dn = dn.replaceFirst("dpnode", dpnode);
                }
                docName = URLDecoder.decode(docName, UTF8);
                if (this.m_Logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{dn};
                    this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0086", tokens);
                }
                if (!(current.contains(dn) || docName.equals(GLOBAL_KEY) || docName.equals(DEFAULT_ORG_KEY))) {
                    if (this.m_Logger.isLoggable(Level.WARNING)) {
                        tokens = new Object[]{dn};
                        this.m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0087", tokens);
                    }
                    if (cont) continue;
                    if (this.m_Logger.isLoggable(Level.WARNING)) {
                        this.m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0088");
                    }
                    return null;
                }
                if (docName.equals(GLOBAL_KEY)) {
                    docsMap.put(GLOBAL_KEY, GLOBAL_KEY);
                    continue;
                }
                if (dn == null) continue;
                docsMap.put(docName, dn);
            }
        }
        catch (Exception e) {
            throw new DesktopDataException(e.getMessage(), e);
        }
        return docsMap;
    }

    private Map checkProps(String base, Vector restoreV, Map dpMappings, String dpnode, DPHelper dpHelper, boolean cont, int level) throws DesktopDataException {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        Set dpMapKeys = dpMappings.keySet();
        Set current = null;
        current = base != null && base.equals(GLOBAL_KEY) ? dpHelper.getAllNames(level) : dpHelper.getAllNamesFromBase(base, level, false);
        try {
            Iterator i = restoreV.iterator();
            while (i.hasNext()) {
                Object[] tokens;
                String key = (String)i.next();
                String dn = null;
                key = key.substring(0, key.indexOf("."));
                if (this.m_Logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{key};
                    this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0089", tokens);
                }
                if (dpMapKeys.contains(key)) {
                    dn = (String)dpMappings.get(key);
                    dn = dn.replaceFirst("dpnode", dpnode);
                    if (this.m_Logger.isLoggable(Level.FINEST)) {
                        tokens = new Object[]{dn};
                        this.m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0090", tokens);
                    }
                }
                key = URLDecoder.decode(key, UTF8);
                if (!(current.contains(dn) || key.equals(GLOBAL_KEY) || key.equals(DEFAULT_ORG_KEY))) {
                    if (this.m_Logger.isLoggable(Level.WARNING)) {
                        tokens = new Object[]{dn};
                        this.m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0091", tokens);
                    }
                    if (cont) continue;
                    if (this.m_Logger.isLoggable(Level.WARNING)) {
                        this.m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0088");
                    }
                    return null;
                }
                if (key.equals(GLOBAL_KEY)) {
                    propsMap.put(GLOBAL_KEY, GLOBAL_KEY);
                    continue;
                }
                if (dn == null) continue;
                propsMap.put(key, dn);
            }
        }
        catch (Exception e) {
            throw new DesktopDataException(e.getMessage(), e);
        }
        return propsMap;
    }

    private int getSearchLevel(String searchLevel) {
        int level = 2;
        try {
            if (searchLevel != null && (level = Integer.parseInt(searchLevel)) < 0) {
                level = 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }
}

