/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.DesktopConstants;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.taskadmin.ChannelTaskAdmin;
import com.sun.portal.taskadmin.TaskAdminException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DPTreeHelper
extends ChannelTaskAdmin
implements DesktopConstants {
    private Logger logger = null;
    private List hierarchy = new ArrayList();

    public void setLogger(Logger pLogger) {
        this.logger = pLogger;
    }

    public DPTreeHelper(SSOToken token, String baseDN, String portalId) throws TaskAdminException {
        super(token, baseDN, portalId);
    }

    public Object[] getVisualTree(String rootContainer) throws TaskAdminException {
        return this.processNode(rootContainer, "0");
    }

    private Object[] processNode(String channelName, String channelType) throws TaskAdminException {
        List chNamesList;
        this.hierarchy.add(channelName);
        this.logger.log(Level.FINEST, "Processing Channel : " + channelName);
        TreeSet chNames = Collections.EMPTY_SET;
        ArrayList<Object[]> children = null;
        if (Integer.parseInt(channelType) < 3 && (chNamesList = this.getAvailableChannels(channelName)) != null) {
            chNames = new TreeSet(chNamesList);
        }
        this.logger.log(Level.FINEST, "Set of Children : " + chNames);
        if (!chNames.isEmpty()) {
            children = new ArrayList<Object[]>(chNames.size());
        }
        Iterator iterator = chNames.iterator();
        while (iterator.hasNext()) {
            Object[] child = null;
            String childChannelName = (String)iterator.next();
            if (this.hierarchy.contains(childChannelName)) {
                throw new TaskAdminException("Recursion Detected in Desktop");
            }
            this.logger.log(Level.FINEST, "Child Channel Name : " + childChannelName);
            if (!this.isDisplayable(childChannelName)) {
                this.logger.log(Level.FINEST, "Child Not Displayable: " + childChannelName);
                continue;
            }
            if (!this.canAccess(childChannelName)) {
                this.logger.log(Level.FINEST, "Child Not Accessible: " + childChannelName);
                continue;
            }
            DPChannel childChannel = this.getDPChannel(childChannelName);
            List selectedChannels = this.getSelectedChannels(channelName);
            if (childChannel instanceof DPContainerChannel) {
                if (selectedChannels.contains(childChannelName)) {
                    child = this.processNode(childChannelName, "1");
                    this.logger.log(Level.FINEST, "Channel Type : 1");
                } else {
                    child = this.processNode(childChannelName, "2");
                    this.logger.log(Level.FINEST, "Channel Type : 2");
                }
            } else {
                String type;
                if (selectedChannels.contains(childChannelName)) {
                    type = this.getChannelType(childChannelName, true);
                    child = this.processNode(childChannelName, type);
                } else {
                    type = this.getChannelType(childChannelName, false);
                    child = this.processNode(childChannelName, type);
                }
                this.logger.log(Level.FINEST, "Channel Type : " + type);
            }
            children.add(child);
        }
        this.hierarchy.remove(channelName);
        Object[] currNode = new Object[]{channelName, channelType, children};
        return currNode;
    }

    private String getChannelType(String childChannelName, boolean isSelected) {
        String classname = null;
        String type = "3";
        try {
            classname = this.getClassName(childChannelName);
            if (classname != null) {
                type = classname.endsWith(PORTLET_CLASS) ? (isSelected ? "5" : "6") : (classname.endsWith(REMOTE_PORTLET_CLASS) ? (isSelected ? "7" : "8") : (isSelected ? "3" : "4"));
            }
        }
        catch (TaskAdminException tae) {
            // empty catch block
        }
        return type;
    }

    public Object[] getPhysicalTree() throws TaskAdminException {
        Object[] topNode = this.processDPNode(null, "0");
        String topNodeName = this.dpRoot.getName();
        if (topNodeName.length() < 1) {
            topNodeName = "_root";
        }
        topNode[0] = topNodeName;
        return topNode;
    }

    private Object[] processDPNode(String channelName, String channelType) throws TaskAdminException {
        this.logger.log(Level.FINEST, "Processing Channel : " + channelName);
        DPNode currDPNode = null;
        currDPNode = channelName != null ? this.getDPChannel(channelName) : this.dpRoot;
        TreeSet chNames = Collections.EMPTY_SET;
        ArrayList<Object[]> children = null;
        if (Integer.parseInt(channelType) < 3) {
            chNames = new TreeSet(this.getChannelNames(currDPNode));
        }
        this.logger.log(Level.FINEST, "Set of Children : " + chNames);
        if (!chNames.isEmpty()) {
            children = new ArrayList<Object[]>(chNames.size());
        }
        Iterator iterator = chNames.iterator();
        while (iterator.hasNext()) {
            Object[] child = null;
            String childFQCN = null;
            String childChannelName = (String)iterator.next();
            childFQCN = channelName == null ? childChannelName : channelName + CHANNEL_NAME_SEPARATOR + childChannelName;
            if (!this.isDisplayable(childFQCN)) {
                this.logger.log(Level.FINEST, "Child Not Displayable: " + childFQCN);
                continue;
            }
            if (!this.canAccess(childFQCN)) {
                this.logger.log(Level.FINEST, "Child Not Accessible: " + childFQCN);
                continue;
            }
            this.logger.log(Level.FINEST, "Child Channel Name : " + childFQCN);
            DPChannel childChannel = this.getDPChannel(childFQCN);
            if (childChannel instanceof DPContainerChannel) {
                child = this.processDPNode(childFQCN, "1");
                this.logger.log(Level.FINEST, "Channel Type : 1");
            } else {
                String type = this.getChannelType(childFQCN, true);
                child = this.processDPNode(childFQCN, type);
                this.logger.log(Level.FINEST, "Channel Type : " + type);
            }
            children.add(child);
        }
        Object[] currNode = new Object[]{channelName, channelType, children};
        return currNode;
    }
}

