/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAException;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAUtil;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.util.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DPHelper {
    public static final String FS = File.separator;
    public static String DESKTOP = "desktop";
    public static String SUBSCRIPTIONS = "subscriptions";
    private AdminDPContext m_ADPContext;
    private XMLDPFactory m_Factory;
    private String m_Portal;
    private DSAMEMultiPortalConstants m_Conts;
    private PSConfigContext m_PCC = null;
    private static Logger m_Logger = null;
    public static final String DELIM = "@@@!!!";
    static final int INDENT_SPACES = 4;

    public static void setLogger(Logger logger) {
        m_Logger = logger;
    }

    private DPHelper(PSConfigContext pcc, SSOToken ssoToken, String portal) throws DesktopDataException {
        this.m_Portal = portal;
        this.m_ADPContext = (AdminDPContext)DPHelper.getAdminDPContext(this.m_Portal);
        this.m_ADPContext.init(ssoToken, null, portal);
        this.m_Factory = XMLDPFactory.getInstance();
        this.m_PCC = pcc;
    }

    public static DPHelper getDPHelper(PSConfigContext pcc, SSOToken ssoToken, String portal) throws DesktopDataException {
        return new DPHelper(pcc, ssoToken, portal);
    }

    public Document getDocument(String base) {
        Document doc = null;
        try {
            String buf = this.m_ADPContext.getDPDocument(base);
            if (buf != null) {
                XMLDPRoot dpRoot = (XMLDPRoot)this.m_Factory.createRoot((DPContext)this.m_ADPContext, buf);
                doc = dpRoot.getDocument();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return doc;
    }

    public String getDPDocument(String base) {
        return this.m_ADPContext.getDPDocument(base);
    }

    public Set getAllNamesFromBase(String base, int level, boolean includeParent) {
        return this.m_ADPContext.getAllNamesFromBase(base, level, includeParent);
    }

    public Set getAllNames(int level) {
        return this.m_ADPContext.getAllNames(level);
    }

    public Map getDocuments(Set nodes, int level) {
        HashMap<String, Document> docs = new HashMap<String, Document>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Document doc = this.getDocument(key);
            if (doc == null) continue;
            docs.put(key, doc);
        }
        return docs;
    }

    public Set getDocumentNames(String base, int level) {
        Set dns = this.m_ADPContext.getAllNamesFromBase(base, level, false);
        HashSet<String> docs = new HashSet<String>();
        Iterator i = dns.iterator();
        while (i.hasNext()) {
            Document doc;
            String key = (String)i.next();
            if (m_Logger.isLoggable(Level.FINEST)) {
                Object[] tokens = new Object[]{key};
                m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0092", tokens);
            }
            if ((doc = this.getDocument(key)) == null) continue;
            docs.add(key);
        }
        return docs;
    }

    public Set getDocumentNames(int level) {
        Set dns = this.m_ADPContext.getAllNames(level);
        HashSet<String> docs = new HashSet<String>();
        Iterator i = dns.iterator();
        while (i.hasNext()) {
            Document doc;
            String key = (String)i.next();
            if (m_Logger.isLoggable(Level.FINEST)) {
                Object[] tokens = new Object[]{key};
                m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0092", tokens);
            }
            if ((doc = this.getDocument(key)) == null) continue;
            docs.add(key);
        }
        return docs;
    }

    public void setServiceAttribute(String base, String key, String val, boolean isGlobal) throws DesktopDataException {
        ArrayList tokList = new ArrayList();
        ArrayList realNameList = new ArrayList();
        Properties attrConf = this.getConfProp("ExportServiceAttrMap.properties");
        this.getExportServices(tokList, realNameList);
        for (int i = 0; i < tokList.size(); ++i) {
            String service = (String)realNameList.get(i);
            String attrNameStr = (String)attrConf.get(tokList.get(i));
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("operation", "set");
            if (!isGlobal) {
                attrMap.put("dn", base);
            }
            if (service.toLowerCase().indexOf(DESKTOP) != -1) {
                attrMap.put("component", DESKTOP);
            } else if (service.toLowerCase().indexOf(SUBSCRIPTIONS) != -1) {
                attrMap.put("component", SUBSCRIPTIONS);
            }
            if (attrNameStr.indexOf(key) == -1) continue;
            attrMap.put("attribute-name", key);
            List vals = this.stringToList(val);
            if (m_Logger.isLoggable(Level.FINEST)) {
                Object[] tokens = new Object[]{base, service, key, vals.toString()};
                m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0093", tokens);
            }
            if (vals.isEmpty()) continue;
            this.invokeSetAttribute(vals, attrMap);
            break;
        }
    }

    public boolean isGlobal(String base) {
        return this.m_ADPContext.isGlobal(base);
    }

    public boolean getServiceAttributes(String dn, Properties prop) throws DesktopDataException {
        boolean hasProperty = false;
        ArrayList tokList = new ArrayList();
        ArrayList realNameList = new ArrayList();
        Properties attrConf = this.getConfProp("ExportServiceAttrMap.properties");
        this.getExportServices(tokList, realNameList);
        for (int ind = 0; ind < tokList.size(); ++ind) {
            String key = (String)tokList.get(ind);
            String service = (String)realNameList.get(ind);
            ArrayList attrNames = new ArrayList();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            this.getServiceAttributeNames((String)attrConf.get(key), attrNames);
            if (m_Logger.isLoggable(Level.FINEST)) {
                Object[] tokens = new Object[]{dn, service, ((Object)attrNames).toString()};
                m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0094", tokens);
            }
            attrMap.put("operation", "get");
            if (!this.isGlobal(dn)) {
                attrMap.put("dn", dn);
            }
            if (service.toLowerCase().indexOf(DESKTOP) != -1) {
                attrMap.put("component", DESKTOP);
            } else if (service.toLowerCase().indexOf(SUBSCRIPTIONS) != -1) {
                attrMap.put("component", SUBSCRIPTIONS);
            }
            for (int k = 0; k < attrNames.size(); ++k) {
                String attrName = (String)attrNames.get(k);
                if (m_Logger.isLoggable(Level.INFO)) {
                    Object[] tokens = new Object[]{attrName};
                    m_Logger.log(Level.INFO, "PSDT_CSPDAMT0095", tokens);
                }
                attrMap.put("attribute-name", attrName);
                List vals = this.invokeGetAttribute(attrMap);
                if (vals == null || vals.isEmpty()) continue;
                hasProperty = true;
                String val = this.listToString(vals);
                if (m_Logger.isLoggable(Level.INFO)) {
                    Object[] tokens = new Object[]{val};
                    m_Logger.log(Level.INFO, "PSDT_CSPDAMT0096", tokens);
                }
                prop.setProperty(attrName, val);
            }
        }
        return hasProperty;
    }

    private void getExportServices(List tokList, List realNameList) throws DesktopDataException {
        Properties svcConf = this.getConfProp("PSServiceConfig.properties");
        String exportSvcList = svcConf.getProperty("ExportServices", "");
        StringTokenizer exportSvcTokens = new StringTokenizer(exportSvcList);
        while (exportSvcTokens.hasMoreTokens()) {
            String exportService = exportSvcTokens.nextToken();
            tokList.add(exportService);
            exportService = exportService.replaceFirst("%PORTAL_ID%", this.m_Portal);
            realNameList.add(exportService);
            if (!m_Logger.isLoggable(Level.FINEST)) continue;
            Object[] tokens = new Object[]{exportService};
            m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0097", tokens);
        }
    }

    private Properties getConfProp(String config) throws DesktopDataException {
        Properties svcConf = new Properties();
        String svcConfLocation = null;
        try {
            String psLibLocation = this.m_PCC.getPSBaseDir() + FS + "lib";
            svcConfLocation = psLibLocation + FS + config;
            svcConf.load(new FileInputStream(svcConfLocation));
        }
        catch (FileNotFoundException fe) {
            throw new DesktopDataException(fe.getMessage(), fe);
        }
        catch (IOException ioe) {
            throw new DesktopDataException("DPHelper.getConfProp() ", ioe);
        }
        return svcConf;
    }

    private void getServiceAttributeNames(String value, List attrNames) {
        if (value != null) {
            StringTokenizer attrNameTokens = new StringTokenizer(value);
            int i = 0;
            while (attrNameTokens.hasMoreTokens()) {
                String attrName = attrNameTokens.nextToken();
                attrNames.add(i, attrName);
                ++i;
            }
        }
    }

    private List invokeGetAttribute(Map attrMap) {
        List vals = null;
        String[] signature = new String[]{"java.util.Map"};
        Object[] params = new Object[]{attrMap};
        try {
            ObjectName on = AdminUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.m_Portal);
            MBeanServer mbs = PASModule.getMBeanServer();
            vals = (List)mbs.invoke(on, "getAttribute", params, signature);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vals;
    }

    private void invokeSetAttribute(List vals, Map attrMap) {
        String[] signature = new String[]{"java.util.List", "java.util.Map"};
        Object[] params = new Object[]{vals, attrMap};
        try {
            ObjectName on = AdminUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.m_Portal);
            MBeanServer mbs = PASModule.getMBeanServer();
            mbs.invoke(on, "setAttribute", params, signature);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String generateDPDocument(Document doc) {
        StringBuffer st = XMLDPRoot.getXMLHeader();
        Element e = (Element)doc.getElementsByTagName("DisplayProfile").item(0);
        if (e == null) {
            return null;
        }
        DPHelper.toStringBuffer(e, st, 1);
        return st.toString();
    }

    public void storeCombinedDPDocument(boolean isGlobal, String base, String dp) throws DesktopDataException {
        DPRoot baseRoot = null;
        String baseDoc = null;
        Object mergedDp = null;
        HashSet docs = new HashSet();
        baseDoc = isGlobal ? this.m_ADPContext.getGlobalDPDocument() : this.m_ADPContext.getDPDocument(base);
        baseRoot = baseDoc != null && baseDoc.length() > 0 ? this.m_Factory.createRoot((DPContext)this.m_ADPContext, baseDoc) : this.m_Factory.createRoot(this.m_ADPContext);
        DPRoot dpRoot = this.m_Factory.createRoot((DPContext)this.m_ADPContext, dp);
        StringBuffer b = new StringBuffer(256);
        try {
            DPAUtil.combineRoots(dpRoot, baseRoot);
        }
        catch (DPAException dpe) {
            throw new DesktopDataException("DPHelper.storeCombinedDpDocument", dpe);
        }
        dpRoot.toXML(b, 0);
        String combinedDp = b.toString();
        if (isGlobal) {
            this.storeGlobalDPDocument(combinedDp);
        } else {
            this.storeDPDocument(base, combinedDp);
        }
    }

    public void storeGlobalDPDocument(String dp) {
        this.m_ADPContext.storeGlobalDPDocument(dp);
        if (m_Logger.isLoggable(Level.INFO)) {
            Object[] tokens = new Object[]{"global"};
            m_Logger.log(Level.INFO, "PSDT_CSPDAMT0115", tokens);
        }
    }

    public void storeDPDocument(String base, String dp) {
        this.m_ADPContext.storeDPDocument(base, dp);
        if (m_Logger.isLoggable(Level.INFO)) {
            Object[] tokens = new Object[]{base};
            m_Logger.log(Level.INFO, "PSDT_CSPDAMT0115", tokens);
        }
    }

    private String listToString(List vals) {
        StringBuffer st = new StringBuffer(800);
        Iterator i = vals.iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            st.append(val);
            st.append(DELIM);
        }
        return st.toString();
    }

    private List stringToList(String vals) {
        String[] arr = vals.split(DELIM);
        ArrayList<String> valList = new ArrayList<String>();
        for (int i = 0; i < arr.length; ++i) {
            valList.add(arr[i]);
        }
        return valList;
    }

    public static Object getAdminDPContext(String portal) throws DesktopDataException {
        String adminDPContextClassName = null;
        try {
            Properties contextProps = ResourceLoader.getInstance((String)portal).getProperties("contextconfig.properties");
            adminDPContextClassName = contextProps.getProperty("adminDPContextClassName");
        }
        catch (FileNotFoundException fnfe) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", fnfe);
        }
        catch (IOException ioe) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", ioe);
        }
        if (adminDPContextClassName == null) {
            throw new DesktopDataException("DPHelper.getAdminDPContext():admindpcontext classname is null");
        }
        Object adcObj = null;
        try {
            adcObj = Class.forName(adminDPContextClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", iae);
        }
        catch (ClassCastException cce) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", cce);
        }
        catch (InstantiationException ie) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", ie);
        }
        catch (SecurityException se) {
            throw new DesktopDataException("DPHelper.getAdminDPContext()", se);
        }
        return adcObj;
    }

    static void appendBuffer(String a, StringBuffer b, int indent) {
        if (b.length() != 0 && b.charAt(b.length() - 1) == '\n') {
            for (int i = 0; i < indent * 4; ++i) {
                b.append(" ");
            }
        }
        b.append(a);
    }

    static void toStringBuffer(Node n, StringBuffer b, int indent) {
        switch (n.getNodeType()) {
            case 1: {
                Node s;
                Element e = (Element)n;
                DPHelper.appendBuffer("<", b, indent);
                DPHelper.appendBuffer(e.getTagName(), b, indent);
                NamedNodeMap attrs = e.getAttributes();
                if (attrs != null) {
                    int numAttrs = attrs.getLength();
                    for (int i = 0; i < numAttrs; ++i) {
                        Node na = attrs.item(i);
                        if (na.getNodeType() != 2) continue;
                        Attr a = (Attr)na;
                        DPHelper.appendBuffer(" ", b, indent);
                        DPHelper.appendBuffer(Encoder.XML_ENCODER.encode(a.getName()), b, indent);
                        DPHelper.appendBuffer("=\"", b, indent);
                        DPHelper.appendBuffer(Encoder.XML_ENCODER.encode(a.getValue()), b, indent);
                        DPHelper.appendBuffer("\"", b, indent);
                    }
                }
                boolean appendNewline = (s = e.getNextSibling()) == null || s.getNodeType() != 3;
                NodeList nodes = e.getChildNodes();
                if (nodes.getLength() == 0) {
                    if (appendNewline) {
                        DPHelper.appendBuffer("/>\n", b, indent);
                        break;
                    }
                    DPHelper.appendBuffer("/>", b, indent);
                    break;
                }
                if (nodes.item(0).getNodeType() == 3) {
                    DPHelper.appendBuffer(">", b, indent);
                } else {
                    DPHelper.appendBuffer(">\n", b, indent);
                }
                for (int j = 0; j < nodes.getLength(); ++j) {
                    DPHelper.toStringBuffer(nodes.item(j), b, indent + 1);
                }
                DPHelper.appendBuffer("</", b, indent);
                DPHelper.appendBuffer(e.getTagName(), b, indent);
                if (appendNewline) {
                    DPHelper.appendBuffer(">\n", b, indent);
                    break;
                }
                DPHelper.appendBuffer(">", b, indent);
                break;
            }
            case 8: {
                Comment c = (Comment)n;
                DPHelper.appendBuffer("<!--", b, indent);
                DPHelper.appendBuffer(c.getData(), b, indent);
                DPHelper.appendBuffer("-->\n", b, indent);
                break;
            }
            case 3: {
                Text t = (Text)n;
                String text = t.getData();
                if (text.length() <= 0) break;
                DPHelper.appendBuffer(Encoder.XML_ENCODER.encode(text), b, 0);
                break;
            }
        }
    }
}

