/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.sun.portal.desktop.admin.mbeans.tasks.DPAException;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAUtil;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DPAList {
    XMLDPFactory dpf = XMLDPFactory.getInstance();

    public String process(AdminDPContext adc, String dn, boolean global, String name, boolean verbose, Logger logger) throws DPAException {
        if (verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            logger.log(Level.INFO, "PSDT_CSPDAMT0001", tokens);
        }
        String doc = null;
        try {
            doc = !global ? adc.getDPDocument(dn) : adc.getGlobalDPDocument();
            if (doc == null || doc.length() == 0) {
                return null;
            }
            if (name == null) {
                return doc.toString();
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? "<global>" : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        if (verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            logger.log(Level.INFO, "PSDT_CSPDAMT0002", tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = this.dpf.createRoot((DPContext)adc, doc);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? "<global>" : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens);
        }
        if (verbose) {
            Object[] tokens = new Object[]{name};
            logger.log(Level.INFO, "PSDT_CSPDAMT0003", tokens);
        }
        DPPropertyHolder ph = null;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            ph = xdpr.getChannelFromThis(name);
            if (ph == null) {
                ph = xdpr.getProviderFromThis(name);
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new DPAException("errorFindPropertyHolder", ex, tokens);
        }
        if (ph != null) {
            StringBuffer sb = new StringBuffer(256);
            ph.toXML(sb, 0);
            return sb.toString();
        }
        return null;
    }
}

