/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.sun.portal.desktop.admin.mbeans.tasks.DPAException;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAUtil;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DPAAdd {
    XMLDPFactory dpf = XMLDPFactory.getInstance();
    boolean verbose = false;
    private Logger logger;

    public void process(AdminDPContext adc, String dn, boolean global, String parent, InputStream[] xmlByteStreams, boolean verbose, boolean dryrun, Logger logger) throws DPAException {
        this.verbose = verbose;
        this.logger = logger;
        logger.finest("PSDT_CSPDAMT0004");
        String doc = null;
        try {
            doc = !global ? adc.getDPDocument(dn) : adc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? "<global>" : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        DPRoot dpr = null;
        try {
            if (doc != null && doc.length() > 0) {
                dpr = this.dpf.createRoot((DPContext)adc, doc);
            }
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? "<global>" : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens);
        }
        for (int i = 0; i < xmlByteStreams.length; ++i) {
            dpr = this.doAdd(adc, dn, global, parent, xmlByteStreams[i], verbose, dpr);
        }
        logger.finest("PSDT_CSPDAMT0005");
        String dpDoc = null;
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
            dpDoc = dpr.toString();
            this.dpf.createRoot((DPContext)adc, dpDoc);
        }
        catch (DPError de) {
            Throwable wrapped = de.getCause();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens = new Object[]{DPAUtil.getLines(new StringReader(dpDoc), linenum)};
                throw new DPAException("errorInvalidXMLText", de, tokens);
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        if (!dryrun) {
            if (verbose) {
                logger.info("PSDT_CSPDAMT0006");
            }
            try {
                StringBuffer sb = new StringBuffer(256);
                dpr.toXML(sb, 0);
                if (!global) {
                    adc.storeDPDocument(dn, sb.toString());
                } else {
                    adc.storeGlobalDPDocument(sb.toString());
                }
            }
            catch (Throwable ex) {
                throw new DPAException("errorStoreDP", ex);
            }
        }
    }

    private DPRoot doAdd(AdminDPContext adc, String dn, boolean global, String parent, InputStream xmlByteStream, boolean verbose, DPRoot dpr) throws DPAException {
        Object[] tokens;
        Element element = DPAUtil.getElement(adc, xmlByteStream);
        String tag = element.getTagName();
        if (verbose) {
            tokens = new Object[]{tag};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0007", tokens);
        }
        if (tag.equals("DisplayProfile")) {
            if (parent != null) {
                tokens = new Object[]{parent};
                throw new DPAException("errorCannotHaveParent", tokens);
            }
            dpr = this.doAddDP(adc, dn, global, element);
        } else {
            if (dpr == null) {
                tokens = new Object[]{global ? "<global>" : dn};
                throw new DPAException("errorCreateDPRoot", tokens);
            }
            if (tag.equals("Channel") || tag.equals("Container")) {
                dpr = this.doAddChannel(adc, dpr, parent, element);
            } else if (tag.equals("Provider")) {
                if (parent != null) {
                    tokens = new Object[]{parent};
                    throw new DPAException("errorProviderCannotHaveParent", tokens);
                }
                dpr = this.doAddProvider(adc, dpr, element);
            } else if (tag.equals("String") || tag.equals("Boolean") || tag.equals("Integer") || tag.equals("Collection") || tag.equals("ConditionalProperties") || tag.equals("Locale")) {
                dpr = this.doAddProperty(adc, dpr, parent, element);
            } else {
                if (tag.equals("Properties") || tag.equals("Available") || tag.equals("Selected")) {
                    tokens = new Object[]{tag};
                    throw new DPAException("errorCannotAdd", tokens);
                }
                tokens = new Object[]{tag};
                throw new DPAException("errorUnsupportedTag", tokens);
            }
        }
        return dpr;
    }

    private DPRoot doAddDP(AdminDPContext adc, String dn, boolean global, Element element) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0008", tokens);
        }
        String doc = null;
        try {
            doc = !global ? adc.getDPDocument(dn) : adc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? "<global>" : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        if (doc != null && doc.length() > 0) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorDupDP", tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = this.dpf.getRoot(adc, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        return dpr;
    }

    private DPRoot doAddChannel(DPContext adc, DPRoot dpr, String parent, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0009", tokens2);
        }
        DPNode node = null;
        try {
            if (parent == null) {
                node = dpr;
            } else {
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    this.logger.log(Level.INFO, "PSDT_CSPDAMT0010", tokens);
                }
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                node = xdpr.getChannelFromThis(parent);
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? "<root>" : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (node == null) {
            tokens = new Object[]{parent == null ? "<root>" : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (!(node instanceof DPContainerChannel) && !(node instanceof DPRoot)) {
            tokens = new Object[]{parent == null ? "<root>" : parent};
            throw new DPAException("errorParentNotCotainer", tokens);
        }
        if (this.verbose) {
            this.logger.info("PSDT_CSPDAMT0061");
        }
        DPChannel ch = null;
        try {
            ch = this.dpf.getChannel(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPChannel", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{ch.getName()};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0011", tokens4);
        }
        boolean dupFound = false;
        try {
            XMLDPNode xnode = (XMLDPNode)node;
            dupFound = xnode.getChannelFromThis(ch.getName()) != null;
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(ch.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorCheckDupName", ex);
        }
        if (dupFound) {
            throw new DPAException("errorDupName");
        }
        try {
            node.addChannel(ch);
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? "<root" : parent, ch.getName()};
            throw new DPAException("errorAddChannel", ex, tokens5);
        }
        return dpr;
    }

    private DPRoot doAddProvider(DPContext adc, DPRoot dpr, Element element) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{element.getAttribute("name")};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0012", tokens);
        }
        if (this.verbose) {
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0013");
        }
        DPProvider p = null;
        try {
            p = this.dpf.getProvider(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProvider", ex);
        }
        if (this.verbose) {
            Object[] tokens = new Object[]{p.getName()};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0014", tokens);
        }
        boolean dupFound = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            boolean bl = dupFound = xdpr.getChannelFromThis(p.getName()) != null;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(p.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorCheckDupName", ex);
        }
        if (dupFound) {
            throw new DPAException("errorDupName");
        }
        try {
            dpr.addProvider(p);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{p.getName()};
            throw new DPAException("errorAddProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot doAddProperty(DPContext adc, DPRoot dpr, String parent, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0015", tokens2);
        }
        DPPropertyHolder ph = null;
        try {
            if (parent == null) {
                ph = dpr;
            } else {
                XMLDPRoot xdpr;
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    this.logger.log(Level.INFO, "PSDT_CSPDAMT0016", tokens);
                }
                if ((ph = (xdpr = (XMLDPRoot)dpr).getChannelFromThis(parent)) == null) {
                    ph = xdpr.getProviderFromThis(parent);
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? "<root>" : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (ph == null) {
            tokens = new Object[]{parent == null ? "<root>" : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            this.logger.info("PSDT_CSPDAMT0060");
        }
        DPProperty p = null;
        try {
            p = this.dpf.getProperty(adc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProperty", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            this.logger.log(Level.INFO, "PSDT_CSPDAMT0017", tokens4);
        }
        DPProperties props = null;
        boolean exists = false;
        try {
            XMLDPPropertyHolder xph = (XMLDPPropertyHolder)ph;
            props = xph.getPropertiesFromThis();
            XMLDPProperties xprops = (XMLDPProperties)props;
            exists = xprops.getFromThis(p.getName()) != null;
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? "<root>" : parent, p.getName()};
            throw new DPAException("errorLookupProperty", ex, tokens5);
        }
        if (exists) {
            Object[] tokens6 = new Object[]{parent == null ? "<root>" : parent, p.getName()};
            throw new DPAException("errorDupProperty", tokens6);
        }
        try {
            props.add(p);
        }
        catch (Throwable ex) {
            Object[] tokens7 = new Object[]{parent == null ? "<root>" : parent, p.getName()};
            throw new DPAException("errorAddProperty", ex, tokens7);
        }
        return dpr;
    }
}

